/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.saml;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.saml.bean.SubjectLocalityBean;
import org.apache.wss4j.common.saml.bean.Version;
import org.openspcoop2.security.message.saml.SAMLBuilderConfig;
import org.openspcoop2.security.message.saml.SAMLBuilderConfigAttribute;
import org.openspcoop2.security.message.saml.SAMLUtilities;

public class SAMLCallbackHandler
implements CallbackHandler {
    private SAMLBuilderConfig samlBuilderConfig = null;

    public SAMLCallbackHandler(SAMLBuilderConfig config) throws IOException {
        if (config == null) {
            throw new IOException("SAMLBuilderConfig undefined");
        }
        this.samlBuilderConfig = config;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            List<SAMLBuilderConfigAttribute> listAttributes;
            Callback callback = callbacks[i];
            if (!(callback instanceof SAMLCallback)) continue;
            SAMLCallback callback2 = (SAMLCallback)callback;
            Instant now = Instant.now();
            callback2.setSamlVersion(this.samlBuilderConfig.getVersion());
            callback2.setIssuer(this.samlBuilderConfig.getIssuerValue());
            callback2.setIssuerQualifier(this.samlBuilderConfig.getIssuerQualifier());
            callback2.setIssuerFormat(this.samlBuilderConfig.getIssuerFormat());
            boolean signAssertion = this.samlBuilderConfig.isSignAssertion();
            callback2.setSignAssertion(signAssertion);
            if (signAssertion) {
                try {
                    callback2.setIssuerCrypto(this.samlBuilderConfig.getSignAssertionCrypto());
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
                callback2.setIssuerKeyName(this.samlBuilderConfig.getSignAssertionIssuerKeyName());
                callback2.setIssuerKeyPassword(this.samlBuilderConfig.getSignAssertionIssuerKeyPassword());
                if (this.samlBuilderConfig.getSignAssertionSignatureDigestAlgorithm() != null) {
                    callback2.setSignatureDigestAlgorithm(this.samlBuilderConfig.getSignAssertionSignatureDigestAlgorithm());
                }
                if (this.samlBuilderConfig.getSignAssertionSignatureAlgorithm() != null) {
                    callback2.setSignatureAlgorithm(this.samlBuilderConfig.getSignAssertionSignatureAlgorithm());
                }
                if (this.samlBuilderConfig.getSignAssertionCanonicalizationAlgorithm() != null) {
                    callback2.setCanonicalizationAlgorithm(this.samlBuilderConfig.getSignAssertionCanonicalizationAlgorithm());
                }
                callback2.setSendKeyValue(this.samlBuilderConfig.isSignAssertionSendKeyValue());
            }
            SubjectBean subjectBean = null;
            if (this.samlBuilderConfig.isSubjectEnabled()) {
                subjectBean = new SubjectBean();
                subjectBean.setSubjectName(this.samlBuilderConfig.getSubjectNameIDValue());
                subjectBean.setSubjectNameIDFormat(this.samlBuilderConfig.getSubjectNameIDFormat());
                subjectBean.setSubjectNameQualifier(this.samlBuilderConfig.getSubjectNameIDQualifier());
                subjectBean.setSubjectConfirmationMethod(this.samlBuilderConfig.getSubjectConfirmationMethod());
                SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
                Instant subjectConfirmationMethodNotBefore = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getSubjectConfirmationDataNotBefore());
                Instant subjectConfirmationMethodNotOnOrAfter = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getSubjectConfirmationDataNotOnOrAfter());
                subjectConfirmationData.setNotBefore(subjectConfirmationMethodNotBefore);
                subjectConfirmationData.setNotAfter(subjectConfirmationMethodNotOnOrAfter);
                subjectConfirmationData.setAddress(this.samlBuilderConfig.getSubjectConfirmationDataAddress());
                subjectConfirmationData.setInResponseTo(this.samlBuilderConfig.getSubjectConfirmationDataInResponseTo());
                subjectConfirmationData.setRecipient(this.samlBuilderConfig.getSubjectConfirmationDataRecipient());
                subjectBean.setSubjectConfirmationData(subjectConfirmationData);
                if ("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(this.samlBuilderConfig.getSubjectConfirmationMethod()) || "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(this.samlBuilderConfig.getSubjectConfirmationMethod())) {
                    try {
                        KeyInfoBean keyInfo = this.createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
                callback2.setSubject(subjectBean);
            }
            if (this.samlBuilderConfig.isConditionsEnabled()) {
                ConditionsBean conditions = new ConditionsBean();
                Instant conditionsNotBefore = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getConditionsDataNotBefore());
                Instant conditionsNotOnOrAfter = SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getConditionsDataNotOnOrAfter());
                conditions.setNotBefore(conditionsNotBefore);
                conditions.setNotAfter(conditionsNotOnOrAfter);
                if (this.samlBuilderConfig.getConditionsAudienceURI() != null) {
                    ArrayList<AudienceRestrictionBean> lAudience = new ArrayList<AudienceRestrictionBean>();
                    AudienceRestrictionBean arb = new AudienceRestrictionBean();
                    ArrayList<String> uri = new ArrayList<String>();
                    uri.add(this.samlBuilderConfig.getConditionsAudienceURI());
                    arb.setAudienceURIs(uri);
                    lAudience.add(arb);
                    conditions.setAudienceRestrictions(lAudience);
                }
                callback2.setConditions(conditions);
            }
            AuthenticationStatementBean authBean = null;
            if (this.samlBuilderConfig.isAuthnStatementEnabled()) {
                authBean = new AuthenticationStatementBean();
                authBean.setSubject(subjectBean);
                Instant authnStatementInstant = null;
                authnStatementInstant = this.samlBuilderConfig.getAuthnStatementDataInstantDate() != null ? this.samlBuilderConfig.getAuthnStatementDataInstantDate().toInstant() : SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getAuthnStatementDataInstant());
                Instant authnStatementNotOnOrAfter = null;
                authnStatementNotOnOrAfter = this.samlBuilderConfig.getAuthnStatementDataNotOnOrAfterDate() != null ? this.samlBuilderConfig.getAuthnStatementDataNotOnOrAfterDate().toInstant() : SAMLUtilities.minutesOperator(now, this.samlBuilderConfig.getAuthnStatementDataNotOnOrAfter());
                authBean.setAuthenticationInstant(authnStatementInstant);
                authBean.setSessionNotOnOrAfter(authnStatementNotOnOrAfter);
                if (this.samlBuilderConfig.getAuthnSubjectLocalityIpAddress() != null || this.samlBuilderConfig.getAuthnSubjectLocalityDnsAddress() != null) {
                    SubjectLocalityBean subjectLocality = new SubjectLocalityBean();
                    subjectLocality.setIpAddress(this.samlBuilderConfig.getAuthnSubjectLocalityIpAddress());
                    subjectLocality.setDnsAddress(this.samlBuilderConfig.getAuthnSubjectLocalityDnsAddress());
                    authBean.setSubjectLocality(subjectLocality);
                }
                authBean.setAuthenticationMethod(this.samlBuilderConfig.getAuthnStatementClassRef());
                if (this.samlBuilderConfig.getAuthnStatementDeclRef() != null) {
                    authBean.setAuthnContextDeclRef(this.samlBuilderConfig.getAuthnStatementDeclRef());
                }
                callback2.setAuthenticationStatementData(Collections.singletonList(authBean));
            }
            if (authBean == null && !Version.SAML_20.equals((Object)this.samlBuilderConfig.getVersion()) && subjectBean != null) {
                authBean = new AuthenticationStatementBean();
                authBean.setSubject(subjectBean);
                callback2.setAuthenticationStatementData(Collections.singletonList(authBean));
            }
            if ((listAttributes = this.samlBuilderConfig.getAttributes()) == null || listAttributes.isEmpty()) continue;
            AttributeStatementBean attrBean = new AttributeStatementBean();
            attrBean.setSubject(subjectBean);
            ArrayList<AttributeBean> attributeBeans = new ArrayList<AttributeBean>();
            for (SAMLBuilderConfigAttribute configAttribute : listAttributes) {
                AttributeBean attributeBean = new AttributeBean();
                attributeBean.setSimpleName(configAttribute.getSimpleName());
                attributeBean.setQualifiedName(configAttribute.getQualifiedName());
                attributeBean.setNameFormat(configAttribute.getFormatName());
                attributeBean.setAttributeValues(configAttribute.getValues());
                attributeBeans.add(attributeBean);
            }
            attrBean.setSamlAttributes(attributeBeans);
            callback2.setAttributeStatementData(Collections.singletonList(attrBean));
        }
    }

    protected KeyInfoBean createKeyInfo() throws Exception {
        Crypto crypto = this.samlBuilderConfig.getSubjectConfirmationMethodHolderOfKeyCrypto();
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(this.samlBuilderConfig.getSubjectConfirmationMethodHolderOfKeyCryptoCertificateAlias());
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        KeyInfoBean keyInfo = new KeyInfoBean();
        keyInfo.setCertificate(certs[0]);
        keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.X509_CERT);
        return keyInfo;
    }
}

