/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.AbstractRESTMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.jose.JOSEUtils;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.utils.PropertiesUtils;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JWSOptions;
import org.openspcoop2.utils.security.JsonEncrypt;
import org.openspcoop2.utils.security.JsonSignature;
import org.openspcoop2.utils.security.JwtHeaders;

public class MessageSecuritySender_jose
extends AbstractRESTMessageSecuritySender {
    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message messageParam, Map<Object> ctx) throws SecurityException {
        block65: {
            try {
                if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding");
                }
                if (!MessageType.JSON.equals((Object)messageParam.getMessageType())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding and a json message, found: " + String.valueOf(messageParam.getMessageType()));
                }
                OpenSPCoop2RestJsonMessage restJsonMessage = messageParam.castAsRestJson();
                RequestInfo requestInfo = null;
                if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
                }
                boolean encrypt = false;
                boolean signature = false;
                String[] actions = ((String)messageSecurityContext.getOutgoingProperties().get("action")).split(" ");
                for (int i = 0; i < actions.length; ++i) {
                    if (SecurityConstants.isActionEncryption(actions[i].trim())) {
                        encrypt = true;
                        continue;
                    }
                    if ("Signature".equals(actions[i].trim())) {
                        signature = true;
                        continue;
                    }
                    throw new SecurityException("JOSE Engine; action '" + actions[i] + "' unsupported");
                }
                if (encrypt && signature) {
                    throw new SecurityException("JOSE Engine usable only with one function beetwen encrypt or signature");
                }
                if (!encrypt && !signature) {
                    throw new SecurityException("JOSE Engine require one function beetwen encrypt or signature");
                }
                if (signature) {
                    String signaturePayloadEncodingParam;
                    JOSESerialization joseSerialization = null;
                    String mode = (String)messageSecurityContext.getOutgoingProperties().get("signatureMode");
                    if (mode == null || "".equals(mode.trim())) {
                        throw new SecurityException("JOSE Signature Engine require 'signatureMode' property");
                    }
                    try {
                        joseSerialization = JOSEUtils.toJOSESerialization(mode);
                    }
                    catch (Exception e) {
                        throw new SecurityException("JOSE Signature Engine, 'signatureMode' property error: " + e.getMessage(), e);
                    }
                    JWSOptions jwsOptions = new JWSOptions(joseSerialization);
                    String signatureDetachedParam = (String)messageSecurityContext.getOutgoingProperties().get("signatureDetached");
                    if (signatureDetachedParam != null) {
                        jwsOptions.setDetached("true".equalsIgnoreCase(signatureDetachedParam));
                    }
                    if ((signaturePayloadEncodingParam = (String)messageSecurityContext.getOutgoingProperties().get("signaturePayloadEncoding")) != null) {
                        jwsOptions.setPayloadEncoding("true".equalsIgnoreCase(signaturePayloadEncodingParam));
                    }
                    JsonSignature jsonSignature = null;
                    SignatureBean bean = null;
                    NotFoundException notFound = null;
                    try {
                        bean = PropertiesUtils.getSenderSignatureBean(messageSecurityContext);
                    }
                    catch (NotFoundException e) {
                        notFound = e;
                    }
                    if (bean != null) {
                        Properties signatureProperties = bean.getProperties();
                        boolean throwError = true;
                        java.util.Map dynamicMap = Costanti.readDynamicMap(ctx);
                        JOSEUtils.injectKeystore(requestInfo, dynamicMap, signatureProperties, messageSecurityContext.getLog(), throwError);
                        JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam);
                        jsonSignature = new JsonSignature(signatureProperties, jwtHeaders, jwsOptions);
                    } else {
                        String signatureAlgorithm;
                        KeyStore signatureKS = null;
                        JWKSet signatureJWKSet = null;
                        String aliasSignatureUser = null;
                        String aliasSignaturePassword = null;
                        try {
                            bean = KeystoreUtils.getSenderSignatureBean(messageSecurityContext, ctx);
                        }
                        catch (Exception e) {
                            if (notFound != null) {
                                messageSecurityContext.getLog().error(e.getMessage(), (Throwable)e);
                                throw notFound;
                            }
                            throw e;
                        }
                        signatureKS = bean.getKeystore();
                        signatureJWKSet = bean.getJwkSet();
                        aliasSignatureUser = bean.getUser();
                        aliasSignaturePassword = bean.getPassword();
                        if (signatureKS == null && signatureJWKSet == null) {
                            throw new SecurityException("JOSE Signature Engine require keystore");
                        }
                        if (aliasSignatureUser == null) {
                            throw new SecurityException("JOSE Signature Engine require alias private key");
                        }
                        if (signatureKS != null && aliasSignaturePassword == null) {
                            boolean required = true;
                            if (KeystoreType.JKS.isType(signatureKS.getKeystoreType())) {
                                required = DBUtils.isKeystoreJksKeyPasswordRequired();
                            } else if (KeystoreType.PKCS12.isType(signatureKS.getKeystoreType())) {
                                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
                            }
                            if (required) {
                                throw new SecurityException("JOSE Signature Engine require password private key");
                            }
                        }
                        if ((signatureAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("signatureAlgorithm")) == null || "".equals(signatureAlgorithm.trim())) {
                            throw new SecurityException("JOSE Signature Engine require 'signatureAlgorithm' property");
                        }
                        String symmetricKeyParam = (String)messageSecurityContext.getOutgoingProperties().get("symmetricKey");
                        boolean symmetricKey = false;
                        if (symmetricKeyParam != null) {
                            symmetricKey = "true".equalsIgnoreCase(symmetricKeyParam);
                        }
                        if (signatureKS != null) {
                            JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam, aliasSignatureUser, signatureKS);
                            jsonSignature = new JsonSignature(signatureKS, symmetricKey, aliasSignatureUser, aliasSignaturePassword, signatureAlgorithm, jwtHeaders, jwsOptions);
                        } else {
                            JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam, aliasSignatureUser, signatureJWKSet);
                            jsonSignature = new JsonSignature(signatureJWKSet.getJsonWebKeys(), symmetricKey, aliasSignatureUser, signatureAlgorithm, jwtHeaders, jwsOptions);
                        }
                    }
                    String contentSign = jsonSignature.sign((String)restJsonMessage.getContent());
                    if (jwsOptions.isDetached()) {
                        this.setDetachedSignatureInMessage(messageSecurityContext.getOutgoingProperties(), (OpenSPCoop2RestMessage<?>)restJsonMessage, "JOSE Signature Engine", contentSign);
                    } else {
                        restJsonMessage.updateContent((Object)contentSign);
                    }
                    break block65;
                }
                if (!encrypt) break block65;
                JOSESerialization joseSerialization = null;
                String mode = (String)messageSecurityContext.getOutgoingProperties().get("encryptionMode");
                if (mode == null || "".equals(mode.trim())) {
                    throw new SecurityException("JOSE Encrypt Engine require 'encryptionMode' property");
                }
                try {
                    joseSerialization = JOSEUtils.toJOSESerialization(mode);
                }
                catch (Exception e) {
                    throw new SecurityException("JOSE Encrypt Engine, 'encryptionMode' property error: " + e.getMessage(), e);
                }
                JWEOptions jweOptions = new JWEOptions(joseSerialization);
                String encryptionDeflateParam = (String)messageSecurityContext.getOutgoingProperties().get("deflate");
                if (encryptionDeflateParam != null) {
                    jweOptions.setDeflate("true".equalsIgnoreCase(encryptionDeflateParam));
                }
                JsonEncrypt jsonEncrypt = null;
                EncryptionBean bean = null;
                NotFoundException notFound = null;
                try {
                    bean = PropertiesUtils.getSenderEncryptionBean(messageSecurityContext);
                }
                catch (NotFoundException e) {
                    notFound = e;
                }
                if (bean != null) {
                    Properties encryptionProperties = bean.getProperties();
                    boolean throwError = true;
                    java.util.Map dynamicMap = Costanti.readDynamicMap(ctx);
                    JOSEUtils.injectKeystore(requestInfo, dynamicMap, encryptionProperties, messageSecurityContext.getLog(), throwError);
                    JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam);
                    jsonEncrypt = new JsonEncrypt(encryptionProperties, jwtHeaders, jweOptions);
                } else {
                    String encryptionKeyAlgorithm;
                    KeyStore encryptionKS = null;
                    KeyStore encryptionTrustStoreKS = null;
                    boolean encryptionSymmetric = false;
                    JWKSet encryptionJWKSet = null;
                    String aliasEncryptUser = null;
                    String aliasEncryptPassword = null;
                    try {
                        bean = KeystoreUtils.getSenderEncryptionBean(messageSecurityContext, ctx);
                    }
                    catch (Exception e) {
                        if (notFound != null) {
                            messageSecurityContext.getLog().error(e.getMessage(), (Throwable)e);
                            throw notFound;
                        }
                        throw e;
                    }
                    encryptionKS = bean.getKeystore();
                    encryptionTrustStoreKS = bean.getTruststore();
                    encryptionSymmetric = bean.isEncryptionSimmetric();
                    encryptionJWKSet = bean.getJwkSet();
                    aliasEncryptUser = bean.getUser();
                    aliasEncryptPassword = bean.getPassword();
                    if (encryptionSymmetric) {
                        if (encryptionKS == null) {
                            throw new SecurityException("JOSE Encrypt Engine require keystore");
                        }
                        if (aliasEncryptUser == null) {
                            throw new SecurityException("JOSE Encrypt Engine require alias secret key");
                        }
                        if (aliasEncryptPassword == null) {
                            throw new SecurityException("JOSE Encrypt Engine require password secret key");
                        }
                    } else {
                        if (encryptionTrustStoreKS == null && encryptionJWKSet == null) {
                            throw new SecurityException("JOSE Encrypt Engine require truststore");
                        }
                        if (aliasEncryptUser == null) {
                            throw new SecurityException("JOSE Encrypt Engine require alias public key");
                        }
                    }
                    if ((encryptionKeyAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionKeyAlgorithm")) == null || "".equals(encryptionKeyAlgorithm.trim())) {
                        throw new SecurityException("JOSE Encrypt Engine require 'encryptionKeyAlgorithm' property");
                    }
                    String encryptionContentAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionContentAlgorithm");
                    if (encryptionContentAlgorithm == null || "".equals(encryptionContentAlgorithm.trim())) {
                        throw new SecurityException("JOSE Encrypt Engine require 'encryptionContentAlgorithm' property");
                    }
                    if (encryptionSymmetric) {
                        JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam, aliasEncryptUser);
                        jsonEncrypt = new JsonEncrypt(encryptionKS, aliasEncryptUser, aliasEncryptPassword, encryptionKeyAlgorithm, encryptionContentAlgorithm, jwtHeaders, jweOptions);
                    } else if (encryptionTrustStoreKS != null) {
                        JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam, aliasEncryptUser, encryptionTrustStoreKS);
                        jsonEncrypt = new JsonEncrypt(encryptionTrustStoreKS, aliasEncryptUser, encryptionKeyAlgorithm, encryptionContentAlgorithm, jwtHeaders, jweOptions);
                    } else {
                        JwtHeaders jwtHeaders = JOSEUtils.getJwtHeaders(messageSecurityContext.getOutgoingProperties(), messageParam, aliasEncryptUser, encryptionJWKSet);
                        jsonEncrypt = new JsonEncrypt(encryptionJWKSet.getJsonWebKeys(), encryptionSymmetric, aliasEncryptUser, encryptionKeyAlgorithm, encryptionContentAlgorithm, jwtHeaders, jweOptions);
                    }
                }
                String contentEncrypted = jsonEncrypt.encrypt((String)restJsonMessage.getContent());
                restJsonMessage.updateContent((Object)contentEncrypted);
            }
            catch (Exception e) {
                String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
                Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
                String innerMsg = null;
                if (innerExc != null) {
                    innerMsg = innerExc.getMessage();
                }
                Object messaggio = null;
                if (msg != null) {
                    messaggio = new String(msg);
                    if (innerMsg != null && !innerMsg.equals(msg)) {
                        messaggio = (String)messaggio + " ; " + innerMsg;
                    }
                } else if (innerMsg != null) {
                    messaggio = innerMsg;
                }
                SecurityException wssException = new SecurityException(e.getMessage(), e);
                wssException.setMsgErrore((String)messaggio);
                throw wssException;
            }
        }
    }
}

