/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPPart;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.utils.DBPropertiesUtils;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecurityContext;
import org.openspcoop2.security.message.IMessageSecurityDigest;
import org.openspcoop2.security.message.IMessageSecurityReceiver;
import org.openspcoop2.security.message.IMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.digest.IDigestReader;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public abstract class MessageSecurityContext {
    protected Map<String, Object> incomingProperties = new HashMap<String, Object>();
    protected Map<String, Object> outgoingProperties = new HashMap<String, Object>();
    protected boolean useActorDefaultIfNotDefined = true;
    protected String actorDefault = null;
    protected String actor;
    protected String msgErrore;
    protected CodiceErroreCooperazione codiceErrore;
    protected List<SubErrorCodeSecurity> listaSubCodiceErrore = new ArrayList<SubErrorCodeSecurity>();
    protected boolean functionAsClient = true;
    protected String prefixWsuId;
    protected boolean removeAllWsuIdRef;
    protected String securityEngine;
    protected IMessageSecurityContext messageSecurityContext;
    protected IMessageSecuritySender messageSecuritySender;
    protected IMessageSecurityReceiver messageSecurityReceiver;
    protected IMessageSecurityDigest messageSecurityDigest;
    protected Logger log;
    private IDSoggetto idFruitore;
    private String pddFruitore;
    private IDServizio idServizio;
    private String pddErogatore;
    private List<Reference> references;
    private String manualAttachmentsEncryptPart = null;
    private String manualAttachmentsSignaturePart = null;
    private SignatureBean signatureBean;
    private EncryptionBean encryptionBean;

    public Logger getLog() {
        return this.log;
    }

    public IDSoggetto getIdFruitore() {
        return this.idFruitore;
    }

    public IDServizio getIdServizio() {
        return this.idServizio;
    }

    public String getPddFruitore() {
        return this.pddFruitore;
    }

    public String getPddErogatore() {
        return this.pddErogatore;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public String getManualAttachmentsEncryptPart() {
        return this.manualAttachmentsEncryptPart;
    }

    public void setManualAttachmentsEncryptPart(String manualAttachmentsEncryptPart) {
        this.manualAttachmentsEncryptPart = manualAttachmentsEncryptPart;
    }

    public String getManualAttachmentsSignaturePart() {
        return this.manualAttachmentsSignaturePart;
    }

    public void setManualAttachmentsSignaturePart(String manualAttachmentsSignaturePart) {
        this.manualAttachmentsSignaturePart = manualAttachmentsSignaturePart;
    }

    public SignatureBean getSignatureBean() {
        return this.signatureBean;
    }

    public void setSignatureBean(SignatureBean signatureBean) {
        this.signatureBean = signatureBean;
    }

    public EncryptionBean getEncryptionBean() {
        return this.encryptionBean;
    }

    public void setEncryptionBean(EncryptionBean encryptionBean) {
        this.encryptionBean = encryptionBean;
    }

    protected MessageSecurityContext(MessageSecurityContextParameters messageSecurityContextParameters) {
        this.useActorDefaultIfNotDefined = messageSecurityContextParameters.isUseActorDefaultIfNotDefined();
        this.actorDefault = messageSecurityContextParameters.getActorDefault();
        this.log = messageSecurityContextParameters.getLog() != null ? messageSecurityContextParameters.getLog() : LoggerWrapperFactory.getLogger(MessageSecurityContext.class);
        this.functionAsClient = messageSecurityContextParameters.isFunctionAsClient();
        this.prefixWsuId = messageSecurityContextParameters.getPrefixWsuId();
        this.removeAllWsuIdRef = messageSecurityContextParameters.isRemoveAllWsuIdRef();
        this.idFruitore = messageSecurityContextParameters.getIdFruitore();
        this.idServizio = messageSecurityContextParameters.getIdServizio();
        this.pddFruitore = messageSecurityContextParameters.getPddFruitore();
        this.pddErogatore = messageSecurityContextParameters.getPddErogatore();
    }

    protected abstract boolean processIncoming(OpenSPCoop2Message var1, Busta var2, org.openspcoop2.utils.Map<Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processIncoming(OpenSPCoop2Message message, Busta busta, org.openspcoop2.utils.Map<Object> ctx, TempiElaborazione tempiElaborazione) {
        MessageRole messageRole = message.getMessageRole();
        if (MessageRole.REQUEST.equals((Object)messageRole)) {
            if (tempiElaborazione != null) {
                tempiElaborazione.startSicurezzaMessaggioRichiesta();
            }
        } else if (tempiElaborazione != null) {
            tempiElaborazione.startSicurezzaMessaggioRisposta();
        }
        try {
            boolean bl = this.processIncoming(message, busta, ctx);
            return bl;
        }
        finally {
            if (MessageRole.REQUEST.equals((Object)messageRole)) {
                if (tempiElaborazione != null) {
                    tempiElaborazione.endSicurezzaMessaggioRichiesta();
                }
            } else if (tempiElaborazione != null) {
                tempiElaborazione.endSicurezzaMessaggioRisposta();
            }
        }
    }

    protected abstract boolean processOutgoing(OpenSPCoop2Message var1, org.openspcoop2.utils.Map<Object> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOutgoing(OpenSPCoop2Message message, org.openspcoop2.utils.Map<Object> ctx, TempiElaborazione tempiElaborazione) {
        MessageRole messageRole = message.getMessageRole();
        if (MessageRole.REQUEST.equals((Object)messageRole)) {
            if (tempiElaborazione != null) {
                tempiElaborazione.startSicurezzaMessaggioRichiesta();
            }
        } else if (tempiElaborazione != null) {
            tempiElaborazione.startSicurezzaMessaggioRisposta();
        }
        try {
            boolean bl = this.processOutgoing(message, ctx);
            return bl;
        }
        finally {
            if (MessageRole.REQUEST.equals((Object)messageRole)) {
                if (tempiElaborazione != null) {
                    tempiElaborazione.endSicurezzaMessaggioRichiesta();
                }
            } else if (tempiElaborazione != null) {
                tempiElaborazione.endSicurezzaMessaggioRisposta();
            }
        }
    }

    public void setFunctionAsClient(boolean functionAsClient) {
        this.functionAsClient = functionAsClient;
    }

    public boolean isFunctionAsClient() {
        return this.functionAsClient;
    }

    public String getPrefixWsuId() {
        return this.prefixWsuId;
    }

    public boolean isRemoveAllWsuIdRef() {
        return this.removeAllWsuIdRef;
    }

    public abstract String getSubject();

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public CodiceErroreCooperazione getCodiceErrore() {
        return this.codiceErrore;
    }

    public List<SubErrorCodeSecurity> getListaSubCodiceErrore() {
        return this.listaSubCodiceErrore;
    }

    public String getActor() {
        return this.actor;
    }

    private void setActor(boolean incoming) {
        boolean actorDefinito = false;
        boolean mustUnderstandTrue = false;
        Map<String, Object> securityProperties = null;
        securityProperties = incoming ? this.incomingProperties : this.outgoingProperties;
        if (securityProperties != null && securityProperties.size() > 0) {
            for (String key : securityProperties.keySet()) {
                String value = null;
                Object oValue = securityProperties.get(key);
                if (oValue instanceof String) {
                    value = (String)oValue;
                }
                if ("actor".equals(key)) {
                    this.actor = value;
                }
                if ("mustUnderstand".equals(key)) {
                    if (!"true".equals(value)) continue;
                    mustUnderstandTrue = true;
                    continue;
                }
                if (!"actor".equals(key)) continue;
                actorDefinito = true;
            }
        }
        if (mustUnderstandTrue && !actorDefinito && this.useActorDefaultIfNotDefined) {
            this.actor = this.actorDefault;
        }
    }

    public void setIncomingProperties(Map<String, Object> secProperties) throws SecurityException {
        this.setIncomingProperties(secProperties, true, false);
    }

    public void setIncomingProperties(Map<String, Object> secProperties, boolean convertSecProperties) throws SecurityException {
        this.setIncomingProperties(secProperties, convertSecProperties, false);
    }

    public void setIncomingProperties(Map<String, Object> secProperties, boolean convertSecProperties, boolean preserveNotStringProperty) throws SecurityException {
        this.incomingProperties = secProperties != null && secProperties.size() > 0 && convertSecProperties ? this.convertSecProperties(secProperties, preserveNotStringProperty) : secProperties;
        this.setActor(true);
        this.readMessageSecurityEngine(true);
        this.resolvePWCallback(true);
    }

    public Map<String, Object> getIncomingProperties() {
        return this.incomingProperties;
    }

    public void setOutgoingProperties(Map<String, Object> secProperties) throws SecurityException {
        this.setOutgoingProperties(secProperties, true, false);
    }

    public void setOutgoingProperties(Map<String, Object> secProperties, boolean convertSecProperties) throws SecurityException {
        this.setOutgoingProperties(secProperties, convertSecProperties, false);
    }

    public void setOutgoingProperties(Map<String, Object> secProperties, boolean convertSecProperties, boolean preserveNotStringProperty) throws SecurityException {
        this.outgoingProperties = secProperties != null && secProperties.size() > 0 && convertSecProperties ? this.convertSecProperties(secProperties, preserveNotStringProperty) : secProperties;
        this.setActor(false);
        this.readMessageSecurityEngine(false);
        this.resolvePWCallback(false);
    }

    public Map<String, Object> getOutgoingProperties() {
        return this.outgoingProperties;
    }

    private Map<String, Object> convertSecProperties(Map<String, Object> secProperties, boolean preserveNotStringProperty) throws SecurityException {
        try {
            HashMap<String, Object> mapNoStringProperty = new HashMap<String, Object>();
            HashMap<String, String> map = new HashMap<String, String>();
            if (secProperties != null && secProperties.size() > 0) {
                for (String key : secProperties.keySet()) {
                    Object value = secProperties.get(key);
                    String v = null;
                    if (value instanceof String) {
                        v = (String)value;
                    }
                    map.put(key, v);
                    if (!preserveNotStringProperty || value == null || value instanceof String) continue;
                    mapNoStringProperty.put(key, value);
                }
            }
            Map multiMap = DBPropertiesUtils.toMultiMap(map);
            HashMap<String, Object> table = new HashMap<String, Object>();
            Properties defaultProperties = MultiPropertiesUtilities.removeDefaultProperties((Map)multiMap);
            if (defaultProperties != null && defaultProperties.size() > 0) {
                for (Object oKey : defaultProperties.keySet()) {
                    if (!(oKey instanceof String)) continue;
                    String key = (String)oKey;
                    String value = null;
                    Object oValue = defaultProperties.get(key);
                    if (oValue instanceof String) {
                        value = (String)oValue;
                    }
                    table.put(key, value);
                }
            }
            if (multiMap.size() > 0) {
                if (preserveNotStringProperty && mapNoStringProperty.size() > 0) {
                    ArrayList keysMultiMap = new ArrayList();
                    keysMultiMap.addAll(multiMap.keySet());
                    for (String keyWithPrefix : mapNoStringProperty.keySet()) {
                        Object object = mapNoStringProperty.get(keyWithPrefix);
                        String prefix = DBPropertiesUtils.startsWith(keysMultiMap, (String)keyWithPrefix);
                        if (prefix == null) {
                            table.put(keyWithPrefix, object);
                            continue;
                        }
                        String keyWithoutPrefix = DBPropertiesUtils.normalizePropertyName((String)prefix, (String)keyWithPrefix);
                        ((Properties)multiMap.get(prefix)).put(keyWithoutPrefix, object);
                    }
                }
                table.putAll(multiMap);
            } else if (preserveNotStringProperty && mapNoStringProperty.size() > 0) {
                table.putAll(mapNoStringProperty);
            }
            return table;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public String getSecurityEngine() {
        return this.securityEngine;
    }

    public IMessageSecurityContext getMessageSecurityContext() {
        return this.messageSecurityContext;
    }

    public IMessageSecuritySender getMessageSecuritySender() {
        return this.messageSecuritySender;
    }

    public IMessageSecurityReceiver getMessageSecurityReceiver() {
        return this.messageSecurityReceiver;
    }

    public IMessageSecurityDigest getMessageSecurityDigest() {
        return this.messageSecurityDigest;
    }

    public IDigestReader getDigestReader(OpenSPCoop2MessageFactory messageFactory) throws SecurityException {
        if (this.messageSecurityDigest != null) {
            return this.getMessageSecurityDigest().getDigestReader(messageFactory, this);
        }
        return null;
    }

    private void readMessageSecurityEngine(boolean incoming) throws SecurityException {
        try {
            this.securityEngine = "wss4j";
            String engineProperty = null;
            engineProperty = incoming ? (String)this.incomingProperties.get("securityEngine") : (String)this.outgoingProperties.get("securityEngine");
            if (engineProperty != null && !"wss4j".equals(engineProperty = engineProperty.trim())) {
                if ("jose".equals(engineProperty)) {
                    this.securityEngine = "jose";
                } else if ("xml".equals(engineProperty)) {
                    this.securityEngine = "xml";
                } else {
                    throw new SecurityException("Security engine impostato [" + engineProperty + "] non supportato");
                }
            }
            if ("wss4j".equals(this.securityEngine)) {
                this.messageSecurityContext = (IMessageSecurityContext)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.wss4j.MessageSecurityContext_wss4j");
                this.messageSecuritySender = (IMessageSecuritySender)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.wss4j.MessageSecuritySender_wss4j");
                this.messageSecurityReceiver = (IMessageSecurityReceiver)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.wss4j.MessageSecurityReceiver_wss4j");
                this.messageSecurityDigest = (IMessageSecurityDigest)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.wss4j.MessageSecurityDigest_wss4j");
            } else if ("jose".equals(this.securityEngine)) {
                this.messageSecurityContext = (IMessageSecurityContext)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.jose.MessageSecurityContext_jose");
                this.messageSecuritySender = (IMessageSecuritySender)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.jose.MessageSecuritySender_jose");
                this.messageSecurityReceiver = (IMessageSecurityReceiver)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.jose.MessageSecurityReceiver_jose");
                this.messageSecurityDigest = (IMessageSecurityDigest)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.jose.MessageSecurityDigest_jose");
            } else if ("xml".equals(this.securityEngine)) {
                this.messageSecurityContext = (IMessageSecurityContext)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.xml.MessageSecurityContext_xml");
                this.messageSecuritySender = (IMessageSecuritySender)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.xml.MessageSecuritySender_xml");
                this.messageSecurityReceiver = (IMessageSecurityReceiver)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.xml.MessageSecurityReceiver_xml");
                this.messageSecurityDigest = (IMessageSecurityDigest)ClassLoaderUtilities.newInstance((String)"org.openspcoop2.security.message.xml.MessageSecurityDigest_xml");
            }
            this.messageSecurityContext.init(this);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private void resolvePWCallback(boolean incoming) throws SecurityException {
        try {
            Map<String, Object> props = null;
            props = incoming ? this.incomingProperties : this.outgoingProperties;
            boolean pwCallback = props.containsKey("passwordCallbackRef");
            props.remove("passwordCallbackRef");
            if (pwCallback) {
                Properties convertTextToProperties;
                String mapUserPassword;
                String alias;
                String password;
                String aliasGenerico = null;
                if (props.containsKey("user")) {
                    aliasGenerico = (String)props.get("user");
                }
                HashMap<String, String> mapAliasToPassword = new HashMap<String, String>();
                if (props.containsKey("signaturePassword") || !MessageSecurityContext.isPasswordRequired(props, "signaturePropRefId")) {
                    password = (String)props.get("signaturePassword");
                    alias = null;
                    alias = props.containsKey("signatureUser") ? (String)props.get("signatureUser") : aliasGenerico;
                    if (alias != null) {
                        mapAliasToPassword.put(alias, password);
                    }
                }
                if (props.containsKey("encryptionPassword") || !MessageSecurityContext.isPasswordRequired(props, "encryptionPropRefId")) {
                    password = (String)props.get("encryptionPassword");
                    alias = null;
                    alias = props.containsKey("encryptionUser") ? (String)props.get("encryptionUser") : aliasGenerico;
                    if (alias != null) {
                        mapAliasToPassword.put(alias, password);
                    }
                }
                if (props.containsKey("decryptionPassword") || !MessageSecurityContext.isPasswordRequired(props, "decryptionPropRefId")) {
                    password = (String)props.get("decryptionPassword");
                    alias = null;
                    alias = props.containsKey("decryptionUser") ? (String)props.get("decryptionUser") : aliasGenerico;
                    if (alias != null) {
                        mapAliasToPassword.put(alias, password);
                    }
                }
                if (props.containsKey("usernameTokenPassword")) {
                    password = (String)props.get("usernameTokenPassword");
                    alias = aliasGenerico;
                    if (alias != null) {
                        mapAliasToPassword.put(alias, password);
                    }
                }
                if (props.containsKey("usernameTokenPasswordMap") && (mapUserPassword = (String)props.get("usernameTokenPasswordMap")) != null && !"".equals(mapUserPassword) && (convertTextToProperties = PropertiesUtilities.convertTextToProperties((String)mapUserPassword)) != null && !convertTextToProperties.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : convertTextToProperties.entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        mapAliasToPassword.put(key, value);
                    }
                }
                if (mapAliasToPassword.size() > 0) {
                    CallbackHandler pwCallbackHandler = MessageSecurityContext.newCallbackHandler(mapAliasToPassword);
                    props.put("passwordCallbackRef", pwCallbackHandler);
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private static boolean isPasswordRequired(Map<String, Object> props, String refId) {
        Object o = props.get(refId);
        Properties p = null;
        if (o instanceof Properties) {
            p = (Properties)o;
        }
        return MessageSecurityContext.isPasswordRequired(p, true);
    }

    public static boolean isPasswordRequired(Properties pr, boolean key) {
        String keystoreType = null;
        keystoreType = pr != null ? pr.getProperty("org.apache.ws.security.crypto.merlin.keystore.type") : null;
        keystoreType = keystoreType != null ? keystoreType.trim() : KeyStore.getDefaultType();
        boolean required = true;
        if (KeystoreType.JKS.isType(keystoreType)) {
            required = key ? DBUtils.isKeystoreJksKeyPasswordRequired() : DBUtils.isKeystoreJksPasswordRequired();
        } else if (KeystoreType.PKCS12.isType(keystoreType)) {
            required = key ? DBUtils.isKeystorePkcs12KeyPasswordRequired() : DBUtils.isKeystorePkcs12PasswordRequired();
        }
        return required;
    }

    public static CallbackHandler newCallbackHandler(final Map<String, String> mapAliasToPassword) {
        return new CallbackHandler(){
            private Map<String, String> mapAliasToPasswordParam;
            {
                this.mapAliasToPasswordParam = mapAliasToPassword;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof WSPasswordCallback) {
                        WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                        if (!this.mapAliasToPasswordParam.containsKey(pc.getIdentifier())) continue;
                        pc.setPassword(this.mapAliasToPasswordParam.get(pc.getIdentifier()));
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
            }
        };
    }

    public boolean existsSecurityHeader(OpenSPCoop2Message msg, String actor) {
        SOAPHeader header = null;
        try {
            if (msg == null) {
                return false;
            }
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                return true;
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            header = soapMsg.getSOAPHeader();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("existsHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return false;
        }
        return this.existsSecurityHeader(msg.getFactory(), msg.getMessageType(), header, actor);
    }

    public boolean existsSecurityHeader(OpenSPCoop2Message msg, String actor, boolean bufferMessage_readOnly, String idTransazione) {
        SOAPEnvelope soapEnvelope;
        block6: {
            soapEnvelope = null;
            try {
                if (msg == null) {
                    return false;
                }
                if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
                    SOAPPart soapPart = MessageUtils.getSOAPPart((OpenSPCoop2SoapMessage)soapMsg, (boolean)bufferMessage_readOnly, (String)idTransazione);
                    if (soapPart != null) {
                        soapEnvelope = soapPart.getEnvelope();
                    }
                    break block6;
                }
                return true;
            }
            catch (Exception e) {
                if (this.log != null) {
                    this.log.error("existsHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
                }
                return false;
            }
        }
        return this.existsSecurityHeader(msg.getFactory(), msg.getMessageType(), soapEnvelope, actor);
    }

    public boolean existsSecurityHeader(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, SOAPEnvelope soapEnvelope, String actor) {
        SOAPHeader header = null;
        try {
            header = soapEnvelope.getHeader();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("existsHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return false;
        }
        return this.existsSecurityHeader(messageFactory, messageType, header, actor);
    }

    public boolean existsSecurityHeader(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, SOAPHeader header, String actor) {
        try {
            if (header == null || SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)header).isEmpty()) {
                return false;
            }
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!"Security".equals(headerElement.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(headerElement.getNamespaceURI())) continue;
                String actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)headerElement, (MessageType)messageType);
                if (!(actor == null ? actorCheck == null : actor.equals(actorCheck))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("existsHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return false;
        }
    }

    public SOAPHeaderElement getSecurityHeader(OpenSPCoop2Message msg, String actor) {
        SOAPHeader header = null;
        try {
            if (msg == null) {
                return null;
            }
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                return null;
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            header = soapMsg.getSOAPHeader();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("getHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return null;
        }
        return this.getSecurityHeader(msg.getFactory(), msg.getMessageType(), header, actor);
    }

    public SOAPHeaderElement getSecurityHeader(OpenSPCoop2Message msg, String actor, boolean bufferMessageReadOnly, String idTransazione) {
        SOAPEnvelope soapEnvelope;
        block6: {
            soapEnvelope = null;
            try {
                if (msg == null) {
                    return null;
                }
                if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
                    SOAPPart soapPart = MessageUtils.getSOAPPart((OpenSPCoop2SoapMessage)soapMsg, (boolean)bufferMessageReadOnly, (String)idTransazione);
                    if (soapPart != null) {
                        soapEnvelope = soapPart.getEnvelope();
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                if (this.log != null) {
                    this.log.error("getHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
                }
                return null;
            }
        }
        return this.getSecurityHeader(msg.getFactory(), msg.getMessageType(), soapEnvelope, actor);
    }

    public SOAPHeaderElement getSecurityHeader(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, SOAPEnvelope soapEnvelope, String actor) {
        SOAPHeader header = null;
        try {
            header = soapEnvelope.getHeader();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("getHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return null;
        }
        return this.getSecurityHeader(messageFactory, messageType, header, actor);
    }

    public SOAPHeaderElement getSecurityHeader(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, SOAPHeader header, String actor) {
        try {
            if (header == null || SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)messageFactory, (Node)header).isEmpty()) {
                return null;
            }
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!"Security".equals(headerElement.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(headerElement.getNamespaceURI())) continue;
                String actorCheck = SoapUtils.getSoapActor((SOAPHeaderElement)headerElement, (MessageType)messageType);
                if (!(actor == null ? actorCheck == null : actor.equals(actorCheck))) continue;
                return headerElement;
            }
            return null;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("getHeaderMessageSecurity error con actor[" + actor + "]", (Throwable)e);
            }
            return null;
        }
    }

    public SOAPElement getSAMLTokenInSecurityHeader(OpenSPCoop2MessageFactory messageFactory, SOAPHeaderElement securityHeader, String samlVersion) {
        try {
            SOAPElement samlElement = null;
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace((Node)securityHeader);
            XPathExpressionEngine xpathExpressionEngine = new XPathExpressionEngine(messageFactory);
            String xpath = null;
            xpath = "2.0".equals(samlVersion) ? "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion" : "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion";
            try {
                Object o = xpathExpressionEngine.getMatchPattern((SOAPElement)securityHeader, dnc, xpath, XPathReturnType.NODE);
                samlElement = (SOAPElement)o;
            }
            catch (XPathNotFoundException xPathNotFoundException) {
                // empty catch block
            }
            return samlElement;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("getSAMLTokenInSecurityHeader error, saml version: [" + samlVersion + "]", (Throwable)e);
            }
            return null;
        }
    }

    public String getSAMLTokenSubjectConfirmationMethodInSecurityHeader(OpenSPCoop2MessageFactory messageFactory, SOAPElement samlToken, String samlVersion) {
        try {
            DynamicNamespaceContext dnc = new DynamicNamespaceContext();
            dnc.findPrefixNamespace((Node)samlToken);
            XPathExpressionEngine xpathExpressionEngine = new XPathExpressionEngine(messageFactory);
            String xpath = null;
            xpath = "2.0".equals(samlVersion) ? "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:Subject/{urn:oasis:names:tc:SAML:2.0:assertion}:SubjectConfirmation/@Method" : "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AuthenticationStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Subject/{urn:oasis:names:tc:SAML:1.0:assertion}:SubjectConfirmation/{urn:oasis:names:tc:SAML:1.0:assertion}:ConfirmationMethod/text()";
            String method = null;
            try {
                Object o = xpathExpressionEngine.getMatchPattern(samlToken, dnc, xpath, XPathReturnType.STRING);
                method = (String)o;
            }
            catch (XPathNotFoundException xPathNotFoundException) {
                // empty catch block
            }
            return method;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("getSAMLTokenSubjectConfirmationMethodInSecurityHeader error, saml version: [" + samlVersion + "]", (Throwable)e);
            }
            return null;
        }
    }
}

