/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.SymmetricKeystore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class SymmetricKeystoreCache
extends AbstractKeystoreCache<SymmetricKeystore> {
    @Override
    public SymmetricKeystore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 2) {
            if (!(params[0] instanceof String)) {
                throw new SecurityException("Param[0] must be String (alias)");
            }
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (algoritmo)");
            }
            String alias = (String)params[0];
            String keyValue = key;
            String algoritmo = (String)params[1];
            return new SymmetricKeystore(alias, keyValue, algoritmo);
        }
        if (params.length == 3) {
            if (!(params[0] instanceof String)) {
                throw new SecurityException("Param[0] must be String (alias)");
            }
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (algoritmo)");
            }
            if (!(params[2] instanceof BYOKRequestParams)) {
                throw new SecurityException("Param[2] must be BYOKRequestParams");
            }
            String alias = (String)params[0];
            String keyValue = key;
            String algoritmo = (String)params[1];
            BYOKRequestParams requestParams = (BYOKRequestParams)params[2];
            return new SymmetricKeystore(alias, keyValue, algoritmo, requestParams);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "SymmetricKeystore ";
    }
}

