/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.security.cert.X509Certificate;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.OCSPResponse;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class OCSPResponseCache
extends AbstractKeystoreCache<OCSPResponse> {
    @Override
    public OCSPResponse createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 2) {
            if (params[0] == null) {
                throw new SecurityException("Param[0] must be not null");
            }
            if (!(params[0] instanceof IOCSPValidator)) {
                throw new SecurityException("Param[0] must be IOCSPValidator");
            }
            IOCSPValidator validator = (IOCSPValidator)params[0];
            if (params[1] == null) {
                throw new SecurityException("Param[1] must be not null");
            }
            if (!(params[1] instanceof X509Certificate)) {
                throw new SecurityException("Param[1] must be X509Certificate");
            }
            X509Certificate cer = (X509Certificate)params[1];
            return new OCSPResponse(validator, cer);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "OCSPResponse ";
    }
}

