/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKUnwrapManager;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;

public class SSLSocketFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SSLConfig sslConfig;
    private transient SSLContext sslContext;
    private transient javax.net.ssl.SSLSocketFactory sslSocketFactoryObject;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("SSLContextFactory (").append(this.sslConfig).append(") ");
        return bf.toString();
    }

    public SSLSocketFactory(RequestInfo requestInfo, SSLConfig sslConfig) throws SecurityException {
        this.sslConfig = sslConfig;
        this.initFactory(requestInfo);
    }

    private void checkInit(RequestInfo requestInfo) throws SecurityException {
        if (this.sslSocketFactoryObject == null) {
            this.initFactory(requestInfo);
        }
    }

    private String getErrorMessage(String location, Exception e, boolean keystore) {
        return "Lettura " + (keystore ? "keystore" : "truststore") + " '" + location + "' dalla cache fallita: " + e.getMessage();
    }

    private synchronized void initFactory(RequestInfo requestInfo) throws SecurityException {
        block17: {
            if (this.sslSocketFactoryObject == null) {
                try {
                    String policyType;
                    if (this.sslConfig == null) break block17;
                    BYOKUnwrapManager byokManager = null;
                    if (this.sslConfig.getKeyStoreLocation() != null) {
                        BYOKRequestParams byokParams = null;
                        if (BYOKProvider.isPolicyDefined((String)this.sslConfig.getKeyStoreBYOKPolicy())) {
                            byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)this.sslConfig.getKeyStoreBYOKPolicy(), this.sslConfig.getDynamicMap() != null ? this.sslConfig.getDynamicMap() : new HashMap());
                        }
                        try {
                            KeyStore keystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, this.sslConfig.getKeyStoreLocation(), this.sslConfig.getKeyStoreType(), this.sslConfig.getKeyStorePassword(), byokParams).getKeyStore();
                            this.sslConfig.setKeyStore(keystore.getKeystore(), keystore.isKeystoreHsm());
                        }
                        catch (Exception e) {
                            String msgError = this.getErrorMessage(this.sslConfig.getKeyStoreLocation(), e, true);
                            this.sslConfig.getLoggerBuffer().error(msgError, (Throwable)e);
                        }
                        if (this.sslConfig.getKeyStore() == null && byokParams != null) {
                            byokManager = new BYOKUnwrapManager(this.sslConfig.getKeyStoreBYOKPolicy(), byokParams);
                        }
                    }
                    if (this.sslConfig.getTrustStoreLocation() != null) {
                        try {
                            KeyStore truststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, this.sslConfig.getTrustStoreLocation(), this.sslConfig.getTrustStoreType(), this.sslConfig.getTrustStorePassword()).getTrustStore();
                            this.sslConfig.setTrustStore(truststore.getKeystore(), truststore.isKeystoreHsm());
                        }
                        catch (Exception e) {
                            String msgError = this.getErrorMessage(this.sslConfig.getTrustStoreLocation(), e, false);
                            this.sslConfig.getLoggerBuffer().error(msgError, (Throwable)e);
                        }
                    }
                    GestoreOCSPValidator ocspValidator = null;
                    boolean crlByOcsp = false;
                    if (this.sslConfig.getTrustStoreOCSPPolicy() != null && (policyType = this.sslConfig.getTrustStoreOCSPPolicy()) != null && StringUtils.isNotEmpty((CharSequence)policyType)) {
                        GestoreOCSPValidator gOcspValidator;
                        GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                        String crlInputConfig = this.sslConfig.getTrustStoreCRLsLocation();
                        ocspValidator = new GestoreOCSPValidator(requestInfo, this.sslConfig.getLog4jBuffer(), crlInputConfig, policyType, ocspResourceReader);
                        if (ocspValidator != null && (gOcspValidator = ocspValidator).getOcspConfig() != null) {
                            crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                        }
                    }
                    if (this.sslConfig.getTrustStoreCRLsLocation() != null && !crlByOcsp) {
                        try {
                            this.sslConfig.setTrustStoreCRLs(GestoreKeystoreCache.getCRLCertstore(requestInfo, this.sslConfig.getTrustStoreCRLsLocation()).getCertStore());
                        }
                        catch (Exception e) {
                            String msgError = "Lettura CRLs '" + this.sslConfig.getTrustStoreLocation() + "' dalla cache fallita: " + e.getMessage();
                            this.sslConfig.getLoggerBuffer().error(msgError, (Throwable)e);
                        }
                    }
                    StringBuilder bfSSLConfig = new StringBuilder();
                    this.sslContext = SSLUtilities.generateSSLContext((SSLConfig)this.sslConfig, ocspValidator, byokManager, (StringBuilder)bfSSLConfig);
                    this.sslSocketFactoryObject = this.sslContext.getSocketFactory();
                    if (this.sslConfig.getLoggerBuffer() != null) {
                        String msgDebug = bfSSLConfig.toString();
                        this.sslConfig.getLoggerBuffer().debug(msgDebug);
                    }
                }
                catch (Exception e) {
                    throw new SecurityException(e.getMessage(), e);
                }
            }
        }
    }

    public javax.net.ssl.SSLSocketFactory getSslSocketFactory(RequestInfo requestInfo) throws SecurityException {
        this.checkInit(requestInfo);
        return this.sslSocketFactoryObject;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }
}

