/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import com.nimbusds.jose.jwk.KeyUse;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKEncryptKey;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.SecretKeyStore;
import org.openspcoop2.security.keystore.SecretPasswordKeyDerivationConfig;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKCostanti;
import org.openspcoop2.utils.certificate.byok.BYOKLocalConfig;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.Decrypt;
import org.openspcoop2.utils.security.DecryptOpenSSLPass;
import org.openspcoop2.utils.security.DecryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.DecryptWrapKey;
import org.openspcoop2.utils.security.Encrypt;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.EncryptWrapKey;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWEOptions;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonDecrypt;
import org.openspcoop2.utils.security.JsonEncrypt;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.security.JwtHeaders;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class BYOKLocalEncrypt {
    private RequestInfo requestInfo;
    private static final String JAVA_SEPARATOR = ".";
    private static final String ENCODING_MODE_UNDEFINED = "Encoding mode undefined";
    private static final String KEYSTORE_PREFIX = "Keystore [";

    public BYOKLocalEncrypt(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public BYOKLocalEncrypt() {
    }

    private String getKeystoreError(BYOKLocalConfig config) {
        return "Access to keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' failed";
    }

    private String getKeyError(BYOKLocalConfig config) {
        return "Access to key [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' failed";
    }

    public String wrap(BYOKLocalConfig config, String value) throws UtilsException {
        return this.wrap(config, value.getBytes());
    }

    public String wrap(BYOKLocalConfig config, byte[] value) throws UtilsException {
        BYOKEncryptKey byokEncryptKey = new BYOKEncryptKey();
        boolean initPasswordKeyDerivation = false;
        try {
            switch (config.getKeystoreType()) {
                case JKS: 
                case PKCS12: 
                case PKCS11: 
                case JCEKS: {
                    this.readKeystore(byokEncryptKey, config, true);
                    break;
                }
                case JWK_SET: {
                    this.readJwk(byokEncryptKey, config, true);
                    break;
                }
                case PUBLIC_KEY: {
                    this.readPublicKey(byokEncryptKey, config);
                    break;
                }
                case SYMMETRIC_KEY: {
                    this.readSecretKey(byokEncryptKey, config);
                    break;
                }
                case PASSWORD_KEY_DERIVATION: {
                    this.readPasswordKeyDerivation(byokEncryptKey, config, true);
                    initPasswordKeyDerivation = true;
                    break;
                }
                default: {
                    throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unsupported");
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (config.isJavaEngine()) {
            if (config.isKeyWrap()) {
                if (initPasswordKeyDerivation) {
                    throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with key wrap java mode");
                }
                return this.encJavaKeyWrap(byokEncryptKey, config, value);
            }
            return this.encJava(byokEncryptKey, config, value);
        }
        if (config.isJoseEngine()) {
            if (initPasswordKeyDerivation) {
                throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with jose mode");
            }
            return this.encJose(byokEncryptKey, config, value);
        }
        if (config.isOpenSSLEngine()) {
            return this.encOpenSSL(byokEncryptKey, config, value);
        }
        throw new UtilsException("Encrypt mode undefined");
    }

    public byte[] unwrap(BYOKLocalConfig config, byte[] value) throws UtilsException {
        return this.unwrap(config, new String(value));
    }

    public byte[] unwrap(BYOKLocalConfig config, String value) throws UtilsException {
        BYOKEncryptKey byokEncryptKey = new BYOKEncryptKey();
        boolean initPasswordKeyDerivation = false;
        try {
            switch (config.getKeystoreType()) {
                case JKS: 
                case PKCS12: 
                case PKCS11: 
                case JCEKS: {
                    this.readKeystore(byokEncryptKey, config, false);
                    break;
                }
                case JWK_SET: {
                    this.readJwk(byokEncryptKey, config, false);
                    break;
                }
                case KEY_PAIR: {
                    this.readKeyPair(byokEncryptKey, config);
                    break;
                }
                case SYMMETRIC_KEY: {
                    this.readSecretKey(byokEncryptKey, config);
                    break;
                }
                case PASSWORD_KEY_DERIVATION: {
                    this.readPasswordKeyDerivation(byokEncryptKey, config, false);
                    initPasswordKeyDerivation = true;
                    break;
                }
                default: {
                    throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unsupported");
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (config.isJavaEngine()) {
            return this.unwrapJava(initPasswordKeyDerivation, config, value, byokEncryptKey);
        }
        if (config.isJoseEngine()) {
            if (initPasswordKeyDerivation) {
                throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with jose mode");
            }
            return this.decryptJose(byokEncryptKey, config, value);
        }
        if (config.isOpenSSLEngine()) {
            return this.decryptOpenSSL(byokEncryptKey, config, value);
        }
        throw new UtilsException("Encrypt mode undefined");
    }

    private byte[] unwrapJava(boolean initPasswordKeyDerivation, BYOKLocalConfig config, String value, BYOKEncryptKey byokEncryptKey) throws UtilsException {
        if (initPasswordKeyDerivation) {
            if (config.isKeyWrap()) {
                throw new UtilsException(KEYSTORE_PREFIX + config.getKeystoreType().getNome() + "] unusable with key wrap java mode");
            }
            this.readJavaPasswordKeyDerivationForUnwrap(byokEncryptKey, config, value);
        }
        if (config.isKeyWrap()) {
            return this.decryptJavaKeyWrap(byokEncryptKey, config, value);
        }
        return this.decryptJava(byokEncryptKey, config, value);
    }

    private void readKeystore(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, boolean wrap) throws UtilsException, SecurityException {
        String type = KeystoreType.PKCS11.equals((Object)config.getKeystoreType()) ? config.getKeystoreHsmType() : config.getKeystoreType().getNome();
        MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore(this.requestInfo, config.getKeystorePath(), type, config.getKeystorePassword());
        if (merlinKs == null || merlinKs.getKeyStore() == null) {
            throw new UtilsException(this.getKeystoreError(config));
        }
        byokEncryptKey.ks = merlinKs.getKeyStore();
        if (KeystoreType.JCEKS.equals((Object)config.getKeystoreType())) {
            byokEncryptKey.key = byokEncryptKey.ks.getSecretKey(config.getKeyAlias(), config.getKeyPassword());
            byokEncryptKey.secret = true;
        } else {
            byokEncryptKey.key = wrap ? merlinKs.getKeyStore().getPublicKey(config.getKeyAlias()) : merlinKs.getKeyStore().getPrivateKey(config.getKeyAlias(), config.getKeyPassword());
        }
    }

    private void readJwk(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, boolean wrap) throws UtilsException, SecurityException {
        JWKSetStore jwtStore = GestoreKeystoreCache.getJwkSetStore(this.requestInfo, config.getKeystorePath());
        if (jwtStore == null || jwtStore.getJwkSet() == null) {
            throw new UtilsException(this.getKeystoreError(config));
        }
        byokEncryptKey.jsonWebKeys = jwtStore.getJwkSet().getJsonWebKeys();
        JsonWebKey jwk = JsonUtils.readKey((JsonWebKeys)byokEncryptKey.jsonWebKeys, (String)config.getKeyAlias());
        if (jwk == null) {
            throw new UtilsException("Access to keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "' failed for alias '" + config.getKeyAlias() + "'");
        }
        if (jwk.getAlgorithm() == null) {
            jwk.setAlgorithm(config.isJavaEngine() ? "A256GCM" : config.getContentAlgorithm());
        }
        if (config.getKeyAlgorithm().contains("RSA")) {
            byokEncryptKey.key = wrap ? JwkUtils.toRSAPublicKey((JsonWebKey)jwk) : JwkUtils.toRSAPrivateKey((JsonWebKey)jwk);
        } else if (config.getKeyAlgorithm().contains("EC")) {
            byokEncryptKey.key = wrap ? JwkUtils.toECPublicKey((JsonWebKey)jwk) : JwkUtils.toECPrivateKey((JsonWebKey)jwk);
        } else {
            byokEncryptKey.key = JwkUtils.toSecretKey((JsonWebKey)jwk);
            byokEncryptKey.secret = true;
        }
    }

    private String readKeyAlgo(BYOKLocalConfig config) {
        String algo = config.getKeyAlgorithm();
        if (config.isJoseEngine() || config.isKeyWrap()) {
            algo = config.getKeyAlgorithm().contains("RSA") ? "RSA" : (config.getKeyAlgorithm().contains("DSA") ? "DSA" : (config.getKeyAlgorithm().contains("DH") ? "DH" : (config.getKeyAlgorithm().contains("EC") ? "EC" : "RSA")));
        }
        return algo;
    }

    private byte[] readKeyInline(BYOKLocalConfig config) throws SecurityException {
        String keyInLine = config.getKeyInline();
        byte[] key = null;
        if (config.isKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])keyInLine.getBytes());
        } else if (config.isKeyHexEncoding()) {
            try {
                key = HexBinaryUtilities.decode((String)keyInLine);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        } else {
            key = keyInLine.getBytes();
        }
        return key;
    }

    private byte[] readEncodedKeyFromPath(BYOKLocalConfig config) throws SecurityException {
        byte[] encodedKey = GestoreKeystoreCache.getExternalResource(this.requestInfo, config.getKeyPath(), null).getResource();
        byte[] key = null;
        if (config.isKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])encodedKey);
        } else {
            try {
                key = HexBinaryUtilities.decode((String)new String(encodedKey));
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        return key;
    }

    private byte[] readPublicKeyInline(BYOKLocalConfig config) throws SecurityException {
        String publicKeyInLine = config.getPublicKeyInline();
        byte[] key = null;
        if (config.isPublicKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])publicKeyInLine.getBytes());
        } else if (config.isPublicKeyHexEncoding()) {
            try {
                key = HexBinaryUtilities.decode((String)publicKeyInLine);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        } else {
            key = publicKeyInLine.getBytes();
        }
        return key;
    }

    private byte[] readEncodedPublicKeyFromPath(BYOKLocalConfig config) throws SecurityException {
        byte[] encodedKey = GestoreKeystoreCache.getExternalResource(this.requestInfo, config.getPublicKeyPath(), null).getResource();
        byte[] key = null;
        if (config.isPublicKeyBase64Encoding()) {
            key = Base64Utilities.decode((byte[])encodedKey);
        } else {
            try {
                key = HexBinaryUtilities.decode((String)new String(encodedKey));
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage());
            }
        }
        return key;
    }

    private void readPublicKey(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config) throws UtilsException, SecurityException {
        String algo = this.readKeyAlgo(config);
        PublicKeyStore publicKeyStore = null;
        if (config.getKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyInline())) {
            key = this.readKeyInline(config);
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore(this.requestInfo, key, algo);
        } else if (config.isKeyBase64Encoding() || config.isKeyHexEncoding()) {
            key = this.readEncodedKeyFromPath(config);
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore(this.requestInfo, key, algo);
        } else {
            publicKeyStore = GestoreKeystoreCache.getPublicKeyStore(this.requestInfo, config.getKeyPath(), algo);
        }
        if (publicKeyStore == null) {
            throw new UtilsException(this.getKeyError(config));
        }
        byokEncryptKey.key = publicKeyStore.getPublicKey();
        if (config.isJoseEngine()) {
            if (config.getKeyId() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyId())) {
                config.setKeyAlias(config.getKeyId());
            } else {
                config.generateKeyAlias();
            }
            JWK jwk = new JWK(publicKeyStore.getPublicKey(), config.getKeyAlias());
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            jwkSet.getJson();
            byokEncryptKey.jsonWebKeys = jwkSet.getJsonWebKeys();
        }
    }

    private void readKeyPair(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config) throws UtilsException, SecurityException {
        String algo = this.readKeyAlgo(config);
        KeyPairStore keyPairStore = this.getKeyPairStore(algo, config);
        if (keyPairStore == null) {
            throw new UtilsException(this.getKeyError(config));
        }
        byokEncryptKey.key = keyPairStore.getPrivateKey();
        if (config.isJoseEngine()) {
            if (config.getKeyId() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyId())) {
                config.setKeyAlias(config.getKeyId());
            } else {
                config.generateKeyAlias();
            }
            JWK jwk = new JWK(keyPairStore.getPublicKey(), keyPairStore.getPrivateKey(), config.getKeyAlias(), KeyUse.ENCRYPTION);
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            jwkSet.getJson();
            byokEncryptKey.jsonWebKeys = jwkSet.getJsonWebKeys();
        }
    }

    private KeyPairStore getKeyPairStore(String algo, BYOKLocalConfig config) throws SecurityException {
        KeyPairStore keyPairStore = null;
        if (config.getKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyInline())) {
            byte[] key = this.readKeyInline(config);
            if (config.getPublicKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getPublicKeyInline())) {
                byte[] publicKey = this.readPublicKeyInline(config);
                keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, publicKey, config.getKeyPassword(), algo);
            } else if (config.isPublicKeyBase64Encoding() || config.isPublicKeyHexEncoding()) {
                byte[] publicKey = this.readEncodedPublicKeyFromPath(config);
                keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, publicKey, config.getKeyPassword(), algo);
            } else {
                keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, config.getPublicKeyPath(), config.getKeyPassword(), algo);
            }
        } else {
            keyPairStore = this.getKeyPairStoreFromPath(algo, config);
        }
        return keyPairStore;
    }

    private KeyPairStore getKeyPairStoreFromPath(String algo, BYOKLocalConfig config) throws SecurityException {
        KeyPairStore keyPairStore = null;
        if (config.isKeyBase64Encoding() || config.isKeyHexEncoding()) {
            keyPairStore = this.getEncodedKeyPairStoreFromPath(algo, config);
        } else if (config.getPublicKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getPublicKeyInline())) {
            byte[] publicKey = this.readPublicKeyInline(config);
            keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, config.getKeyPath(), publicKey, config.getKeyPassword(), algo);
        } else if (config.isPublicKeyBase64Encoding() || config.isPublicKeyHexEncoding()) {
            byte[] publicKey = this.readEncodedPublicKeyFromPath(config);
            keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, config.getKeyPath(), publicKey, config.getKeyPassword(), algo);
        } else {
            keyPairStore = GestoreKeystoreCache.getKeyPairStore(this.requestInfo, config.getKeyPath(), config.getPublicKeyPath(), config.getKeyPassword(), algo);
        }
        return keyPairStore;
    }

    private KeyPairStore getEncodedKeyPairStoreFromPath(String algo, BYOKLocalConfig config) throws SecurityException {
        byte[] key = this.readEncodedKeyFromPath(config);
        if (config.getPublicKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getPublicKeyInline())) {
            byte[] publicKey = this.readPublicKeyInline(config);
            return GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, publicKey, config.getKeyPassword(), algo);
        }
        if (config.isPublicKeyBase64Encoding() || config.isPublicKeyHexEncoding()) {
            byte[] publicKey = this.readEncodedPublicKeyFromPath(config);
            return GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, publicKey, config.getKeyPassword(), algo);
        }
        return GestoreKeystoreCache.getKeyPairStore(this.requestInfo, key, config.getPublicKeyPath(), config.getKeyPassword(), algo);
    }

    private void readSecretKey(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config) throws UtilsException, SecurityException {
        String algo = config.isJoseEngine() ? "AES" : config.getKeyAlgorithm();
        SecretKeyStore secretKeyStore = null;
        if (config.getKeyInline() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyInline())) {
            byte[] key = this.readKeyInline(config);
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore(this.requestInfo, key, algo);
        } else if (config.isKeyBase64Encoding() || config.isKeyHexEncoding()) {
            byte[] key = this.readEncodedKeyFromPath(config);
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore(this.requestInfo, key, algo);
        } else {
            secretKeyStore = GestoreKeystoreCache.getSecretKeyStore(this.requestInfo, config.getKeyPath(), algo);
        }
        this.initSecretKey(secretKeyStore, byokEncryptKey, config);
    }

    private void readPasswordKeyDerivation(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, boolean wrap) throws UtilsException, SecurityException {
        byokEncryptKey.pwdKeyDerivationConfig = new SecretPasswordKeyDerivationConfig(config.getPassword(), config.getPasswordType(), config.getPasswordIteration());
        if (!config.isOpenSSLEngine() && wrap) {
            SecretKeyStore secretKeyStore = GestoreKeystoreCache.getSecretKeyStore(this.requestInfo, byokEncryptKey.pwdKeyDerivationConfig);
            this.initSecretKey(secretKeyStore, byokEncryptKey, config);
        }
    }

    private void readJavaPasswordKeyDerivationForUnwrap(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String wrapValue) throws UtilsException {
        String[] tmp = wrapValue.split("\\.");
        if (tmp == null || tmp.length != 2) {
            throw new UtilsException("Wrong format");
        }
        byte[] iv = null;
        byte[] dataEncrypted = null;
        if (config.isBase64Encoding()) {
            iv = Base64Utilities.decode((String)tmp[0]);
            dataEncrypted = Base64Utilities.decode((String)tmp[1]);
        } else if (config.isHexEncoding()) {
            iv = HexBinaryUtilities.decode((String)tmp[0]);
            dataEncrypted = HexBinaryUtilities.decode((String)tmp[1]);
        } else {
            throw new UtilsException(ENCODING_MODE_UNDEFINED);
        }
        CipherInfo cipherInfo = null;
        cipherInfo = BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)byokEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode()) ? DecryptOpenSSLPassPBKDF2.buildCipherInfo((byte[])dataEncrypted, (String)byokEncryptKey.pwdKeyDerivationConfig.getPassword(), (Integer)byokEncryptKey.pwdKeyDerivationConfig.getPasswordIterator(), (OpenSSLEncryptionMode)OpenSSLEncryptionMode.toMode((String)byokEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode())) : DecryptOpenSSLPass.buildCipherInfo((byte[])dataEncrypted, (String)byokEncryptKey.pwdKeyDerivationConfig.getPassword(), null, (OpenSSLEncryptionMode)OpenSSLEncryptionMode.toMode((String)byokEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode()));
        try {
            this.initSecretKey((SecretKey)cipherInfo.getKey(), iv, cipherInfo.getSalt(), byokEncryptKey, config);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void initSecretKey(SecretKeyStore secretKeyStore, BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config) throws UtilsException, SecurityException {
        if (secretKeyStore == null) {
            throw new UtilsException(this.getKeyError(config));
        }
        this.initSecretKey(secretKeyStore.getSecretKey(), secretKeyStore.getIv(), secretKeyStore.getSalt(), byokEncryptKey, config);
    }

    private void initSecretKey(SecretKey key, byte[] iv, byte[] salt, BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config) throws UtilsException {
        byokEncryptKey.key = key;
        byokEncryptKey.iv = iv;
        byokEncryptKey.salt = salt;
        byokEncryptKey.secret = true;
        if (config.isJoseEngine()) {
            if (config.getKeyId() != null && StringUtils.isNotEmpty((CharSequence)config.getKeyId())) {
                config.setKeyAlias(config.getKeyId());
            } else {
                config.generateKeyAlias();
            }
            JWK jwk = new JWK(key, config.getKeyAlias(), KeyUse.ENCRYPTION);
            JWKSet jwkSet = new JWKSet();
            jwkSet.addJwk(jwk);
            jwkSet.getJson();
            byokEncryptKey.jsonWebKeys = jwkSet.getJsonWebKeys();
        }
    }

    private String encJava(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        Encrypt encrypt = null;
        encrypt = byokEncryptKey.secret && byokEncryptKey.iv != null ? new Encrypt(byokEncryptKey.key, byokEncryptKey.iv) : new Encrypt(byokEncryptKey.key);
        if (byokEncryptKey.secret && byokEncryptKey.iv == null) {
            encrypt.initIV(config.getContentAlgorithm());
        }
        byte[] encrypted = null;
        try {
            encrypted = encrypt.encrypt(value, config.getContentAlgorithm());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (byokEncryptKey.secret && byokEncryptKey.salt != null) {
            encrypted = EncryptOpenSSLPass.formatOutput((byte[])byokEncryptKey.salt, (byte[])encrypted);
        }
        String en = null;
        if (config.isBase64Encoding()) {
            en = Base64Utilities.encodeAsString((byte[])encrypted);
        } else if (config.isHexEncoding()) {
            en = HexBinaryUtilities.encodeAsString((byte[])encrypted);
        } else {
            throw new UtilsException("Java algorithm undefined in keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "'");
        }
        if (byokEncryptKey.secret) {
            if (config.isBase64Encoding()) {
                return encrypt.getIVBase64AsString() + JAVA_SEPARATOR + en;
            }
            return encrypt.getIVHexBinaryAsString() + JAVA_SEPARATOR + en;
        }
        return en;
    }

    private String encJavaKeyWrap(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        EncryptWrapKey encrypt = null;
        encrypt = byokEncryptKey.ks != null ? new EncryptWrapKey(byokEncryptKey.ks, config.getKeyAlias()) : new EncryptWrapKey(byokEncryptKey.key);
        byte[] encrypted = null;
        try {
            encrypted = encrypt.encrypt(value, config.getKeyAlgorithm(), config.getContentAlgorithm());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        String en = null;
        if (config.isBase64Encoding()) {
            en = Base64Utilities.encodeAsString((byte[])encrypted);
        } else if (config.isHexEncoding()) {
            en = HexBinaryUtilities.encodeAsString((byte[])encrypted);
        } else {
            throw new UtilsException("Java algorithm undefined in keystore [" + config.getKeystoreType().getNome() + "] '" + config.getKeystorePath() + "'");
        }
        if (config.isBase64Encoding()) {
            return encrypt.getWrappedKeyBase64() + JAVA_SEPARATOR + encrypt.getIVBase64AsString() + JAVA_SEPARATOR + en;
        }
        return encrypt.getWrappedKeyHexBinary() + JAVA_SEPARATOR + encrypt.getIVHexBinaryAsString() + JAVA_SEPARATOR + en;
    }

    private String encJose(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        JsonEncrypt encrypt = null;
        JwtHeaders jwtHeaders = null;
        JWEOptions options = new JWEOptions(JOSESerialization.COMPACT);
        if (byokEncryptKey.ks != null) {
            jwtHeaders = this.getJwtHeaders(config, byokEncryptKey.ks);
            encrypt = byokEncryptKey.secret ? new JsonEncrypt(byokEncryptKey.ks, config.getKeyAlias(), config.getKeyPassword(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options) : new JsonEncrypt(byokEncryptKey.ks, config.getKeyAlias(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options);
        } else {
            jwtHeaders = this.getJwtHeaders(config, byokEncryptKey.jsonWebKeys);
            encrypt = new JsonEncrypt(byokEncryptKey.jsonWebKeys, byokEncryptKey.secret, config.getKeyAlias(), config.getKeyAlgorithm(), config.getContentAlgorithm(), jwtHeaders, options);
        }
        return encrypt.encrypt(value);
    }

    private JwtHeaders getJwtHeaders(BYOKLocalConfig config, KeyStore ks) throws UtilsException {
        return this.getJwtHeaders(config, ks, null);
    }

    private JwtHeaders getJwtHeaders(BYOKLocalConfig config, JsonWebKeys jsonWebKeys) throws UtilsException {
        return this.getJwtHeaders(config, null, jsonWebKeys);
    }

    private JwtHeaders getJwtHeaders(BYOKLocalConfig config, KeyStore ks, JsonWebKeys jsonWebKeys) throws UtilsException {
        Certificate cert;
        JwtHeaders jwtHeaders = new JwtHeaders();
        if (config.isJoseIncludeKeyId()) {
            jwtHeaders.setKid(config.getKeyAlias());
        }
        if (config.isJoseIncludeCert()) {
            jwtHeaders.setAddX5C(true);
        }
        if (config.isJoseIncludeCertSha1()) {
            jwtHeaders.setX509IncludeCertSha1(true);
        }
        if (config.isJoseIncludeCertSha256()) {
            jwtHeaders.setX509IncludeCertSha256(true);
        }
        if (ks != null && (config.isJoseIncludeCert() || config.isJoseIncludeCertSha1() || config.isJoseIncludeCertSha256()) && (cert = ks.getCertificate(config.getKeyAlias())) instanceof X509Certificate) {
            jwtHeaders.addX509cert((X509Certificate)cert);
        }
        if (jsonWebKeys != null && config.isJoseIncludePublicKey()) {
            jwtHeaders.setJwKey(jsonWebKeys, config.getKeyAlias());
        }
        return jwtHeaders;
    }

    private String encOpenSSL(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        if (BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)byokEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode())) {
            return this.encOpenSSLPBKDF2(byokEncryptKey, config, value);
        }
        return this.encOpenSSLStandard(byokEncryptKey, config, value);
    }

    private String encOpenSSLStandard(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = byokEncryptKey.pwdKeyDerivationConfig;
        EncryptOpenSSLPass encrypt = new EncryptOpenSSLPass(passwordKeyDerivationConfig.getPassword(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return encrypt.encryptBase64AsString(value);
        }
        if (config.isHexEncoding()) {
            return encrypt.encryptHexBinaryAsString(value);
        }
        throw new UtilsException(ENCODING_MODE_UNDEFINED);
    }

    private String encOpenSSLPBKDF2(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, byte[] value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = byokEncryptKey.pwdKeyDerivationConfig;
        EncryptOpenSSLPassPBKDF2 encrypt = new EncryptOpenSSLPassPBKDF2(passwordKeyDerivationConfig.getPassword(), passwordKeyDerivationConfig.getPasswordIterator(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return encrypt.encryptBase64AsString(value);
        }
        if (config.isHexEncoding()) {
            return encrypt.encryptHexBinaryAsString(value);
        }
        throw new UtilsException(ENCODING_MODE_UNDEFINED);
    }

    private byte[] decryptJava(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        Decrypt d = null;
        byte[] dataEncrypted = null;
        if (byokEncryptKey.secret) {
            String[] tmp = value.split("\\.");
            if (tmp == null || tmp.length != 2) {
                throw new UtilsException("Atteso formato iv.secret (enc)");
            }
            byte[] iv = null;
            if (config.isBase64Encoding()) {
                iv = Base64Utilities.decode((String)tmp[0]);
                dataEncrypted = Base64Utilities.decode((String)tmp[1]);
            } else if (config.isHexEncoding()) {
                iv = HexBinaryUtilities.decode((String)tmp[0]);
                dataEncrypted = HexBinaryUtilities.decode((String)tmp[1]);
            } else {
                iv = tmp[0].getBytes();
                dataEncrypted = tmp[1].getBytes();
            }
            if (KeystoreType.PASSWORD_KEY_DERIVATION.equals((Object)config.getKeystoreType())) {
                dataEncrypted = DecryptOpenSSLPass.extractCipherBytes((byte[])dataEncrypted);
            }
            d = new Decrypt(byokEncryptKey.key, iv);
        } else {
            dataEncrypted = config.isBase64Encoding() ? Base64Utilities.decode((String)value) : (config.isHexEncoding() ? HexBinaryUtilities.decode((String)value) : value.getBytes());
            d = new Decrypt(byokEncryptKey.key);
        }
        return d.decrypt(dataEncrypted, config.getContentAlgorithm());
    }

    private byte[] decryptJavaKeyWrap(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        String[] tmp = value.split("\\.");
        if (tmp == null || tmp.length != 3) {
            throw new UtilsException("Atteso formato wrappedKey.iv.secret (" + config.getEncoding() + ")");
        }
        byte[] wrappedKey = null;
        byte[] iv = null;
        byte[] dataEncrypted = null;
        if (config.isBase64Encoding()) {
            wrappedKey = Base64Utilities.decode((String)tmp[0]);
            iv = Base64Utilities.decode((String)tmp[1]);
            dataEncrypted = Base64Utilities.decode((String)tmp[2]);
        } else if (config.isHexEncoding()) {
            wrappedKey = HexBinaryUtilities.decode((String)tmp[0]);
            iv = HexBinaryUtilities.decode((String)tmp[1]);
            dataEncrypted = HexBinaryUtilities.decode((String)tmp[2]);
        } else {
            wrappedKey = tmp[0].getBytes();
            iv = tmp[1].getBytes();
            dataEncrypted = tmp[2].getBytes();
        }
        DecryptWrapKey d = new DecryptWrapKey(byokEncryptKey.key);
        return d.decrypt(dataEncrypted, wrappedKey, iv, config.getKeyAlgorithm(), config.getContentAlgorithm());
    }

    private byte[] decryptJose(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        JsonDecrypt decrypt = null;
        JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
        decrypt = byokEncryptKey.ks != null ? new JsonDecrypt(byokEncryptKey.ks, byokEncryptKey.secret, config.getKeyAlias(), config.getKeyPassword(), config.getKeyAlgorithm(), config.getContentAlgorithm(), options) : new JsonDecrypt(byokEncryptKey.jsonWebKeys, byokEncryptKey.secret, config.getKeyAlias(), config.getKeyAlgorithm(), config.getContentAlgorithm(), options);
        decrypt.decrypt(value);
        return decrypt.getDecodedPayloadAsByte();
    }

    private byte[] decryptOpenSSL(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        if (BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)byokEncryptKey.pwdKeyDerivationConfig.getPasswordEncryptionMode())) {
            return this.decryptOpenSSLPBKDF2(byokEncryptKey, config, value);
        }
        return this.decryptOpenSSLStandard(byokEncryptKey, config, value);
    }

    private byte[] decryptOpenSSLStandard(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = byokEncryptKey.pwdKeyDerivationConfig;
        DecryptOpenSSLPass decrypt = new DecryptOpenSSLPass(passwordKeyDerivationConfig.getPassword(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return decrypt.decryptBase64(value);
        }
        if (config.isHexEncoding()) {
            return decrypt.decryptHexBinary(value);
        }
        throw new UtilsException(ENCODING_MODE_UNDEFINED);
    }

    private byte[] decryptOpenSSLPBKDF2(BYOKEncryptKey byokEncryptKey, BYOKLocalConfig config, String value) throws UtilsException {
        SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig = byokEncryptKey.pwdKeyDerivationConfig;
        DecryptOpenSSLPassPBKDF2 decrypt = new DecryptOpenSSLPassPBKDF2(passwordKeyDerivationConfig.getPassword(), passwordKeyDerivationConfig.getPasswordIterator(), OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
        if (config.isBase64Encoding()) {
            return decrypt.decryptBase64(value);
        }
        if (config.isHexEncoding()) {
            return decrypt.decryptHexBinary(value);
        }
        throw new UtilsException(ENCODING_MODE_UNDEFINED);
    }
}

