/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers.pdnd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDNDConfig;
import org.openspcoop2.pdd.config.PDNDConfigUtilities;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.pdnd.TimerGestoreChiaviPDNDLib;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerGestoreChiaviPDND
extends BaseThread {
    public static final String ID_MODULO = "TimerGestoreChiaviPDND";
    static final String CONNESSIONE_NON_DISPONIBILE = "Connessione al database della configurazione non disponibile";
    private Logger logTimer = null;
    private MsgDiagnostico msgDiag = null;
    private OpenSPCoop2Properties op2Properties = null;
    private List<PDNDConfig> remoteStores;
    private Map<String, String> mapUrlCheckEventi;

    private void logError(String msgErrore, Exception e) {
        if (this.logTimer != null) {
            this.logTimer.error(msgErrore, (Throwable)e);
        }
    }

    public TimerGestoreChiaviPDND(long timeout, List<PDNDConfig> remoteStores) throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            Utilities.sleep((long)1000L);
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreChiaviPDND.");
            this.msgDiag.addKeyword("@ID_TIMER@", ID_MODULO);
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.op2Properties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logError(msgErrore, e);
            throw new TimerException(msgErrore, e);
        }
        this.remoteStores = remoteStores;
        this.initMapUrlCheckEventi();
        this.setTimeout((int)timeout);
        String sec = "secondi";
        if (this.getTimeout() == 1) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.getTimeout() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    private void initMapUrlCheckEventi() throws TimerException {
        if (this.remoteStores != null && !this.remoteStores.isEmpty()) {
            for (PDNDConfig pdndConfig : this.remoteStores) {
                String remoteStoreName = pdndConfig.getRemoteStoreConfig().getStoreName();
                try {
                    String urlCheckEventi = PDNDConfigUtilities.buildUrlCheckEventi(pdndConfig.getRemoteStoreConfig());
                    if (this.mapUrlCheckEventi == null) {
                        this.mapUrlCheckEventi = new HashMap<String, String>();
                    }
                    this.mapUrlCheckEventi.put(remoteStoreName, urlCheckEventi);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
                    String msgErrore = "Riscontrato errore durante l'inizializzazione della configurazione del timer: " + e.getMessage();
                    this.logError(msgErrore, e);
                    throw new TimerException(msgErrore, e);
                }
            }
        }
    }

    public void process() {
        try {
            if (this.remoteStores != null && !this.remoteStores.isEmpty()) {
                for (PDNDConfig remoteStore : this.remoteStores) {
                    String remoteStoreName = remoteStore.getRemoteStoreConfig().getStoreName();
                    this.msgDiag.addKeyword("@ID_REMOTE_STORE@", remoteStoreName);
                    String urlCheckEventi = this.mapUrlCheckEventi.get(remoteStoreName);
                    this.process(remoteStoreName, remoteStore, urlCheckEventi);
                }
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreChiaviPDNDLib.check()");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }

    private void process(String remoteStoreName, PDNDConfig remoteStore, String urlCheckEventi) {
        try {
            TimerGestoreChiaviPDNDLib timer = new TimerGestoreChiaviPDNDLib(this.logTimer, this.msgDiag, remoteStore.getRemoteStoreConfig(), urlCheckEventi, this.getTimeout());
            timer.check();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "TimerGestoreChiaviPDNDLib.check(" + remoteStoreName + ")");
            this.logError("Errore generale: " + e.getMessage(), e);
        }
    }
}

