/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.io.Serializable;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;

public enum TipoLock implements Serializable
{
    GESTIONE_REPOSITORY_MESSAGGI("RepositoryMessaggi"),
    GESTIONE_PULIZIA_REPOSITORY_MESSAGGI("PuliziaRepositoryMessaggi"),
    GESTIONE_PULIZIA_REPOSITORY_BUSTE("PuliziaRepositoryBuste"),
    GESTIONE_CORRELAZIONE_APPLICATIVA("CorrelazioneApplicativa"),
    GESTIONE_BUSTE_NON_RISCONTRATE("BusteNonRiscontrate"),
    GESTIONE_PULIZIA_MESSAGGI_ANOMALI("PuliziaMessaggiAnomali"),
    GESTIONE_FILESYSTEM_TRACE_RECOVERY("FileSystemTraceRecovery"),
    GENERAZIONE_STATISTICHE_ORARIE(TipoLock.getLockStatistico(TipoIntervalloStatistico.STATISTICHE_ORARIE)),
    GENERAZIONE_STATISTICHE_GIORNALIERE(TipoLock.getLockStatistico(TipoIntervalloStatistico.STATISTICHE_GIORNALIERE)),
    GENERAZIONE_STATISTICHE_SETTIMANALI(TipoLock.getLockStatistico(TipoIntervalloStatistico.STATISTICHE_SETTIMANALI)),
    GENERAZIONE_STATISTICHE_MENSILI(TipoLock.getLockStatistico(TipoIntervalloStatistico.STATISTICHE_MENSILI)),
    GENERAZIONE_PDND_TRACCIAMENTO_GENERAZIONE(TipoLock.getLockStatistico(TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO)),
    GENERAZIONE_PDND_TRACCIAMENTO_PUBBLICAZIONE(TipoLock.getLockStatistico(TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO)),
    CONSEGNA_NOTIFICHE("ConsegnaNotifiche"),
    GESTORE_CHIAVI_PDND("GestoreChaviPDND"),
    STARTUP("StartupGateway"),
    CUSTOM("Custom");

    private final String tipo;

    private static final String getLockStatistico(TipoIntervalloStatistico tipo) {
        if (TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO.equals((Object)tipo) || TipoIntervalloStatistico.PDND_PUBBLICAZIONE_TRACCIAMENTO.equals((Object)tipo)) {
            return tipo.getValue();
        }
        return "Generazione" + tipo.getValue();
    }

    private TipoLock(String tipo) {
        this.tipo = tipo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public static TipoLock _getLockGestioneRepositoryMessaggi() {
        return GESTIONE_REPOSITORY_MESSAGGI;
    }
}

