/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TipoLock;

public class TimerLock {
    private TipoLock tipoLock;
    private String idLock;

    public static TimerLock newInstance(TipoLock tipoLock) throws TimerException {
        return new TimerLock(tipoLock);
    }

    public TimerLock(TipoLock tipoLock) throws TimerException {
        this(tipoLock, tipoLock.getTipo());
        TimerLock.check(tipoLock);
    }

    private static void check(TipoLock tipoLock) throws TimerException {
        if (TipoLock.CUSTOM.equals(tipoLock) || TipoLock.CONSEGNA_NOTIFICHE.equals(tipoLock)) {
            throw new TimerException("Tipo lock '" + String.valueOf(tipoLock) + "' non utilizzabile senza fornire l'id del lock");
        }
    }

    public TimerLock(TipoLock tipoLock, String idLock) throws TimerException {
        if (tipoLock == null) {
            throw new TimerException("Tipo lock non definito");
        }
        if ((TipoLock.CUSTOM.equals(tipoLock) || TipoLock.CONSEGNA_NOTIFICHE.equals(tipoLock)) && (idLock == null || "".equals(idLock))) {
            throw new TimerException("Tipo lock '" + String.valueOf(tipoLock) + "' non utilizzabile senza fornire l'id del lock");
        }
        this.tipoLock = tipoLock;
        this.idLock = idLock == null || "".equals(idLock) ? tipoLock.getTipo() : (TipoLock.CONSEGNA_NOTIFICHE.equals(tipoLock) ? TimerLock.getIdLockConsegnaNotifica(idLock) : idLock);
    }

    public static String getIdLockConsegnaNotifica(String queue) throws TimerException {
        if (queue == null) {
            throw new TimerException("Coda non definita");
        }
        return TipoLock.CONSEGNA_NOTIFICHE.getTipo() + "-" + queue;
    }

    public TipoLock getTipoLock() {
        return this.tipoLock;
    }

    public void setTipoLock(TipoLock tipoLock) {
        this.tipoLock = tipoLock;
    }

    public String getIdLock() {
        return this.idLock;
    }

    public void setIdLock(String idLock) {
        this.idLock = idLock;
    }
}

