/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerLockNotAvailableException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.slf4j.Logger;

public class TimerGestoreRepositoryBusteLib {
    private static TimerState STATE = TimerState.OFF;
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;
    private TimerLock timerLock = null;
    private Semaphore semaphore = null;
    private InfoStatistics semaphore_statistics;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerGestoreRepositoryBusteLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, boolean orderByQuery) throws TimerException {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
        this.timerLock = this.propertiesReader.isMsgGiaInProcessamentoUseLock() ? new TimerLock(TipoLock._getLockGestioneRepositoryMessaggi()) : new TimerLock(TipoLock.GESTIONE_PULIZIA_REPOSITORY_BUSTE);
        if (this.propertiesReader.isTimerLockByDatabase()) {
            this.semaphore_statistics = new InfoStatistics();
            SemaphoreConfiguration config = GestoreMessaggi.newSemaphoreConfiguration(this.propertiesReader.getTimerGestoreRepositoryBusteLockMaxLife(), this.propertiesReader.getTimerGestoreRepositoryBusteLockIdleTime());
            TipiDatabase databaseType = TipiDatabase.toEnumConstant((String)this.propertiesReader.getDatabaseType());
            try {
                this.semaphore = new Semaphore(this.semaphore_statistics, SemaphoreMapping.newInstance((String)this.timerLock.getIdLock()), config, databaseType, this.logTimer);
            }
            catch (Exception e) {
                throw new TimerException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error("[GestoreRepositoryBuste] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error(msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            this.logTimer.error("[GestoreRepositoryBuste] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error("[GestoreRepositoryBuste] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (!TimerState.ENABLED.equals((Object)STATE)) {
            this.msgDiag.logPersonalizzato("disabilitato");
            this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("disabilitato"));
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info(this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryBuste = DateManager.getTimeMillis();
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefaultWithoutProtocol(), "GestoreRepositoryBuste", null);
            Connection connectionDB = ((StateMessage)openspcoopstate.getStatoRichiesta()).getConnectionDB();
            RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), this.logTimer, null);
            boolean trovatiMessaggi = true;
            while (trovatiMessaggi) {
                List idMsgOUTBOX;
                List idMsgINBOX;
                block50: {
                    Date now;
                    block49: {
                        trovatiMessaggi = false;
                        now = null;
                        if (!this.propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                            now = DateManager.getDate();
                        }
                        String causaMessaggiINBOX = "Eliminazione buste (INBOX) marcate logicamente da eliminare";
                        idMsgINBOX = null;
                        try {
                            GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOX, this.propertiesReader.getTimerGestoreRepositoryBuste_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreRepositoryBuste_getLockCheckInterval());
                            idMsgINBOX = repositoryBuste.getBusteDaEliminareFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.propertiesReader.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione(), this.orderByQuery, now);
                            int gestiti = 0;
                            if (idMsgINBOX != null && idMsgINBOX.size() > 0) {
                                if (this.logQuery) {
                                    this.logTimer.info("Trovate " + idMsgINBOX.size() + " buste da eliminare nel repository (INBOX) ...");
                                }
                                trovatiMessaggi = true;
                                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                                for (int i = 0; i < idMsgINBOX.size(); ++i) {
                                    String idMsgDaEliminare = (String)idMsgINBOX.get(i);
                                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                    try {
                                        try {
                                            GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione busta INBOX con id [" + idMsgDaEliminare + "] ...");
                                        }
                                        catch (Throwable e) {
                                            this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")-UpdateLock");
                                            this.logTimer.error("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                            break;
                                        }
                                        repositoryBuste.eliminaBustaFromInBox(idMsgDaEliminare, now);
                                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                        if (this.logQuery) {
                                            this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                        }
                                        ++gestiti;
                                        continue;
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                                        this.logTimer.error("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (this.logQuery) {
                                    this.logTimer.info("Eliminate " + gestiti + " buste nel repository (INBOX)");
                                }
                                break block49;
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Non sono state trovate buste da eliminare nel repository (INBOX)");
                            }
                        }
                        finally {
                            try {
                                GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiINBOX);
                            }
                            catch (Exception gestiti) {}
                        }
                    }
                    String causaMessaggiOUTBOX = "Eliminazione buste (OUTBOX) marcate logicamente da eliminare";
                    idMsgOUTBOX = null;
                    try {
                        GestoreMessaggi.acquireLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOX, this.propertiesReader.getTimerGestoreRepositoryBuste_getLockAttesaAttiva(), this.propertiesReader.getTimerGestoreRepositoryBuste_getLockCheckInterval());
                        idMsgOUTBOX = repositoryBuste.getBusteDaEliminareFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.propertiesReader.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione(), this.orderByQuery, now);
                        int gestiti = 0;
                        if (idMsgOUTBOX != null && idMsgOUTBOX.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info("Trovate " + idMsgOUTBOX.size() + " buste da eliminare nel repository (OUTBOX) ...");
                            }
                            trovatiMessaggi = true;
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                            for (int i = 0; i < idMsgOUTBOX.size(); ++i) {
                                String idMsgDaEliminare = (String)idMsgOUTBOX.get(i);
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                                try {
                                    try {
                                        GestoreMessaggi.updateLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, "Eliminazione busta OUTBOX con id [" + idMsgDaEliminare + "] ...");
                                    }
                                    catch (Throwable e) {
                                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")-UpdateLock");
                                        this.logTimer.error("ErroreEliminazioneBustaOutbox(" + idMsgDaEliminare + ")-UpdateLock: " + e.getMessage(), e);
                                        break;
                                    }
                                    repositoryBuste.eliminaBustaFromOutBox(idMsgDaEliminare, now);
                                    this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                    if (this.logQuery) {
                                        this.logTimer.debug(this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                    }
                                    ++gestiti;
                                    continue;
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                                    this.logTimer.error("ErroreEliminazioneBustaOutbox(" + idMsgDaEliminare + "): " + e.getMessage(), (Throwable)e);
                                }
                            }
                            if (this.logQuery) {
                                this.logTimer.info("Eliminate " + gestiti + " buste nel repository (OUTBOX)");
                            }
                            break block50;
                        }
                        if (this.logQuery) {
                            this.logTimer.info("Non sono state trovate buste da eliminare nel repository (OUTBOX)");
                        }
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.semaphore, connectionDB, this.timerLock, this.msgDiag, causaMessaggiOUTBOX);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!trovatiMessaggi) continue;
                this.msgDiag.addKeyword("@NUMERO_BUSTE_INBOX@", (String)(idMsgINBOX != null ? "" + idMsgINBOX.size() : "0"));
                this.msgDiag.addKeyword("@NUMERO_BUSTE_OUTBOX@", (String)(idMsgOUTBOX != null ? "" + idMsgOUTBOX.size() : "0"));
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
            }
            long endControlloRepositoryBuste = DateManager.getTimeMillis();
            long diff = endControlloRepositoryBuste - startControlloRepositoryBuste;
            this.logTimer.info("Controllo Repository Buste terminato in " + Utilities.convertSystemTimeIntoStringMillisecondi((long)diff, (boolean)true));
        }
        catch (TimerLockNotAvailableException t) {
            this.logTimer.info(t.getMessage(), (Throwable)t);
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBuste");
            this.logTimer.error("Riscontrato errore durante l'eliminazione delle buste: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

