/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.controllo_traffico.NotificatoreEventi;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttive;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerEventiThread
extends BaseThread {
    private static TimerState STATE = TimerState.OFF;
    public static final String ID_MODULO = "TimerEventi";
    private Logger log = null;
    private boolean debug = false;
    private OpenSPCoop2Properties properties;
    private NotificatoreEventi notificatoreEventi = null;
    private Date lastInterval;
    private int checkConnectionTimeoutEveryXTimes = 1;
    private int offsetConnectionTimeoutEveryXTimes = 0;
    private Date lastIntervalConnectionTimeout;
    private int checkRequestReadTimeoutEveryXTimes = 1;
    private int offsetRequestReadTimeoutEveryXTimes = 0;
    private Date lastIntervalRequestReadTimeout;
    private int checkReadTimeoutEveryXTimes = 1;
    private int offsetReadTimeoutEveryXTimes = 0;
    private Date lastIntervalReadTimeout;
    private boolean forceCheckPrimoAvvio = false;
    private static boolean inizializzazioneAttiva = false;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public static boolean isInizializzazioneAttiva() {
        return inizializzazioneAttiva;
    }

    public static void setInizializzazioneAttiva(boolean inizializzazioneAttiva) {
        TimerEventiThread.inizializzazioneAttiva = inizializzazioneAttiva;
    }

    public TimerEventiThread(Logger log) throws Exception {
        this.log = log;
        this.properties = OpenSPCoop2Properties.getInstance();
        this.setTimeout(this.properties.getEventiTimerIntervalSeconds());
        this.checkConnectionTimeoutEveryXTimes = this.properties.getEventiTimerIntervalConnectionTimeoutEveryXTimes();
        this.checkRequestReadTimeoutEveryXTimes = this.properties.getEventiTimerIntervalRequestReadTimeoutEveryXTimes();
        this.checkReadTimeoutEveryXTimes = this.properties.getEventiTimerIntervalReadTimeoutEveryXTimes();
        if (this.properties.isControlloTrafficoEnabled()) {
            this.notificatoreEventi = NotificatoreEventi.getInstance();
            if (inizializzazioneAttiva) {
                List<PolicyGroupByActiveThreadsType> tipiGestorePolicyRateLimiting = null;
                try {
                    tipiGestorePolicyRateLimiting = GestorePolicyAttive.getTipiGestoriAttivi();
                }
                catch (Throwable e) {
                    this.log.error("Errore durante l'inizializzazione dell'immagine degli eventi per il Controllo del Traffico: " + e.getMessage(), e);
                }
                if (tipiGestorePolicyRateLimiting != null && !tipiGestorePolicyRateLimiting.isEmpty()) {
                    for (PolicyGroupByActiveThreadsType type : tipiGestorePolicyRateLimiting) {
                        File fDati = null;
                        try {
                            File fRepository = this.properties.getControlloTrafficoGestorePolicyFileSystemRecoveryRepository();
                            if (fRepository == null) continue;
                            if (!fRepository.exists()) {
                                throw new Exception("Directory [" + fRepository.getAbsolutePath() + "] not exists");
                            }
                            if (!fRepository.isDirectory()) {
                                throw new Exception("File [" + fRepository.getAbsolutePath() + "] is not directory");
                            }
                            if (!fRepository.canRead()) {
                                throw new Exception("File [" + fRepository.getAbsolutePath() + "] cannot read");
                            }
                            if (!fRepository.canWrite()) {
                                throw new Exception("File [" + fRepository.getAbsolutePath() + "] cannot write");
                            }
                            fDati = new File(fRepository, GestorePolicyAttive.getControlloTrafficoEventiImage(type));
                            if (!fDati.exists() || !fDati.canRead() || fDati.length() <= 0L) continue;
                            FileInputStream fin = new FileInputStream(fDati);
                            this.notificatoreEventi.initialize(fin);
                            if (!fDati.delete()) {
                                // empty if block
                            }
                            this.forceCheckPrimoAvvio = true;
                        }
                        catch (Exception e) {
                            String img = null;
                            if (fDati != null) {
                                img = fDati.getAbsolutePath();
                            }
                            throw new HandlerException("Inizializzazione dell'immagine degli eventi [" + img + "] per il Controllo del Traffico non riuscita: " + e.getMessage(), e);
                        }
                    }
                }
            }
        }
        this.lastInterval = DateManager.getDate();
        this.lastIntervalConnectionTimeout = DateManager.getDate();
        this.lastIntervalRequestReadTimeout = DateManager.getDate();
        this.lastIntervalReadTimeout = DateManager.getDate();
        this.debug = this.properties.isEventiDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process() {
        if (TimerState.ENABLED.equals((Object)STATE)) {
            DBTransazioniManager dbManager = null;
            Resource r = null;
            try {
                dbManager = DBTransazioniManager.getInstance();
                r = dbManager.getResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, null);
                if (r == null) {
                    throw new UtilsException("Risorsa al database non disponibile");
                }
                Connection con = (Connection)r.getResource();
                if (con == null) {
                    throw new UtilsException("Connessione non disponibile");
                }
                if (!this.properties.isControlloTrafficoEnabled()) return;
                try {
                    this.lastInterval = this.notificatoreEventi.process(this.log, this.getTimeout(), this.lastInterval, con, this.debug);
                }
                catch (Exception e) {
                    this.log.error("Errore durante la generazione degli eventi per il controllo del traffico: " + e.getMessage(), (Throwable)e);
                }
                try {
                    boolean analyzeConnectionTimeout = this.isAnalyzeConnectionTimeout();
                    if (analyzeConnectionTimeout) {
                        this.lastIntervalConnectionTimeout = this.notificatoreEventi.processConnectionTimeout(this.log, this.getTimeout() * this.checkConnectionTimeoutEveryXTimes, this.lastIntervalConnectionTimeout, con, this.debug);
                    } else {
                        this.notificatoreEventi.emitProcessConnectionTimeoutSkip(this.log, this.debug, this.offsetConnectionTimeoutEveryXTimes, this.checkConnectionTimeoutEveryXTimes);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante la generazione degli eventi di connection timeout: " + e.getMessage(), (Throwable)e);
                }
                try {
                    boolean analyzeRequestReadTimeout = this.isAnalyzeRequestReadTimeout();
                    if (analyzeRequestReadTimeout) {
                        this.lastIntervalRequestReadTimeout = this.notificatoreEventi.processRequestReadTimeout(this.log, this.getTimeout() * this.checkRequestReadTimeoutEveryXTimes, this.lastIntervalRequestReadTimeout, con, this.debug);
                    } else {
                        this.notificatoreEventi.emitProcessRequestReadTimeoutSkip(this.log, this.debug, this.offsetRequestReadTimeoutEveryXTimes, this.checkRequestReadTimeoutEveryXTimes);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante la generazione degli eventi di request read timeout: " + e.getMessage(), (Throwable)e);
                }
                try {
                    boolean analyzeReadTimeout = this.isAnalyzeReadTimeout();
                    if (analyzeReadTimeout) {
                        this.lastIntervalReadTimeout = this.notificatoreEventi.processReadTimeout(this.log, this.getTimeout() * this.checkReadTimeoutEveryXTimes, this.lastIntervalReadTimeout, con, this.debug);
                        return;
                    }
                    this.notificatoreEventi.emitProcessReadTimeoutSkip(this.log, this.debug, this.offsetReadTimeoutEveryXTimes, this.checkReadTimeoutEveryXTimes);
                    return;
                }
                catch (Exception e) {
                    this.log.error("Errore durante la generazione degli eventi di request read timeout: " + e.getMessage(), (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                this.log.error("Errore durante la generazione degli eventi: " + e.getMessage(), (Throwable)e);
                return;
            }
            finally {
                try {
                    if (r != null) {
                        dbManager.releaseResource(this.properties.getIdentitaPortaDefaultWithoutProtocol(), ID_MODULO, r);
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.log.info("Timer TimerEventi disabilitato");
    }

    public void close() {
        this.log.info("Thread per la generazione degli eventi terminato");
    }

    private boolean isAnalyzeConnectionTimeout() {
        ++this.offsetConnectionTimeoutEveryXTimes;
        boolean esito = false;
        if (this.offsetConnectionTimeoutEveryXTimes == this.checkConnectionTimeoutEveryXTimes) {
            esito = true;
            this.offsetConnectionTimeoutEveryXTimes = 0;
        }
        return esito;
    }

    private boolean isAnalyzeRequestReadTimeout() {
        ++this.offsetRequestReadTimeoutEveryXTimes;
        boolean esito = false;
        if (this.offsetRequestReadTimeoutEveryXTimes == this.checkRequestReadTimeoutEveryXTimes) {
            esito = true;
            this.offsetRequestReadTimeoutEveryXTimes = 0;
        }
        return esito;
    }

    private boolean isAnalyzeReadTimeout() {
        ++this.offsetReadTimeoutEveryXTimes;
        boolean esito = false;
        if (this.offsetReadTimeoutEveryXTimes == this.checkReadTimeoutEveryXTimes) {
            esito = true;
            this.offsetReadTimeoutEveryXTimes = 0;
        }
        return esito;
    }
}

