/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyVerifier;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.threads.BaseThread;
import org.slf4j.Logger;

public class TimerClusterDinamicoThread
extends BaseThread {
    private static TimerState STATE = TimerState.OFF;
    public static final String ID_MODULO = "TimerClusterDinamico";
    private Logger log = null;
    private OpenSPCoop2Properties properties;
    private DynamicClusterManager manager;

    public static TimerState getSTATE() {
        return STATE;
    }

    public static void setSTATE(TimerState sTATE) {
        STATE = sTATE;
    }

    public TimerClusterDinamicoThread(Logger log) throws Exception {
        this.log = log;
        this.properties = OpenSPCoop2Properties.getInstance();
        this.setTimeout(this.properties.getClusterDinamicoRefreshSecondsInterval());
        this.manager = DynamicClusterManager.getInstance();
    }

    public void process() {
        if (TimerState.ENABLED.equals((Object)STATE)) {
            try {
                this.manager.refresh(this.log);
            }
            catch (Exception e) {
                this.log.error("Errore durante l'aggiornamento del cluster id dinamico: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.manager.deleteOldHostnames(this.log);
            }
            catch (Exception e) {
                this.log.error("Errore durante lo svecchiamento dei nodi cluster dinamici: " + e.getMessage(), (Throwable)e);
            }
            try {
                if (this.manager.isRateLimitingGestioneCluster()) {
                    PolicyVerifier.setListClusterNodes(this.manager.getHostnames(this.log));
                }
            }
            catch (Exception e) {
                this.log.error("Errore durante l'aggiornamento della lista dei nodi per il rate limiting: " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.log.info("Timer TimerClusterDinamico disabilitato");
        }
    }

    public void close() {
        this.log.info("Thread per il refresh del cluster id dinamico terminato");
    }
}

