/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.skeleton;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.StatoServiziPdD;
import org.openspcoop2.pdd.core.autenticazione.GestoreAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.EsitoAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenzialiIM;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerRequestContext;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerResponseContext;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateDBManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.transazioni.GestoreConsegnaMultipla;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiIntegrationManagerService;
import org.openspcoop2.pdd.services.skeleton.IdentificativoIM;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerException;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerMessage;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerMessageBoxInterface;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerPDInterface;
import org.openspcoop2.pdd.services.skeleton.MessaggioIM;
import org.openspcoop2.pdd.services.skeleton.Operazione;
import org.openspcoop2.pdd.services.skeleton.ProtocolHeaderInfo;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.protocol.engine.LetturaParametriBusta;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.IUniqueIdentifier;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public abstract class IntegrationManager
implements IntegrationManagerMessageBoxInterface,
IntegrationManagerPDInterface {
    public static final IDService ID_SERVICE = IDService.INTEGRATION_MANAGER_SOAP;
    public static final String ID_MODULO = ID_SERVICE.getValue();
    private OpenSPCoop2Properties propertiesReader;
    private ClassNameProperties className;
    private static final boolean useNewMethod = true;
    private boolean inizializzato = false;
    private static Semaphore semaphore = new Semaphore(ID_MODULO);
    private static Boolean staticInitialized = false;
    private String[] tipiGestoriCredenziali = null;

    private static void logError(Logger logCore, String msg) {
        logCore.error(msg);
    }

    private static void logError(Logger logCore, String msg, Throwable e) {
        logCore.error(msg, e);
    }

    private void init() {
        if (!this.inizializzato) {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
            this.className = ClassNameProperties.getInstance();
            this.inizializzato = true;
            SemaphoreLock lock = semaphore.acquireThrowRuntime("init");
            try {
                if (!staticInitialized.booleanValue()) {
                    staticInitialized = true;
                }
            }
            finally {
                semaphore.release(lock, "init");
            }
        }
    }

    protected abstract HttpServletRequest getHttpServletRequest() throws IntegrationManagerException;

    protected abstract HttpServletResponse getHttpServletResponse() throws IntegrationManagerException;

    private ErroriProperties getErroriProperties(Logger log) {
        ErroriProperties erroriProperties = null;
        try {
            erroriProperties = ErroriProperties.getInstance((Logger)log);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return erroriProperties;
    }

    private IProtocolFactory<?> getProtocolFactory(Logger log) throws IntegrationManagerException {
        try {
            String protocolName = (String)this.getHttpServletRequest().getAttribute((String)((Object)Costanti.PROTOCOL_NAME.getValue()));
            return ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolName);
        }
        catch (Exception e) {
            log.error("Errore durante il recupero della ProtocolFactory: " + e.getMessage(), (Throwable)e);
            throw new IntegrationManagerException(null, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(log));
        }
    }

    private void checkIMAuthorization(Logger log) throws IntegrationManagerException {
        try {
            Object o = this.getHttpServletRequest().getAttribute((String)((Object)Costanti.INTEGRATION_MANAGER_ENGINE_AUTHORIZED.getValue()));
            if (!(o instanceof Boolean)) {
                throw new CoreException("Invocazione del Servizio non autorizzata");
            }
            Boolean b = (Boolean)o;
            if (!b.booleanValue()) {
                throw new CoreException("Invocazione del Servizio non autorizzata");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IntegrationManagerException(null, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.AUTHORIZATION, this.getErroriProperties(log));
        }
    }

    private void setNomePortaDelegata(Logger log, String nomePorta) throws IntegrationManagerException {
        try {
            this.getHttpServletRequest().setAttribute((String)((Object)Costanti.PORTA_DELEGATA.getValue()), (Object)nomePorta);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IntegrationManagerException(null, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(log));
        }
    }

    public static InfoConnettoreIngresso buildInfoConnettoreIngresso(HttpServletRequest req, Credenziali credenziali, URLProtocolContext urlProtocolContext) {
        InfoConnettoreIngresso connettoreIngresso = new InfoConnettoreIngresso();
        connettoreIngresso.setCredenziali(credenziali);
        connettoreIngresso.setFromLocation(urlProtocolContext.getSource());
        connettoreIngresso.setUrlProtocolContext(urlProtocolContext);
        return connettoreIngresso;
    }

    private IntegrationManagerRequestContext buildIMRequestContext(Date dataRichiestaOperazione, Operazione tipoOperazione, PdDContext pddContext, Logger logCore, IProtocolFactory<?> protocolFactory) throws IntegrationManagerException, ProtocolException, UtilsException {
        IntegrationManagerRequestContext imRequestContext = new IntegrationManagerRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        Credenziali credenziali = null;
        HttpServletRequest req = this.getHttpServletRequest();
        URLProtocolContextImpl urlProtocolContext = new URLProtocolContextImpl(req, logCore, true, true, this.propertiesReader.getCustomContexts());
        try {
            credenziali = new Credenziali(urlProtocolContext.getCredential());
        }
        catch (Exception e) {
            credenziali = new Credenziali();
        }
        imRequestContext.setConnettore(IntegrationManager.buildInfoConnettoreIngresso(req, credenziali, (URLProtocolContext)urlProtocolContext));
        return imRequestContext;
    }

    private synchronized void initializeGestoreCredenziali(Logger logCore, IProtocolFactory<?> protocolFactory, MsgDiagnostico msgDiag) throws IntegrationManagerException {
        if (this.tipiGestoriCredenziali == null) {
            Loader loader = Loader.getInstance();
            this.tipiGestoriCredenziali = this.propertiesReader.getTipoGestoreCredenzialiIM();
            if (this.tipiGestoriCredenziali != null) {
                for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                    String classType = this.className.getGestoreCredenzialiIM(this.tipiGestoriCredenziali[i]);
                    try {
                        IGestoreCredenzialiIM gestore = (IGestoreCredenzialiIM)loader.newInstance(classType);
                        gestore.toString();
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "InizializzazioneGestoreCredenziali(" + this.tipiGestoriCredenziali[i] + ")");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                    }
                }
            }
        }
    }

    private void gestioneCredenziali(Logger logCore, IProtocolFactory<?> protocolFactory, MsgDiagnostico msgDiag, InfoConnettoreIngresso infoConnettoreIngresso, PdDContext pddContext) throws IntegrationManagerException {
        if (this.tipiGestoriCredenziali == null) {
            this.initializeGestoreCredenziali(logCore, protocolFactory, msgDiag);
        }
        if (this.tipiGestoriCredenziali != null) {
            msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
            Loader loader = Loader.getInstance();
            for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                try {
                    String classType = null;
                    IGestoreCredenzialiIM gestore = null;
                    try {
                        classType = this.className.getGestoreCredenzialiIM(this.tipiGestoriCredenziali[i]);
                        gestore = (IGestoreCredenzialiIM)loader.newInstance(classType);
                        AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "InizializzazioneGestoreCredenziali(" + this.tipiGestoriCredenziali[i] + ")");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                    }
                    if (gestore != null) {
                        Credenziali credenzialiRitornate = gestore.elaborazioneCredenziali(infoConnettoreIngresso);
                        if (credenzialiRitornate == null) {
                            throw new CoreException("Credenziali non ritornate");
                        }
                        if (!infoConnettoreIngresso.getCredenziali().equals(credenzialiRitornate)) {
                            String nuoveCredenziali = credenzialiRitornate.toString();
                            nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                            msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                            Object identita = gestore.getIdentitaGestoreCredenziali();
                            if (identita == null) {
                                identita = "Gestore delle credenziali di tipo " + this.tipiGestoriCredenziali[i];
                            }
                            msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", (String)identita);
                            pddContext.addObject(Costanti.IDENTITA_GESTORE_CREDENZIALI, identita);
                            msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                            infoConnettoreIngresso.setCredenziali(credenzialiRitornate);
                        }
                        continue;
                    }
                    throw new CoreException("non inizializzato");
                }
                catch (Exception e) {
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante l'identificazione delle credenziali [" + this.tipiGestoriCredenziali[i] + "]: " + e.getMessage(), (Throwable)e);
                    msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", this.tipiGestoriCredenziali[i]);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                    ErroreIntegrazione errore = null;
                    IntegrationFunctionError integrationFunctionError = null;
                    if (e instanceof GestoreCredenzialiConfigurationException) {
                        GestoreCredenzialiConfigurationException ge = (GestoreCredenzialiConfigurationException)e;
                        integrationFunctionError = ge.getIntegrationFunctionError();
                        errore = ErroriIntegrazione.ERRORE_431_GESTORE_CREDENZIALI_ERROR.getErrore431_ErroreGestoreCredenziali(this.tipiGestoriCredenziali[i], e);
                    } else {
                        errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE);
                    }
                    if (integrationFunctionError == null) {
                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                    }
                    throw new IntegrationManagerException(protocolFactory, errore, integrationFunctionError, this.getErroriProperties(logCore));
                }
            }
        }
    }

    private IDServizioApplicativo autenticazione(Logger logCore, IProtocolFactory<?> protocolFactory, MsgDiagnostico msgDiag, InfoConnettoreIngresso infoConnettoreIngresso, ConfigurazionePdDManager configPdDManager, PdDContext pddContext) throws IntegrationManagerException {
        Credenziali credenziali = infoConnettoreIngresso.getCredenziali();
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
        IDServizioApplicativo servizioApplicativo = null;
        String[] tipoAutenticazione = configPdDManager.getIntegrationManagerAuthentication();
        if (tipoAutenticazione == null || tipoAutenticazione.length < 1) {
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            if (!CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString().equalsIgnoreCase(tipoAutenticazione[i])) continue;
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        StringBuilder errori = new StringBuilder();
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            DatiInvocazionePortaDelegata datiInvocazione = new DatiInvocazionePortaDelegata();
            datiInvocazione.setInfoConnettoreIngresso(infoConnettoreIngresso);
            EsitoAutenticazionePortaDelegata esito = null;
            try {
                esito = GestoreAutenticazione.verificaAutenticazioneMessageBox(tipoAutenticazione[i], datiInvocazione, null, pddContext, protocolFactory);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione[i] + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_503_AUTENTICAZIONE), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            if (esito.getDetails() == null) {
                msgDiag.addKeyword("@DETAILS@", "");
            } else {
                msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
            }
            if (!esito.isClientAuthenticated() || !esito.isClientIdentified()) {
                if (errori.length() > 0 || tipoAutenticazione.length > 1) {
                    errori.append("\n");
                }
                try {
                    if (esito.getErroreIntegrazione() != null) {
                        errori.append("(Autenticazione " + tipoAutenticazione[i] + ") " + esito.getErroreIntegrazione().getDescrizione(protocolFactory));
                        continue;
                    }
                    errori.append("(Autenticazione " + tipoAutenticazione[i] + ") non ha identificato alcun servizio applicativo");
                    continue;
                }
                catch (Exception e) {
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Errore durante l'identificazione dell'errore: " + e.getMessage(), (Throwable)e);
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
            }
            servizioApplicativo = esito.getIdServizioApplicativo();
            break;
        }
        if (servizioApplicativo == null) {
            if (errori.length() > 0) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errori.toString());
                msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita(errori.toString()), IntegrationFunctionError.AUTHENTICATION, this.getErroriProperties(logCore));
            }
            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio applicativo non autenticato");
            msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_503_AUTENTICAZIONE), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo.getNome());
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo.getNome());
        msgDiag.setServizioApplicativo(servizioApplicativo.getNome());
        if (servizioApplicativo.getIdSoggettoProprietario() != null) {
            msgDiag.addKeyword("@TIPO_MITTENTE_BUSTA_RICHIESTA@", servizioApplicativo.getIdSoggettoProprietario().getTipo());
            msgDiag.addKeyword("@MITTENTE_BUSTA_RICHIESTA@", servizioApplicativo.getIdSoggettoProprietario().getNome());
            msgDiag.setFruitore(servizioApplicativo.getIdSoggettoProprietario());
        }
        return servizioApplicativo;
    }

    private void verificaRisorseSistema(IProtocolFactory<?> protocolFactory, Logger logCore, String tipoOperazione) throws IntegrationManagerException {
        if (!OpenSPCoop2Startup.initialize) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Inizializzazione di GovWay non correttamente effettuata");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, this.getErroriProperties(logCore));
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        if (!TimerThresholdThread.freeSpace) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Non sono disponibili abbastanza risorse per la gestione della richiesta");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), Tracciamento.motivoMalfunzionamentoTracciamento);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        try {
            ConfigurazionePdDManager.getInstance().verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Riscontrato errore durante la verifica della consistenza della configurazione PdD", e);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, this.getErroriProperties(logCore));
        }
        boolean serviceIsEnabled = false;
        Exception serviceIsEnabledExceptionProcessamento = null;
        try {
            serviceIsEnabled = StatoServiziPdD.isEnabledIntegrationManager();
        }
        catch (Exception e) {
            serviceIsEnabledExceptionProcessamento = e;
        }
        if (!serviceIsEnabled || serviceIsEnabledExceptionProcessamento != null) {
            if (serviceIsEnabledExceptionProcessamento != null) {
                IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Identificazione stato servizio IntegrationManager non riuscita: " + serviceIsEnabledExceptionProcessamento.getMessage(), serviceIsEnabledExceptionProcessamento);
            } else {
                IntegrationManager.logError(logCore, "[" + ID_MODULO + "][" + tipoOperazione + "] Servizio IntegrationManager disabilitato");
            }
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_552_IM_SERVICE_NOT_ACTIVE), IntegrationFunctionError.API_SUSPEND, this.getErroriProperties(logCore));
        }
    }

    private IUniqueIdentifier getUniqueIdentifier(Logger logCore, IProtocolFactory<?> protocolFactory, MsgDiagnostico msgDiag, String tipoOperazione) throws IntegrationManagerException {
        try {
            return UniqueIdentifierManager.newUniqueIdentifier();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "(" + tipoOperazione + ").getUniqueIdentifier()");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
    }

    private MsgDiagnostico getMsgDiagnostico() {
        MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(ID_MODULO);
        msgDiag.setPrefixMsgPersonalizzati("integrationManager.");
        return msgDiag;
    }

    private EsitoTransazione getEsitoTransazione(IProtocolFactory<?> pf, IntegrationManagerRequestContext imRequestContext, EsitoTransazioneName name) throws ProtocolException {
        URLProtocolContext t = null;
        if (imRequestContext != null && imRequestContext.getConnettore() != null) {
            t = imRequestContext.getConnettore().getUrlProtocolContext();
        }
        return pf.createEsitoBuilder().getEsito(t, name);
    }

    private List<String> getAllMessagesId_engine(Operazione tipoOperazione, String tipoServizio, String servizio, Integer versioneServizio, String azione, int counter, int offset) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory<?> protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        IDServizioApplicativo idServizioApplicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(logCore, protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        pddContext.addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
        IDServizio idServizio = null;
        try {
            int ver = -1;
            if (versioneServizio != null) {
                ver = versioneServizio;
            }
            idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(tipoServizio, servizio, OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), null).getTipo(), OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), null).getNome(), ver);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "IDServizioFactory.getIDServizioFromValues");
            ErroreIntegrazione erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
            throw new IntegrationManagerException(protocolFactory, erroreIntegrazione, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        idServizio.setAzione(azione);
        pddContext.addObject(Costanti.ID_SERVIZIO, idServizio);
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            ErroreIntegrazione erroreIntegrazione = null;
            IntegrationFunctionError integrationFunctionError = null;
            if (e instanceof HandlerException) {
                HandlerException he = (HandlerException)e;
                integrationFunctionError = he.getIntegrationFunctionError();
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                erroreIntegrazione = he.convertToErroreIntegrazione();
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            if (erroreIntegrazione == null) {
                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
            }
            if (integrationFunctionError == null) {
                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
            }
            throw new IntegrationManagerException(protocolFactory, erroreIntegrazione, integrationFunctionError, this.getErroriProperties(logCore));
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        if (imRequestContext != null) {
            imResponseContext.setConnettore(imRequestContext.getConnettore());
        }
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol(), null), ID_MODULO, idTransazione, OpenSPCoopStateDBManager.messageBox);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(configPdDManager);
            this.gestioneCredenziali(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            idServizioApplicativo = this.autenticazione(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            imResponseContext.setServizioApplicativo(idServizioApplicativo);
            Object tipoServizioLog = "";
            Object servizioLog = "";
            Object azioneLog = "";
            Object counterLog = "";
            if (tipoServizio != null) {
                tipoServizioLog = " tipoServizio[" + tipoServizio + "]";
            }
            if (servizio != null) {
                servizioLog = " servizio[" + servizio + "]";
            }
            if (azione != null) {
                azioneLog = " azione[" + azione + "]";
            }
            if (counter >= 0) {
                counterLog = " counter[" + counter + "]";
            }
            String param = "ServizioApplicativo[" + idServizioApplicativo.getNome() + "]" + (String)tipoServizioLog + (String)servizioLog + (String)azioneLog + (String)counterLog;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            List<IdentificativoIM> ids = null;
            GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, msgDiag, pddContext);
            ids = counter < 0 && offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(idServizioApplicativo.getNome(), tipoServizio, servizio, azione) : (offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(idServizioApplicativo.getNome(), tipoServizio, servizio, azione, counter) : gestoreMessaggi.getIDMessaggi_ServizioApplicativo(idServizioApplicativo.getNome(), tipoServizio, servizio, azione, counter, offset));
            if (ids == null || ids.isEmpty()) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.IM_MESSAGES_NOT_FOUND, this.getErroriProperties(logCore));
            }
            ArrayList<String> listResponse = new ArrayList<String>();
            if (ids != null && !ids.isEmpty()) {
                for (IdentificativoIM id : ids) {
                    if (this.propertiesReader.isIntegrationManagerIdWithDate()) {
                        listResponse.add(id.getIdWithDate());
                        continue;
                    }
                    listResponse.add(id.getId());
                }
            }
            imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.OK));
            ArrayList<String> arrayList = listResponse;
            return arrayList;
        }
        catch (Exception e) {
            try {
                imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX));
                if (e instanceof IntegrationManagerException) {
                    IntegrationManagerException exc = (IntegrationManagerException)e;
                    if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTENTICAZIONE_FALLITA));
                    } else if (CodiceErroreIntegrazione.CODICE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.MESSAGGI_NON_PRESENTI));
                    }
                }
            }
            catch (Exception eInteral) {
                IntegrationManager.logError(logCore, "Errore durante la generazione dell'esito: " + eInteral.getMessage(), eInteral);
                imResponseContext.setEsito(EsitoTransazione.ESITO_TRANSAZIONE_ERROR);
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "getAllMessagesId(" + String.valueOf(tipoOperazione) + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception exception) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    }
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public List<String> getAllMessagesId() throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getAllMessagesId, null, null, null, null, -1, -1);
    }

    @Override
    public List<String> getAllMessagesIdByService(String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getAllMessagesIdByService, tipoServizio, servizio, null, azione, -1, -1);
    }

    @Override
    @Deprecated
    public List<String> getNextMessagesId(int counter) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getNextMessagesId, null, null, null, null, counter, -1);
    }

    @Override
    @Deprecated
    public List<String> getNextMessagesIdByService(int counter, String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getNextMessagesIdByService, tipoServizio, servizio, null, azione, counter, -1);
    }

    @Override
    public List<String> getMessagesIdArray(int offset, int counter) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArray, null, null, null, null, counter, offset);
    }

    @Override
    public List<String> getMessagesIdArrayByService(int offset, int counter, String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArrayByService, tipoServizio, servizio, null, azione, counter, offset);
    }

    private IntegrationManagerMessage getMessage_engine(Operazione tipoOperazione, String idMessaggioParam, boolean isRiferimentoMessaggio) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory<?> protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        String idMessaggio = null;
        Date dataMessaggio = null;
        if (this.propertiesReader.isIntegrationManagerIdWithDate()) {
            IdentificativoIM idIM = IdentificativoIM.getIdentificativoIM(idMessaggioParam, logCore);
            idMessaggio = idIM.getId();
            dataMessaggio = idIM.getData();
        } else {
            idMessaggio = idMessaggioParam;
        }
        if (isRiferimentoMessaggio) {
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idMessaggio);
        } else {
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessaggio);
        }
        IDServizioApplicativo idServizioApplicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(logCore, protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        pddContext.addObject(Costanti.ID_MESSAGGIO, idMessaggio);
        pddContext.addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            imRequestContext.setIdMessaggio(idMessaggio);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            ErroreIntegrazione erroreIntegrazione = null;
            IntegrationFunctionError integrationFunctionError = null;
            if (e instanceof HandlerException) {
                HandlerException he = (HandlerException)e;
                integrationFunctionError = he.getIntegrationFunctionError();
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                erroreIntegrazione = he.convertToErroreIntegrazione();
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            if (erroreIntegrazione == null) {
                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
            }
            if (integrationFunctionError == null) {
                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
            }
            throw new IntegrationManagerException(protocolFactory, erroreIntegrazione, integrationFunctionError, this.getErroriProperties(logCore));
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        if (imRequestContext != null) {
            imResponseContext.setConnettore(imRequestContext.getConnettore());
        }
        imResponseContext.setIdMessaggio(idMessaggio);
        try {
            Busta busta;
            IDServizio idServizio;
            IDSoggetto fruitore;
            ProtocolHeaderInfo protocolHeaderInfo;
            String idMessaggioRichiesto;
            MessaggioIM messaggioIM;
            GestoreMessaggi gestoreMessaggi;
            block63: {
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol(), null), ID_MODULO, idTransazione, OpenSPCoopStateDBManager.messageBox);
                ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
                msgDiag.updateState(configPdDManager);
                this.gestioneCredenziali(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
                idServizioApplicativo = this.autenticazione(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
                imResponseContext.setServizioApplicativo(idServizioApplicativo);
                String param = "ServizioApplicativo[" + idServizioApplicativo.getNome() + "] ID[" + idMessaggio + "]";
                msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
                msgDiag.logPersonalizzato("logInvocazioneOperazione");
                gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                messaggioIM = null;
                messaggioIM = gestoreMessaggi.readMessageForSIL(idServizioApplicativo.getNome(), isRiferimentoMessaggio, dataMessaggio);
                boolean exists = false;
                boolean bl = exists = messaggioIM != null;
                if (!exists) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.IM_MESSAGE_NOT_FOUND, this.getErroriProperties(logCore));
                }
                boolean authorized = false;
                authorized = messaggioIM.isAuthorized();
                if (!authorized) {
                    msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(idServizioApplicativo.getNome()), idServizioApplicativo, IntegrationFunctionError.AUTHORIZATION, this.getErroriProperties(logCore));
                }
                idMessaggioRichiesto = idMessaggio;
                try {
                    if (isRiferimentoMessaggio) {
                        idMessaggioRichiesto = messaggioIM.getIdentificativoRichiesta();
                    }
                }
                catch (Exception e) {
                    msgDiag.addKeywordErroreProcessamento(e);
                    msgDiag.logPersonalizzato("mappingRifMsgToId.nonRiuscito");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
                RepositoryBuste repository = new RepositoryBuste(stato.getStatoRichiesta(), true, protocolFactory);
                protocolHeaderInfo = null;
                fruitore = null;
                idServizio = null;
                busta = null;
                try {
                    LetturaParametriBusta parametri = new LetturaParametriBusta();
                    parametri.setMittente(true);
                    parametri.setDestinatario(true);
                    parametri.setRiferimentoMessaggio(true);
                    parametri.setServizio(true);
                    parametri.setAzione(true);
                    parametri.setCollaborazione(true);
                    busta = repository.getSomeValuesFromInBox(idMessaggioRichiesto, parametri, dataMessaggio);
                    if (busta != null) {
                        protocolHeaderInfo = new ProtocolHeaderInfo();
                        protocolHeaderInfo.setID(idMessaggioRichiesto);
                        protocolHeaderInfo.setRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                        protocolHeaderInfo.setTipoMittente(busta.getTipoMittente());
                        protocolHeaderInfo.setMittente(busta.getMittente());
                        protocolHeaderInfo.setTipoDestinatario(busta.getTipoDestinatario());
                        protocolHeaderInfo.setDestinatario(busta.getDestinatario());
                        protocolHeaderInfo.setTipoServizio(busta.getTipoServizio());
                        protocolHeaderInfo.setServizio(busta.getServizio());
                        protocolHeaderInfo.setAzione(busta.getAzione());
                        protocolHeaderInfo.setIdCollaborazione(busta.getCollaborazione());
                        busta.setID(idMessaggioRichiesto);
                        msgDiag.addKeywords(busta, true);
                        fruitore = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ReadInformazioniProtocollo(" + String.valueOf(tipoOperazione) + "," + idMessaggioRichiesto + ")");
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") >= 0) break block63;
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
            }
            boolean sbustamentoSoap = false;
            sbustamentoSoap = messaggioIM.isSbustamentoSoap();
            boolean sbustamentoInformazioniProtocollo = false;
            sbustamentoInformazioniProtocollo = messaggioIM.isSbustamentoInformazioniProtocollo();
            GestoreMessaggi gestoreMessaggiIdentificativoReale = null;
            RuoloMessaggio ruoloMessaggio = RuoloMessaggio.RICHIESTA;
            try {
                gestoreMessaggiIdentificativoReale = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", msgDiag, pddContext);
                ruoloMessaggio = messaggioIM.getRiferimentoMessaggio() == null ? RuoloMessaggio.RICHIESTA : RuoloMessaggio.RISPOSTA;
            }
            catch (Exception e) {
                IntegrationManager.logError(logCore, "Identificazione tipo messaggio non riuscita: " + e.getMessage(), e);
            }
            OpenSPCoop2Message consegnaMessage = null;
            try {
                consegnaMessage = gestoreMessaggiIdentificativoReale != null ? gestoreMessaggiIdentificativoReale.getMessage(dataMessaggio) : gestoreMessaggi.getMessage(isRiferimentoMessaggio);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + String.valueOf(tipoOperazione) + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            if (sbustamentoInformazioniProtocollo) {
                try {
                    IBustaBuilder bustaBuilder = protocolFactory.createBustaBuilder(stato.getStatoRichiesta());
                    FaseSbustamento fase = null;
                    fase = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? FaseSbustamento.PRE_CONSEGNA_RICHIESTA : FaseSbustamento.PRE_CONSEGNA_RISPOSTA;
                    ProprietaManifestAttachments proprietaManifest = this.propertiesReader.getProprietaManifestAttachments("standard");
                    proprietaManifest.setGestioneManifest(false);
                    ProtocolMessage protocolMessage = bustaBuilder.sbustamento(consegnaMessage, (Context)pddContext, busta, ruoloMessaggio, proprietaManifest, fase, null, null);
                    if (protocolMessage != null) {
                        consegnaMessage = protocolMessage.getMessage();
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + String.valueOf(tipoOperazione) + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
            }
            msgDiag.mediumDebug("Dump applicativo messaggio ritornato...");
            Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol(), null), ID_MODULO, idMessaggio, fruitore, idServizio, TipoPdD.INTEGRATION_MANAGER, null, pddContext, stato.getStatoRichiesta(), stato.getStatoRisposta(), null);
            dumpApplicativo.dumpIntegrationManagerGetMessage(consegnaMessage);
            IntegrationManagerMessage msgReturn = null;
            try {
                if (!sbustamentoSoap) {
                    msgReturn = new IntegrationManagerMessage(consegnaMessage, false, protocolHeaderInfo);
                } else {
                    byte[] sbustato = TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)consegnaMessage);
                    msgReturn = new IntegrationManagerMessage(sbustato, false, protocolHeaderInfo);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "buildMsgReturn(" + idMessaggio + "," + String.valueOf(tipoOperazione) + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_523_CREAZIONE_PROTOCOL_MESSAGE), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.OK));
            imResponseContext.setDimensioneMessaggioBytes(Long.valueOf(msgReturn.getMessage().length));
            try {
                TransazioneApplicativoServer transazioneApplicativoServer = null;
                String nomePorta = null;
                transazioneApplicativoServer = new TransazioneApplicativoServer();
                transazioneApplicativoServer.setIdTransazione(messaggioIM.getIdTransazione());
                transazioneApplicativoServer.setServizioApplicativoErogatore(messaggioIM.getServizioApplicativo());
                transazioneApplicativoServer.setDataRegistrazione(messaggioIM.getOraRegistrazione());
                transazioneApplicativoServer.setDataPrelievoIm(DateManager.getDate());
                transazioneApplicativoServer.setProtocollo(protocolFactory.getProtocol());
                nomePorta = messaggioIM.getNomePorta();
                if (transazioneApplicativoServer != null) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    try {
                        GestoreConsegnaMultipla.getInstance().safeUpdatePrelievoIM(transazioneApplicativoServer, idPA, stato, pddContext);
                    }
                    catch (Throwable t) {
                        IntegrationManager.logError(logCore, "[" + transazioneApplicativoServer.getIdTransazione() + "][" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "] Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                    }
                }
            }
            catch (Exception e) {
                IntegrationManager.logError(logCore, "Salvataggio informazioni sulla transazione non riuscita: " + e.getMessage(), e);
            }
            IntegrationManagerMessage integrationManagerMessage = msgReturn;
            return integrationManagerMessage;
        }
        catch (Exception e) {
            try {
                imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX));
                if (e instanceof IntegrationManagerException) {
                    IntegrationManagerException exc = (IntegrationManagerException)e;
                    if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTENTICAZIONE_FALLITA));
                    } else if (CodiceErroreIntegrazione.CODICE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.MESSAGGIO_NON_TROVATO));
                    } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTORIZZAZIONE_FALLITA));
                    }
                }
            }
            catch (Exception eInteral) {
                IntegrationManager.logError(logCore, "Errore durante la generazione dell'esito: " + eInteral.getMessage(), eInteral);
                imResponseContext.setEsito(EsitoTransazione.ESITO_TRANSAZIONE_ERROR);
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "getMessage(" + String.valueOf(tipoOperazione) + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception exception) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    }
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public IntegrationManagerMessage getMessage(String idMessaggio) throws IntegrationManagerException {
        this.init();
        return this.getMessage_engine(Operazione.getMessage, idMessaggio, false);
    }

    @Override
    public IntegrationManagerMessage getMessageByReference(String riferimentoMsg) throws IntegrationManagerException {
        this.init();
        return this.getMessage_engine(Operazione.getMessageByReference, riferimentoMsg, true);
    }

    private void deleteMessage_engine(Operazione tipoOperazione, String idMessaggioParam, boolean isRiferimentoMessaggio) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory<?> protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        String idMessaggio = null;
        Date dataMessaggio = null;
        if (this.propertiesReader.isIntegrationManagerIdWithDate()) {
            IdentificativoIM idIM = IdentificativoIM.getIdentificativoIM(idMessaggioParam, logCore);
            idMessaggio = idIM.getId();
            dataMessaggio = idIM.getData();
        } else {
            idMessaggio = idMessaggioParam;
        }
        if (isRiferimentoMessaggio) {
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idMessaggio);
        } else {
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessaggio);
        }
        GestoreMessaggi gestoreMessaggi = null;
        IDServizioApplicativo idServizioApplicativo = null;
        String servizioApplicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(logCore, protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        pddContext.addObject(Costanti.ID_MESSAGGIO, idMessaggio);
        pddContext.addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            imRequestContext.setIdMessaggio(idMessaggio);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            ErroreIntegrazione erroreIntegrazione = null;
            IntegrationFunctionError integrationFunctionError = null;
            if (e instanceof HandlerException) {
                HandlerException he = (HandlerException)e;
                integrationFunctionError = he.getIntegrationFunctionError();
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                erroreIntegrazione = he.convertToErroreIntegrazione();
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            if (erroreIntegrazione == null) {
                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
            }
            if (integrationFunctionError == null) {
                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
            }
            throw new IntegrationManagerException(protocolFactory, erroreIntegrazione, integrationFunctionError, this.getErroriProperties(logCore));
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        if (imRequestContext != null) {
            imResponseContext.setConnettore(imRequestContext.getConnettore());
        }
        imResponseContext.setIdMessaggio(idMessaggio);
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol(), null), ID_MODULO, idTransazione, OpenSPCoopStateDBManager.messageBox);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(configPdDManager);
            this.gestioneCredenziali(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            idServizioApplicativo = this.autenticazione(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            servizioApplicativo = idServizioApplicativo.getNome();
            imResponseContext.setServizioApplicativo(idServizioApplicativo);
            String param = "ServizioApplicativo[" + servizioApplicativo + "] ID[" + idMessaggio + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
            MessaggioIM messaggioIM = null;
            messaggioIM = gestoreMessaggi.readMessageForSIL(idServizioApplicativo.getNome(), isRiferimentoMessaggio, dataMessaggio);
            boolean exists = false;
            boolean bl = exists = messaggioIM != null;
            if (!exists) {
                msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                msgDiag.logPersonalizzato("messaggioNonTrovato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.IM_MESSAGE_NOT_FOUND, this.getErroriProperties(logCore));
            }
            boolean authorized = false;
            authorized = messaggioIM.isAuthorized();
            if (!authorized) {
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(servizioApplicativo), idServizioApplicativo, IntegrationFunctionError.AUTHORIZATION, this.getErroriProperties(logCore));
            }
            String idMessaggioRichiesto = idMessaggio;
            try {
                if (isRiferimentoMessaggio) {
                    idMessaggioRichiesto = messaggioIM.getIdentificativoRichiesta();
                }
            }
            catch (Exception e) {
                msgDiag.addKeywordErroreProcessamento(e);
                msgDiag.logPersonalizzato("mappingRifMsgToId.nonRiuscito");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            GestoreMessaggi gestoreEliminazione = null;
            try {
                gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", msgDiag, pddContext);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + String.valueOf(tipoOperazione) + "," + servizioApplicativo + "," + idMessaggio + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            try {
                TransazioneApplicativoServer transazioneApplicativoServer = null;
                String nomePorta = null;
                transazioneApplicativoServer = new TransazioneApplicativoServer();
                transazioneApplicativoServer.setIdTransazione(messaggioIM.getIdTransazione());
                transazioneApplicativoServer.setServizioApplicativoErogatore(messaggioIM.getServizioApplicativo());
                transazioneApplicativoServer.setDataRegistrazione(messaggioIM.getOraRegistrazione());
                transazioneApplicativoServer.setDataEliminazioneIm(DateManager.getDate());
                transazioneApplicativoServer.setProtocollo(protocolFactory.getProtocol());
                nomePorta = messaggioIM.getNomePorta();
                if (transazioneApplicativoServer != null) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    try {
                        GestoreConsegnaMultipla.getInstance().safeUpdateEliminazioneIM(transazioneApplicativoServer, idPA, stato, pddContext);
                    }
                    catch (Throwable t) {
                        IntegrationManager.logError(logCore, "[" + transazioneApplicativoServer.getIdTransazione() + "][" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "] Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                    }
                }
            }
            catch (Exception e) {
                IntegrationManager.logError(logCore, "Salvataggio informazioni sulla transazione non riuscita: " + e.getMessage(), e);
            }
            try {
                gestoreEliminazione.eliminaDestinatarioMessaggio(servizioApplicativo, gestoreEliminazione.getRiferimentoMessaggio(), dataMessaggio);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + String.valueOf(tipoOperazione) + "," + servizioApplicativo + "," + idMessaggio + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
            }
            imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.OK));
        }
        catch (Exception e) {
            try {
                imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX));
                if (e instanceof IntegrationManagerException) {
                    IntegrationManagerException exc = (IntegrationManagerException)e;
                    if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTENTICAZIONE_FALLITA));
                    } else if (CodiceErroreIntegrazione.CODICE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.MESSAGGIO_NON_TROVATO));
                    } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTORIZZAZIONE_FALLITA));
                    }
                }
            }
            catch (Exception eInteral) {
                IntegrationManager.logError(logCore, "Errore durante la generazione dell'esito: " + eInteral.getMessage(), eInteral);
                imResponseContext.setEsito(EsitoTransazione.ESITO_TRANSAZIONE_ERROR);
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "deleteMessage(" + String.valueOf(tipoOperazione) + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception exception) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    }
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public void deleteMessage(String idMessaggio) throws IntegrationManagerException {
        this.init();
        this.deleteMessage_engine(Operazione.deleteMessage, idMessaggio, false);
    }

    @Override
    public void deleteMessageByReference(String riferimentoMsg) throws IntegrationManagerException {
        this.init();
        this.deleteMessage_engine(Operazione.deleteMessageByReference, riferimentoMsg, true);
    }

    @Override
    public void deleteAllMessages() throws IntegrationManagerException {
        this.init();
        Operazione tipoOperazione = Operazione.deleteAllMessages;
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory<?> protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        IDServizioApplicativo idServizioApplicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(logCore, protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject(Costanti.ID_TRANSAZIONE, idTransazione);
        pddContext.addObject(Costanti.PROTOCOL_NAME, protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            ErroreIntegrazione erroreIntegrazione = null;
            IntegrationFunctionError integrationFunctionError = null;
            if (e instanceof HandlerException) {
                HandlerException he = (HandlerException)e;
                integrationFunctionError = he.getIntegrationFunctionError();
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                erroreIntegrazione = he.convertToErroreIntegrazione();
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            if (erroreIntegrazione == null) {
                erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione();
            }
            if (integrationFunctionError == null) {
                integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
            }
            throw new IntegrationManagerException(protocolFactory, erroreIntegrazione, integrationFunctionError, this.getErroriProperties(logCore));
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        if (imRequestContext != null) {
            imResponseContext.setConnettore(imRequestContext.getConnettore());
        }
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol(), null), ID_MODULO, idTransazione, OpenSPCoopStateDBManager.messageBox);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(configPdDManager);
            this.gestioneCredenziali(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            idServizioApplicativo = this.autenticazione(logCore, protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            imResponseContext.setServizioApplicativo(idServizioApplicativo);
            String param = "ServizioApplicativo[" + idServizioApplicativo.getNome() + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            GestoreMessaggi gestoreSearchID = new GestoreMessaggi(stato, true, msgDiag, pddContext);
            List<IdentificativoIM> ids = gestoreSearchID.getIDMessaggi_ServizioApplicativo(idServizioApplicativo.getNome());
            if (ids.isEmpty()) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.IM_MESSAGES_NOT_FOUND, this.getErroriProperties(logCore));
            }
            ArrayList<MessaggioIM> messaggiIM = new ArrayList<MessaggioIM>();
            for (int i = 0; i < ids.size(); ++i) {
                IdentificativoIM idIM = ids.get(i);
                String idMessaggio = idIM.getId();
                Date dataMessaggio = idIM.getData();
                GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                MessaggioIM messaggioIM = null;
                messaggioIM = gestoreMessaggi.readMessageForSIL(idServizioApplicativo.getNome(), dataMessaggio);
                if (messaggioIM != null) {
                    messaggiIM.add(messaggioIM);
                }
                boolean exists = false;
                boolean bl = exists = messaggioIM != null;
                if (!exists) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
                boolean authorized = false;
                authorized = messaggioIM.isAuthorized();
                if (authorized) continue;
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(idServizioApplicativo.getNome()), idServizioApplicativo, IntegrationFunctionError.AUTHORIZATION, this.getErroriProperties(logCore));
            }
            while (!ids.isEmpty()) {
                IdentificativoIM idIM = ids.remove(0);
                String idMessaggio = idIM.getId();
                Date dataMessaggio = idIM.getData();
                MessaggioIM messaggioIM = null;
                messaggioIM = (MessaggioIM)messaggiIM.remove(0);
                GestoreMessaggi gestoreEliminazione = null;
                try {
                    gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + String.valueOf(tipoOperazione) + "," + idServizioApplicativo.getNome() + "," + idMessaggio + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
                try {
                    TransazioneApplicativoServer transazioneApplicativoServer = null;
                    String nomePorta = null;
                    transazioneApplicativoServer = new TransazioneApplicativoServer();
                    transazioneApplicativoServer.setIdTransazione(messaggioIM.getIdTransazione());
                    transazioneApplicativoServer.setServizioApplicativoErogatore(messaggioIM.getServizioApplicativo());
                    transazioneApplicativoServer.setDataRegistrazione(messaggioIM.getOraRegistrazione());
                    transazioneApplicativoServer.setDataEliminazioneIm(DateManager.getDate());
                    transazioneApplicativoServer.setProtocollo(protocolFactory.getProtocol());
                    nomePorta = messaggioIM.getNomePorta();
                    if (transazioneApplicativoServer != null) {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(nomePorta);
                        try {
                            GestoreConsegnaMultipla.getInstance().safeUpdateEliminazioneIM(transazioneApplicativoServer, idPA, stato, pddContext);
                        }
                        catch (Throwable t) {
                            IntegrationManager.logError(logCore, "[" + transazioneApplicativoServer.getIdTransazione() + "][" + transazioneApplicativoServer.getServizioApplicativoErogatore() + "] Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage(), t);
                        }
                    }
                }
                catch (Exception e) {
                    IntegrationManager.logError(logCore, "Salvataggio informazioni sulla transazione non riuscita: " + e.getMessage(), e);
                }
                try {
                    gestoreEliminazione.eliminaDestinatarioMessaggio(idServizioApplicativo.getNome(), gestoreEliminazione.getRiferimentoMessaggio(), dataMessaggio);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + String.valueOf(tipoOperazione) + "," + idServizioApplicativo.getNome() + "," + idMessaggio + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
                }
            }
            imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.OK));
        }
        catch (Exception e) {
            try {
                imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX));
                if (e instanceof IntegrationManagerException) {
                    IntegrationManagerException exc = (IntegrationManagerException)e;
                    if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTENTICAZIONE_FALLITA));
                    } else if (CodiceErroreIntegrazione.CODICE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.MESSAGGI_NON_PRESENTI));
                    } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals((Object)exc.getCodiceErroreIntegrazione())) {
                        imResponseContext.setEsito(this.getEsitoTransazione(protocolFactory, imRequestContext, EsitoTransazioneName.AUTORIZZAZIONE_FALLITA));
                    }
                }
            }
            catch (Exception eInteral) {
                IntegrationManager.logError(logCore, "Errore durante la generazione dell'esito: " + eInteral.getMessage(), eInteral);
                imResponseContext.setEsito(EsitoTransazione.ESITO_TRANSAZIONE_ERROR);
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "deleteAllMessages(" + String.valueOf(tipoOperazione) + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idServizioApplicativo, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.getErroriProperties(logCore));
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception exception) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    HandlerException he = (HandlerException)e;
                    if (he.isEmettiDiagnostico()) {
                        msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                    }
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public IntegrationManagerMessage invocaPortaDelegata(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "invocaPortaDelegata";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    @Override
    public IntegrationManagerMessage invocaPortaDelegataPerRiferimento(String portaDelegata, IntegrationManagerMessage msg, String riferimentoMessaggio) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "invocaPortaDelegataPerRiferimento";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, riferimentoMessaggio);
    }

    @Override
    public IntegrationManagerMessage sendRispostaAsincronaSimmetrica(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "sendRispostaAsincronaSimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    @Override
    public IntegrationManagerMessage sendRichiestaStatoAsincronaAsimmetrica(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "sendRichiestaStatoAsincronaAsimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    private IntegrationManagerMessage invocaPortaDelegata_engine(String tipoOperazione, String portaDelegata, IntegrationManagerMessage msg, String idInvocazionePerRiferimento) throws IntegrationManagerException {
        Date dataAccettazioneRichiesta;
        Date dataIngressoRichiesta = dataAccettazioneRichiesta = DateManager.getDate();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory<?> protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione);
        this.setNomePortaDelegata(logCore, portaDelegata);
        RicezioneContenutiApplicativiIntegrationManagerService service = new RicezioneContenutiApplicativiIntegrationManagerService();
        return service.process(tipoOperazione, portaDelegata, msg, idInvocazionePerRiferimento, logCore, this.getHttpServletRequest(), this.getHttpServletResponse(), protocolFactory, dataAccettazioneRichiesta, dataIngressoRichiesta);
    }
}

