/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.core;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.LocalForwardEngine;
import org.openspcoop2.pdd.core.LocalForwardParameter;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiRest;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazione;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneHttpServletRequest;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.handlers.BaseContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.response_caching.HashGenerator;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Imbustamento;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.SbustamentoRisposte;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.AsyncResponseCallbackClientEvent;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.IAsyncResponseCallback;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop2.pdd.services.core.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.pdd.services.error.AbstractErrorGenerator;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.pdd.timers.TimerLock;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.pdd.timers.TimerThresholdThread;
import org.openspcoop2.pdd.timers.TipoLock;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativi
implements IAsyncResponseCallback {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    private static final String ERRORE_NON_GESTITO = "Errore non gestito";
    public static boolean initializeService = false;
    private static String[] defaultGestoriIntegrazionePD = null;
    private static ConcurrentHashMap<String, String[]> defaultPerProtocolloGestoreIntegrazionePD = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore;
    private RicezioneContenutiApplicativiContext msgContext;
    private IAsyncResponseCallback asyncResponseCallback;
    private ConfigurazionePdDManager configurazionePdDReader;
    private RegistroServiziManager registroServiziReader;
    private MsgDiagnostico msgDiag;
    private Logger logCore;
    private PdDContext context;
    private String idMessageRequest;
    private Busta bustaRichiesta;
    private IDSoggetto identitaPdD;
    private GestoreMessaggi msgRequest;
    private String servizioApplicativo;
    private HashMap<String, Object> internalObjects = null;
    private InRequestContext inRequestContext = null;
    private RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta;
    private ImbustamentoMessage imbustamentoMSG;
    private OpenSPCoop2Message requestMessage;
    private OpenSPCoopState openspcoopstate = null;
    private IProtocolFactory<?> protocolFactory = null;
    private PortaDelegata portaDelegata;
    private IDSoggetto soggettoFruitore;
    private IDServizio idServizio;
    private HeaderIntegrazione headerIntegrazioneRichiesta;
    private HeaderIntegrazione headerIntegrazioneRisposta;
    private String[] tipiIntegrazionePD;
    private boolean portaStateless = false;
    private boolean oneWayVers11 = false;
    private boolean richiestaAsincronaSimmetricaStateless;
    private boolean localForward;
    private boolean asyncWait = false;
    private EsitoLib esitoStatelessAfterSendRequest;

    private static void logDebug(Logger logCore, String msg) {
        logCore.debug(msg);
    }

    private static void logDebug(Logger logCore, String msg, Throwable e) {
        logCore.debug(msg, e);
    }

    private static void logInfo(Logger logCore, String msg) {
        logCore.info(msg);
    }

    private static void logError(Logger logCore, String msg) {
        logCore.error(msg);
    }

    private static void logError(Logger logCore, String msg, Throwable e) {
        logCore.error(msg, e);
    }

    public static synchronized void initializeService(ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws CoreException, ProtocolException {
        if (initializeService) {
            return;
        }
        String effettuataSuffix = " effettuata.";
        Loader loader = Loader.getInstance();
        PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + effettuataSuffix);
        }
        catch (Exception e) {
            throw new CoreException("Riscontrato errore durante il caricamento della classe 'NodeSender' [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore NodeReceiver di tipo " + classType + effettuataSuffix);
        }
        catch (Exception e) {
            throw new CoreException("Riscontrato errore durante il caricamento della classe 'NodeReceiver' [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (int i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            try {
                IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
                gestore.toString();
                RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore dati di integrazione per le fruizioni di tipo " + defaultGestoriIntegrazionePD[i] + effettuataSuffix);
                continue;
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
        }
        defaultPerProtocolloGestoreIntegrazionePD = new ConcurrentHashMap();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePD = propertiesReader.getTipoIntegrazionePD(protocol);
            if (tipiIntegrazionePD == null || tipiIntegrazionePD.length <= 0) continue;
            ArrayList<String> tipiIntegrazionePerProtocollo = new ArrayList<String>();
            for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
                try {
                    IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                    gestore.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePD[i]);
                    RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore dati di integrazione (protocollo: " + protocol + ") per le fruizioni di tipo " + tipiIntegrazionePD[i] + effettuataSuffix);
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException(e.getMessage(), (Throwable)e);
                }
            }
            if (tipiIntegrazionePerProtocollo.isEmpty()) continue;
            defaultPerProtocolloGestoreIntegrazionePD.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPD();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    RicezioneContenutiApplicativi.logInfo(logCore, "Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + effettuataSuffix);
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException("Riscontrato errore durante il caricamento della classe 'IGestoreCredenziali' [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context, RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore, IAsyncResponseCallback asyncResponseCallback) {
        this.msgContext = context;
        this.generatoreErrore = generatoreErrore;
        this.asyncResponseCallback = asyncResponseCallback;
    }

    public void process(Object ... params) throws ConnectorException {
        try {
            this.internalProcess(params);
        }
        finally {
            if (this.asyncResponseCallback != null && !this.asyncWait) {
                this.asyncResponseCallback.asyncComplete(AsyncResponseCallbackClientEvent.NONE, new Object[0]);
            }
        }
    }

    @Override
    public void asyncComplete(AsyncResponseCallbackClientEvent clientEvent, Object ... args) throws ConnectorException {
        if (this.asyncResponseCallback == null) {
            throw new ConnectorException("Async context not active");
        }
        if (args == null || args.length < 1) {
            throw new ConnectorException("Async context invalid (EsitoLib not found)");
        }
        Object esito = args[0];
        if (!(esito instanceof EsitoLib)) {
            throw new ConnectorException("Async context invalid (EsitoLib with uncorrect type '" + esito.getClass().getName() + "')");
        }
        this.esitoStatelessAfterSendRequest = (EsitoLib)esito;
        this.statelessComplete(true);
        this.asyncResponseCallback.asyncComplete(clientEvent, new Object[0]);
    }

    private void internalProcess(Object ... params) {
        String tipo;
        OpenSPCoop2Properties properties;
        this.context = this.msgContext.getPddContext();
        this.logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (this.logCore == null) {
            this.logCore = LoggerWrapperFactory.getLogger((String)ID_MODULO);
        }
        this.msgDiag = this.msgContext.getMsgDiagnostico();
        this.requestMessage = this.msgContext.getMessageRequest();
        if (this.requestMessage == null) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, new Exception("Request message is null"), "LetturaMessaggioRichiesta");
            return;
        }
        try {
            if (this.context == null) {
                throw new CoreException("Context is null");
            }
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.context.getObject(Costanti.PROTOCOL_NAME));
        }
        catch (Exception e) {
            this.setSOAPFault(IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, this.logCore, this.msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        this.inRequestContext = new InRequestContext(this.logCore, this.protocolFactory, null);
        this.inRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        this.inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null && this.msgContext.getUrlProtocolContext().getHttpServletRequest() != null && (properties = OpenSPCoop2Properties.getInstance()) != null && (tipo = properties.getRealContainerCustom()) != null) {
            try {
                ClassNameProperties className = ClassNameProperties.getInstance();
                Loader loader = Loader.getInstance();
                String tipoClass = className.getRealmContainerCustom(tipo);
                IAutorizzazioneSecurityContainer authEngine = (IAutorizzazioneSecurityContainer)loader.newInstance(tipoClass);
                authEngine.init(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), this.context, this.protocolFactory);
                AutorizzazioneHttpServletRequest httpServletRequestAuth = new AutorizzazioneHttpServletRequest(this.msgContext.getUrlProtocolContext().getHttpServletRequest(), authEngine);
                this.msgContext.getUrlProtocolContext().updateHttpServletRequest((HttpServletRequest)httpServletRequestAuth);
            }
            catch (Exception e) {
                this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "AutorizzazioneSecurityContainerInstance");
                return;
            }
        }
        connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        if (ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
            try {
                connettore.setSoapAction(this.requestMessage.castAsSoap().getSoapAction());
            }
            catch (Exception e) {
                this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "LetturaSoapAction");
                return;
            }
        }
        connettore.setFromLocation(this.msgContext.getSourceLocation());
        this.inRequestContext.setConnettore(connettore);
        this.inRequestContext.setDataAccettazioneRichiesta(this.msgContext.getDataAccettazioneRichiesta());
        this.inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        this.inRequestContext.setPddContext(this.context);
        this.inRequestContext.setMessaggio(this.requestMessage);
        try {
            GestoreHandlers.inRequest(this.inRequestContext, this.msgDiag, this.logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, this.logCore, this.msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        this.internalObjects = new HashMap();
        try {
            this.processEngine(this.internalObjects, params);
        }
        catch (TracciamentoException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
            return;
        }
        catch (DumpException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            return;
        }
        catch (ProtocolException e) {
            this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "InstanziazioneProtocolFactoryNonRiuscita");
            return;
        }
        if (this.asyncResponseCallback == null) {
            this._processComplete(false);
        }
    }

    private void _processComplete(boolean invokedFromAsyncConnector) {
        if (!this.internalObjects.containsKey("PROCESS_COMPLETE_SET_TIPO")) {
            try {
                if (invokedFromAsyncConnector) {
                    // empty if block
                }
                if (this.context != null && this.msgContext.getIntegrazione() != null) {
                    if (this.context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA)) {
                        this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)this.context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RICHIESTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA)) {
                        this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)this.context.getObject(CostantiPdD.TIPO_PROCESSAMENTO_MTOM_RISPOSTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA)) {
                        this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)this.context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RICHIESTA));
                    }
                    if (this.context.containsKey(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA)) {
                        this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)this.context.getObject(CostantiPdD.TIPO_SICUREZZA_MESSAGGIO_RISPOSTA));
                    }
                }
            }
            catch (Exception e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "FinalizeIntegrationContextRicezioneContenutiApplicativi");
                return;
            }
            this.internalObjects.put("PROCESS_COMPLETE_SET_TIPO", true);
        }
        if (!this.internalObjects.containsKey("DumpRichiestaEffettuato") && Dump.isSistemaDumpDisponibile()) {
            try {
                OpenSPCoop2Message msgRichiesta;
                URLProtocolContext urlProtocolContext;
                if (this.configurazionePdDReader == null) {
                    this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                }
                if (!this.internalObjects.containsKey("DumpConfig") && (urlProtocolContext = this.msgContext.getUrlProtocolContext()) != null && urlProtocolContext.getInterfaceName() != null) {
                    IDPortaDelegata identificativoPortaDelegata = new IDPortaDelegata();
                    identificativoPortaDelegata.setNome(urlProtocolContext.getInterfaceName());
                    this.portaDelegata = this.configurazionePdDReader.getPortaDelegataSafeMethod(identificativoPortaDelegata, this.msgContext.getRequestInfo());
                    if (this.portaDelegata != null) {
                        DumpConfigurazione dumpConfig = this.configurazionePdDReader.getDumpConfigurazione(this.portaDelegata);
                        this.internalObjects.put("DumpConfig", dumpConfig);
                    }
                }
                if ((msgRichiesta = this.inRequestContext.getMessaggio()) != null) {
                    Dump dumpApplicativo = this.getDump(this.configurazionePdDReader, this.protocolFactory, this.internalObjects, this.msgDiag.getPorta());
                    dumpApplicativo.dumpRichiestaIngresso(msgRichiesta, this.inRequestContext.getConnettore().getUrlProtocolContext());
                }
            }
            catch (DumpException e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        BaseContext outResponseContext = null;
        if (!this.internalObjects.containsKey("PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER")) {
            outResponseContext = new OutResponseContext(this.logCore, this.protocolFactory, null);
            outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
            outResponseContext.setIdModulo(this.msgContext.getIdModulo());
            outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            outResponseContext.setPddContext(this.inRequestContext.getPddContext());
            ((OutResponseContext)outResponseContext).setProtocollo(this.msgContext.getProtocol());
            ((OutResponseContext)outResponseContext).setIntegrazione(this.msgContext.getIntegrazione());
            ((OutResponseContext)outResponseContext).setResponseHeaders(this.msgContext.getResponseHeaders());
            OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
            outResponseContext.setMessaggio(msgResponse);
            try {
                GestoreHandlers.outResponse((OutResponseContext)outResponseContext, this.msgDiag, this.logCore);
            }
            catch (HandlerException e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, e.getIdentitaHandler());
                return;
            }
            catch (Exception e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "InvocazioneOutResponseHandler");
                return;
            }
            this.internalObjects.put("PROCESS_COMPLETE_GESTORE_OUT_RESPONSE_HANDLER", true);
        }
        OpenSPCoop2Message msgRisposta = null;
        if (outResponseContext != null) {
            try {
                msgRisposta = outResponseContext.getMessaggio();
                boolean rispostaPresente = true;
                OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
                if (properties != null) {
                    rispostaPresente = ServicesUtils.verificaRispostaRelazioneCodiceTrasporto202(this.protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
                }
                if (rispostaPresente) {
                    this.msgContext.setMessageResponse(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(null);
                    msgRisposta = null;
                }
            }
            catch (Exception e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, e, "FineGestioneRicezioneContenutiApplicativi");
                return;
            }
        }
        if (!this.internalObjects.containsKey("DumpRispostaEffettuato") && Dump.isSistemaDumpDisponibile() && outResponseContext != null) {
            try {
                if (this.configurazionePdDReader == null) {
                    this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                }
                if (msgRisposta != null) {
                    Dump dumpApplicativo = this.getDump(this.configurazionePdDReader, this.protocolFactory, this.internalObjects, this.msgDiag.getPorta());
                    if (((OutResponseContext)outResponseContext).getResponseHeaders() == null) {
                        ((OutResponseContext)outResponseContext).setResponseHeaders(new HashMap<String, List<String>>());
                    }
                    Map<String, List<String>> propertiesTrasporto = ((OutResponseContext)outResponseContext).getResponseHeaders();
                    ServicesUtils.setGovWayHeaderResponse(this.requestMessage.getServiceBinding(), msgRisposta, OpenSPCoop2Properties.getInstance(), propertiesTrasporto, this.logCore, true, outResponseContext.getPddContext(), this.msgContext.getRequestInfo());
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, this.inRequestContext.getConnettore().getUrlProtocolContext(), ((OutResponseContext)outResponseContext).getResponseHeaders());
                    this.internalObjects.put("DumpRispostaEffettuato", true);
                }
            }
            catch (DumpException e) {
                this.setSOAPFault(AbstractErrorGenerator.getIntegrationInternalError(this.context), this.logCore, this.msgDiag, (Exception)((Object)e), "DumpNonRiuscito");
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(this.logCore, e.getMessage(), e);
            }
        }
    }

    private Dump getDump(ConfigurazionePdDManager configurazionePdDReader, IProtocolFactory<?> protocolFactory, HashMap<String, Object> internalObjects, String nomePorta) throws DumpException, DriverRegistroServiziException {
        DumpConfigurazione dumpConfig = null;
        dumpConfig = internalObjects.containsKey("DumpConfig") ? (DumpConfigurazione)internalObjects.get("DumpConfig") : configurazionePdDReader.getDumpConfigurazionePortaDelegata();
        ProtocolContext protocolContext = this.msgContext.getProtocol();
        URLProtocolContext urlProtocolContext = this.msgContext.getUrlProtocolContext();
        IDSoggetto soggettoErogatore = null;
        IDSoggetto fruitore = null;
        IDSoggetto dominio = null;
        String idRichiesta = null;
        if (protocolContext != null) {
            if (protocolContext.getTipoServizio() != null && protocolContext.getServizio() != null && protocolContext.getVersioneServizio() != null && protocolContext.getErogatore() != null && protocolContext.getErogatore().getTipo() != null && protocolContext.getErogatore().getNome() != null) {
                this.idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getErogatore(), protocolContext.getVersioneServizio().intValue());
            }
            dominio = protocolContext.getDominio();
            idRichiesta = protocolContext.getIdRichiesta();
            if (protocolContext.getFruitore() != null && protocolContext.getFruitore().getTipo() != null && protocolContext.getFruitore().getNome() != null) {
                fruitore = protocolContext.getFruitore();
            }
        }
        if ((dominio == null || fruitore == null || this.idServizio == null) && urlProtocolContext != null && urlProtocolContext.getInterfaceName() != null) {
            IDPortaDelegata identificativoPortaDelegata = new IDPortaDelegata();
            identificativoPortaDelegata.setNome(urlProtocolContext.getInterfaceName());
            this.portaDelegata = null;
            try {
                this.portaDelegata = configurazionePdDReader.getPortaDelegataSafeMethod(identificativoPortaDelegata, this.msgContext.getRequestInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.portaDelegata != null) {
                soggettoErogatore = new IDSoggetto(this.portaDelegata.getSoggettoErogatore().getTipo(), this.portaDelegata.getSoggettoErogatore().getNome());
                if (this.portaDelegata.getServizio() != null) {
                    this.idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(this.portaDelegata.getServizio().getTipo(), this.portaDelegata.getServizio().getNome(), soggettoErogatore, this.portaDelegata.getServizio().getVersione().intValue());
                }
                dominio = new IDSoggetto(this.portaDelegata.getTipoSoggettoProprietario(), this.portaDelegata.getNomeSoggettoProprietario());
                fruitore = new IDSoggetto(this.portaDelegata.getTipoSoggettoProprietario(), this.portaDelegata.getNomeSoggettoProprietario());
                try {
                    dominio.setCodicePorta(RegistroServiziManager.getInstance().getDominio(dominio, null, protocolFactory, this.msgContext.getRequestInfo()));
                }
                catch (Exception e) {
                    dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
                }
            }
        }
        if (this.idServizio != null) {
            if (protocolContext != null && protocolContext.getAzione() != null) {
                this.idServizio.setAzione(protocolContext.getAzione());
            } else if (this.msgContext.getRequestInfo() != null && this.msgContext.getRequestInfo().getIdServizio() != null && this.msgContext.getRequestInfo().getIdServizio().getAzione() != null) {
                this.idServizio.setAzione(this.msgContext.getRequestInfo().getIdServizio().getAzione());
            }
        }
        if (dominio == null) {
            dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), this.msgContext.getRequestInfo());
        }
        Dump dumpApplicativo = null;
        dumpApplicativo = this.idServizio != null ? new Dump(dominio, this.msgContext.getIdModulo(), idRichiesta, fruitore, this.idServizio, this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig) : new Dump(dominio, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), nomePorta, this.msgContext.getPddContext(), null, null, dumpConfig);
        return dumpApplicativo;
    }

    private void setSOAPFault(IntegrationFunctionError integrationFunctionError, Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        HandlerException he = null;
        if (e instanceof HandlerException) {
            HandlerException cast;
            he = cast = (HandlerException)e;
        }
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizione);
                }
            } else {
                msgDiag.logErroreGenerico(e, posizione);
            }
        } else if (e != null) {
            RicezioneContenutiApplicativi.logError(logCore, posizione + ": " + e.getMessage(), e);
        } else {
            RicezioneContenutiApplicativi.logError(logCore, posizione);
        }
        IntegrationFunctionError ifError = integrationFunctionError;
        if (he != null && he.getIntegrationFunctionError() != null) {
            ifError = he.getIntegrationFunctionError();
        }
        ErroreIntegrazione erroreIntegrazioneGenerato = null;
        if (he != null) {
            erroreIntegrazioneGenerato = he.convertToErroreIntegrazione();
        }
        if (this.msgContext.isGestioneRisposta()) {
            Object posizioneFault = null;
            posizioneFault = e != null ? posizione + ": " + e.getMessage() : posizione;
            if (erroreIntegrazioneGenerato == null) {
                erroreIntegrazioneGenerato = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento((String)posizioneFault);
            }
            OpenSPCoop2Message messageFault = this.generatoreErrore.build((Context)this.msgContext.getPddContext(), ifError, erroreIntegrazioneGenerato, e, null);
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    private boolean checkInizializzazione(Logger logCore, PdDContext pddContext) {
        if (!OpenSPCoop2Startup.initialize) {
            String msgErrore = "Inizializzazione di GovWay non correttamente effettuata";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneGovWay");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (InizializzazioneGovWay): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), null, null));
            }
            return false;
        }
        if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
            String msgErrore = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "InizializzazioneRisorseGovWay");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (InizializzazioneRisorseGovWay): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI), null, null));
            }
            return false;
        }
        if (!TimerThresholdThread.freeSpace) {
            String msgErrore = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "DisponibilitaRisorseGovWay");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (DisponibilitaRisorseGovWay): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO), null, null));
            }
            return false;
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            String msgErrore = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, Tracciamento.motivoMalfunzionamentoTracciamento);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Tracciamento");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Tracciamento): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            String msgErrore = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Diagnostica");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logDebug(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Diagnostica): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        if (!Dump.isSistemaDumpDisponibile()) {
            String msgErrore = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage();
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, Dump.getMotivoMalfunzionamentoDump());
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "Dump");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (Dump): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE), null, null));
            }
            return false;
        }
        this.configurazionePdDReader = ConfigurazionePdDManager.getInstance();
        try {
            this.configurazionePdDReader.verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica della consistenza della configurazione";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckConfigurazioneGovWay");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (CheckConfigurazioneGovWay): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), null, null));
            }
            return false;
        }
        this.registroServiziReader = RegistroServiziManager.getInstance();
        try {
            this.registroServiziReader.verificaConsistenzaRegistroServizi();
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato errore durante la verifica del registro dei servizi";
            RicezioneContenutiApplicativi.logError(logCore, "[RicezioneContenutiApplicativi]  " + msgErrore, e);
            try {
                if (this.msgContext.getMsgDiagnostico() != null) {
                    this.msgContext.getMsgDiagnostico().logErroreGenerico(msgErrore, "CheckRegistroServizi");
                }
            }
            catch (Exception t) {
                RicezioneContenutiApplicativi.logError(logCore, "Emissione diagnostico per errore inizializzazione non riuscita (CheckRegistroServizi): " + t.getMessage(), t);
            }
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), null, null));
            }
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private void processEngine(HashMap<String, Object> internalObjects, Object ... params) throws TracciamentoException, DumpException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [139[CATCHBLOCK]], but top level block is 28[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void finalEngine(Transaction transaction, ServizioApplicativo sa, IDPortaDelegata identificativoPortaDelegata, RichiestaDelegata richiestaDelegata, String idCorrelazioneApplicativa, InRequestPDMessage inRequestPDMessage, String token, boolean corsTrasparente, String nomeUtilizzatoPerErrore, Credenziali credenziali) throws ProtocolException {
        block369: {
            block368: {
                block367: {
                    block366: {
                        block365: {
                            block363: {
                                block362: {
                                    block361: {
                                        pddContext = this.inRequestContext.getPddContext();
                                        propertiesReader = OpenSPCoop2Properties.getInstance();
                                        traduttore = this.protocolFactory.createTraduttore();
                                        protocolConfig = this.protocolFactory.createProtocolConfiguration();
                                        dataIngressoRichiesta = this.msgContext.getDataIngressoRichiesta();
                                        idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, this.inRequestContext.getPddContext());
                                        requestInfo = this.msgContext.getRequestInfo();
                                        className = ClassNameProperties.getInstance();
                                        loader = Loader.getInstance();
                                        pluginLoader = PddPluginLoader.getInstance();
                                        bustaBuilder = this.protocolFactory.createBustaBuilder(this.openspcoopstate.getStatoRichiesta());
                                        this.idServizio = richiestaDelegata.getIdServizio();
                                        this.msgContext.getProtocol().setFruitore(this.soggettoFruitore);
                                        this.msgContext.getProtocol().setErogatore(this.idServizio.getSoggettoErogatore());
                                        this.msgContext.getProtocol().setTipoServizio(this.idServizio.getTipo());
                                        this.msgContext.getProtocol().setServizio(this.idServizio.getNome());
                                        this.msgContext.getProtocol().setVersioneServizio(this.idServizio.getVersione());
                                        this.msgContext.getProtocol().setAzione(this.idServizio.getAzione());
                                        this.msgContext.getProtocol().setIdRichiesta(this.idMessageRequest);
                                        idServizioApplicativo = new IDServizioApplicativo();
                                        idServizioApplicativo.setNome(this.servizioApplicativo);
                                        idServizioApplicativo.setIdSoggettoProprietario(this.soggettoFruitore);
                                        infoSearch = null;
                                        try {
                                            infoSearch = IDServizioFactory.getInstance().getUriFromIDServizio(this.idServizio);
                                        }
                                        catch (Exception e) {
                                            infoSearch = this.idServizio.toString(false);
                                        }
                                        if (this.idServizio.getAzione() != null) {
                                            infoSearch = (String)infoSearch + " azione " + this.idServizio.getAzione();
                                        }
                                        this.msgDiag.addKeyword("@INFO_SERVIZIO_BUSTA@", (String)infoSearch);
                                        this.msgDiag.mediumDebug("Ricerca nome registro [" + (String)infoSearch + "]...");
                                        nomeRegistroForSearch = null;
                                        try {
                                            nomeRegistroForSearch = this.configurazionePdDReader.getRegistroForImbustamento(this.soggettoFruitore, this.idServizio, false, requestInfo);
                                        }
                                        catch (Exception e) {
                                            RicezioneContenutiApplicativi.logError(this.logCore, "Connettore associato al servizio non trovato: " + e.getMessage(), e);
                                            this.msgDiag.addKeywordErroreProcessamento(e, "connettore associato al servizio non trovato");
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            this.openspcoopstate.releaseResource();
                                            if (this.msgContext.isGestioneRisposta()) {
                                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_514_ROUTING_CONFIGURATION_ERROR), e, null));
                                            }
                                            return;
                                        }
                                        riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato = null;
                                        v0 = supportoProfiliAsincroni = protocolConfig.isSupportato(requestInfo.getProtocolServiceBinding(), ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) != false || protocolConfig.isSupportato(requestInfo.getProtocolServiceBinding(), ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO) != false;
                                        if (supportoProfiliAsincroni) {
                                            if (this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                                                riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato = this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio();
                                            }
                                            if (riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato == null && propertiesReader.isIntegrazioneAsincroniConIdCollaborazioneEnabled() && this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() != null) {
                                                infoServizioTmpVerificaCorrelato = null;
                                                try {
                                                    infoServizioTmpVerificaCorrelato = this.registroServiziReader.getInfoServizioCorrelato(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, requestInfo);
                                                }
                                                catch (Exception e) {
                                                    RicezioneContenutiApplicativi.logDebug(this.logCore, "Verifica servizio [" + (String)infoSearch + "] se e' correlato, fallita: " + e.getMessage());
                                                    try {
                                                        infoServizioTmpVerificaCorrelato = this.registroServiziReader.getInfoServizioAzioneCorrelata(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, requestInfo);
                                                    }
                                                    catch (Exception eCorrelato) {
                                                        RicezioneContenutiApplicativi.logDebug(this.logCore, "Verifica servizio [" + (String)infoSearch + "] se e' correlato rispetto all'azione, fallita: " + e.getMessage());
                                                    }
                                                }
                                                if (infoServizioTmpVerificaCorrelato != null) {
                                                    riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato = this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione();
                                                }
                                            }
                                        }
                                        infoSearch = riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato != null ? "Servizio correlato " + (String)infoSearch : "Servizio " + (String)infoSearch;
                                        infoSearch = "Ricerca nel registro dei servizi di: " + (String)infoSearch;
                                        if (riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato != null) {
                                            infoSearch = (String)infoSearch + " (idServizioCorrelato: " + riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato + ")";
                                        }
                                        this.msgDiag.addKeyword("@INFO_SERVIZIO_BUSTA@", (String)infoSearch);
                                        this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioInCorso");
                                        isServizioCorrelato = false;
                                        invocazioneAzioneErrata = null;
                                        portTypeErrato = null;
                                        ricercaConErrore = false;
                                        servizioCorrelatoNonTrovato = false;
                                        servizioNonTrovato = false;
                                        infoServizio = null;
                                        eServiceNotFound = null;
                                        try {
                                            if (riferimentoServizioCorrelatoRicercaSolamenteServizioCorrelato != null) {
                                                erroreRicerca = null;
                                                this.msgDiag.mediumDebug("Ricerca servizio correlato ...");
                                                try {
                                                    infoServizio = this.registroServiziReader.getInfoServizioCorrelato(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, requestInfo);
                                                    isServizioCorrelato = true;
                                                }
                                                catch (DriverRegistroServiziAzioneNotFound e) {
                                                    throwFault = true;
                                                    if (corsTrasparente) {
                                                        try {
                                                            infoServizio = this.registroServiziReader.getInfoServizioCorrelato(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, false, requestInfo);
                                                            isServizioCorrelato = true;
                                                            throwFault = false;
                                                        }
                                                        catch (Throwable var38_60) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (throwFault) {
                                                        invocazioneAzioneErrata = e.getMessage();
                                                        throw e;
                                                    }
                                                }
                                                catch (DriverRegistroServiziNotFound e) {
                                                    erroreRicerca = "\nRicerca come servizio correlato-> " + e.getMessage();
                                                }
                                                if (infoServizio == null && this.idServizio.getAzione() != null) {
                                                    this.msgDiag.mediumDebug("Ricerca servizio con azione correlata...");
                                                    try {
                                                        infoServizio = this.registroServiziReader.getInfoServizioAzioneCorrelata(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, requestInfo);
                                                        isServizioCorrelato = true;
                                                    }
                                                    catch (DriverRegistroServiziAzioneNotFound e) {
                                                        throwFault = true;
                                                        if (corsTrasparente) {
                                                            try {
                                                                infoServizio = this.registroServiziReader.getInfoServizioAzioneCorrelata(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, false, requestInfo);
                                                                isServizioCorrelato = true;
                                                                throwFault = false;
                                                            }
                                                            catch (Throwable var38_61) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (throwFault) {
                                                            invocazioneAzioneErrata = e.getMessage();
                                                            throw e;
                                                        }
                                                    }
                                                    catch (DriverRegistroServiziNotFound e) {
                                                        erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                                    }
                                                }
                                                this.msgDiag.highDebug("Controllo dati individuati ...");
                                                if (infoServizio == null && erroreRicerca == null) {
                                                    throw new DriverRegistroServiziNotFound("Servizio Correlato non trovato ne tramite la normale ricerca, ne tramite la ricerca per azione correlata (solo se profilo e' asincrono asimmetrico)");
                                                }
                                                if (infoServizio == null) {
                                                    throw new DriverRegistroServiziNotFound(erroreRicerca);
                                                }
                                                break block361;
                                            }
                                            erroreRicerca = null;
                                            this.msgDiag.mediumDebug("Ricerca servizio ...");
                                            try {
                                                infoServizio = this.registroServiziReader.getInfoServizio(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, true, requestInfo);
                                            }
                                            catch (DriverRegistroServiziAzioneNotFound e) {
                                                throwFault = true;
                                                if (corsTrasparente) {
                                                    try {
                                                        infoServizio = this.registroServiziReader.getInfoServizio(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, false, requestInfo);
                                                        throwFault = false;
                                                    }
                                                    catch (Throwable var38_63) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (throwFault) {
                                                    invocazioneAzioneErrata = e.getMessage();
                                                    throw e;
                                                }
                                            }
                                            catch (DriverRegistroServiziNotFound e) {
                                                erroreRicerca = "\nRicerca come servizio -> " + e.getMessage();
                                            }
                                            if (infoServizio == null) {
                                                this.msgDiag.mediumDebug("Ricerca servizio correlato...");
                                                try {
                                                    infoServizio = this.registroServiziReader.getInfoServizioCorrelato(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, true, requestInfo);
                                                    isServizioCorrelato = true;
                                                }
                                                catch (DriverRegistroServiziAzioneNotFound e) {
                                                    throwFault = true;
                                                    if (corsTrasparente) {
                                                        try {
                                                            infoServizio = this.registroServiziReader.getInfoServizioCorrelato(this.soggettoFruitore, this.idServizio, nomeRegistroForSearch, false, requestInfo);
                                                            isServizioCorrelato = true;
                                                            throwFault = false;
                                                        }
                                                        catch (Throwable var38_64) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    if (throwFault) {
                                                        invocazioneAzioneErrata = e.getMessage();
                                                        throw e;
                                                    }
                                                }
                                                catch (DriverRegistroServiziNotFound e) {
                                                    erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                                }
                                            }
                                            if (infoServizio == null && erroreRicerca == null) {
                                                throw new DriverRegistroServiziNotFound("Servizio non trovato ne tramite la normale ricerca, ne tramite la ricerca per servizio correlato");
                                            }
                                            if (infoServizio == null) {
                                                throw new DriverRegistroServiziNotFound(erroreRicerca);
                                            }
                                        }
                                        catch (DriverRegistroServiziNotFound e) {
                                            eServiceNotFound = e;
                                            this.msgDiag.addKeywordErroreProcessamento(e);
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            servizioNonTrovato = true;
                                        }
                                        catch (DriverRegistroServiziAzioneNotFound e) {
                                            eServiceNotFound = e;
                                            this.msgDiag.addKeywordErroreProcessamento(e);
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                        }
                                        catch (DriverRegistroServiziPortTypeNotFound e) {
                                            eServiceNotFound = e;
                                            this.msgDiag.addKeywordErroreProcessamento(e, "configurazione registro dei servizi errata");
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            portTypeErrato = "Configurazione del registro dei Servizi errata: " + e.getMessage();
                                        }
                                        catch (DriverRegistroServiziCorrelatoNotFound e) {
                                            eServiceNotFound = e;
                                            this.msgDiag.addKeywordErroreProcessamento(e, "correlazione asincrona non rilevata");
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            servizioCorrelatoNonTrovato = true;
                                        }
                                        catch (Exception e) {
                                            eServiceNotFound = e;
                                            this.msgDiag.addKeywordErroreProcessamento(e, "errore generale");
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            RicezioneContenutiApplicativi.logError(this.logCore, "Ricerca servizio fallita", e);
                                            ricercaConErrore = true;
                                        }
                                    }
                                    if (infoServizio == null) {
                                        if (!(servizioNonTrovato || ricercaConErrore || servizioCorrelatoNonTrovato || invocazioneAzioneErrata != null)) {
                                            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio non esistente");
                                            this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                            servizioNonTrovato = true;
                                        }
                                        erroreIntegrazione = null;
                                        integrationFunctionError = null;
                                        if (invocazioneAzioneErrata != null) {
                                            azione = "";
                                            if (this.idServizio.getAzione() != null) {
                                                azione = "(azione:" + this.idServizio.getAzione() + ") ";
                                            }
                                            pddContext.addObject(Costanti.OPERAZIONE_NON_INDIVIDUATA, "true");
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_423_SERVIZIO_CON_AZIONE_SCORRETTA.getErrore423_ServizioConAzioneScorretta((String)azione + invocazioneAzioneErrata);
                                            integrationFunctionError = IntegrationFunctionError.OPERATION_UNDEFINED;
                                        } else if (portTypeErrato != null) {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(portTypeErrato, CodiceErroreIntegrazione.CODICE_540_REGISTRO_SERVIZI_MAL_CONFIGURATO);
                                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        } else if (servizioNonTrovato) {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione();
                                            integrationFunctionError = IntegrationFunctionError.NOT_FOUND;
                                        } else if (ricercaConErrore) {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE);
                                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        } else if (servizioCorrelatoNonTrovato) {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione();
                                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        } else {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_500_ERRORE_INTERNO);
                                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        }
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, eServiceNotFound, null));
                                        }
                                        return;
                                    }
                                    this.msgDiag.highDebug("Ricerca servizio terminata");
                                    infoServizio.setCorrelato(isServizioCorrelato);
                                    this.msgContext.getProtocol().setProfiloCollaborazione(infoServizio.getProfiloDiCollaborazione(), null);
                                    this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(infoServizio.getProfiloDiCollaborazione()));
                                    if (infoServizio != null && infoServizio.getIdAccordo() != null) {
                                        this.msgContext.getProtocol().setIdAccordo(infoServizio.getIdAccordo());
                                        richiestaDelegata.setIdAccordo(infoServizio.getIdAccordo());
                                        try {
                                            this.idServizio.setUriAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromIDAccordo(infoServizio.getIdAccordo()));
                                        }
                                        catch (Exception erroreIntegrazione) {
                                            // empty catch block
                                        }
                                    }
                                    this.msgDiag.highDebug("Convert infoServizio to Busta ...");
                                    this.bustaRichiesta = infoServizio.convertToBusta(this.protocolFactory.getProtocol(), this.soggettoFruitore);
                                    if (sa != null) {
                                        this.bustaRichiesta.setServizioApplicativoFruitore(sa.getNome());
                                    }
                                    this.msgDiag.highDebug("Convert infoServizio to Busta terminata");
                                    inRequestPDMessage.setBustaRichiesta(this.bustaRichiesta);
                                    if (this.msgContext.getProtocol() != null && this.idServizio.getVersione() != null && (this.msgContext.getProtocol().getVersioneServizio() == null || this.msgContext.getProtocol().getVersioneServizio().intValue() != this.idServizio.getVersione().intValue())) {
                                        this.msgContext.getProtocol().setVersioneServizio(this.idServizio.getVersione());
                                    }
                                    tipoAutorizzazione = null;
                                    tipoAutorizzazioneContenuto = null;
                                    try {
                                        tipoAutorizzazione = this.configurazionePdDReader.getAutorizzazione(this.portaDelegata);
                                        tipoAutorizzazioneContenuto = this.configurazionePdDReader.getAutorizzazioneContenuto(this.portaDelegata);
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "letturaAutenticazioneTokenAutorizzazione");
                                        RicezioneContenutiApplicativi.logError(this.logCore, this.msgDiag.getMessaggio_replaceKeywords("letturaAutenticazioneTokenAutorizzazione"), e);
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                                        }
                                        return;
                                    }
                                    datiInvocazione = new DatiInvocazionePortaDelegata();
                                    datiInvocazione.setBusta(this.bustaRichiesta);
                                    datiInvocazione.setToken(token);
                                    datiInvocazione.setPddContext(pddContext);
                                    datiInvocazione.setInfoConnettoreIngresso(this.inRequestContext.getConnettore());
                                    datiInvocazione.setIdServizio(richiestaDelegata.getIdServizio());
                                    datiInvocazione.setState(this.openspcoopstate.getStatoRichiesta());
                                    datiInvocazione.setIdPD(identificativoPortaDelegata);
                                    datiInvocazione.setPd(this.portaDelegata);
                                    datiInvocazione.setIdServizioApplicativo(idServizioApplicativo);
                                    datiInvocazione.setServizioApplicativo(sa);
                                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Autorizzazione del servizio applicativo...");
                                    this.msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                                    this.msgContext.getIntegrazione().setTipoAutorizzazione(tipoAutorizzazione);
                                    if (tipoAutorizzazione != null) {
                                        this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE@", tipoAutorizzazione);
                                    }
                                    if (!"none".equalsIgnoreCase(tipoAutorizzazione)) {
                                        transaction.getTempiElaborazione().startAutorizzazione();
                                        try {
                                            this.msgDiag.logPersonalizzato("autorizzazioneInCorso");
                                            errore = null;
                                            eAutorizzazione = null;
                                            errorMessageAutorizzazione = null;
                                            wwwAuthenticateErrorHeader = null;
                                            detailsSet = false;
                                            integrationFunctionError = null;
                                            try {
                                                esito = GestoreAutorizzazione.verificaAutorizzazionePortaDelegata(tipoAutorizzazione, datiInvocazione, pddContext, this.protocolFactory, this.requestMessage, this.logCore);
                                                CostantiPdD.addKeywordInCache(this.msgDiag, esito.isEsitoPresenteInCache(), pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE);
                                                if (esito.getDetails() == null) {
                                                    this.msgDiag.addKeyword("@DETAILS@", "");
                                                } else {
                                                    this.msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                                                }
                                                detailsSet = true;
                                                if (!esito.isAutorizzato()) {
                                                    errore = esito.getErroreIntegrazione();
                                                    eAutorizzazione = esito.getEccezioneProcessamento();
                                                    errorMessageAutorizzazione = esito.getErrorMessage();
                                                    wwwAuthenticateErrorHeader = esito.getWwwAuthenticateErrorHeader();
                                                    integrationFunctionError = esito.getIntegrationFunctionError();
                                                    pddContext.addObject(Costanti.ERRORE_AUTORIZZAZIONE, "true");
                                                } else {
                                                    this.msgDiag.logPersonalizzato("autorizzazioneEffettuata");
                                                }
                                            }
                                            catch (Exception e) {
                                                CostantiPdD.addKeywordInCache(this.msgDiag, false, pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE);
                                                errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage(), CodiceErroreIntegrazione.CODICE_504_AUTORIZZAZIONE);
                                                eAutorizzazione = e;
                                                RicezioneContenutiApplicativi.logError(this.logCore, "processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage(), e);
                                            }
                                            if (errore == null) break block362;
                                            if (!detailsSet) {
                                                this.msgDiag.addKeyword("@DETAILS@", "");
                                            }
                                            descrizioneErrore = null;
                                            try {
                                                descrizioneErrore = errore.getDescrizione(this.protocolFactory);
                                                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", descrizioneErrore);
                                            }
                                            catch (Exception e) {
                                                RicezioneContenutiApplicativi.logError(this.logCore, "getDescrizione Error:" + e.getMessage(), e);
                                            }
                                            this.msgDiag.logPersonalizzato("servizioApplicativoFruitore.nonAutorizzato");
                                            errorMsg = "Riscontrato errore durante il processo di Autorizzazione per il messaggio con identificativo [" + this.idMessageRequest + "]: " + descrizioneErrore;
                                            if (eAutorizzazione != null) {
                                                RicezioneContenutiApplicativi.logError(this.logCore, errorMsg, eAutorizzazione);
                                            } else {
                                                RicezioneContenutiApplicativi.logError(this.logCore, errorMsg);
                                            }
                                            this.openspcoopstate.releaseResource();
                                            if (this.msgContext.isGestioneRisposta()) {
                                                if (errorMessageAutorizzazione != null) {
                                                    this.msgContext.setMessageResponse(errorMessageAutorizzazione);
                                                } else {
                                                    if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals((Object)errore.getCodiceErrore()) || CodiceErroreIntegrazione.CODICE_445_TOKEN_AUTORIZZAZIONE_FALLITA.equals((Object)errore.getCodiceErrore())) {
                                                        if (integrationFunctionError == null) {
                                                            integrationFunctionError = IntegrationFunctionError.AUTHORIZATION;
                                                        }
                                                    } else if (integrationFunctionError == null) {
                                                        integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                                    }
                                                    errorOpenSPCoopMsg = this.generatoreErrore.build((Context)pddContext, integrationFunctionError, errore, eAutorizzazione, null);
                                                    if (wwwAuthenticateErrorHeader != null) {
                                                        errorOpenSPCoopMsg.forceTransportHeader("WWW-Authenticate", wwwAuthenticateErrorHeader);
                                                    }
                                                    this.msgContext.setMessageResponse(errorOpenSPCoopMsg);
                                                }
                                            }
                                            return;
                                        }
                                        finally {
                                            transaction.getTempiElaborazione().endAutorizzazione();
                                        }
                                    }
                                    this.msgDiag.logPersonalizzato("autorizzazioneDisabilitata");
                                }
                                if (infoServizio.getIdRiferimentoRichiesta() && protocolConfig.isIntegrationInfoRequired(TipoPdD.DELEGATA, requestInfo.getProtocolServiceBinding(), FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA)) {
                                    riferimentoRichiesta = null;
                                    if (this.headerIntegrazioneRichiesta != null && this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                                        riferimentoRichiesta = this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio();
                                        this.msgContext.getProtocol().setRiferimentoAsincrono(riferimentoRichiesta);
                                    }
                                    if (riferimentoRichiesta == null) {
                                        bf = new StringBuilder();
                                        for (i = 0; i < this.tipiIntegrazionePD.length; ++i) {
                                            if (i > 0) {
                                                bf.append(",");
                                            }
                                            bf.append(this.tipiIntegrazionePD[i]);
                                        }
                                        this.msgDiag.addKeyword("@TIPI_INTEGRAZIONE@", bf.toString());
                                        this.msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "riferimentoIdRichiesta.nonFornito");
                                        erroreIntegrazione = ErroriIntegrazione.ERRORE_442_RIFERIMENTO_ID_MESSAGGIO.getErroreIntegrazione();
                                        integrationFunctionError = IntegrationFunctionError.CORRELATION_INFORMATION_NOT_FOUND;
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, null, null));
                                        }
                                        return;
                                    }
                                }
                                try {
                                    profiloGestione = this.registroServiziReader.getProfiloGestioneFruizioneServizio(this.idServizio, nomeRegistroForSearch, requestInfo);
                                    richiestaDelegata.setProfiloGestione(profiloGestione);
                                    this.msgDiag.mediumDebug("Profilo di gestione [RicezioneContenutiApplicativi] della busta: " + profiloGestione);
                                }
                                catch (Exception e) {
                                    this.msgDiag.addKeywordErroreProcessamento(e, "analisi del profilo di gestione fallita");
                                    this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                    RicezioneContenutiApplicativi.logError(this.logCore, "Identificazione Profilo Gestione fallita", e);
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null));
                                    }
                                    return;
                                }
                                try {
                                    this.msgDiag.mediumDebug("Aggiornamento del messaggio");
                                    this.requestMessage = this.protocolFactory.createProtocolManager().updateOpenSPCoop2MessageRequest(this.requestMessage, this.bustaRichiesta, this.protocolFactory.getCachedRegistryReader((Object)this.registroServiziReader, requestInfo));
                                }
                                catch (Exception e) {
                                    this.msgDiag.addKeywordErroreProcessamento(e, "Aggiornamento messaggio fallito");
                                    this.msgDiag.logErroreGenerico(e, "ProtocolManager.updateOpenSPCoop2Message");
                                    RicezioneContenutiApplicativi.logError(this.logCore, "ProtocolManager.updateOpenSPCoop2Message error: " + e.getMessage(), e);
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null));
                                    }
                                    return;
                                }
                                indirizzoFruitore = null;
                                indirizzoErogatore = null;
                                protocolConfiguration = this.protocolFactory.createProtocolConfiguration();
                                if (protocolConfiguration.isSupportoIndirizzoRisposta()) {
                                    try {
                                        connettoreFruitore = null;
                                        try {
                                            connettoreFruitore = this.registroServiziReader.getConnettore(this.soggettoFruitore, nomeRegistroForSearch, requestInfo);
                                        }
                                        catch (DriverRegistroServiziNotFound detailsSet) {
                                            // empty catch block
                                        }
                                        if (connettoreFruitore != null && !CostantiConfigurazione.DISABILITATO.equals(connettoreFruitore.getTipo()) && connettoreFruitore.getProperties() != null && connettoreFruitore.getProperties().containsKey("location")) {
                                            indirizzoFruitore = (String)connettoreFruitore.getProperties().get("location");
                                        }
                                        this.msgDiag.mediumDebug("Indirizzo Risposta del soggetto fruitore [" + String.valueOf(this.soggettoFruitore) + "]: " + indirizzoFruitore);
                                        connettoreErogatore = null;
                                        try {
                                            connettoreErogatore = this.registroServiziReader.getConnettore(this.idServizio.getSoggettoErogatore(), nomeRegistroForSearch, requestInfo);
                                        }
                                        catch (DriverRegistroServiziNotFound integrationFunctionError) {
                                            // empty catch block
                                        }
                                        if (connettoreErogatore != null && !CostantiConfigurazione.DISABILITATO.equals(connettoreErogatore.getTipo()) && connettoreErogatore.getProperties() != null && connettoreErogatore.getProperties().containsKey("location")) {
                                            indirizzoErogatore = (String)connettoreErogatore.getProperties().get("location");
                                        }
                                        this.msgDiag.mediumDebug("Indirizzo Risposta del soggetto erogatore [" + String.valueOf(this.idServizio.getSoggettoErogatore()) + "]: " + indirizzoErogatore);
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.addKeywordErroreProcessamento(e, "recupero degli indirizzi di risposta per i soggetti fallita");
                                        this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                                        RicezioneContenutiApplicativi.logError(this.logCore, "Identificazione Indirizzo Risposta fallita", e);
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null));
                                        }
                                        return;
                                    }
                                    this.msgContext.getProtocol().setIndirizzoFruitore(indirizzoFruitore);
                                    this.msgContext.getProtocol().setIndirizzoErogatore(indirizzoErogatore);
                                }
                                this.msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioEffettuata");
                                try {
                                    inRequestProtocolContext = new InRequestProtocolContext(this.inRequestContext);
                                    if (inRequestProtocolContext.getStato() == null) {
                                        inRequestProtocolContext.setStato(this.openspcoopstate.getStatoRichiesta());
                                    }
                                    if (inRequestProtocolContext.getConnettore() != null) {
                                        inRequestProtocolContext.getConnettore().setCredenziali(credenziali);
                                    }
                                    inRequestProtocolContext.setProtocollo(this.msgContext.getProtocol());
                                    inRequestProtocolContext.setIntegrazione(this.msgContext.getIntegrazione());
                                    GestoreHandlers.inRequestProtocol(inRequestProtocolContext, this.msgDiag, this.logCore);
                                }
                                catch (Exception e) {
                                    erroreIntegrazione = null;
                                    integrationFunctionError = null;
                                    if (e instanceof HandlerException) {
                                        he = (HandlerException)e;
                                        if (he.isEmettiDiagnostico()) {
                                            this.msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                                        }
                                        RicezioneContenutiApplicativi.logError(this.logCore, "Gestione InRequestProtocolHandler non riuscita (" + he.getIdentitaHandler() + "): " + String.valueOf(he));
                                        if (this.msgContext.isGestioneRisposta()) {
                                            erroreIntegrazione = he.convertToErroreIntegrazione();
                                            integrationFunctionError = he.getIntegrationFunctionError();
                                        }
                                    } else {
                                        this.msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                                        RicezioneContenutiApplicativi.logError(this.logCore, "Gestione InRequestProtocolHandler non riuscita: " + String.valueOf(e));
                                    }
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        if (erroreIntegrazione == null) {
                                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_558_HANDLER_IN_PROTOCOL_REQUEST);
                                        }
                                        if (integrationFunctionError == null) {
                                            integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                        }
                                        responseMessageError = this.generatoreErrore.build((Context)pddContext, integrationFunctionError, erroreIntegrazione, e, null);
                                        if (e instanceof HandlerException) {
                                            he = (HandlerException)e;
                                            he.customized(responseMessageError);
                                        }
                                        this.msgContext.setMessageResponse(responseMessageError);
                                    }
                                    return;
                                }
                                implementazionePdDMittente = null;
                                implementazionePdDDestinatario = null;
                                idPdDMittente = null;
                                idPdDDestinatario = null;
                                this.msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
                                try {
                                    implementazionePdDMittente = this.registroServiziReader.getImplementazionePdD(this.soggettoFruitore, null, requestInfo);
                                    implementazionePdDDestinatario = this.registroServiziReader.getImplementazionePdD(this.idServizio.getSoggettoErogatore(), null, requestInfo);
                                    idPdDMittente = this.registroServiziReader.getIdPortaDominio(this.soggettoFruitore, null, requestInfo);
                                    idPdDDestinatario = this.registroServiziReader.getIdPortaDominio(this.idServizio.getSoggettoErogatore(), null, requestInfo);
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "ricercaImplementazioniPdD");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), e, null));
                                    }
                                    return;
                                }
                                this.msgDiag.mediumDebug("ImplementazionePdD soggetto (" + this.soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + this.idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
                                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo validazione xsd abilitata/disabilitata...");
                                this.msgDiag.mediumDebug("Controllo validazione xsd abilitata/disabilitata...");
                                validazioneContenutoApplicativoApplicativo = null;
                                proprietaPorta = null;
                                try {
                                    validazioneContenutoApplicativoApplicativo = this.configurazionePdDReader.getTipoValidazioneContenutoApplicativo(this.portaDelegata, implementazionePdDDestinatario, true);
                                    proprietaPorta = this.portaDelegata.getProprietaList();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "getTipoValidazioneContenutoApplicativo(pd," + implementazionePdDDestinatario + ")");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                                    }
                                    return;
                                }
                                if (validazioneContenutoApplicativoApplicativo != null && validazioneContenutoApplicativoApplicativo.getTipo() != null) {
                                    tipo = ValidatoreMessaggiApplicativi.getTipo(validazioneContenutoApplicativoApplicativo);
                                    this.msgContext.getIntegrazione().setTipoValidazioneContenuti(tipo);
                                    this.msgDiag.addKeyword("@TIPO_VALIDAZIONE_CONTENUTI@", tipo);
                                    this.msgDiag.addKeyword("@DETAILS_VALIDAZIONE_CONTENUTI@", "");
                                }
                                if (validazioneContenutoApplicativoApplicativo != null && (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals((Object)validazioneContenutoApplicativoApplicativo.getStato()) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato()))) {
                                    transaction.getTempiElaborazione().startValidazioneRichiesta();
                                    binXSD = null;
                                    try {
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaInCorso");
                                        readInterface = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo());
                                        if (ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                            xomReferences = null;
                                            if (StatoFunzionalita.ABILITATO.equals((Object)validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                                                this.msgDiag.mediumDebug("Validazione xsd della richiesta (mtomFastUnpackagingForXSDConformance)...");
                                                if (!ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                                    throw new Exception("Funzionalita 'AcceptMtomMessage' valida solamente per Service Binding SOAP");
                                                }
                                                xomReferences = this.requestMessage.castAsSoap().mtomFastUnpackagingForXSDConformance();
                                            }
                                            this.msgDiag.mediumDebug("Validazione xsd della richiesta (initValidator)...");
                                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(this.registroServiziReader, richiestaDelegata.getIdServizio(), this.requestMessage, readInterface, propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeGestione(), proprietaPorta, pddContext);
                                            if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo())) {
                                                this.msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                                                validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true);
                                            }
                                            this.msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                                            validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true);
                                            if ((CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo())) && propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeGestione() && propertiesReader.isValidazioneContenutiApplicativiRpcLiteralXsiTypeRipulituraDopoValidazione()) {
                                                this.msgDiag.mediumDebug("Ripristino elementi modificati per supportare validazione wsdl della richiesta ...");
                                                validatoreMessaggiApplicativi.restoreOriginalDocument(true);
                                            }
                                            if (xomReferences != null && !xomReferences.isEmpty()) {
                                                this.msgDiag.mediumDebug("Validazione xsd della richiesta (mtomRestoreAfterXSDConformance)...");
                                                if (!ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                                    throw new CoreException("Funzionalita 'AcceptMtomMessage' valida solamente per Service Binding SOAP");
                                                }
                                                this.requestMessage.castAsSoap().mtomRestoreAfterXSDConformance(xomReferences);
                                            }
                                        } else {
                                            this.msgDiag.mediumDebug("Validazione della richiesta (initValidator)...");
                                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativiRest(this.registroServiziReader, richiestaDelegata.getIdServizio(), this.requestMessage, readInterface, proprietaPorta, this.protocolFactory, pddContext);
                                            if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.equals((Object)validazioneContenutoApplicativoApplicativo.getTipo()) && this.requestMessage.castAsRest().hasContent()) {
                                                this.msgDiag.mediumDebug("Validazione xsd della richiesta ...");
                                                validatoreMessaggiApplicativi.validateWithSchemiXSD(true);
                                            } else {
                                                validatoreMessaggiApplicativi.validateRequestWithInterface(false);
                                            }
                                        }
                                        this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaEffettuata");
                                    }
                                    catch (ValidatoreMessaggiApplicativiException ex) {
                                        this.msgDiag.addKeywordErroreProcessamento(ex);
                                        RicezioneContenutiApplicativi.logError(this.logCore, "[ValidazioneContenutiApplicativi Richiesta] " + ex.getMessage(), ex);
                                        if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) {
                                            this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly");
                                        } else {
                                            this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita");
                                        }
                                        if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) ** GOTO lbl600
                                        pddContext.addObject(Costanti.ERRORE_VALIDAZIONE_RICHIESTA, "true");
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            integrationFunctionError = null;
                                            integrationFunctionError = ex.getErrore() != null && CodiceErroreIntegrazione.CODICE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.equals((Object)ex.getErrore().getCodiceErrore()) != false ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, integrationFunctionError, ex.getErrore(), ex, null));
                                        }
                                        return;
                                    }
                                    catch (Exception ex) {
                                        this.msgDiag.addKeywordErroreProcessamento(ex);
                                        RicezioneContenutiApplicativi.logError(this.logCore, "Riscontrato errore durante la validazione xsd della richiesta applicativa", ex);
                                        if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) {
                                            this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly");
                                        } else {
                                            this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaNonRiuscita");
                                        }
                                        if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) ** GOTO lbl600
                                        pddContext.addObject(Costanti.ERRORE_VALIDAZIONE_RICHIESTA, "true");
                                        this.openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA), ex, null));
                                        }
                                        return;
                                    }
                                    finally {
                                        transaction.getTempiElaborazione().endValidazioneRichiesta();
                                        if (binXSD != null) {
                                            try {
                                                binXSD.close();
                                            }
                                            catch (Exception integrationFunctionError) {}
                                        }
                                    }
                                } else {
                                    this.msgDiag.logPersonalizzato("validazioneContenutiApplicativiRichiestaDisabilitata");
                                }
lbl600:
                                // 4 sources

                                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Autorizzazione del servizio applicativo...");
                                this.msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                                this.msgContext.getIntegrazione().setTipoAutorizzazioneContenuto(tipoAutorizzazioneContenuto);
                                if (tipoAutorizzazioneContenuto != null) {
                                    this.msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_CONTENUTO@", tipoAutorizzazioneContenuto);
                                }
                                if (!"none".equalsIgnoreCase(tipoAutorizzazioneContenuto)) {
                                    transaction.getTempiElaborazione().startAutorizzazioneContenuti();
                                    try {
                                        this.msgDiag.logPersonalizzato("autorizzazioneContenutiApplicativiInCorso");
                                        errore = null;
                                        eAutorizzazione = null;
                                        detailsSet = false;
                                        integrationFunctionError = null;
                                        try {
                                            esito = GestoreAutorizzazione.verificaAutorizzazioneContenutoPortaDelegata(tipoAutorizzazioneContenuto, datiInvocazione, pddContext, this.protocolFactory, this.requestMessage, this.logCore);
                                            CostantiPdD.addKeywordInCache(this.msgDiag, esito.isEsitoPresenteInCache(), pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI);
                                            if (esito.getDetails() == null) {
                                                this.msgDiag.addKeyword("@DETAILS@", "");
                                            } else {
                                                this.msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                                            }
                                            detailsSet = true;
                                            if (!esito.isAutorizzato()) {
                                                errore = esito.getErroreIntegrazione();
                                                eAutorizzazione = esito.getEccezioneProcessamento();
                                                integrationFunctionError = esito.getIntegrationFunctionError();
                                                pddContext.addObject(Costanti.ERRORE_AUTORIZZAZIONE, "true");
                                            } else {
                                                this.msgDiag.logPersonalizzato("autorizzazioneContenutiApplicativiEffettuata");
                                            }
                                        }
                                        catch (Exception e) {
                                            CostantiPdD.addKeywordInCache(this.msgDiag, false, pddContext, CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_AUTORIZZAZIONE_CONTENUTI);
                                            msgErroreAutorizzazione = "processo di autorizzazione [" + tipoAutorizzazioneContenuto + "] fallito, " + e.getMessage();
                                            errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErroreAutorizzazione, CodiceErroreIntegrazione.CODICE_542_AUTORIZZAZIONE_CONTENUTO);
                                            eAutorizzazione = e;
                                            RicezioneContenutiApplicativi.logError(this.logCore, msgErroreAutorizzazione, e);
                                        }
                                        if (errore != null) {
                                            if (!detailsSet) {
                                                this.msgDiag.addKeyword("@DETAILS@", "");
                                            }
                                            this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore.getDescrizione(this.protocolFactory));
                                            this.msgDiag.logPersonalizzato("servizioApplicativoFruitore.contenuto.nonAutorizzato");
                                            this.openspcoopstate.releaseResource();
                                            if (this.msgContext.isGestioneRisposta()) {
                                                if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals((Object)errore.getCodiceErrore()) || CodiceErroreIntegrazione.CODICE_428_AUTORIZZAZIONE_CONTENUTO_FALLITA.equals((Object)errore.getCodiceErrore())) {
                                                    if (integrationFunctionError == null) {
                                                        integrationFunctionError = IntegrationFunctionError.CONTENT_AUTHORIZATION_DENY;
                                                    }
                                                } else if (integrationFunctionError == null) {
                                                    integrationFunctionError = IntegrationFunctionError.INTERNAL_REQUEST_ERROR;
                                                }
                                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, integrationFunctionError, errore, eAutorizzazione, null));
                                            }
                                            return;
                                        }
                                        break block363;
                                    }
                                    finally {
                                        transaction.getTempiElaborazione().endAutorizzazioneContenuti();
                                    }
                                }
                                this.msgDiag.logPersonalizzato("autorizzazioneContenutiApplicativiDisabilitata");
                            }
                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo tipo di invocazione (riferimento/normale)...");
                            this.msgDiag.mediumDebug("Controllo tipo di invocazione (riferimento/normale)...");
                            invocazionePDPerRiferimento = false;
                            try {
                                invocazionePDPerRiferimento = this.configurazionePdDReader.invocazionePortaDelegataPerRiferimento(sa);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento(sa)");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                                }
                                return;
                            }
                            if (invocazionePDPerRiferimento) {
                                if (!this.msgContext.isInvocazionePDPerRiferimento()) {
                                    this.msgDiag.logPersonalizzato("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.BAD_REQUEST, ErroriIntegrazione.ERRORE_412_PD_INVOCABILE_SOLO_PER_RIFERIMENTO.getErroreIntegrazione(), null, null));
                                    }
                                    return;
                                }
                                try {
                                    if (this.openspcoopstate.resourceReleased()) {
                                        this.openspcoopstate.setUseConnection(true);
                                        this.openspcoopstate.initResource(this.identitaPdD, this.msgContext.getIdModulo(), idTransazione);
                                    }
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "openspcoopstate.initResource() 'invocazionePerRiferimento'");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.GOVWAY_RESOURCES_NOT_AVAILABLE, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e, null));
                                    }
                                    return;
                                }
                                gestoreMessaggio = new GestoreMessaggi(this.openspcoopstate, true, this.msgContext.getIdInvocazionePDPerRiferimento(), "INBOX", this.msgDiag, this.msgContext.getPddContext());
                                try {
                                    sbustamentoInformazioniProtocollo = gestoreMessaggio.sbustamentoInformazioniProtocollo(this.servizioApplicativo, false);
                                    if (!sbustamentoInformazioniProtocollo) ** GOTO lbl709
                                    proprietaManifest = propertiesReader.getProprietaManifestAttachments("standard");
                                    proprietaManifest.setGestioneManifest(false);
                                    protocolMessage = bustaBuilder.sbustamento(this.requestMessage, (Context)pddContext, this.bustaRichiesta, RuoloMessaggio.RICHIESTA, proprietaManifest, FaseSbustamento.PRE_INVIO_RICHIESTA_PER_RIFERIMENTO, requestInfo.getIntegrationServiceBinding(), requestInfo.getBindingConfig());
                                    if (protocolMessage == null) ** GOTO lbl709
                                    this.requestMessage = protocolMessage.getMessage();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento.sbustamentoProtocolHeader()");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                                    }
                                    return;
                                }
                            } else if (this.msgContext.isInvocazionePDPerRiferimento()) {
                                this.msgDiag.logPersonalizzato("portaDelegataInvocabileNormalmente.riferimentoPresente");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.BAD_REQUEST, ErroriIntegrazione.ERRORE_413_PD_INVOCABILE_SOLO_SENZA_RIFERIMENTO.getErroreIntegrazione(), null, null));
                                }
                                return;
                            }
lbl709:
                            // 5 sources

                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo non esistenza di una busta ...");
                            this.msgDiag.mediumDebug("Controllo non esistenza di una busta ...");
                            validatoreSintattico = new ValidazioneSintattica((Context)pddContext, this.openspcoopstate.getStatoRichiesta(), this.requestMessage, this.protocolFactory);
                            esisteProtocolloMsgRichiesta = false;
                            esisteProtocolloMsgRichiestaExit = false;
                            try {
                                esisteProtocolloMsgRichiesta = validatoreSintattico.verifyProtocolPresence(this.msgContext.getTipoPorta(), infoServizio.getProfiloDiCollaborazione(), RuoloMessaggio.RICHIESTA);
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "controlloEsistenzaBusta");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null));
                                }
                                esisteProtocolloMsgRichiestaExit = true;
                            }
                            finally {
                                if (esisteProtocolloMsgRichiesta) {
                                    this.msgDiag.logPersonalizzato("richiestaContenenteBusta");
                                    this.openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTEROPERABILITY_PROFILE_REQUEST_ALREADY_EXISTS, ErroriIntegrazione.ERRORE_420_BUSTA_PRESENTE_RICHIESTA_APPLICATIVA.getErroreIntegrazione(), null, null));
                                    }
                                    esisteProtocolloMsgRichiestaExit = true;
                                }
                                if (validatoreSintattico != null) {
                                    validatoreSintattico.setHeaderSOAP(null);
                                }
                                validatoreSintattico = null;
                            }
                            if (esisteProtocolloMsgRichiestaExit) {
                                return;
                            }
                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Recupero configurazione per salvataggio risposta in cache ...");
                            this.msgDiag.mediumDebug("Recupero configurazione per salvataggio risposta in cache ...");
                            try {
                                responseCachingConfig = this.configurazionePdDReader.getConfigurazioneResponseCaching(this.portaDelegata);
                                if (responseCachingConfig == null || !StatoFunzionalita.ABILITATO.equals((Object)responseCachingConfig.getStato())) break block365;
                                transaction.getTempiElaborazione().startResponseCachingCalcoloDigest();
                                try {
                                    this.msgDiag.mediumDebug("Calcolo digest per salvataggio risposta ...");
                                    hashGenerator = new HashGenerator(propertiesReader.getCachingResponseDigestAlgorithm());
                                    digest = hashGenerator.buildKeyCache(this.requestMessage, requestInfo, responseCachingConfig);
                                    this.requestMessage.addContextProperty(CostantiPdD.RESPONSE_CACHE_REQUEST_DIGEST, (Object)digest);
                                }
                                finally {
                                    transaction.getTempiElaborazione().endResponseCachingCalcoloDigest();
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "calcoloDigestSalvataggioRisposta");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_561_DIGEST_REQUEST), e, null));
                                }
                                return;
                            }
                        }
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Update/Delete Header di integrazione se necessario");
                        for (i = 0; i < this.tipiIntegrazionePD.length; ++i) {
                            try {
                                gestore = pluginLoader.newIntegrazionePortaDelegata(this.tipiIntegrazionePD[i]);
                                if (gestore == null) continue;
                                classType = null;
                                try {
                                    classType = gestore.getClass().getName();
                                    AbstractCore.init(gestore, pddContext, this.protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new CoreException("Riscontrato errore durante l'inizializzazione della classe (IGestoreIntegrazionePD) [" + classType + "] da utilizzare per la gestione dell'integrazione delle fruizioni (Update/Delete) di tipo [" + this.tipiIntegrazionePD[i] + "]: " + e.getMessage());
                                }
                                if (!(gestore instanceof IGestoreIntegrazionePDSoap)) continue;
                                gestoreIntegrazionePDSoap = (IGestoreIntegrazionePDSoap)gestore;
                                if (propertiesReader.deleteHeaderIntegrazioneRequestPD()) {
                                    gestoreIntegrazionePDSoap.deleteInRequestHeader(inRequestPDMessage);
                                    continue;
                                }
                                servizioApplicativoDaInserireHeader = null;
                                if (!"Anonimo".equals(this.servizioApplicativo)) {
                                    servizioApplicativoDaInserireHeader = this.servizioApplicativo;
                                }
                                gestoreIntegrazionePDSoap.updateInRequestHeader(inRequestPDMessage, this.idServizio, this.idMessageRequest, servizioApplicativoDaInserireHeader, idCorrelazioneApplicativa);
                                continue;
                            }
                            catch (Exception e) {
                                if (propertiesReader.deleteHeaderIntegrazioneRequestPD()) {
                                    this.msgDiag.logErroreGenerico(e, "deleteHeaderIntegrazione(" + this.tipiIntegrazionePD[i] + ")");
                                } else {
                                    this.msgDiag.logErroreGenerico(e, "updateHeaderIntegrazione(" + this.tipiIntegrazionePD[i] + ")");
                                }
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_541_GESTIONE_HEADER_INTEGRAZIONE), e, null));
                                }
                                return;
                            }
                        }
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Gestione Funzionalita' speciali per Attachments (Manifest)");
                        allegaBody = false;
                        scartaBody = false;
                        try {
                            allegaBody = this.configurazionePdDReader.isAllegaBody(this.portaDelegata);
                            scartaBody = this.configurazionePdDReader.isScartaBody(this.portaDelegata);
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "configurazionePdDReader.isAllega/ScartaBody(pd)");
                            this.openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                            }
                            return;
                        }
                        if (scartaBody) {
                            integrationFunctionError = null;
                            try {
                                if (!ServiceBinding.SOAP.equals((Object)this.requestMessage.getServiceBinding())) {
                                    integrationFunctionError = IntegrationFunctionError.NOT_SUPPORTED_BY_PROTOCOL;
                                    throw new CoreException("Funzionalita 'ScartaBody' valida solamente per Service Binding SOAP");
                                }
                                if (this.requestMessage.castAsSoap().countAttachments() <= 0) {
                                    throw new CoreException("La funzionalita' e' permessa solo per messaggi SOAP With Attachments");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.addKeywordErroreProcessamento(e);
                                this.msgDiag.logPersonalizzato("funzionalitaScartaBodyNonEffettuabile");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    if (integrationFunctionError == null) {
                                        integrationFunctionError = IntegrationFunctionError.BAD_REQUEST;
                                    }
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, integrationFunctionError, ErroriIntegrazione.ERRORE_425_SCARTA_BODY.getErrore425_ScartaBody(e.getMessage()), e, null));
                                }
                                return;
                            }
                        }
                        if (allegaBody) {
                            try {
                                TunnelSoapUtils.allegaBody((OpenSPCoop2Message)this.requestMessage, (String)propertiesReader.getHeaderSoapActorIntegrazione());
                            }
                            catch (Exception e) {
                                this.msgDiag.addKeywordErroreProcessamento(e);
                                this.msgDiag.logPersonalizzato("funzionalitaAllegaBodyNonEffettuabile");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.BAD_REQUEST, ErroriIntegrazione.ERRORE_424_ALLEGA_BODY.getErrore424_AllegaBody(e.getMessage()), e, null));
                                }
                                return;
                            }
                        }
                        oneWayStateless = false;
                        oneWayVersione11 = false;
                        sincronoStateless = false;
                        asincronoStateless = false;
                        this.portaStateless = false;
                        try {
                            if (propertiesReader.isServerJ2EE() == null || !propertiesReader.isServerJ2EE().booleanValue()) {
                                oneWayStateless = true;
                                sincronoStateless = true;
                                asincronoStateless = true;
                            } else if (ProfiloDiCollaborazione.ONEWAY.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                                oneWayStateless = this.configurazionePdDReader.isModalitaStateless(this.portaDelegata, infoServizio.getProfiloDiCollaborazione());
                            } else if (ProfiloDiCollaborazione.SINCRONO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                                sincronoStateless = this.configurazionePdDReader.isModalitaStateless(this.portaDelegata, infoServizio.getProfiloDiCollaborazione());
                            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                                asincronoStateless = this.configurazionePdDReader.isModalitaStateless(this.portaDelegata, infoServizio.getProfiloDiCollaborazione());
                            }
                            v1 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && ProfiloDiCollaborazione.ONEWAY.equals((Object)infoServizio.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                            if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                                this.openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)this.openspcoopstate, this.openspcoopstate.isUseConnection());
                                this.portaStateless = true;
                                this.msgContext.getIntegrazione().setGestioneStateless(oneWayVersione11 == false);
                            } else {
                                this.msgContext.getIntegrazione().setGestioneStateless(false);
                            }
                            if ((!this.portaStateless || oneWayVersione11) && !this.openspcoopstate.isUseConnection() && (this.openspcoopstate instanceof OpenSPCoopStateful || oneWayVersione11) && this.openspcoopstate.resourceReleased()) {
                                this.openspcoopstate.setUseConnection(true);
                                this.openspcoopstate.initResource(this.identitaPdD, this.msgContext.getIdModulo(), idTransazione);
                            }
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "GestioneStatelessStateful");
                            RicezioneContenutiApplicativi.logError(this.logCore, "Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + String.valueOf(e));
                            this.openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e, null));
                            }
                            return;
                        }
                        this.localForward = false;
                        localForwardEngine = null;
                        localForwardParameter = null;
                        pa = null;
                        try {
                            this.localForward = this.configurazionePdDReader.isLocalForwardMode(this.portaDelegata);
                            if (!this.localForward) break block366;
                            erroreConfigurazione = null;
                            prefix = "( Servizio " + IDServizioFactory.getInstance().getUriFromIDServizio(this.idServizio) + " ) ";
                            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione())) {
                                erroreConfigurazione = "profilo di collaborazione " + infoServizio.getProfiloDiCollaborazione().getEngineValue() + " non supportato";
                            }
                            if (erroreConfigurazione == null && ProfiloDiCollaborazione.SINCRONO.equals((Object)infoServizio.getProfiloDiCollaborazione()) && !sincronoStateless) {
                                erroreConfigurazione = "profilo di collaborazione " + infoServizio.getProfiloDiCollaborazione().getEngineValue() + " non supportato nella modalit\u00e0 stateful";
                            }
                            if (erroreConfigurazione == null && !this.configurazionePdDReader.existsSoggetto(this.idServizio.getSoggettoErogatore(), requestInfo)) {
                                erroreConfigurazione = "il soggetto erogatore non risulta essere gestito localmente dalla Porta";
                            }
                            ra = null;
                            idPA = null;
                            if (erroreConfigurazione == null) {
                                nomePA = this.configurazionePdDReader.getLocalForwardNomePortaApplicativa(this.portaDelegata);
                                if (nomePA == null) {
                                    try {
                                        list = this.configurazionePdDReader.getPorteApplicative(this.idServizio, false);
                                        if (list.isEmpty()) {
                                            throw new DriverConfigurazioneNotFound("NotFound");
                                        }
                                        if (list.size() > 1) {
                                            bf = new StringBuilder();
                                            for (PortaApplicativa portaApplicativa : list) {
                                                if (bf.length() > 0) {
                                                    bf.append(",");
                                                }
                                                bf.append(portaApplicativa.getNome());
                                            }
                                            throw new CoreException("Esiste pi\u00f9 di una porta applicativa indirizzabile tramite il servizio [" + String.valueOf(this.idServizio) + "] indicato nella porta delegata [" + nomeUtilizzatoPerErrore + "]: " + bf.toString());
                                        }
                                        idPA = this.configurazionePdDReader.convertToIDPortaApplicativa(list.get(0));
                                    }
                                    catch (DriverConfigurazioneNotFound n) {
                                        erroreConfigurazione = "Non esiste alcuna porta applicativa indirizzabile tramite il servizio [" + String.valueOf(this.idServizio) + "] indicato nella porta delegata [" + nomeUtilizzatoPerErrore + "]";
                                    }
                                    catch (Exception e) {
                                        erroreConfigurazione = e.getMessage();
                                    }
                                } else {
                                    try {
                                        idPA = this.configurazionePdDReader.getIDPortaApplicativa(nomePA, requestInfo, this.protocolFactory);
                                    }
                                    catch (Exception e) {
                                        erroreConfigurazione = e.getMessage();
                                    }
                                }
                            }
                            if (erroreConfigurazione == null) {
                                ra = new RichiestaApplicativa(this.soggettoFruitore, this.idServizio.getSoggettoErogatore(), idPA);
                                ra.setIntegrazione(this.msgContext.getIntegrazione());
                                ra.setProtocol(this.msgContext.getProtocol());
                                pa = this.configurazionePdDReader.getPortaApplicativaSafeMethod(ra.getIdPortaApplicativa(), requestInfo);
                                if (pa.sizeServizioApplicativoList() <= 0) {
                                    erroreConfigurazione = "non risultano registrati servizi applicativi erogatori associati alla porta applicativa (" + pa.getNome() + ") relativa al servizio richiesto";
                                }
                            }
                            if (erroreConfigurazione != null) {
                                erroreConfigurazione = prefix + (String)erroreConfigurazione;
                                this.msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", (String)erroreConfigurazione);
                                this.msgDiag.logPersonalizzato("localForward.configError");
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_435_LOCAL_FORWARD_CONFIG_NON_VALIDA.getErrore435_LocalForwardConfigNonValida((String)erroreConfigurazione), null, null));
                                }
                                return;
                            }
                            localForwardParameter = new LocalForwardParameter();
                            localForwardParameter.setLog(this.logCore);
                            localForwardParameter.setConfigurazionePdDReader(this.configurazionePdDReader);
                            localForwardParameter.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                            localForwardParameter.setIdentitaPdD(this.identitaPdD);
                            localForwardParameter.setIdModulo(this.msgContext.getIdModulo());
                            localForwardParameter.setIdRequest(this.idMessageRequest);
                            localForwardParameter.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                            localForwardParameter.setImplementazionePdDMittente(implementazionePdDMittente);
                            localForwardParameter.setIdPdDMittente(idPdDMittente);
                            localForwardParameter.setIdPdDDestinatario(idPdDDestinatario);
                            localForwardParameter.setInfoServizio(infoServizio);
                            localForwardParameter.setMsgDiag(this.msgDiag);
                            localForwardParameter.setOpenspcoopstate(this.openspcoopstate);
                            localForwardParameter.setPddContext(this.inRequestContext.getPddContext());
                            localForwardParameter.setProtocolFactory(this.protocolFactory);
                            localForwardParameter.setRichiestaDelegata(richiestaDelegata);
                            localForwardParameter.setStateless(this.portaStateless);
                            localForwardParameter.setOneWayVersione11(oneWayVersione11);
                            localForwardParameter.setIdPortaApplicativaIndirizzata(idPA);
                            localForwardEngine = new LocalForwardEngine(localForwardParameter);
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "GestioneLocalForward");
                            this.openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_554_LOCAL_FORWARD_ERROR), e, null));
                            }
                            return;
                        }
                    }
                    if (this.localForward) {
                        try {
                            if (!localForwardEngine.processRequest(this.requestMessage)) {
                                this.openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(localForwardEngine.getResponseMessageError());
                                }
                                return;
                            }
                            if (localForwardEngine.getRequestMessageAfterProcess() != null) {
                                this.requestMessage = localForwardEngine.getRequestMessageAfterProcess();
                            }
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "GestioneLocalForward.processRequest");
                            this.openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_555_LOCAL_FORWARD_PROCESS_REQUEST_ERROR), e, null));
                            }
                            return;
                        }
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo presenza del messaggio gia' in gestione...");
                    this.msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
                    this.msgRequest = null;
                    tipoMessaggio = "OUTBOX";
                    if (this.localForward) {
                        tipoMessaggio = "INBOX";
                    }
                    this.msgRequest = new GestoreMessaggi(this.openspcoopstate, true, this.idMessageRequest, tipoMessaggio, this.msgDiag, this.inRequestContext.getPddContext());
                    this.msgRequest.setOneWayVersione11(oneWayVersione11);
                    repositoryBuste = new RepositoryBuste(this.openspcoopstate.getStatoRichiesta(), true, this.protocolFactory);
                    try {
                        if (!this.msgRequest.existsMessage_noCache()) break block367;
                        proprietarioMessaggio = this.msgRequest.getProprietario(this.msgContext.getIdModulo());
                        if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                            this.msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                            msg = this.msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.marcatoDaEliminare");
                            if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                this.msgRequest._deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamentoAttesaAttiva(), propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                            } else {
                                this.msgRequest.deleteMessageByNow();
                            }
                            break block367;
                        }
                        this.msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                        this.msgDiag.logPersonalizzato("messaggioInGestione");
                        pddContext.addObject(Costanti.RICHIESTA_DUPLICATA, "true");
                        this.openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.CONFLICT_IN_QUEUE, ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(this.idMessageRequest), null, null));
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                        RicezioneContenutiApplicativi.logError(this.logCore, "Controllo/gestione presenza messaggio gia in gestione non riuscito", e);
                        this.openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_537_BUSTA_GIA_RICEVUTA), e, null));
                        }
                        return;
                    }
                }
                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                this.msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                moduleManager = this.protocolFactory.createProtocolVersionManager(richiestaDelegata.getProfiloGestione());
                this.richiestaAsincronaSimmetricaStateless = false;
                try {
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)infoServizio.getProfiloDiCollaborazione()) && this.portaStateless) {
                        this.richiestaAsincronaSimmetricaStateless = StatoFunzionalitaProtocollo.ABILITATA.equals((Object)moduleManager.getCollaborazione(infoServizio)) ? (this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null ? false : this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() == null) : this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() == null;
                    }
                    this.msgRequest.registraMessaggio(this.requestMessage, dataIngressoRichiesta, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false, idCorrelazioneApplicativa);
                    if (this.localForward) {
                        this.msgRequest.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                    } else {
                        this.msgRequest.aggiornaProprietarioMessaggio("Imbustamento");
                    }
                    if (this.richiestaAsincronaSimmetricaStateless) {
                        if (this.openspcoopstate.resourceReleased()) {
                            this.openspcoopstate.setUseConnection(true);
                            this.openspcoopstate.initResource(this.identitaPdD, this.msgContext.getIdModulo(), idTransazione);
                        }
                        this.msgRequest.registraInformazioniMessaggio_statelessEngine(dataIngressoRichiesta, "Imbustamento", idCorrelazioneApplicativa);
                    }
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "msgRequest.aggiornaProprietarioMessaggio");
                    this.msgRequest.deleteMessageFromFileSystem();
                    this.openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_508_SAVE_REQUEST_MSG), e, null));
                    }
                    return;
                }
                this.msgDiag.mediumDebug("Registrazione busta di richiesta nel RepositoryBuste...");
                try {
                    if (this.portaStateless && !oneWayVersione11) break block368;
                    if (repositoryBuste.isRegistrata(this.idMessageRequest, tipoMessaggio)) {
                        try {
                            if (this.localForward) {
                                repositoryBuste.aggiornaBustaIntoInBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                            } else {
                                repositoryBuste.aggiornaBustaIntoOutBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                            }
                            repositoryBuste.impostaUtilizzoPdD(this.idMessageRequest, tipoMessaggio);
                        }
                        catch (Exception e) {
                            if (propertiesReader.isMsgGiaInProcessamentoUseLock()) {
                                tipo = "OUTBOX";
                                if (this.localForward) {
                                    tipo = "INBOX";
                                }
                                causa = "Aggiornamento dati busta con id [" + this.idMessageRequest + "] tipo[" + tipo + "] non riuscito: " + e.getMessage();
                                try {
                                    GestoreMessaggi.acquireLock(this.msgRequest, TimerLock.newInstance(TipoLock._getLockGestioneRepositoryMessaggi()), this.msgDiag, causa, propertiesReader.getMsgGiaInProcessamentoAttesaAttiva(), propertiesReader.getMsgGiaInProcessamentoCheckInterval());
                                    if (repositoryBuste.isRegistrata(this.idMessageRequest, tipoMessaggio)) {
                                        if (this.localForward) {
                                            repositoryBuste.aggiornaBustaIntoInBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                        } else {
                                            repositoryBuste.aggiornaBustaIntoOutBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                        }
                                        repositoryBuste.impostaUtilizzoPdD(this.idMessageRequest, tipoMessaggio);
                                    }
                                    if (this.localForward) {
                                        repositoryBuste.registraBustaIntoInBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                    }
                                    repositoryBuste.registraBustaIntoOutBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                }
                                finally {
                                    try {
                                        GestoreMessaggi.releaseLock(this.msgRequest, TimerLock.newInstance(TipoLock._getLockGestioneRepositoryMessaggi()), this.msgDiag, causa);
                                    }
                                    catch (Exception bf) {}
                                }
                            }
                            throw e;
                        }
                    } else if (this.localForward) {
                        repositoryBuste.registraBustaIntoInBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    } else {
                        repositoryBuste.registraBustaIntoOutBox(this.idMessageRequest, this.soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    }
                    infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                    infoIntegrazione.setNomePorta(richiestaDelegata.getIdPortaDelegata().getNome());
                    infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                    repositoryBuste.aggiornaInfoIntegrazione(this.idMessageRequest, tipoMessaggio, infoIntegrazione);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "registrazioneAggiornamentoBusta");
                    this.msgRequest.deleteMessageFromFileSystem();
                    this.openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e, null));
                    }
                    return;
                }
            }
            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Invio messaggio al modulo di Imbustamento...");
            nextModulo = "Imbustamento";
            if (this.localForward) {
                this.msgDiag.addKeyword("@PORTA_APPLICATIVA@", pa.getNome());
                if (this.idServizio.getAzione() == null) {
                    this.msgDiag.addKeyword("@AZIONE_BUSTA_RICHIESTA@", "non presente");
                }
                this.msgDiag.logPersonalizzato("localForward.logInfo");
                nextModulo = "ConsegnaContenutiApplicativi";
            } else {
                this.msgDiag.mediumDebug("Invio messaggio al modulo di Imbustamento...");
            }
            try {
                if (proprietaPorta != null && !proprietaPorta.isEmpty() && (filtroDuplicatiTestEnabled = CostantiProprieta.isFiltroDuplicatiTestEnabled(proprietaPorta, false))) {
                    pddContext.addObject(CostantiPdD.FILTRO_DUPLICATI_TEST, filtroDuplicatiTestEnabled);
                }
                this.msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                msgJMS = null;
                if (this.localForward) {
                    localForwardParameter.setRepositoryBuste(repositoryBuste);
                    portaDelegataAttuale = localForwardParameter.getMsgDiag().getPorta();
                    localForwardParameter.getMsgDiag().updatePorta(TipoPdD.APPLICATIVA, localForwardParameter.getIdPortaApplicativaIndirizzata().getNome(), requestInfo);
                    localForwardEngine.updateLocalForwardParameter(localForwardParameter);
                    localForwardEngine.sendRequest(this.msgRequest);
                    localForwardParameter.getMsgDiag().updatePorta(TipoPdD.DELEGATA, portaDelegataAttuale, requestInfo);
                } else {
                    this.imbustamentoMSG.setRichiestaDelegata(richiestaDelegata);
                    this.imbustamentoMSG.setInfoServizio(infoServizio);
                    this.imbustamentoMSG.setOneWayVersione11(oneWayVersione11);
                    if (this.headerIntegrazioneRichiesta.getBusta() != null) {
                        riferimentoServizioCorrelato = moduleManager.getIdCorrelazioneAsincrona(this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio(), this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione());
                        if (riferimentoServizioCorrelato != null) {
                            this.imbustamentoMSG.setRiferimentoServizioCorrelato(riferimentoServizioCorrelato);
                        }
                        if (this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() != null) {
                            this.imbustamentoMSG.setIdCollaborazione(this.headerIntegrazioneRichiesta.getBusta().getIdCollaborazione());
                        }
                        if (this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                            this.imbustamentoMSG.setIdRiferimentoMessaggio(this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio());
                        }
                    }
                    this.imbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                    this.imbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                    this.imbustamentoMSG.setIndirizzoSoggettoMittente(indirizzoFruitore);
                    this.imbustamentoMSG.setIndirizzoSoggettoDestinatario(indirizzoErogatore);
                    this.imbustamentoMSG.setPddContext(this.inRequestContext.getPddContext());
                    msgJMS = this.imbustamentoMSG;
                }
                if (this.portaStateless) break block369;
                RicezioneContenutiApplicativi.logDebug(this.logCore, "RicezioneContenutiApplicativi :eseguo send verso " + nextModulo + "...");
                classTypeNodeSender = null;
                nodeSender = null;
                try {
                    classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                    nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                }
                catch (Exception e) {
                    throw new CoreException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
                }
                nodeSender.send(msgJMS, nextModulo, this.msgDiag, this.identitaPdD, this.msgContext.getIdModulo(), this.idMessageRequest, this.msgRequest);
                RicezioneContenutiApplicativi.logDebug(this.logCore, "RicezioneContenutiApplicativi :send verso " + nextModulo + " effettuata");
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(this.logCore, "Spedizione->" + nextModulo + " non riuscita", e);
                this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(" + nextModulo + ")");
                this.msgRequest.deleteMessageFromFileSystem();
                this.openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), e, null));
                }
                return;
            }
        }
        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Commit delle operazioni per la gestione della richiesta...");
        this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            this.openspcoopstate.commit();
            RicezioneContenutiApplicativi.logDebug(this.logCore, "RicezioneContenutiApplicativi :RicezioneContenutiApplicativi commit eseguito");
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit");
            this.msgRequest.deleteMessageFromFileSystem();
            this.openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_506_COMMIT_JDBC), e, null));
            }
            return;
        }
        if (!this.portaStateless) {
            if (this.msgRequest != null) {
                this.msgRequest.addMessaggiIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta");
            }
            if (this.msgRequest != null) {
                this.msgRequest.addProprietariIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta", null, false);
            }
            this.msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            this.openspcoopstate.releaseResource();
        }
        this.parametriGestioneRisposta = new RicezioneContenutiApplicativiGestioneRisposta();
        this.parametriGestioneRisposta.setPropertiesReader(propertiesReader);
        this.parametriGestioneRisposta.setPddContext(this.inRequestContext.getPddContext());
        if (this.portaStateless) {
            this.openspcoopstate.setUseConnection(false);
            resultRequest = this.comportamentoStatelessRichiesta(this.imbustamentoMSG);
            if (!resultRequest) {
                this.openspcoopstate.releaseResource();
                return;
            }
        }
        if (this.asyncResponseCallback == null) {
            this.statelessComplete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statelessComplete(boolean invokedFromAsyncConnector) {
        try {
            if (this.portaStateless) {
                boolean resultResponse = this.comportamentoStatelessRisposta(this.imbustamentoMSG);
                if (!resultResponse) {
                    this.openspcoopstate.releaseResource();
                    return;
                }
                this.openspcoopstate.setUseConnection(true);
            }
            this.registroServiziReader = this.registroServiziReader.refreshState(this.openspcoopstate.getStatoRichiesta(), this.openspcoopstate.getStatoRisposta());
            this.configurazionePdDReader = this.configurazionePdDReader.refreshState(this.registroServiziReader);
            this.msgDiag.updateState(this.configurazionePdDReader);
            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Gestione risposta...");
            this.msgDiag.mediumDebug("Gestione risposta...");
            if (!this.msgContext.isGestioneRisposta()) {
                if (this.portaStateless) {
                    this.openspcoopstate.releaseResource();
                }
                return;
            }
            this.gestioneRisposta();
            this.msgDiag.mediumDebug("Lavoro Terminato.");
        }
        finally {
            try {
                if (this.openspcoopstate != null) {
                    this.openspcoopstate.forceFinallyReleaseResource();
                }
            }
            catch (Throwable e) {
                if (this.msgDiag != null) {
                    try {
                        this.msgDiag.logErroreGenerico(e, "Rilascio risorsa");
                    }
                    catch (Throwable eLog) {
                        RicezioneContenutiApplicativi.logError(this.logCore, "Diagnostico errore per Rilascio risorsa: " + eLog.getMessage(), eLog);
                    }
                }
                RicezioneContenutiApplicativi.logError(this.logCore, "Rilascio risorsa: " + e.getMessage(), e);
            }
            this._processComplete(invokedFromAsyncConnector);
        }
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        if (credenziali != null) {
            if (credenziali.getUsername() != null) {
                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
            } else if (credenziali.getSubject() != null) {
                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
            } else if (credenziali.getPrincipal() != null) {
                msgDiag.setServizioApplicativo("principal(" + credenziali.getPrincipal() + ")");
            } else {
                msgDiag.setServizioApplicativo(null);
            }
        }
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
    }

    private boolean comportamentoStatelessRichiesta(ImbustamentoMessage imbustamentoMSG) {
        OpenSPCoopStateless openspcoopstateless = (OpenSPCoopStateless)this.openspcoopstate;
        OpenSPCoop2Properties propertiesReader = this.parametriGestioneRisposta.getPropertiesReader();
        this.portaStateless = true;
        boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getProtocol().getProfiloCollaborazione()) && !this.oneWayVers11;
        String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, imbustamentoMSG.getPddContext());
        PdDContext pddContext = this.parametriGestioneRisposta.getPddContext();
        if (this.localForward) {
            if ("ConsegnaContenutiApplicativi".equals(openspcoopstateless.getDestinatarioRequestMsgLib()) && openspcoopstateless.getDestinatarioResponseMsgLib() == null) {
                EsitoLib esito;
                if (rinegoziamentoConnessione) {
                    this.msgDiag.highDebug("ConsegnaContenutiApplicativi stateless (commit) ...");
                    openspcoopstateless.setUseConnection(true);
                    try {
                        openspcoopstateless.commit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    openspcoopstateless.releaseResource();
                    openspcoopstateless.setUseConnection(false);
                }
                ConsegnaContenutiApplicativi consegnaContenutiLib = null;
                try {
                    consegnaContenutiLib = new ConsegnaContenutiApplicativi(this.logCore);
                    esito = consegnaContenutiLib.onMessage(openspcoopstateless, this.registroServiziReader, this.configurazionePdDReader);
                    if (esito.getStatoInvocazione() == 3) {
                        if (esito.getErroreNonGestito() != null) {
                            throw esito.getErroreNonGestito();
                        }
                        throw new CoreException(ERRORE_NON_GESTITO);
                    }
                }
                catch (Throwable e) {
                    this.msgDiag.logErroreGenerico(e, "Stateless.ConsegnaContenutiApplicativi");
                    RicezioneContenutiApplicativi.logError(this.logCore, "Errore Generale durante la gestione stateless (ConsegnaContenutiApplicativi): " + e.getMessage(), e);
                    this.msgRequest.deleteMessageFromFileSystem();
                    openspcoopstateless.setUseConnection(true);
                    openspcoopstateless.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                    }
                    return false;
                }
                if (esito.getStatoInvocazione() != 1) {
                    openspcoopstateless.setUseConnection(true);
                    this.gestioneRisposta();
                    return false;
                }
            }
        } else {
            EsitoLib esito;
            this.msgDiag.highDebug("Imbustamento stateless ...");
            Imbustamento imbustamentoLib = null;
            openspcoopstateless.setMessageLib(imbustamentoMSG);
            openspcoopstateless.setIDMessaggioSessione(this.idMessageRequest);
            try {
                imbustamentoLib = new Imbustamento(this.logCore);
                this.msgDiag.highDebug("Imbustamento stateless (invoco) ...");
                esito = imbustamentoLib.onMessage(openspcoopstateless, this.registroServiziReader, this.configurazionePdDReader);
                this.msgDiag.highDebug("Imbustamento stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new CoreException(ERRORE_NON_GESTITO);
                }
            }
            catch (Throwable e) {
                this.msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                RicezioneContenutiApplicativi.logError(this.logCore, "Errore Generale durante la gestione stateless (Imbustamento): " + e.getMessage(), e);
                this.msgRequest.deleteMessageFromFileSystem();
                openspcoopstateless.setUseConnection(true);
                openspcoopstateless.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstateless.setUseConnection(true);
                this.gestioneRisposta();
                this.msgDiag.highDebug("Imbustamento stateless (terminato:false)");
                return false;
            }
            if (openspcoopstateless.getDestinatarioResponseMsgLib() != null && openspcoopstateless.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                this.msgDiag.highDebug("Imbustamento stateless (terminato:true)");
                return true;
            }
            if (rinegoziamentoConnessione) {
                this.msgDiag.highDebug("Imbustamento stateless (commit) ...");
                openspcoopstateless.setUseConnection(true);
                try {
                    openspcoopstateless.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstateless.releaseResource();
                openspcoopstateless.setUseConnection(false);
            }
            this.msgDiag.highDebug("Imbustamento stateless terminato");
            this.msgDiag.highDebug("InoltroBuste stateless ...");
            InoltroBuste inoltroBusteLib = null;
            try {
                inoltroBusteLib = new InoltroBuste(this.logCore);
                this.msgDiag.highDebug("InoltroBuste stateless (invoco) ...");
                this.esitoStatelessAfterSendRequest = inoltroBusteLib.onMessage(openspcoopstateless, this.registroServiziReader, this.configurazionePdDReader, this.asyncResponseCallback != null ? this : null);
                if (this.asyncResponseCallback != null) {
                    this.asyncWait = true;
                }
            }
            catch (Throwable e) {
                this.msgDiag.logErroreGenerico(e, "Stateless.InoltroBuste");
                this.logCore.error("Errore Generale durante la gestione stateless (InoltroBuste): " + e.getMessage(), e);
                this.msgRequest.deleteMessageFromFileSystem();
                openspcoopstateless.setUseConnection(true);
                openspcoopstateless.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean comportamentoStatelessRisposta(ImbustamentoMessage imbustamentoMSG) {
        if (!this.localForward) {
            EsitoLib esito;
            OpenSPCoopStateless openspcoopstateless = (OpenSPCoopStateless)this.openspcoopstate;
            if (openspcoopstateless.getDestinatarioResponseMsgLib() != null && openspcoopstateless.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                this.msgDiag.highDebug("Imbustamento not stateless (terminato:true)");
                return true;
            }
            OpenSPCoop2Properties propertiesReader = this.parametriGestioneRisposta.getPropertiesReader();
            this.portaStateless = true;
            boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getProtocol().getProfiloCollaborazione()) && !this.oneWayVers11;
            String idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, imbustamentoMSG.getPddContext());
            PdDContext pddContext = this.parametriGestioneRisposta.getPddContext();
            this.msgDiag.highDebug("InoltroBuste stateless ...");
            try {
                esito = this.esitoStatelessAfterSendRequest;
                this.msgDiag.highDebug("InoltroBuste stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new CoreException(ERRORE_NON_GESTITO);
                }
            }
            catch (Throwable e) {
                this.msgDiag.logErroreGenerico(e, "Stateless.InoltroBuste");
                this.logCore.error("Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                this.msgRequest.deleteMessageFromFileSystem();
                openspcoopstateless.setUseConnection(true);
                openspcoopstateless.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstateless.setUseConnection(true);
                this.gestioneRisposta();
                this.msgDiag.highDebug("InoltroBuste stateless (terminato:false)");
                return false;
            }
            if (openspcoopstateless.getDestinatarioResponseMsgLib() != null && openspcoopstateless.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                this.msgDiag.highDebug("InoltroBuste stateless (terminato:true)");
                return true;
            }
            this.msgDiag.highDebug("InoltroBuste stateless terminato");
            this.msgDiag.highDebug("SbustamentoRisposte stateless ...");
            SbustamentoRisposte sbustamentoRisposteLib = null;
            boolean erroreSbustamentoRisposta = false;
            try {
                sbustamentoRisposteLib = new SbustamentoRisposte(this.logCore);
                if (rinegoziamentoConnessione && openspcoopstateless.resourceReleased()) {
                    this.registroServiziReader = this.registroServiziReader.refreshState(openspcoopstateless.getStatoRichiesta(), openspcoopstateless.getStatoRisposta());
                    this.configurazionePdDReader = this.configurazionePdDReader.refreshState(this.registroServiziReader);
                    this.msgDiag.updateState(this.configurazionePdDReader);
                }
                this.msgDiag.highDebug("SbustamentoRisposte stateless (invoco) ...");
                esito = sbustamentoRisposteLib.onMessage(openspcoopstateless, this.registroServiziReader, this.configurazionePdDReader);
                this.msgDiag.highDebug("SbustamentoRisposte stateless (analizzo esito) ...");
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new CoreException(ERRORE_NON_GESTITO);
                }
            }
            catch (Throwable e) {
                erroreSbustamentoRisposta = true;
                this.msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                RicezioneContenutiApplicativi.logError(this.logCore, "Errore Generale durante la gestione stateless: " + e.getMessage(), e);
                this.msgRequest.deleteMessageFromFileSystem();
                openspcoopstateless.setUseConnection(true);
                openspcoopstateless.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, AbstractErrorGenerator.getIntegrationInternalError(pddContext), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, null));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    this.msgDiag.highDebug("SbustamentoRisposte stateless (commit) ...");
                    openspcoopstateless.setUseConnection(true);
                    try {
                        openspcoopstateless.commit();
                    }
                    catch (Exception exception) {}
                    openspcoopstateless.releaseResource();
                    openspcoopstateless.setUseConnection(false);
                }
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstateless.setUseConnection(true);
                this.gestioneRisposta();
                this.msgDiag.highDebug("SbustamentoRisposte stateless (terminato:false)");
                return false;
            }
            this.msgDiag.highDebug("SbustamentoRisposte stateless terminato");
        }
        return true;
    }

    private void gestioneRisposta() {
        HashMap<String, List<String>> propertiesIntegrazioneRisposta;
        OutResponsePDMessage outResponsePDMessage;
        OpenSPCoop2Message responseMessage;
        ProfiloDiCollaborazione profiloCollaborazione;
        String idMessageResponse;
        boolean errorOccursSetResponse;
        PddPluginLoader pluginLoader;
        RequestInfo requestInfo;
        String idTransazione;
        PdDContext pddContext;
        OpenSPCoop2Properties propertiesReader;
        block76: {
            String idCorrelazioneApplicativaRisposta;
            String profiloCollaborazioneValue;
            String idCollaborazioneResponse;
            block75: {
                propertiesReader = this.parametriGestioneRisposta.getPropertiesReader();
                pddContext = this.parametriGestioneRisposta.getPddContext();
                idTransazione = PdDContext.getValue((MapKey<String>)Costanti.ID_TRANSAZIONE, pddContext);
                requestInfo = (RequestInfo)pddContext.getObject(Costanti.REQUEST_INFO);
                Loader loader = Loader.getInstance();
                pluginLoader = PddPluginLoader.getInstance();
                errorOccursSetResponse = false;
                idMessageResponse = null;
                idCollaborazioneResponse = null;
                profiloCollaborazione = null;
                profiloCollaborazioneValue = null;
                responseMessage = null;
                idCorrelazioneApplicativaRisposta = null;
                try {
                    if (this.portaStateless || this.oneWayVers11) {
                        RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)this.openspcoopstate.getMessageLib();
                        idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                        idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                        profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                        profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                        responseMessage = ((OpenSPCoopStateless)this.openspcoopstate).getRispostaMsg();
                        idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativaRisposta();
                        if (!ProfiloDiCollaborazione.ONEWAY.equals((Object)profiloCollaborazione)) {
                            this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                        }
                        this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                        this.msgDiag.setIdMessaggioRisposta(idMessageResponse);
                        this.msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                        break block75;
                    }
                    try {
                        List enumPddContext;
                        responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                        String classType = null;
                        INodeReceiver nodeReceiver = null;
                        try {
                            classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                            nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                        }
                        catch (Exception e) {
                            throw new CoreException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                        }
                        this.msgDiag.mediumDebug("Attesa/lettura risposta...");
                        RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(this.msgDiag, this.identitaPdD, this.msgContext.getIdModulo(), this.idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                        idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                        idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                        profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                        profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                        pddContext = ricezioneContenutiApplicativiMSG.getPddContext();
                        if (pddContext != null && (enumPddContext = pddContext.keys()) != null && !enumPddContext.isEmpty()) {
                            for (MapKey key : enumPddContext) {
                                this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                            }
                        }
                        if (!ProfiloDiCollaborazione.ONEWAY.equals((Object)profiloCollaborazione)) {
                            this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                        }
                        this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                    }
                    catch (Exception e) {
                        RicezioneContenutiApplicativi.logError(this.logCore, "Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore", e);
                        this.msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                        if (e instanceof NodeTimeoutException) {
                            try {
                                this.openspcoopstate.updateResource(idTransazione);
                            }
                            catch (Exception eDB) {
                                this.msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                                return;
                            }
                            try {
                                this.msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                                this.msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                                this.openspcoopstate.commit();
                            }
                            catch (Exception eDel) {
                                this.msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                            }
                            this.openspcoopstate.releaseResource();
                        }
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                    this.msgDiag.setIdMessaggioRisposta(idMessageResponse);
                    this.msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                    this.msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    try {
                        this.openspcoopstate.updateResource(idTransazione);
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                    this.msgRequest.updateOpenSPCoopState(this.openspcoopstate);
                    this.msgDiag.mediumDebug("Lettura messaggio di risposta...");
                    GestoreMessaggi msgResponse = new GestoreMessaggi(this.openspcoopstate, false, idMessageResponse, "INBOX", this.msgDiag, this.msgContext.pddContext);
                    try {
                        responseMessage = msgResponse.getMessage();
                        if (responseMessage != null && this.msgContext.getPddContext() != null) {
                            Object o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO);
                            if (o instanceof Boolean) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, true);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) instanceof ParseException) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO)) instanceof Boolean) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, true);
                            }
                            if ((o = responseMessage.getContextProperty(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION)) instanceof ParseException) {
                                this.msgContext.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, o);
                            }
                        }
                        idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                    }
                    catch (GestoreMessaggiException e) {
                        this.msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                        this.openspcoopstate.releaseResource();
                        this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                        return;
                    }
                }
                catch (Exception e) {
                    RicezioneContenutiApplicativi.logError(this.logCore, "ErroreGenerale", e);
                    this.msgDiag.logErroreGenerico(e, "ErroreGenerale");
                    this.openspcoopstate.releaseResource();
                    this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                    errorOccursSetResponse = true;
                }
            }
            this.msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
            if (this.msgContext.getProtocol() != null) {
                this.msgContext.getProtocol().setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
            }
            if (this.msgContext.getIntegrazione() != null) {
                this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
            }
            this.msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
            this.headerIntegrazioneRisposta.getBusta().setIdCollaborazione(idCollaborazioneResponse);
            this.headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(profiloCollaborazione);
            String jtiIdModIRequest = null;
            Object bustaRispostaObject = null;
            if (pddContext != null) {
                if (pddContext.containsKey(Costanti.MODI_JTI_REQUEST_ID)) {
                    jtiIdModIRequest = (String)pddContext.get(Costanti.MODI_JTI_REQUEST_ID);
                }
                if (pddContext.containsKey(CostantiPdD.BUSTA_RISPOSTA)) {
                    bustaRispostaObject = pddContext.getObject(CostantiPdD.BUSTA_RISPOSTA);
                }
            }
            if (jtiIdModIRequest != null && StringUtils.isNotEmpty(jtiIdModIRequest) && !jtiIdModIRequest.equals(this.idMessageRequest)) {
                this.headerIntegrazioneRisposta.getBusta().setID(jtiIdModIRequest);
            } else {
                this.headerIntegrazioneRisposta.getBusta().setID(this.idMessageRequest);
            }
            outResponsePDMessage = new OutResponsePDMessage();
            outResponsePDMessage.setBustaRichiesta(this.bustaRichiesta);
            Busta bustaRisposta = null;
            if (bustaRispostaObject instanceof Busta) {
                Busta b;
                bustaRisposta = b = (Busta)bustaRispostaObject;
            } else if (bustaRispostaObject == null && "sdi".equalsIgnoreCase(this.protocolFactory.getProtocol()) && pddContext != null) {
                Object idSdiObject;
                String s;
                Object nomeFileSDIObject;
                if (pddContext.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE) && (nomeFileSDIObject = pddContext.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_NOME_FILE)) instanceof String) {
                    s = (String)nomeFileSDIObject;
                    outResponsePDMessage.getBustaRichiesta().addProperty("NomeFile", s);
                }
                if (pddContext.containsKey(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI) && (idSdiObject = pddContext.getObject(CostantiPdD.BUSTA_RICHIESTA_SDI_IDENTIFICATIVO_SDI)) instanceof String) {
                    s = (String)idSdiObject;
                    outResponsePDMessage.getBustaRichiesta().addProperty("IdentificativoSdI", s);
                }
            }
            if (bustaRisposta != null && bustaRisposta.sizeProperties() > 0) {
                String[] propertyNames = bustaRisposta.getPropertiesNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    outResponsePDMessage.getBustaRichiesta().addProperty(propertyNames[i], bustaRisposta.getProperty(propertyNames[i]));
                }
            }
            outResponsePDMessage.setMessage(responseMessage);
            outResponsePDMessage.setPortaDelegata(this.portaDelegata);
            propertiesIntegrazioneRisposta = new HashMap<String, List<String>>();
            outResponsePDMessage.setHeaders(propertiesIntegrazioneRisposta);
            outResponsePDMessage.setServizio(this.idServizio);
            outResponsePDMessage.setSoggettoMittente(this.soggettoFruitore);
            if (this.msgContext.getIdModulo().startsWith(ID_MODULO + IntegrationManager.ID_MODULO)) {
                try {
                    IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata("trasporto");
                    if (gestore == null) break block76;
                    String classType = null;
                    try {
                        classType = gestore.getClass().getName();
                        AbstractCore.init(gestore, pddContext, this.protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione della classe (IGestoreIntegrazionePD) [" + classType + "] da utilizzare per la gestione dell'integrazione delle fruizioni (Risposta IM) di tipo [trasporto]: " + e.getMessage());
                    }
                    gestore.setOutResponseHeader(this.headerIntegrazioneRisposta, outResponsePDMessage);
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
                }
            }
        }
        for (int i = 0; i < this.tipiIntegrazionePD.length; ++i) {
            try {
                IGestoreIntegrazionePD gestore = pluginLoader.newIntegrazionePortaDelegata(this.tipiIntegrazionePD[i]);
                if (gestore != null) {
                    String classType = null;
                    try {
                        classType = gestore.getClass().getName();
                        AbstractCore.init(gestore, pddContext, this.protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new CoreException("Riscontrato errore durante l'inizializzazione della classe (IGestoreIntegrazionePD) [" + classType + "] da utilizzare per la gestione dell'integrazione delle fruizioni (Risposta) di tipo [" + this.tipiIntegrazionePD[i] + "]: " + e.getMessage());
                    }
                    if (gestore instanceof IGestoreIntegrazionePDSoap) {
                        if (propertiesReader.processHeaderIntegrazionePDResponse(false)) {
                            if (propertiesReader.deleteHeaderIntegrazioneResponsePD()) {
                                if (responseMessage == null) {
                                    responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                                    outResponsePDMessage.setMessage(responseMessage);
                                }
                                gestore.setOutResponseHeader(this.headerIntegrazioneRisposta, outResponsePDMessage);
                            }
                            continue;
                        }
                        if (responseMessage == null) {
                            responseMessage = MessageUtilities.buildEmptyMessage((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)requestInfo.getIntegrationRequestMessageType(), (MessageRole)MessageRole.RESPONSE);
                            outResponsePDMessage.setMessage(responseMessage);
                        }
                        gestore.setOutResponseHeader(this.headerIntegrazioneRisposta, outResponsePDMessage);
                        continue;
                    }
                    gestore.setOutResponseHeader(this.headerIntegrazioneRisposta, outResponsePDMessage);
                    continue;
                }
                throw new CoreException("Gestore non inizializzato");
            }
            catch (Exception e) {
                this.msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", this.tipiIntegrazionePD[i]);
                this.msgDiag.addKeywordErroreProcessamento(e);
                this.msgDiag.logPersonalizzato("headerIntegrazione.creazioneFallita");
                RicezioneContenutiApplicativi.logError(this.logCore, this.msgDiag.getMessaggio_replaceKeywords("headerIntegrazione.creazioneFallita"), e);
            }
        }
        this.msgContext.setResponseHeaders(propertiesIntegrazioneRisposta);
        if (!this.portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)this.openspcoopstate, this.msgDiag, this.idMessageRequest, idMessageResponse, this.servizioApplicativo);
        }
        if (this.portaStateless && !this.oneWayVers11) {
            this.msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (this.richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = this.openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        this.openspcoopstate.setUseConnection(true);
                        this.openspcoopstate.updateResource(idTransazione);
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(this.openspcoopstate, false, idMessageResponse, "INBOX", this.msgDiag, this.msgContext.pddContext);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    this.msgRequest.updateOpenSPCoopState(this.openspcoopstate);
                    this.msgRequest.setReadyForDrop(true);
                    this.msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    this.msgRequest.setReadyForDrop(false);
                }
                this.openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(this.logCore, "Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", e);
                this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                this.openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                errorOccursSetResponse = true;
            }
        }
        if (this.oneWayVers11) {
            this.msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless...");
            try {
                this.openspcoopstate.commit();
            }
            catch (Exception e) {
                RicezioneContenutiApplicativi.logError(this.logCore, "Riscontrato errore durante il commit della gestione oneWay stateful/stateless", e);
                this.msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                this.openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(this.generatoreErrore.build((Context)pddContext, IntegrationFunctionError.INTERNAL_RESPONSE_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, responseMessage != null && responseMessage.getParseException() != null ? responseMessage.getParseException() : null));
                errorOccursSetResponse = true;
            }
        }
        this.msgDiag.mediumDebug("Rilascio connessione al database...");
        this.openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.SINCRONO)) {
                this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                if (this.headerIntegrazioneRichiesta != null && this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                if (this.headerIntegrazioneRichiesta != null && this.headerIntegrazioneRichiesta.getBusta() != null && this.headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    this.msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                this.msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            }
        }
        this.msgDiag.mediumDebug("Imposto risposta nel context...");
        if (!errorOccursSetResponse) {
            this.msgContext.setMessageResponse(responseMessage);
        }
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idMessageRequest, String idMessageResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idMessageRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }
}

