/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector.messages;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaDimensioneMessaggio;
import org.openspcoop2.pdd.core.controllo_traffico.SogliaReadTimeout;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorInMessage;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.transport.Credential;
import org.slf4j.Logger;

public class DumpRawConnectorInMessage
implements ConnectorInMessage {
    private ConnectorInMessage connectorInMessage;
    private Logger log;
    private DumpByteArrayOutputStream bout = null;
    private OpenSPCoop2MessageParseResult parseResult = null;
    private String contentType;
    private Integer contentLength;
    private Context context;
    private String idTransazione;
    private int soglia;
    private File repositoryFile;
    private MsgDiagnostico msgDiagnostico;

    public DumpRawConnectorInMessage(Logger log, ConnectorInMessage connectorInMessage, Context context, int soglia, File repositoryFile) {
        this.log = log;
        this.connectorInMessage = connectorInMessage;
        this.context = context;
        if (this.context != null) {
            this.idTransazione = (String)this.context.getObject(Costanti.ID_TRANSAZIONE);
        }
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
    }

    @Override
    public void setThresholdContext(Context context, int soglia, File repositoryFile) {
    }

    @Override
    public void setRequestReadTimeout(SogliaReadTimeout timeout) {
    }

    @Override
    public void disableReadTimeout() {
    }

    @Override
    public void setRequestLimitedStream(SogliaDimensioneMessaggio requestLimitSize) {
    }

    @Override
    public void disableLimitedStream() {
    }

    @Override
    public void checkContentLengthLimit() throws LimitExceededIOException {
        this.connectorInMessage.checkContentLengthLimit();
    }

    @Override
    public void setDiagnosticProducer(Context context, MsgDiagnostico msgDiag) {
        if (this.context == null) {
            this.context = context;
        }
        this.msgDiagnostico = msgDiag;
    }

    public ConnectorInMessage getWrappedConnectorInMessage() {
        return this.connectorInMessage;
    }

    public DumpByteArrayOutputStream getDumpByteArrayOutputStream() {
        if (this.bout != null && this.bout.size() > 0) {
            return this.bout;
        }
        return null;
    }

    public boolean isParsingRequestError() {
        return this.parseResult != null && this.parseResult.getParseException() != null;
    }

    public String getParsingRequestErrorAsString() {
        if (this.parseResult != null && this.parseResult.getParseException() != null) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bout);
                this.parseResult.getParseException().getSourceException().printStackTrace(pw);
                pw.flush();
                bout.flush();
                pw.close();
                bout.close();
                return bout.toString();
            }
            catch (Exception e) {
                return "ParsingRequestError, serializazione eccezione non riuscita: " + e.getMessage();
            }
        }
        return null;
    }

    @Override
    public OpenSPCoop2MessageSoapStreamReader getSoapReader() throws ConnectorException {
        return this.connectorInMessage.getSoapReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenSPCoop2MessageParseResult getRequest(NotifierInputStreamParams notifierInputStreamParams) throws ConnectorException {
        if (this.parseResult != null) {
            return this.parseResult;
        }
        ConnectorInMessage connectorInMessage = this.connectorInMessage;
        if (connectorInMessage instanceof HttpServletConnectorInMessage) {
            HttpServletConnectorInMessage http = (HttpServletConnectorInMessage)connectorInMessage;
            this.bout = new DumpByteArrayOutputStream(this.soglia, this.repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.getValue());
            try {
                this.parseResult = http.getRequest(this.bout, notifierInputStreamParams);
                if (this.bout.size() > 0) return this.parseResult;
                this.bout = null;
                return this.parseResult;
            }
            finally {
                try {
                    if (this.bout != null) {
                        this.bout.flush();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.bout != null) {
                        this.bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.parseResult = this.connectorInMessage.getRequest(notifierInputStreamParams);
        if (this.parseResult.getMessage() == null) return this.parseResult;
        try {
            this.bout = new DumpByteArrayOutputStream(this.soglia, this.repositoryFile, this.idTransazione, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.getValue());
            this.parseResult.getMessage().writeTo((OutputStream)this.bout, false);
        }
        catch (Throwable t) {
            try {
                this.bout = null;
                OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
                if (this.parseResult.getMessage().getParseException() != null) {
                    result.setParseException(this.parseResult.getMessage().getParseException());
                } else {
                    result.setParseException(ParseExceptionUtils.buildParseException((Throwable)t, (MessageRole)MessageRole.REQUEST));
                }
                OpenSPCoop2MessageParseResult openSPCoop2MessageParseResult = result;
                return openSPCoop2MessageParseResult;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (this.bout != null) {
                        this.bout.flush();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (this.bout != null) {
                        this.bout.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            if (this.bout != null) {
                this.bout.flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.bout == null) return this.parseResult;
            this.bout.close();
            return this.parseResult;
        }
        catch (Throwable throwable) {
            return this.parseResult;
        }
    }

    @Override
    public DumpByteArrayOutputStream getRequest() throws ConnectorException {
        return this.getRequest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DumpByteArrayOutputStream getRequest(boolean consume) throws ConnectorException {
        if (this.bout != null) {
            return this.bout;
        }
        try {
            DumpByteArrayOutputStream tmp = this.connectorInMessage.getRequest(consume);
            if (tmp != null) {
                this.bout = tmp;
            }
        }
        catch (Throwable t) {
            try {
                this.bout = DumpByteArrayOutputStream.newInstance((byte[])("getRequest error: " + t.getMessage()).getBytes());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.log.error("getRequest error: " + t.getMessage(), t);
        }
        finally {
            try {
                if (this.bout != null) {
                    this.bout.flush();
                }
            }
            catch (Throwable tmp) {}
            try {
                if (this.bout != null) {
                    this.bout.close();
                }
            }
            catch (Throwable tmp) {}
        }
        if (this.bout != null) {
            return this.bout;
        }
        return null;
    }

    @Override
    public Date getDataIngressoRichiesta() {
        return this.connectorInMessage.getDataIngressoRichiesta();
    }

    @Override
    public String getContentType() throws ConnectorException {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.connectorInMessage.getContentType();
        return this.contentType;
    }

    @Override
    public int getContentLength() throws ConnectorException {
        if (this.contentLength != null) {
            return this.contentLength;
        }
        this.contentLength = this.connectorInMessage.getContentLength();
        return this.contentLength;
    }

    @Override
    public MessageType getRequestMessageType() {
        return this.connectorInMessage.getRequestMessageType();
    }

    @Override
    public IDService getIdModuloAsIDService() {
        return this.connectorInMessage.getIdModuloAsIDService();
    }

    @Override
    public String getIdModulo() {
        return this.connectorInMessage.getIdModulo();
    }

    @Override
    public void updateRequestInfo(RequestInfo requestInfo) throws ConnectorException {
        this.connectorInMessage.updateRequestInfo(requestInfo);
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.connectorInMessage.getRequestInfo();
    }

    @Override
    public Object getAttribute(String key) throws ConnectorException {
        return this.connectorInMessage.getAttribute(key);
    }

    @Override
    public List<String> getHeaderValues(String key) throws ConnectorException {
        return this.connectorInMessage.getHeaderValues(key);
    }

    @Override
    public List<String> getParameterValues(String key) throws ConnectorException {
        return this.connectorInMessage.getParameterValues(key);
    }

    @Override
    public IProtocolFactory<?> getProtocolFactory() throws ConnectorException {
        return this.connectorInMessage.getProtocolFactory();
    }

    @Override
    public String getSOAPAction() throws ConnectorException {
        return this.connectorInMessage.getSOAPAction();
    }

    @Override
    public URLProtocolContext getURLProtocolContext() throws ConnectorException {
        return this.connectorInMessage.getURLProtocolContext();
    }

    @Override
    public Credential getCredential() throws ConnectorException {
        return this.connectorInMessage.getCredential();
    }

    @Override
    public String getSource() throws ConnectorException {
        return this.connectorInMessage.getSource();
    }

    @Override
    public String getProtocol() throws ConnectorException {
        return this.connectorInMessage.getProtocol();
    }

    @Override
    public String getRemoteAddress() throws ConnectorException {
        return this.connectorInMessage.getRemoteAddress();
    }

    @Override
    public void close() throws ConnectorException {
        this.connectorInMessage.close();
    }
}

