/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorDispatcherUtils;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.HttpServletConnectorOutMessage;
import org.openspcoop2.pdd.services.error.RicezioneContenutiApplicativiInternalErrorGenerator;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class RicezioneContenutiApplicativiConnector {
    public static final IDService ID_SERVICE = RicezioneContenutiApplicativiConnector.getIdServiceFromProperties();
    public static final String ID_MODULO = ID_SERVICE.getValue();

    private static IDService getIdServiceFromProperties() {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        if (op2Properties != null && op2Properties.isEnabledPDChannelNIODefault()) {
            return IDService.PORTA_DELEGATA_BIO;
        }
        return IDService.PORTA_DELEGATA;
    }

    public void doEngine(RequestInfo requestInfo, HttpServletRequest req, HttpServletResponse res, HttpRequestMethod method) throws ServletException {
        Date dataAccettazioneRichiesta = DateManager.getDate();
        if (method != null) {
            // empty if block
        }
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        RicezioneContenutiApplicativiInternalErrorGenerator generatoreErrore = null;
        try {
            generatoreErrore = new RicezioneContenutiApplicativiInternalErrorGenerator(logCore, ID_MODULO, requestInfo);
        }
        catch (Exception e) {
            String msg = "Inizializzazione Generatore Errore fallita: " + Utilities.readFirstErrorValidMessageFromException((Throwable)e);
            logCore.error(msg, (Throwable)e);
            ConnectorDispatcherUtils.doError(requestInfo, generatoreErrore, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msg, CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), IntegrationFunctionError.GOVWAY_NOT_INITIALIZED, (Throwable)e, res, logCore);
            return;
        }
        RicezioneContenutiApplicativiService ricezioneContenutiApplicativi = new RicezioneContenutiApplicativiService(generatoreErrore);
        HttpServletConnectorInMessage httpIn = null;
        try {
            httpIn = new HttpServletConnectorInMessage(requestInfo, req, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorInMessage init error", e);
        }
        IProtocolFactory<?> protocolFactory = null;
        try {
            protocolFactory = httpIn.getProtocolFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpServletConnectorOutMessage httpOut = null;
        try {
            httpOut = new HttpServletConnectorOutMessage(requestInfo, protocolFactory, res, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            this.doError("HttpServletConnectorOutMessage init error", e);
        }
        try {
            ricezioneContenutiApplicativi.process(httpIn, httpOut, dataAccettazioneRichiesta, false);
        }
        catch (Exception e) {
            this.doError("RicezioneContenutiApplicativi.process error", e);
        }
    }

    private void doError(String msg, Exception e) throws ServletException {
        String msgError = msg + ": " + e.getMessage();
        ConnectorUtils.getErrorLog().error(msgError, (Throwable)e);
        throw new ServletException(e.getMessage(), (Throwable)e);
    }
}

