/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContextImpl;
import org.openspcoop2.protocol.manifest.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.slf4j.Logger;

public class ConnectorUtils {
    public static Logger getErrorLog() {
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = LoggerWrapperFactory.getLogger(ConnectorUtils.class);
        }
        return log;
    }

    public static RequestInfo getRequestInfo(IProtocolFactory<?> pf, URLProtocolContext protocolContext) throws ProtocolException, MessageException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        IProtocolConfiguration pc = pf.createProtocolConfiguration();
        ServiceBindingConfiguration bindingConfig = pc.getDefaultServiceBindingConfiguration((TransportRequestContext)protocolContext);
        ServiceBinding integrationServiceBinding = bindingConfig.getDefaultBinding();
        ServiceBinding protocolServiceBinding = pc.getProtocolServiceBinding(integrationServiceBinding, (TransportRequestContext)protocolContext);
        ServiceBinding serviceBindingDaUtilizzare = integrationServiceBinding;
        boolean pa = false;
        if (protocolContext.isPortaApplicativaService()) {
            serviceBindingDaUtilizzare = protocolServiceBinding;
            pa = true;
        }
        String ct = null;
        try {
            ct = protocolContext.getContentType();
            if (ct != null && !"".equals(ct)) {
                ContentTypeUtilities.validateContentType((String)ct);
            }
        }
        catch (Throwable e) {
            ct = null;
        }
        MessageType requestMessageType = bindingConfig.getRequestMessageType(serviceBindingDaUtilizzare, (TransportRequestContext)protocolContext, ct);
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setProtocolContext(protocolContext);
        requestInfo.setProtocolFactory(pf);
        if (pa) {
            requestInfo.setProtocolRequestMessageType(requestMessageType);
        } else {
            requestInfo.setIntegrationRequestMessageType(requestMessageType);
        }
        requestInfo.setProtocolServiceBinding(protocolServiceBinding);
        requestInfo.setIntegrationServiceBinding(integrationServiceBinding);
        requestInfo.setBindingConfig(bindingConfig);
        requestInfo.setIdentitaPdD(op2Properties != null ? op2Properties.getIdentitaPortaDefault(pf.getProtocol(), requestInfo) : null);
        return requestInfo;
    }

    public static String getMessageHttpMethodNotSupported(HttpRequestMethod method) {
        return "Method HTTP @METHOD@ non supportato".replace("@METHOD@", method.name());
    }

    public static String getMessageServiceBindingNotSupported(ServiceBinding serviceBinding) {
        return "ServiceBinding @SERVICE_BINDING@ non supportato".replace("@SERVICE_BINDING@", serviceBinding.name());
    }

    private static StringBuilder getPrefixCode(IDService idService) {
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
        }
        if (log == null) {
            log = LoggerWrapperFactory.getLogger(ConnectorUtils.class);
        }
        StringBuilder bf = new StringBuilder();
        try {
            bf.append(idService.getCode()).append("-");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            bf = new StringBuilder();
            bf.append("0000000");
        }
        return bf;
    }

    public static String getFullCodeGovWayNotInitialized(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("9999");
        return bf.toString();
    }

    public static String getFullCodeProtocolUnsupported(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0001");
        return bf.toString();
    }

    public static String getFullCodeWsdlUnsupported(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0021");
        return bf.toString();
    }

    public static String getFullCodeWsdlNotDefined(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0022");
        return bf.toString();
    }

    public static String getFullCodeEngineFilter(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0031");
        return bf.toString();
    }

    public static String getFullCodeFunctionUnsupported(IDService idService) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0041");
        return bf.toString();
    }

    public static String getFullCodeHttpMethodNotSupported(IDService idService, HttpRequestMethod method) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        switch (method) {
            case GET: {
                bf.append("0011");
                break;
            }
            case POST: {
                bf.append("0012");
                break;
            }
            case PUT: {
                bf.append("0013");
                break;
            }
            case HEAD: {
                bf.append("0014");
                break;
            }
            case DELETE: {
                bf.append("0015");
                break;
            }
            case OPTIONS: {
                bf.append("0016");
                break;
            }
            case TRACE: {
                bf.append("0017");
                break;
            }
            case PATCH: {
                bf.append("0018");
                break;
            }
            case LINK: {
                bf.append("0019");
                break;
            }
            case UNLINK: {
                bf.append("0020");
            }
        }
        return bf.toString();
    }

    public static String getFullCodeServiceBindingNotSupported(IDService idService, ServiceBinding serviceBinding) {
        StringBuilder bf = ConnectorUtils.getPrefixCode(idService);
        switch (serviceBinding) {
            case SOAP: {
                bf.append("0051");
                break;
            }
            case REST: {
                bf.append("0052");
            }
        }
        return bf.toString();
    }

    public static String generateError404Message(String code) {
        return "GovWay-" + code;
    }

    public static void generateErrorMessage(IDService idService, HttpRequestMethod httpMethod, HttpServletRequest req, HttpServletResponse res, String msgErrore, boolean erroreGenerale, boolean htmlMessage) throws IOException {
        ConnectorUtils.generateErrorMessage(idService, httpMethod, req, res, msgErrore, erroreGenerale, htmlMessage, null);
    }

    public static void generateErrorMessage(IDService idService, HttpRequestMethod httpMethod, HttpServletRequest req, StringBuilder log, String msgErrore, boolean erroreGenerale, boolean htmlMessage) throws IOException {
        ConnectorUtils.generateErrorMessage(idService, httpMethod, req, null, msgErrore, erroreGenerale, htmlMessage, log);
    }

    private static void generateErrorMessage(IDService idService, HttpRequestMethod httpMethod, HttpServletRequest req, HttpServletResponse response, String msgErrore, boolean erroreGenerale, boolean htmlMessage, StringBuilder log) throws IOException {
        boolean doBody;
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        String versione = "GovWay/3.4.1";
        if (op2Properties != null) {
            versione = op2Properties.getPddDetailsForServices();
        }
        if (htmlMessage) {
            versione = StringEscapeUtils.escapeHtml4((String)versione);
            if (response != null) {
                response.setContentType("text/html");
            }
        } else if (response != null) {
            response.setContentType("text/plain");
        }
        boolean bl = doBody = !HttpRequestMethod.HEAD.equals((Object)httpMethod);
        if (!doBody) {
            if (log != null) {
                log.append("GovWay-Version").append("=").append(versione);
                log.append("GovWay-Version-Info").append("=").append(msgErrore);
            } else {
                response.setHeader("GovWay-Version", versione);
                response.setHeader("GovWay-Version-Info", msgErrore);
                response.setContentLength(0);
            }
            return;
        }
        StringBuilder risposta = new StringBuilder();
        risposta.append("<html>\n");
        risposta.append("<head>\n");
        risposta.append("<title>" + versione + "</title>\n");
        risposta.append("</head>\n");
        risposta.append("<body>\n");
        risposta.append("<h1>" + versione + "</h1>\n");
        String function = null;
        String parameters = null;
        try {
            URLProtocolContextImpl protocolContext = new URLProtocolContextImpl(req, logCore, true, op2Properties != null ? op2Properties.getCustomContexts() : null);
            String url = protocolContext.getUrlInvocazione_formBased();
            if (url.endsWith("?wsdl=")) {
                url = url.substring(0, url.length() - "=".length());
            }
            if (htmlMessage) {
                url = StringEscapeUtils.escapeHtml4((String)url);
            }
            risposta.append("<p>" + url + "</p>\n");
            function = protocolContext.getFunction();
            parameters = protocolContext.getFunctionParameters();
        }
        catch (Exception e) {
            if (logCore == null) {
                LoggerWrapperFactory.getLogger(ConnectorUtils.class).error(e.getMessage(), (Throwable)e);
            } else {
                logCore.error(e.getMessage(), (Throwable)e);
            }
            String context = req.getContextPath();
            if (htmlMessage) {
                context = StringEscapeUtils.escapeHtml4((String)context);
            }
            risposta.append("<p>" + context + "</p>\n");
        }
        String errore = msgErrore;
        if (htmlMessage) {
            errore = StringEscapeUtils.escapeHtml4((String)errore);
        }
        risposta.append("<p>" + errore + "</p>\n");
        switch (idService) {
            case PORTA_DELEGATA: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione delle fruizioni esposte dall'API Gateway GovWay</i><br/><br/>\n");
                break;
            }
            case PORTA_APPLICATIVA: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione delle erogazioni esposte dall'API Gateway GovWay</i><br/><br/>\n");
                break;
            }
            case PORTA_DELEGATA_XML_TO_SOAP: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione delle fruizioni esposte dall'API Gateway GovWay, con messaggi xml non imbustati nel protocollo SOAP</i><br/><br/>\n");
                break;
            }
            case INTEGRATION_MANAGER_SOAP: {
                if (parameters == null) {
                    risposta.append("<i>Servizio IntegrationManager</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).equals("IntegrationManager/PD")) {
                    risposta.append("<i>Servizio utilizzabile per l'invocazione delle fruizioni esposte dall'API Gateway GovWay</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).startsWith("IntegrationManager/PD/")) {
                    risposta.append("<i>Servizio utilizzabile per l'invocazione delle fruizioni esposte dall'API Gateway GovWay</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).equals("IntegrationManager/MessageBox")) {
                    risposta.append("<i>Servizio utilizzabile per accedere alla MessageBox esposta dall'API Gateway GovWay</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).startsWith("IntegrationManager/MessageBox/")) {
                    risposta.append("<i>Servizio utilizzabile per accedere alla MessageBox esposta dall'API Gateway GovWay</i><br/><br/>\n");
                    break;
                }
                risposta.append("<i>Servizio IntegrationManager dell'API Gateway GovWay</i><br/><br/>\n");
                break;
            }
            case CHECK_PDD: {
                risposta.append("<i>Servizio utilizzabile per comprendere lo stato di funzionamento dell'API Gateway GovWay</i><br/><br/>\n");
                break;
            }
            case PROXY: {
                risposta.append("<i>Servizio utilizzato in installazioni container dell'API Gateway GovWay</i><br/><br/>\n");
                break;
            }
            default: {
                if (htmlMessage) {
                    Object useAs = "Use as http[s]://<server>" + req.getContextPath() + "/<protocol-context>/<service>[/...]";
                    useAs = StringEscapeUtils.escapeHtml4((String)useAs);
                    risposta.append("<i>" + (String)useAs + "</i><br/>\n");
                }
                try {
                    MapReader prots = ProtocolFactoryManager.getInstance().getProtocolFactories();
                    if (prots.size() <= 0) {
                        risposta.append("<i>ERROR: No protocol installed</i><br/>\n");
                    } else {
                        StringBuilder bfProtocols = new StringBuilder();
                        Enumeration keys = prots.keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            IProtocolFactory pf = (IProtocolFactory)prots.get((Object)key);
                            if (pf.getManifest().getWeb().getEmptyContext() != null && pf.getManifest().getWeb().getEmptyContext().isEnabled()) {
                                if (bfProtocols.length() > 0) {
                                    bfProtocols.append(", ");
                                }
                                bfProtocols.append("\"\" (protocol:" + key + ")");
                            }
                            if (pf.getManifest().getWeb().sizeContextList() <= 0) continue;
                            for (Context context : pf.getManifest().getWeb().getContextList()) {
                                if (bfProtocols.length() > 0) {
                                    bfProtocols.append(", ");
                                }
                                bfProtocols.append(context.getName() + " (protocol:" + key + ")");
                            }
                        }
                        Object enabledProtocols = "Enabled protocol-contexts: " + bfProtocols.toString();
                        if (htmlMessage) {
                            enabledProtocols = StringEscapeUtils.escapeHtml4((String)enabledProtocols);
                        }
                        risposta.append("<i>" + (String)enabledProtocols + "</i><br/>\n");
                    }
                }
                catch (Exception e) {
                    if (logCore == null) {
                        LoggerWrapperFactory.getLogger(ConnectorUtils.class).error(e.getMessage(), (Throwable)e);
                    } else {
                        logCore.error(e.getMessage(), (Throwable)e);
                    }
                    risposta.append("<i>ERROR: No protocol installed</i><br/>\n");
                }
                if (!htmlMessage) break;
                risposta.append("<i>Enabled services: in, out, out/xml2soap, check, IntegrationManager</i><br/><br/>\n");
                risposta.append("<i>Official website: https://govway.org</i><br/><br/>\n");
            }
        }
        risposta.append("</body>\n");
        risposta.append("</html>\n");
        if (log != null) {
            log.append(risposta.toString());
        } else {
            response.getOutputStream().write(risposta.toString().getBytes());
        }
    }
}

