/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;

public class ConnectorAsyncThreadPoolConfig {
    public static final String PROPERTY_PREFIX = "org.openspcoop2.pdd.connettori.asyncThreadPool.";
    private static final String PROPERTY_IN_REQUEST = "inRequest";
    private static final String PROPERTY_OUT_RESPONSE = "outResponse";
    private static final String PROPERTY_OUT_REQUEST = "outRequest";
    private static final String PROPERTY_IN_RESPONSE = "inResponse";
    private static final String PROPERTY_EXECUTOR_PREFIX = "executor.";
    private static final String PROPERTY_EXECUTOR_TYPE_SUFFIX = ".type";
    private static final String PROPERTY_EXECUTOR_TYPE_VIRTUAL = "virtual";
    private static final String PROPERTY_EXECUTOR_TYPE_FIXED = "fixed";
    private static final String PROPERTY_EXECUTOR_SIZE_SUFFIX = ".size";
    private String inRequestThreadPoolId = null;
    private String outResponseThreadPoolId = null;
    private String outRequestThreadPoolId = null;
    private String inResponseThreadPoolId = null;
    private Map<String, Boolean> poolVirtualThreadType = new HashMap<String, Boolean>();
    private Map<String, Integer> poolSize = new HashMap<String, Integer>();

    public String getInRequestThreadPoolId() {
        return this.inRequestThreadPoolId;
    }

    public String getOutResponseThreadPoolId() {
        return this.outResponseThreadPoolId;
    }

    public String getOutRequestThreadPoolId() {
        return this.outRequestThreadPoolId;
    }

    public String getInResponseThreadPoolId() {
        return this.inResponseThreadPoolId;
    }

    public Map<String, Boolean> getPoolVirtualThreadType() {
        return this.poolVirtualThreadType;
    }

    public Map<String, Integer> getPoolSize() {
        return this.poolSize;
    }

    public ConnectorAsyncThreadPoolConfig(Properties properties, boolean requestStreamEnabled, boolean responseStreamEnabled) throws UtilsException {
        PropertiesReader pr = new PropertiesReader(properties, false);
        this.inRequestThreadPoolId = this.getProperty(pr, PROPERTY_IN_REQUEST, requestStreamEnabled);
        this.outResponseThreadPoolId = this.getProperty(pr, PROPERTY_OUT_RESPONSE, responseStreamEnabled);
        this.outRequestThreadPoolId = this.getProperty(pr, PROPERTY_OUT_REQUEST, requestStreamEnabled);
        this.inResponseThreadPoolId = this.getProperty(pr, PROPERTY_IN_RESPONSE, responseStreamEnabled);
        ArrayList<String> poolNames = new ArrayList<String>();
        this.fillPoolNames(pr, poolNames);
        if (poolNames.isEmpty()) {
            throw new UtilsException("Property org.openspcoop2.pdd.connettori.asyncThreadPool..executor.<id>.type not found");
        }
        for (String pName : poolNames) {
            Integer size;
            boolean virtualThread = this.isVirtualTypeProperty(pr, PROPERTY_EXECUTOR_PREFIX + pName + PROPERTY_EXECUTOR_TYPE_SUFFIX, true);
            this.poolVirtualThreadType.put(pName, virtualThread);
            if (virtualThread || (size = this.getSizeProperty(pr, PROPERTY_EXECUTOR_PREFIX + pName + PROPERTY_EXECUTOR_SIZE_SUFFIX, true)) == null) continue;
            this.poolSize.put(pName, size);
        }
        if (this.poolVirtualThreadType.isEmpty()) {
            throw new UtilsException("Pool is empty?");
        }
    }

    private String getProperty(PropertiesReader pr, String id, boolean required) throws UtilsException {
        String v = pr.getValue_convertEnvProperties(id);
        if (v != null) {
            return v.trim();
        }
        if (required) {
            throw new UtilsException("Property 'org.openspcoop2.pdd.connettori.asyncThreadPool." + id + "' not found");
        }
        return null;
    }

    private Boolean isVirtualTypeProperty(PropertiesReader pr, String id, boolean required) throws UtilsException {
        String v = this.getProperty(pr, id, required);
        if (v != null) {
            if (PROPERTY_EXECUTOR_TYPE_VIRTUAL.equals(v)) {
                return true;
            }
            if (PROPERTY_EXECUTOR_TYPE_FIXED.equals(v)) {
                return false;
            }
            throw new UtilsException("Property 'org.openspcoop2.pdd.connettori.asyncThreadPool." + id + "' uncorrect value (" + v + "): use 'virtual' or 'fixed'");
        }
        return true;
    }

    private Integer getSizeProperty(PropertiesReader pr, String id, boolean required) throws UtilsException {
        String v = this.getProperty(pr, id, required);
        if (v != null) {
            if ("availableProcessors".equals(v)) {
                return CostantiPdD.getAvailableProcessors();
            }
            try {
                return Integer.parseInt(v);
            }
            catch (Exception e) {
                throw new UtilsException("Property 'org.openspcoop2.pdd.connettori.asyncThreadPool." + id + "' uncorrect value (" + v + "): " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private void fillPoolNames(PropertiesReader pr, List<String> poolNames) throws UtilsException {
        Properties p = pr.readProperties(PROPERTY_EXECUTOR_PREFIX);
        if (!p.isEmpty()) {
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String name;
                String key;
                Object object = entry.getKey();
                if (!(object instanceof String) || !(key = (String)object).contains(".") || poolNames.contains(name = key.substring(0, key.indexOf(".")))) continue;
                poolNames.add(name);
            }
        }
    }
}

