/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposteMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorseThread;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class ImbustamentoRisposteMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private transient MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (log == null) {
                LoggerWrapperFactory.getLogger(ImbustamentoRisposteMDB.class).error("[ImbustamentoRisposte] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorseThread.isRisorseDisponibili()) {
                log.error("[ImbustamentoRisposte] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile().getMessage(), (Throwable)TimerMonitoraggioRisorseThread.getRisorsaNonDisponibile());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                log.error("[ImbustamentoRisposte] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage(), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                log.error("[ImbustamentoRisposte] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage(), MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.isSistemaDumpDisponibile()) {
                log.error("[ImbustamentoRisposte] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.getMotivoMalfunzionamentoDump().getMessage(), Dump.getMotivoMalfunzionamentoDump());
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ImbustamentoRisposte lib = null;
            try {
                lib = new ImbustamentoRisposte(log);
            }
            catch (Exception e) {
                log.error("ImbustamentoRisposte.instanziazione: " + e.getMessage(), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                log = LoggerWrapperFactory.getLogger(ImbustamentoRisposteMDB.class);
                log.error("[ImbustamentoRisposte] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = MsgDiagnostico.newInstance(TipoPdD.APPLICATIVA, "ImbustamentoRisposte");
            msgDiag.mediumDebug("Ricezione richiesta (ImbustamentoRisposteMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ImbustamentoRisposteMessage imbustamentoRisposteMsg = null;
            try {
                imbustamentoRisposteMsg = (ImbustamentoRisposteMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getObject(ImbustamentoRisposteMessage)");
                return;
            }
            RequestInfo requestInfo = null;
            if (imbustamentoRisposteMsg.getPddContext() != null && imbustamentoRisposteMsg.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)imbustamentoRisposteMsg.getPddContext().getObject(Costanti.REQUEST_INFO);
            }
            if (imbustamentoRisposteMsg.getRichiestaApplicativa() != null && imbustamentoRisposteMsg.getRichiestaApplicativa().getIdPortaApplicativa() != null) {
                msgDiag.updatePorta(imbustamentoRisposteMsg.getRichiestaApplicativa().getIdPortaApplicativa().getNome(), requestInfo);
            } else if (imbustamentoRisposteMsg.getRichiestaDelegata() != null && imbustamentoRisposteMsg.getRichiestaDelegata().getIdPortaDelegata() != null) {
                msgDiag.updatePorta(TipoPdD.DELEGATA, imbustamentoRisposteMsg.getRichiestaDelegata().getIdPortaDelegata().getNome(), requestInfo);
            }
            String idMessageRequest = null;
            try {
                idMessageRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico(e, "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopStateful stato = null;
            try {
                stato = new OpenSPCoopStateful();
                stato.setIDMessaggioSessione(idMessageRequest);
                stato.setMessageLib(imbustamentoRisposteMsg);
            }
            catch (Exception e) {
                log.error("[ImbustamentoRisposte] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = imbustamentoRisposteMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject(Costanti.PROTOCOL_NAME)));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            String idMessageResponse = imbustamentoRisposteMsg.getIDMessageResponse();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ImbustamentoRisposte", idMessageResponse, "OUTBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessageRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "ImbustamentoRisposte");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                log.error("[ImbustamentoRisposte] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                log.info("[ImbustamentoRisposte] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                log.debug("[ImbustamentoRisposte] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

