/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.transazioni;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.slf4j.Logger;

public class ConfigurazioneTracciamentoUtils {
    private ConfigurazioneTracciamentoUtils() {
    }

    public static boolean isConsegnaMultipla(Context context) {
        int connettoriMultipli = ConfigurazioneTracciamentoUtils.getNumeroConnettoriMultipli(context);
        return ConfigurazioneTracciamentoUtils.isConsegnaMultipla(connettoriMultipli);
    }

    public static boolean isConsegnaMultipla(int connettoriMultipli) {
        boolean consegnaMultipla = false;
        if (connettoriMultipli > 0) {
            consegnaMultipla = true;
        }
        return consegnaMultipla;
    }

    public static int getNumeroConnettoriMultipli(Context context) {
        Object oConnettori;
        int connettoriMultipli = -1;
        if (context.containsKey(Costanti.CONSEGNA_MULTIPLA_CONNETTORI) && (oConnettori = context.getObject(Costanti.CONSEGNA_MULTIPLA_CONNETTORI)) instanceof Integer) {
            connettoriMultipli = (Integer)oConnettori;
        }
        return connettoriMultipli;
    }

    public static String getConnettoriMultipli(Context context) {
        return ConnettoreUtils.getNomeConnettori(context);
    }

    public static boolean isEsitoDaRegistrare(Logger log, IProtocolFactory<?> protocolFactory, Context context, List<String> esitiDaRegistrare, EsitoTransazione esitoTransazione) throws ProtocolException {
        EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        int code = esitoTransazione.getCode();
        boolean consegnaMultipla = ConfigurazioneTracciamentoUtils.isConsegnaMultipla(context);
        if (consegnaMultipla) {
            code = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
        }
        String codeAsString = "" + code;
        return esitiDaRegistrare.contains(codeAsString);
    }

    public static String getEsitoTransazionDetail(Logger log, IProtocolFactory<?> protocolFactory, EsitoTransazione esitoTransazione) throws ProtocolException {
        EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        int code = esitoTransazione.getCode();
        String codeAsString = "" + code;
        return "esito [name:" + esitiProperties.getEsitoName(esitoTransazione.getCode()) + " code:" + codeAsString + "]";
    }

    public static boolean isEsitoOk(Logger log, IProtocolFactory<?> protocolFactory, EsitoTransazione esitoTransazione) throws ProtocolException {
        List<String> esitiOk = ConfigurazioneTracciamentoUtils.getEsitiOk(log, protocolFactory);
        int code = esitoTransazione.getCode();
        String codeAsString = "" + code;
        return esitiOk.contains(codeAsString);
    }

    private static List<String> getEsitiOk(Logger log, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        EsitiProperties esitiProperties = EsitiProperties.getInstance((Logger)log, protocolFactory);
        List tmpEsitiOk = esitiProperties.getEsitiCodeOk();
        ArrayList<String> esitiOk = new ArrayList<String>();
        if (tmpEsitiOk != null && !tmpEsitiOk.isEmpty()) {
            for (Integer esito : tmpEsitiOk) {
                esitiOk.add("" + esito);
            }
        }
        return esitiOk;
    }

    public static String getPrefixFile(File f, boolean expectedDir) {
        return (expectedDir ? "Dir " : "") + "[" + f.getAbsolutePath() + "] ";
    }

    public static CoreException newCoreExceptionNotFile(File f, boolean expectedDir) {
        return new CoreException(ConfigurazioneTracciamentoUtils.getPrefixFile(f, expectedDir) + "isn't file");
    }

    public static CoreException newCoreExceptionCannotRead(File f, boolean expectedDir) {
        return new CoreException(ConfigurazioneTracciamentoUtils.getPrefixFile(f, expectedDir) + "cannot read");
    }

    public static CoreException newCoreExceptionNotExists(File f, boolean expectedDir) {
        return new CoreException(ConfigurazioneTracciamentoUtils.getPrefixFile(f, expectedDir) + "not exists");
    }
}

