/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.info;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class FormatUtils {
    public static String getTestoVisualizzabile(Logger log, byte[] b, StringBuilder stringBuffer, boolean logError) {
        int max = 256000;
        return FormatUtils.getTestoVisualizzabile(log, b, stringBuffer, logError, max);
    }

    public static String getTestoVisualizzabile(Logger log, byte[] b, StringBuilder stringBuffer, boolean logError, int max) {
        try {
            stringBuffer.append(Utilities.convertToPrintableText((byte[])b, (int)max));
            return null;
        }
        catch (Exception e) {
            if (logError) {
                log.error("getTestoVisualizzabile error", (Throwable)e);
            } else {
                log.debug("getTestoVisualizzabile error", (Throwable)e);
            }
            return e.getMessage();
        }
    }

    public static String prettifyXml(Logger log, String xml) {
        return FormatUtils.prettifyXml(log, xml, null);
    }

    public static String prettifyXml(Logger log, String xml, String charset) {
        if (xml == null || "".equals(xml)) {
            return "";
        }
        try {
            if (charset == null) {
                charset = Charset.UTF_8.getValue();
            }
            Element element = FormatUtils.buildContent(xml.getBytes(), charset);
            return PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element, (boolean)false, (String)charset);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return xml;
        }
    }

    public static String prettifyXml(Logger log, byte[] xml) {
        return FormatUtils.prettifyXml(log, xml, null);
    }

    public static String prettifyXml(Logger log, byte[] xml, String charset) {
        if (xml == null) {
            return "";
        }
        String res = "";
        try {
            if (charset == null) {
                charset = Charset.UTF_8.getValue();
            }
            Element element = FormatUtils.buildContent(xml, charset);
            return PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element, (boolean)false, (String)charset);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            return res;
        }
    }

    private static Element buildContent(byte[] content, String charset) throws MessageException {
        ByteArrayInputStream is = null;
        InputStreamReader isr = null;
        InputSource isSax = null;
        try {
            is = new ByteArrayInputStream(content);
            isr = new InputStreamReader((InputStream)is, charset);
            isSax = new InputSource(isr);
            isSax.setEncoding(charset);
            Element element = XMLUtils.getInstance().newElement(isSax);
            return element;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

