/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger.dump;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.transazioni.DumpAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCDumpMessaggioServiceSearchImpl;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class TransactionDumpMessaggioServiceSearchImpl
extends JDBCDumpMessaggioServiceSearchImpl {
    protected DumpMessaggio getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws Exception {
        DumpMessaggio dumpMessaggio = super.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
        this.readMultipartHeaderExt(dumpMessaggio);
        this.readHeaderExt(dumpMessaggio);
        this.readAllegatiExt(dumpMessaggio);
        return dumpMessaggio;
    }

    private void readMultipartHeaderExt(DumpMessaggio dumpMessaggio) throws CoreException {
        Map headers;
        if (dumpMessaggio.getMultipartHeaderExt() != null && !StringUtils.isEmpty((CharSequence)dumpMessaggio.getMultipartHeaderExt()) && (headers = PropertiesSerializator.convertoFromDBColumnValue((String)dumpMessaggio.getMultipartHeaderExt())) != null && headers.size() > 0) {
            this.readMultipartHeaderExt(dumpMessaggio, headers);
        }
    }

    private void readMultipartHeaderExt(DumpMessaggio dumpMessaggio, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                DumpMultipartHeader headerMultipart = new DumpMultipartHeader();
                headerMultipart.setNome(key);
                headerMultipart.setValore(value);
                headerMultipart.setDumpTimestamp(dumpMessaggio.getDumpTimestamp());
                dumpMessaggio.addMultipartHeader(headerMultipart);
            }
        }
    }

    private void readHeaderExt(DumpMessaggio dumpMessaggio) throws CoreException {
        Map headers;
        if (dumpMessaggio.getHeaderExt() != null && !StringUtils.isEmpty((CharSequence)dumpMessaggio.getHeaderExt()) && (headers = PropertiesSerializator.convertoFromDBColumnValue((String)dumpMessaggio.getHeaderExt())) != null && headers.size() > 0) {
            this.readHeaderExt(dumpMessaggio, headers);
        }
    }

    private void readHeaderExt(DumpMessaggio dumpMessaggio, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                DumpHeaderTrasporto headerTrasporto = new DumpHeaderTrasporto();
                headerTrasporto.setNome(key);
                headerTrasporto.setValore(value);
                headerTrasporto.setDumpTimestamp(dumpMessaggio.getDumpTimestamp());
                dumpMessaggio.addHeaderTrasporto(headerTrasporto);
            }
        }
    }

    private void readAllegatiExt(DumpMessaggio dumpMessaggio) throws CoreException {
        if (dumpMessaggio.getAllegatoList() != null && !dumpMessaggio.getAllegatoList().isEmpty()) {
            for (DumpAllegato dumpAllegato : dumpMessaggio.getAllegatoList()) {
                Map headers;
                if (dumpAllegato.getHeaderExt() == null || StringUtils.isEmpty((CharSequence)dumpAllegato.getHeaderExt()) || (headers = PropertiesSerializator.convertoFromDBColumnValue((String)dumpAllegato.getHeaderExt())) == null || headers.size() <= 0) continue;
                this.readAllegatiExt(dumpMessaggio, dumpAllegato, headers);
            }
        }
    }

    private void readAllegatiExt(DumpMessaggio dumpMessaggio, DumpAllegato dumpAllegato, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            for (String value : values) {
                DumpHeaderAllegato headerAllegato = new DumpHeaderAllegato();
                headerAllegato.setNome(key);
                headerAllegato.setValore(value);
                headerAllegato.setDumpTimestamp(dumpMessaggio.getDumpTimestamp());
                dumpAllegato.addHeader(headerAllegato);
            }
        }
    }
}

