/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.dao.IDBCredenzialeMittenteServiceSearch;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.pdd.logger.DriverMsgDiagnostici;
import org.openspcoop2.pdd.logger.TransactionDriverTracciamento;
import org.openspcoop2.pdd.logger.diagnostica.InformazioniRecordDiagnostici;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiException;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class TransactionDriverMsgDiagnostici
implements IDiagnosticDriver {
    private static final String TIPO_DB_NON_GESTITO = "Tipo database non gestito";
    DataSource datasource = null;
    Connection connection = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    String tipoDatabase = null;
    DriverMsgDiagnostici driverMsgDiagnostici = null;
    DAOFactory daoFactory = null;
    private Logger log = null;

    public IProtocolFactory<?> getProtocolFactory() {
        return null;
    }

    public TransactionDriverMsgDiagnostici(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMsgDiagnosticiException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public TransactionDriverMsgDiagnostici(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds jndiName) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new DriverMsgDiagnosticiException("datasource is null");
            }
            initCtx.close();
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds jndiName) Errore durante la ricerca del datasource: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds jndiName) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverMsgDiagnostici = new DriverMsgDiagnostici(nomeDataSource, tipoDatabase, prop, log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds jndiName) Errore durante l'inizializzazione del driver dei messaggi diagnostici: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds jndiName) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverMsgDiagnostici(DataSource dataSourceObject, String tipoDatabase) throws DriverMsgDiagnosticiException {
        this(dataSourceObject, tipoDatabase, null);
    }

    public TransactionDriverMsgDiagnostici(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new DriverMsgDiagnosticiException("datasource is null");
            }
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds) Errore durante la ricerca del datasource: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverMsgDiagnostici = new DriverMsgDiagnostici(this.datasource, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds) Errore durante l'inizializzazione del driver dei messaggi diagnostici: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(ds) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverMsgDiagnostici(Connection connection, String tipoDatabase) throws DriverMsgDiagnosticiException {
        this(connection, tipoDatabase, null);
    }

    public TransactionDriverMsgDiagnostici(Connection connection, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        this.connection = connection;
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverMsgDiagnostici = new DriverMsgDiagnostici(this.connection, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection) Errore durante l'inizializzazione del driver dei messaggi diagnostici: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionDriverMsgDiagnostici(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase) throws DriverMsgDiagnosticiException {
        this(urlJDBC, driverJDBC, username, password, tipoDatabase, null);
    }

    public TransactionDriverMsgDiagnostici(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection url) Errore durante l'inizializzazione del logger: " + e.getMessage(), (Throwable)e);
        }
        try {
            Class.forName(driverJDBC);
            this.connection = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection url) Errore durante l'inizializzazione della connessione...", (Throwable)e);
        }
        try {
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException(TIPO_DB_NON_GESTITO);
            }
            this.tipoDatabase = tipoDatabase;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection url) Errore durante la ricerca del SQLQueryObject: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.driverMsgDiagnostici = new DriverMsgDiagnostici(this.connection, tipoDatabase, log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection url) Errore durante l'inizializzazione del driver dei messaggi diagnostici: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)log);
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("(connection url) Errore durante l'inizializzazione del dao factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public int countMessaggiDiagnostici(FiltroRicercaDiagnostici filtro) throws DriverMsgDiagnosticiException {
        String idTransazione = filtro.getIdTransazione();
        if (idTransazione == null) {
            idTransazione = filtro.getProperty("id_transazione");
        }
        if (idTransazione == null) {
            throw new DriverMsgDiagnosticiException("Metodo non implementato in questa versione (Identificativo di transazione non fornito)");
        }
        return this.countListaLog(filtro);
    }

    public List<MsgDiagnostico> getMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filtro) throws DriverMsgDiagnosticiException, DriverMsgDiagnosticiNotFoundException {
        String idTransazione = filtro.getIdTransazione();
        if (idTransazione == null) {
            idTransazione = filtro.getProperty("id_transazione");
        }
        if (idTransazione == null) {
            throw new DriverMsgDiagnosticiException("Metodo non implementato in questa versione (Identificativo di transazione non fornito)");
        }
        List<MsgDiagnostico> list = null;
        try {
            list = this.getListaLog(filtro);
        }
        catch (DriverMsgDiagnosticiNotFoundException driverMsgDiagnosticiNotFoundException) {
            // empty catch block
        }
        if (list == null || list.isEmpty()) {
            throw new DriverMsgDiagnosticiNotFoundException("Diagnostici non trovati che rispettano il filtro di ricerca (Filtro:" + filtro.toString() + ")");
        }
        return list;
    }

    public int deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter) throws DriverMsgDiagnosticiException {
        throw new DriverMsgDiagnosticiException("Metodo non implementato in questa versione");
    }

    private void setPropertiesEngine(List<MsgDiagnostico> listDiagnostici, String idTransazione) {
        int index = 1;
        for (MsgDiagnostico msgDiagnostico : listDiagnostici) {
            if (msgDiagnostico.getProperty("id_transazione") == null) {
                msgDiagnostico.addProperty("id_transazione", idTransazione);
            }
            int id = index * -1;
            int code = 0;
            try {
                code = Integer.parseInt(msgDiagnostico.getCodice());
                code *= -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (msgDiagnostico.getProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@") == null) {
                if (code < 0) {
                    msgDiagnostico.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", "" + code);
                } else {
                    msgDiagnostico.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", "" + id);
                }
            }
            ++index;
        }
    }

    public void close() throws DriverMsgDiagnosticiException {
        try {
            if (this.driverMsgDiagnostici != null) {
                this.driverMsgDiagnostici.close();
            }
        }
        finally {
            block10: {
                try {
                    if (this.connectionOpenViaJDBCInCostructor && this.connection != null && !this.connection.isClosed()) {
                        JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)this.connection, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    }
                }
                catch (Exception e) {
                    if (this.log == null) break block10;
                    this.log.error("Close connection failure: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Connection close(Connection con) {
        try {
            if (con != null) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)con, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                con = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    private JDBCServiceManager close(JDBCServiceManager transazioniServiceManager) {
        try {
            if (transazioniServiceManager != null) {
                transazioniServiceManager.close();
                transazioniServiceManager = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return transazioniServiceManager;
    }

    private List<Map<String, Object>> selectEsitoProtocollo(ITransazioneServiceSearch transazioneServiceSearch, IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List l = null;
        try {
            l = transazioneServiceSearch.select(expression, new IField[]{Transazione.model().ESITO, Transazione.model().PROTOCOLLO});
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l;
    }

    public int countListaLog(FiltroRicercaDiagnostici filtro) throws DriverMsgDiagnosticiException {
        int n;
        int size;
        JDBCServiceManager transazioniServiceManager;
        boolean closeConnection;
        Connection con;
        String idTransazione;
        block29: {
            int countSalvatiDatabase;
            InformazioniRecordDiagnostici informazioniSalvataggioDiagnostici;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            Object protocolloObj;
                            Map<String, Object> map;
                            idTransazione = filtro.getIdTransazione();
                            if (idTransazione == null) {
                                idTransazione = filtro.getProperty("id_transazione");
                            }
                            if (idTransazione == null) {
                                throw new DriverMsgDiagnosticiException("Identificativo di transazione non fornito");
                            }
                            con = null;
                            closeConnection = true;
                            transazioniServiceManager = null;
                            if (this.connection != null) {
                                con = this.connection;
                                closeConnection = false;
                            } else {
                                con = this.datasource.getConnection();
                            }
                            if (con == null) {
                                throw new DriverMsgDiagnosticiException("Connection non ottenuta");
                            }
                            transazioniServiceManager = (JDBCServiceManager)this.daoFactory.getServiceManager((IProjectInfo)new ProjectInfo(), con, true);
                            if (transazioniServiceManager == null) {
                                throw new DriverMsgDiagnosticiException("transazioniServiceManager is null");
                            }
                            ITransazioneServiceSearch transazioneServiceSearch = null;
                            if (filtro.getApplicativo() == null || "".equals(filtro.getApplicativo())) break block25;
                            transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
                            IPaginatedExpression expression = transazioneServiceSearch.newPaginatedExpression();
                            expression.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
                            expression.limit(1);
                            List<Map<String, Object>> l = this.selectEsitoProtocollo(transazioneServiceSearch, expression);
                            if (l == null || l.isEmpty() || (map = l.remove(0)) == null || map.isEmpty() || !((protocolloObj = map.get(Transazione.model().PROTOCOLLO.getFieldName())) instanceof String)) break block25;
                            String protocollo = (String)protocolloObj;
                            Object esitoObj = map.get(Transazione.model().ESITO.getFieldName());
                            if (!(esitoObj instanceof Integer)) break block25;
                            int esito = (Integer)esitoObj;
                            EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)protocollo);
                            EsitoTransazioneName esitoName = esitiProperties.getEsitoTransazioneName(Integer.valueOf(esito));
                            if (!EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoName)) break block25;
                            transazioniServiceManager = this.close(transazioniServiceManager);
                            if (closeConnection) {
                                con = this.close(con);
                            }
                            int n2 = this.driverMsgDiagnostici.countMessaggiDiagnostici(filtro);
                            this.close(transazioniServiceManager);
                            if (closeConnection) {
                                this.close(con);
                            }
                            return n2;
                        }
                        informazioniSalvataggioDiagnostici = this.getInformazioniSalvataggioDiagnostici(transazioniServiceManager, idTransazione, null);
                        transazioniServiceManager = this.close(transazioniServiceManager);
                        if (closeConnection) {
                            con = this.close(con);
                        }
                        if (informazioniSalvataggioDiagnostici != null) break block26;
                        int l = this.driverMsgDiagnostici.countMessaggiDiagnostici(filtro);
                        this.close(transazioniServiceManager);
                        if (closeConnection) {
                            this.close(con);
                        }
                        return l;
                    }
                    if (informazioniSalvataggioDiagnostici.isPresenti()) break block27;
                    int l = 0;
                    this.close(transazioniServiceManager);
                    if (closeConnection) {
                        this.close(con);
                    }
                    return l;
                }
                if (informazioniSalvataggioDiagnostici.isRicostruibili()) break block28;
                int l = this.driverMsgDiagnostici.countMessaggiDiagnostici(filtro);
                this.close(transazioniServiceManager);
                if (closeConnection) {
                    this.close(con);
                }
                return l;
            }
            size = informazioniSalvataggioDiagnostici.getDiagnostici().size();
            if (informazioniSalvataggioDiagnostici.getDiagnosticiExt() != null) {
                size += informazioniSalvataggioDiagnostici.getDiagnosticiExt().size();
            }
            if ((countSalvatiDatabase = this.driverMsgDiagnostici.countMessaggiDiagnostici(filtro)) <= 0) break block29;
            int n3 = size + countSalvatiDatabase;
            this.close(transazioniServiceManager);
            if (closeConnection) {
                this.close(con);
            }
            return n3;
        }
        try {
            n = size;
            this.close(transazioniServiceManager);
        }
        catch (Exception e) {
            try {
                throw new DriverMsgDiagnosticiException("Riscontrato errore durante la lettura (count) dei dati (Transazione:" + idTransazione + "): " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.close(transazioniServiceManager);
                if (closeConnection) {
                    this.close(con);
                }
                throw throwable;
            }
        }
        if (closeConnection) {
            this.close(con);
        }
        return n;
    }

    private Traccia getTraccia(RuoloMessaggio ruolo, TransactionDriverTracciamento driverTracciamento, Map<String, String> propertiesRicerca) throws DriverTracciamentoException {
        Traccia tr = null;
        try {
            tr = driverTracciamento.getTraccia(ruolo, propertiesRicerca);
        }
        catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            // empty catch block
        }
        return tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDiagnostici(FiltroRicercaDiagnosticiConPaginazione filter, List<MsgDiagnostico> list) throws DriverMsgDiagnosticiException {
        int offsetOriginal = -1;
        int limitOriginal = -1;
        offsetOriginal = filter.getOffset();
        filter.setOffset(0);
        limitOriginal = filter.getLimit();
        filter.setLimit(-1);
        try {
            List<MsgDiagnostico> listDB = this.driverMsgDiagnostici.getMessaggiDiagnostici(filter);
            if (listDB != null && !listDB.isEmpty()) {
                list.addAll(listDB);
            }
        }
        catch (DriverMsgDiagnosticiNotFoundException driverMsgDiagnosticiNotFoundException) {
        }
        finally {
            if (offsetOriginal >= 0) {
                filter.setOffset(offsetOriginal);
            }
            if (limitOriginal > 0) {
                filter.setLimit(limitOriginal);
            }
        }
    }

    private int parseSafe(String v) {
        int code = -1;
        try {
            code = Integer.parseInt(v);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    /*
     * Exception decompiling
     */
    private List<MsgDiagnostico> getListaLog(FiltroRicercaDiagnosticiConPaginazione filter) throws DriverMsgDiagnosticiNotFoundException, DriverMsgDiagnosticiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 14[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CredenzialeMittente getCredenzialeMittente(JDBCServiceManager transazioniServiceManager, String dbValueTokenClientId, String idTransazione) throws ServiceException, MultipleResultException, NotImplementedException {
        CredenzialeMittente credenzialeClientId = null;
        long id = -1L;
        try {
            IDBCredenzialeMittenteServiceSearch credenzialeMittenteServiceSearch = (IDBCredenzialeMittenteServiceSearch)transazioniServiceManager.getCredenzialeMittenteServiceSearch();
            id = Long.parseLong(dbValueTokenClientId);
            credenzialeClientId = (CredenzialeMittente)credenzialeMittenteServiceSearch.get(id);
            String msgDebug = "RECUPERATO CLIENT ID [" + String.valueOf(credenzialeClientId) + "] per id [" + idTransazione + "]";
            this.log.debug(msgDebug);
        }
        catch (NotFoundException notFound) {
            credenzialeClientId = new CredenzialeMittente();
            credenzialeClientId.setId(Long.valueOf(id));
            credenzialeClientId.setCredenziale("Informazione non disponibile");
        }
        return credenzialeClientId;
    }

    private InformazioniRecordDiagnostici getInformazioniSalvataggioDiagnostici(JDBCServiceManager transazioniServiceManager, String idTransazione, CredenzialiMittente credentialsFiller) throws DriverMsgDiagnosticiException {
        try {
            String dbValueTokenClientId;
            ITransazioneServiceSearch transazioneServiceSearch = transazioniServiceManager.getTransazioneServiceSearch();
            IPaginatedExpression pagExpr = transazioneServiceSearch.newPaginatedExpression();
            pagExpr.equals(Transazione.model().ID_TRANSAZIONE, (Object)idTransazione);
            List selectField = transazioneServiceSearch.select(pagExpr, new IField[]{Transazione.model().DIAGNOSTICI, Transazione.model().DIAGNOSTICI_LIST_1, Transazione.model().DIAGNOSTICI_LIST_2, Transazione.model().DIAGNOSTICI_LIST_EXT, Transazione.model().DIAGNOSTICI_EXT, Transazione.model().TOKEN_CLIENT_ID});
            if (selectField == null || selectField.isEmpty()) {
                throw new DriverMsgDiagnosticiException("Recupero informazioni per ricostruire i diagnostici non riuscito. Transazione con ID[" + idTransazione + "] non presente?");
            }
            if (selectField.size() > 1) {
                throw new DriverMsgDiagnosticiException("Recupero informazioni per ricostruire i diagnostici non riuscito] non riuscito. Trovata piu' di una Transazione con ID[" + idTransazione + "]?");
            }
            Map dbValue = (Map)selectField.get(0);
            String dbValueMetaInf = this.readValue(dbValue, Transazione.model().DIAGNOSTICI, idTransazione);
            if (dbValueMetaInf == null) {
                return null;
            }
            String dbValueList1 = this.readValue(dbValue, Transazione.model().DIAGNOSTICI_LIST_1, idTransazione);
            String dbValueList2 = this.readValue(dbValue, Transazione.model().DIAGNOSTICI_LIST_2, idTransazione);
            String dbValueListExt = this.readValue(dbValue, Transazione.model().DIAGNOSTICI_LIST_EXT, idTransazione);
            String dbValueDatiExt = this.readValue(dbValue, Transazione.model().DIAGNOSTICI_EXT, idTransazione);
            InformazioniRecordDiagnostici info = InformazioniRecordDiagnostici.convertoFromDBColumnValue(dbValueMetaInf, dbValueList1, dbValueList2, dbValueListExt, dbValueDatiExt);
            String msgDebug = "RECUPERO [" + info.toString() + "]";
            this.log.debug(msgDebug);
            if (credentialsFiller != null && (dbValueTokenClientId = this.readValue(dbValue, Transazione.model().TOKEN_CLIENT_ID, idTransazione)) != null && StringUtils.isNotEmpty((CharSequence)dbValueTokenClientId)) {
                CredenzialeMittente credenzialeClientId = this.getCredenzialeMittente(transazioniServiceManager, dbValueTokenClientId, idTransazione);
                credentialsFiller.setTokenClientId(credenzialeClientId);
            }
            return info;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Riscontrato errore durante la lettura dei dati (Transazione:" + idTransazione + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private String readValue(Map<String, Object> dbValue, IField field, String idTransazione) throws DriverMsgDiagnosticiException {
        Object objectDBValue = dbValue.get(field.getFieldName());
        String dbValueAsString = null;
        if (objectDBValue instanceof ObjectUtils.Null) {
            objectDBValue = null;
        }
        if (objectDBValue != null) {
            if (!(objectDBValue instanceof String)) {
                throw new DriverMsgDiagnosticiException("Recupero informazioni per ricostruire i diagnostici non riuscito. Trovato campo '" + field.getFieldName() + "' di tipo [" + objectDBValue.getClass().getName() + "] differente da quello atteso [" + String.class.getName() + "] per la Transazione con ID[" + idTransazione + "]?");
            }
            dbValueAsString = (String)objectDBValue;
        }
        return dbValueAsString;
    }
}

