/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoException;
import org.openspcoop2.utils.resources.MapReader;

public class MsgDiagnosticoOpenSPCoopProtocolAppender
implements IDiagnosticProducer {
    private static HashMap<String, IDiagnosticProducer> mappingProtocolToAppenders = new HashMap();

    private static synchronized void initProtocolAppender(String protocol, OpenspcoopAppender appenderProperties) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IDiagnosticProducer msgDiag = p.createDiagnosticProducer();
            if (msgDiag == null) {
                throw new ProtocolException("IDiagnosticProducer not defined for protocol [" + protocol + "]");
            }
            try {
                msgDiag.initializeAppender(appenderProperties);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            mappingProtocolToAppenders.put(protocol, msgDiag);
        }
    }

    private static IDiagnosticProducer getProtocolAppender(String protocol) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            throw new ProtocolException("ProtocolAppender per protocollo[" + protocol + "] non inizializzato");
        }
        return mappingProtocolToAppenders.get(protocol);
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws MsgDiagnosticoException {
        try {
            MapReader table = ProtocolFactoryManager.getInstance().getProtocolFactories();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String protocol = (String)keys.nextElement();
                MsgDiagnosticoOpenSPCoopProtocolAppender.initProtocolAppender(protocol, appenderProperties);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void log(Connection conOpenSPCoopPdD, MsgDiagnostico msgDiagnostico) throws MsgDiagnosticoException {
        try {
            if (msgDiagnostico.getProtocollo() != null) {
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(msgDiagnostico.getProtocollo()).log(conOpenSPCoopPdD, msgDiagnostico);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void isAlive() throws CoreException {
        try {
            Enumeration protocols = ProtocolFactoryManager.getInstance().getProtocolNames();
            while (protocols.hasMoreElements()) {
                String protocol = (String)protocols.nextElement();
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(protocol).isAlive();
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return null;
    }
}

