/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.MsgDiagnosticiInstanceProperties;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.slf4j.Logger;

public class MsgDiagnosticiProperties {
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_TYPE = "DYNAMIC_INFO_TYPE";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_VALUE = "DYNAMIC_INFO_VALUE";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_SEPARATOR = "#_#";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_DIAG_SEPARATOR = "###";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_TYPE_SEPARATOR = " ";
    public static final String DIAGNOSTIC_TYPE_POLICY_CONTROLLO_TRAFFICO = "CT";
    public static final String NON_PRESENTE = "-";
    public static final String SEPARATOR = " ";
    private Logger log = OpenSPCoop2Startup.initialize ? OpenSPCoop2Logger.getLoggerOpenSPCoopCore() : LoggerWrapperFactory.getLogger(MsgDiagnosticiProperties.class);
    private MsgDiagnosticiInstanceProperties reader;
    private static MsgDiagnosticiProperties msgDiagnosticiProperties = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level0 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level1 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level2 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level3 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level4 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level5 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level6 = null;
    private static Integer filtroMsgDiagnosticoOpenSPCoop2level7 = null;
    private static Boolean initMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader livelliMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader codiciMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader messaggiMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader codiciIdentificativiFunzione = null;
    private static PropertiesReader mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = null;
    public static List<String> MSG_DIAGNOSTICI_WARNING = new ArrayList<String>();
    public static List<String> MSG_DIAGNOSTICI_ERRORE_CONNETTORE;
    public static List<String> MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE;
    public static final String MSG_DIAG_RICEZIONE_CONTENUTI_APPLICATIVI = "ricezioneContenutiApplicativi.";
    public static final String MSG_DIAG_IMBUSTAMENTO = "imbustamentoBusta.";
    public static final String MSG_DIAG_IMBUSTAMENTO_RISPOSTE = "imbustamentoRispostaBusta.";
    public static final String MSG_DIAG_INOLTRO_BUSTE = "inoltroBuste.";
    public static final String MSG_DIAG_RICEZIONE_BUSTE = "ricezioneBuste.";
    public static final String MSG_DIAG_SBUSTAMENTO = "sbustamentoBusta.";
    public static final String MSG_DIAG_SBUSTAMENTO_RISPOSTE = "sbustamentoRispostaBusta.";
    public static final String MSG_DIAG_CONSEGNA_CONTENUTI_APPLICATIVI = "consegnaContenutiApplicativi.";
    public static final String MSG_DIAG_INTEGRATION_MANAGER = "integrationManager.";
    public static final String MSG_DIAG_TRACCIAMENTO = "tracciamento.";
    public static final String MSG_DIAG_TIMER_GESTORE_RISCONTRI_RICEVUTE = "timerGestoreRiscontriRicevute.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI = "timerGestoreMessaggi.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI_INCONSISTENTI = "timerGestoreMessaggiInconsistenti.";
    public static final String MSG_DIAG_TIMER_GESTORE_REPOSITORY_BUSTE = "timerGestoreRepositoryBuste.";
    public static final String MSG_DIAG_TIMER_MONITORAGGIO_RISORSE = "timerMonitoraggioRisorse.";
    public static final String MSG_DIAG_TIMER_THRESHOLD = "timerThreshold.";
    public static final String MSG_DIAG_TIMER_CONSEGNA_CONTENUTI_APPLICATIVI = "timerConsegnaContenutiApplicativi.";
    public static final String MSG_DIAG_TIMER_STATISTICHE = "timerStatistiche.";
    public static final String MSG_DIAG_TIMER_GESTORE_CHIAVI_PDND = "timerGestoreChiaviPDND.";
    public static final String MSG_DIAG_TIMER_GESTORE_OPERAZIONI_ASINCRONE = "timerGestoreOperazioniAsincrone.";
    public static final String MSG_DIAG_TIMER_SVECCHIAMENTO_OPERAZIONI_ASINCRONE = "timerSvecchiamentoOperazioniAsincrone.";
    public static final String MSG_DIAG_TIMER_FILESYSTEM_RECOVERY = "timerFileSystemRecovery.";
    public static final String MSG_DIAG_OPENSPCOOP_STARTUP = "openspcoopStartup.";
    public static final String MSG_DIAG_ALL = "all.";
    public static final String MSG_DIAG_IDENTIFICAZIONE_DINAMICA_AZIONE_NON_RIUSCITA = "identificazioneDinamicaAzioneNonRiuscita";
    public static final String MSG_DIAG_REGISTRO_RICERCA_SERVIZIO_FALLITA = "registroServizi.ricercaServizioFallita";
    public static final String MSG_DIAG_VALIDAZIONE_NON_RIUSCITA = "validazioneNonRiuscita";
    public static final String MSG_DIAG_VALIDAZIONE_RILEVATA_BUSTA_NON_CORRETTA = "validazioneBusta.bustaNonCorretta";
    public static final String MSG_DIAG_VALIDAZIONE_CONTENUTI_RISPOSTA_DISABILITATA = "validazioneContenutiApplicativiRispostaDisabilitata";
    public static final String MSG_DIAG_CONSEGNA_RISPOSTA_APPLICATIVA = "consegnaRispostaApplicativa";
    public static final String MSG_DIAG_CONSEGNA_CON_ERRORE = "consegnaConErrore";
    public static final String MSG_DIAG_CONSEGNA_CON_ERRORE_MITTENTE_ANONIMO = "consegnaConErrore.mittenteAnonimo";
    public static final String MSG_DIAG_CONSEGNA_EFFETTUATA = "consegnaEffettuata";
    public static final String MSG_DIAG_CONSEGNA_EFFETTUATA_MITTENTE_ANONIMO = "consegnaEffettuata.mittenteAnonimo";
    public static final String MSG_DIAG_CONSEGNA_IN_ORDINE_MESSAGGIO_FUORI_ORDINE = "consegnaInOrdine.messaggioFuoriOrdine";
    public static final String MSG_DIAG_INOLTRO_CON_ERRORE = "inoltroConErrore";
    public static final String MSG_DIAG_RICEZIONE_SOAP_FAULT = "ricezioneSoapFault";
    public static final String MSG_DIAG_RICEZIONE_REST_PROBLEM = "ricezioneRestProblem";
    public static final String MSG_DIAG_RICEZIONE_SOAP_MESSAGE_HEADER_PROTOCOLLO_NON_PRESENTE = "ricezioneSoapMessage.headerProtocolloNonPresente";
    public static final String MSG_DIAG_PARSING_EXCEPTION_RICHIESTA = "parsingExceptionRichiesta";
    public static final String MSG_DIAG_PARSING_EXCEPTION_RISPOSTA = "parsingExceptionRisposta";
    public static final String MSG_DIAG_ROUTING_TABLE_ESAMINA_IN_CORSO_FALLITA = "routingTable.esaminaInCorsoFallita";
    private static final String[] MSG_DIAGNOSTICI_PERSONALIZZATI;
    private static final String PREFIX_MSG_DIAGNOSTICO = "org.openspcoop2.pdd.msgdiagnostico.";
    private static final String SUFFIX_LIVELLO_MSG_DIAGNOSTICO = ".livello";
    private static final String SUFFIX_CODICE_MSG_DIAGNOSTICO = ".codice";
    private static final String SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO = ".messaggio";
    private static final String SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO = ".codiceModulo";
    private static final String PREFIX_UNKNOW_CODE_PREFIX = "org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.";
    private static final String PREFIX_UNKNOW_CODE_SUFFIX = ".codice";
    private static boolean codiceDiagnosticoInitialized;
    private static String codiceDiagnosticoFatal;
    private static String codiceDiagnosticoErrorProtocol;
    private static String codiceDiagnosticoErrorIntegration;
    private static String codiceDiagnosticoInfoProtocol;
    private static String codiceDiagnosticoInfoIntegration;
    private static String codiceDiagnosticoDebugLow;
    private static String codiceDiagnosticoDebugMedium;
    private static String codiceDiagnosticoDebugHigh;

    private void logError(String msgErrore, Exception e) {
        if (this.log != null) {
            this.log.error(msgErrore, (Throwable)e);
        }
    }

    private void logError(String msgErrore) {
        if (this.log != null) {
            this.log.error(msgErrore);
        }
    }

    private static void logError(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
    }

    private static void logInfo(Logger log, String msg) {
        if (log != null) {
            log.info(msg);
        }
    }

    private MsgDiagnosticiProperties(String location, String confDir) throws CoreException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : MsgDiagnosticiProperties.class.getResourceAsStream("/govway.msgDiagnostici.properties");
            if (properties == null) {
                throw new CoreException("File '/govway.msgDiagnostici.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.logError("Riscontrato errore durante la lettura del file 'govway.msgDiagnostici.properties': \n\n" + e.getMessage());
            throw new CoreException("MsgDiagnosticiProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.reader = new MsgDiagnosticiInstanceProperties(propertiesReader, this.log, confDir);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean initialize(String location, String confDir) {
        try {
            if (msgDiagnosticiProperties == null) {
                MsgDiagnosticiProperties.initializeEngine(location, confDir);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static synchronized void initializeEngine(String location, String confDir) throws CoreException {
        if (msgDiagnosticiProperties == null) {
            msgDiagnosticiProperties = new MsgDiagnosticiProperties(location, confDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MsgDiagnosticiProperties getInstance() {
        if (msgDiagnosticiProperties != null) return msgDiagnosticiProperties;
        Class<MsgDiagnosticiProperties> clazz = MsgDiagnosticiProperties.class;
        synchronized (MsgDiagnosticiProperties.class) {
            if (msgDiagnosticiProperties != null) return msgDiagnosticiProperties;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public static void updateLocalImplementation(Properties prop) {
        MsgDiagnosticiProperties.msgDiagnosticiProperties.reader.setLocalObjectImplementation(prop);
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level0() {
        if (filtroMsgDiagnosticoOpenSPCoop2level0 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level0(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level0;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level0(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level0 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.0");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level0 = LogLevels.toIntervalloLog4J(0);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level0 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level0 < 0 || filtroMsgDiagnosticoOpenSPCoop2level0 > 9999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [0,9999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.0': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level0 = LogLevels.toIntervalloLog4J(0);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level1() {
        if (filtroMsgDiagnosticoOpenSPCoop2level1 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level1(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level1;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level1(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level1 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.1");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level1 = LogLevels.toIntervalloLog4J(1);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level1 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level1 < 1 || filtroMsgDiagnosticoOpenSPCoop2level1 > 19999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [1,19999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.1': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level1 = LogLevels.toIntervalloLog4J(1);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level2() {
        if (filtroMsgDiagnosticoOpenSPCoop2level2 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level2(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level2;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level2(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level2 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.2");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level2 = LogLevels.toIntervalloLog4J(2);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level2 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level2 < 10001 || filtroMsgDiagnosticoOpenSPCoop2level2 > 29999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [10001,29999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.2': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level2 = LogLevels.toIntervalloLog4J(2);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level3() {
        if (filtroMsgDiagnosticoOpenSPCoop2level3 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level3(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level3;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level3(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level3 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.3");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level3 = LogLevels.toIntervalloLog4J(3);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level3 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level3 < 20001 || filtroMsgDiagnosticoOpenSPCoop2level3 > 39999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [20001,39999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.3': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level3 = LogLevels.toIntervalloLog4J(3);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level4() {
        if (filtroMsgDiagnosticoOpenSPCoop2level4 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level4(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level4;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level4(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level4 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.4");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level4 = LogLevels.toIntervalloLog4J(4);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level4 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level4 < 30001 || filtroMsgDiagnosticoOpenSPCoop2level4 > 49999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [30001,49999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.4': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level4 = LogLevels.toIntervalloLog4J(4);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level5() {
        if (filtroMsgDiagnosticoOpenSPCoop2level5 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level5(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level5;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level5(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level5 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.5");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level5 = LogLevels.toIntervalloLog4J(5);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level5 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level5 < 40001 || filtroMsgDiagnosticoOpenSPCoop2level5 > 59999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [40001,59999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.5': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level5 = LogLevels.toIntervalloLog4J(5);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level6() {
        if (filtroMsgDiagnosticoOpenSPCoop2level6 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level6(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level6;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level6(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level6 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.6");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level6 = LogLevels.toIntervalloLog4J(6);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level6 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level6 < 50001 || filtroMsgDiagnosticoOpenSPCoop2level6 > 69999) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [50001,69999]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.6': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level6 = LogLevels.toIntervalloLog4J(6);
            }
        }
    }

    int getFiltroMsgDiagnosticoOpenSPCoop2level7() {
        if (filtroMsgDiagnosticoOpenSPCoop2level7 == null) {
            MsgDiagnosticiProperties.initFiltroMsgDiagnosticoOpenSPCoop2level7(this.reader, this.log);
        }
        return filtroMsgDiagnosticoOpenSPCoop2level7;
    }

    private static synchronized void initFiltroMsgDiagnosticoOpenSPCoop2level7(MsgDiagnosticiInstanceProperties reader, Logger log) {
        if (filtroMsgDiagnosticoOpenSPCoop2level7 == null) {
            try {
                String value = null;
                value = reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.7");
                if (value == null) {
                    filtroMsgDiagnosticoOpenSPCoop2level7 = LogLevels.toIntervalloLog4J(7);
                } else {
                    filtroMsgDiagnosticoOpenSPCoop2level7 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnosticoOpenSPCoop2level7 < 60001 || filtroMsgDiagnosticoOpenSPCoop2level7 > 70000) {
                        throw new CoreException("Il valore della proprieta' deve essere compreso nell'intervallo [60001,70000]");
                    }
                }
            }
            catch (Exception e) {
                MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.7': " + e.getMessage());
                filtroMsgDiagnosticoOpenSPCoop2level7 = LogLevels.toIntervalloLog4J(7);
            }
        }
    }

    public int getValoreFiltroFromValoreOpenSPCoop2(int livello) {
        if (livello == 0) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level0();
        }
        if (livello == 1) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level1();
        }
        if (livello == 2) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level2();
        }
        if (livello == 3) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level3();
        }
        if (livello == 4) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level4();
        }
        if (livello == 5) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level5();
        }
        if (livello == 6) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level6();
        }
        if (livello == 7) {
            return this.getFiltroMsgDiagnosticoOpenSPCoop2level7();
        }
        return livello;
    }

    public boolean checkValoriFiltriMsgDiagnostici(Logger log) {
        int openspcoop2level7;
        int openspcoop2level6;
        int openspcoop2level5;
        int openspcoop2level4;
        int openspcoop2level3;
        int openspcoop2level2;
        int openspcoop2level1;
        int openspcoop2level0 = this.getFiltroMsgDiagnosticoOpenSPCoop2level0();
        if (openspcoop2level0 != LogLevels.toIntervalloLog4J(0)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 0) al valore openspcoop: " + openspcoop2level0);
        }
        if ((openspcoop2level1 = this.getFiltroMsgDiagnosticoOpenSPCoop2level1()) <= openspcoop2level0) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 1 (valore: " + openspcoop2level1 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 0 (valore: " + openspcoop2level0 + ").");
            return false;
        }
        if (openspcoop2level1 != LogLevels.toIntervalloLog4J(1)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 1) al valore openspcoop: " + openspcoop2level1);
        }
        if ((openspcoop2level2 = this.getFiltroMsgDiagnosticoOpenSPCoop2level2()) <= openspcoop2level1) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 2 (valore: " + openspcoop2level2 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 1 (valore: " + openspcoop2level1 + ").");
            return false;
        }
        if (openspcoop2level2 != LogLevels.toIntervalloLog4J(2)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 2) al valore openspcoop: " + openspcoop2level2);
        }
        if ((openspcoop2level3 = this.getFiltroMsgDiagnosticoOpenSPCoop2level3()) <= openspcoop2level2) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 3 (valore: " + openspcoop2level3 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 2 (valore: " + openspcoop2level2 + ").");
            return false;
        }
        if (openspcoop2level3 != LogLevels.toIntervalloLog4J(3)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 3) al valore openspcoop: " + openspcoop2level3);
        }
        if ((openspcoop2level4 = this.getFiltroMsgDiagnosticoOpenSPCoop2level4()) <= openspcoop2level3) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 4 (valore: " + openspcoop2level4 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 3 (valore: " + openspcoop2level3 + ").");
            return false;
        }
        if (openspcoop2level4 != LogLevels.toIntervalloLog4J(4)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 4) al valore openspcoop: " + openspcoop2level4);
        }
        if ((openspcoop2level5 = this.getFiltroMsgDiagnosticoOpenSPCoop2level5()) <= openspcoop2level4) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 5 (valore: " + openspcoop2level5 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 4 (valore: " + openspcoop2level4 + ").");
            return false;
        }
        if (openspcoop2level5 != LogLevels.toIntervalloLog4J(5)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 5) al valore openspcoop: " + openspcoop2level5);
        }
        if ((openspcoop2level6 = this.getFiltroMsgDiagnosticoOpenSPCoop2level6()) <= openspcoop2level5) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 6 (valore: " + openspcoop2level6 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 5 (valore: " + openspcoop2level5 + ").");
            return false;
        }
        if (openspcoop2level6 != LogLevels.toIntervalloLog4J(6)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 6) al valore openspcoop: " + openspcoop2level6);
        }
        if ((openspcoop2level7 = this.getFiltroMsgDiagnosticoOpenSPCoop2level7()) <= openspcoop2level6) {
            this.logError("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 7 (valore: " + openspcoop2level7 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 6 (valore: " + openspcoop2level6 + ").");
            return false;
        }
        if (openspcoop2level7 != LogLevels.toIntervalloLog4J(7)) {
            MsgDiagnosticiProperties.logInfo(log, "Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 7) al valore openspcoop: " + openspcoop2level7);
        }
        return true;
    }

    public static PropertiesReader getLivelliMsgDiagnosticiPersonalizzati() {
        return livelliMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getCodiciMsgDiagnosticiPersonalizzati() {
        return codiciMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getMessaggiMsgDiagnosticiPersonalizzati() {
        return messaggiMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getCodiciIdentificativiFunzione() {
        return codiciIdentificativiFunzione;
    }

    public static PropertiesReader getMappingCodiceToKeywordMsgDiagnosticiPersonalizzati() {
        return mappingCodiceToKeywordMsgDiagnosticiPersonalizzati;
    }

    public boolean initializeMsgDiagnosticiPersonalizzati() {
        if (initMsgDiagnosticiPersonalizzati == null) {
            return MsgDiagnosticiProperties.initializeMsgDiagnosticiPersonalizzatiEngine(this.reader, this.log);
        }
        return initMsgDiagnosticiPersonalizzati != null && initMsgDiagnosticiPersonalizzati != false;
    }

    private static synchronized boolean initializeMsgDiagnosticiPersonalizzatiEngine(MsgDiagnosticiInstanceProperties reader, Logger log) {
        try {
            if (initMsgDiagnosticiPersonalizzati == null) {
                String key;
                Properties tmpLivelliMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmpCodiciMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmpCodiciIdentificativiFunzione = new Properties();
                Properties tmpMessaggiMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmpMappingCodiceToKeywordMsgDiagnosticiPersonalizzati = new Properties();
                Properties msgDiagnostici = reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                Enumeration<Object> nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    key = (String)nomi.nextElement();
                    if (!key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    String value = msgDiagnostici.getProperty(key);
                    String[] tmpSplit = key.split("\\.");
                    String modulo = tmpSplit[0].trim();
                    if (tmpCodiciIdentificativiFunzione.containsKey(modulo)) {
                        throw new CoreException("Per Il modulo funzionale [" + modulo + "] sono stati definiti piu' codici??");
                    }
                    if (tmpCodiciIdentificativiFunzione.containsValue(value)) {
                        throw new CoreException("Il codice fornito (" + modulo + "=" + value + ") e' gia' utilizzato da un altro modulo funzionale");
                    }
                    tmpCodiciIdentificativiFunzione.put(modulo, value);
                }
                msgDiagnostici = reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    String valore;
                    String chiave;
                    key = (String)nomi.nextElement();
                    if (key.endsWith(SUFFIX_LIVELLO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_LIVELLO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        try {
                            Integer v = Integer.parseInt(valore);
                            if (v.toString() != null) {
                                // empty if block
                            }
                            tmpLivelliMsgDiagnosticiPersonalizzati.put(chiave, valore);
                            continue;
                        }
                        catch (Exception e) {
                            throw new CoreException("Valore della proprieta' [" + key + "] non valido [" + valore + "]: " + e.getMessage());
                        }
                    }
                    if (key.endsWith(".codice")) {
                        chiave = key.substring(0, key.length() - ".codice".length());
                        valore = msgDiagnostici.getProperty(key);
                        String[] tmp = chiave.split("\\.");
                        String moduloFunzionale = tmp[0].trim();
                        Object codiceModuloFunzionaleObject = tmpCodiciIdentificativiFunzione.get(moduloFunzionale);
                        if (codiceModuloFunzionaleObject == null) {
                            throw new CoreException("Per il modulo funzionale [" + moduloFunzionale + "] non e' stato definito il codice");
                        }
                        String codiceModuloFunzionale = (String)codiceModuloFunzionaleObject;
                        String codiceDefinitivo = codiceModuloFunzionale + valore;
                        if (tmpCodiciMsgDiagnosticiPersonalizzati.containsValue(codiceDefinitivo)) {
                            throw new CoreException("Propriet\u00e0 " + chiave + " contiene un codice [" + valore + "] gia' definito per un altro messaggio diagnostico del modulo funzionale " + moduloFunzionale + " (" + codiceModuloFunzionale + ")");
                        }
                        tmpCodiciMsgDiagnosticiPersonalizzati.put(chiave, codiceDefinitivo);
                        tmpMappingCodiceToKeywordMsgDiagnosticiPersonalizzati.put(codiceDefinitivo, chiave);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        tmpMessaggiMsgDiagnosticiPersonalizzati.put(chiave, valore);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    throw new CoreException("Proprieta' malformata [" + key + "]");
                }
                for (int i = 0; i < MSG_DIAGNOSTICI_PERSONALIZZATI.length; ++i) {
                    String prefix = PREFIX_MSG_DIAGNOSTICO + MSG_DIAGNOSTICI_PERSONALIZZATI[i];
                    String livello = prefix + SUFFIX_LIVELLO_MSG_DIAGNOSTICO;
                    String codice = prefix + ".codice";
                    String messaggio = prefix + SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO;
                    if (!tmpLivelliMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new CoreException("Proprieta' " + livello + " non definita");
                    }
                    if (!tmpCodiciMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new CoreException("Proprieta' " + codice + " non definita");
                    }
                    if (tmpMessaggiMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) continue;
                    throw new CoreException("Proprieta' " + messaggio + " non definita");
                }
                livelliMsgDiagnosticiPersonalizzati = new PropertiesReader(tmpLivelliMsgDiagnosticiPersonalizzati, true);
                codiciMsgDiagnosticiPersonalizzati = new PropertiesReader(tmpCodiciMsgDiagnosticiPersonalizzati, true);
                messaggiMsgDiagnosticiPersonalizzati = new PropertiesReader(tmpMessaggiMsgDiagnosticiPersonalizzati, true);
                mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = new PropertiesReader(tmpMappingCodiceToKeywordMsgDiagnosticiPersonalizzati, true);
                codiciIdentificativiFunzione = new PropertiesReader(tmpCodiciIdentificativiFunzione, true);
                initMsgDiagnosticiPersonalizzati = true;
            }
            return true;
        }
        catch (Exception e) {
            MsgDiagnosticiProperties.logError(log, "Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage());
            if (OpenSPCoop2Logger.getLoggerOpenSPCoopCore() != null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage(), (Throwable)e);
            }
            livelliMsgDiagnosticiPersonalizzati = null;
            codiciMsgDiagnosticiPersonalizzati = null;
            messaggiMsgDiagnosticiPersonalizzati = null;
            mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = null;
            codiciIdentificativiFunzione = null;
            return false;
        }
    }

    public Integer getLivello(String modulo, String keyLivelloPersonalizzato) {
        try {
            String livello = livelliMsgDiagnosticiPersonalizzati.getValue(modulo + keyLivelloPersonalizzato);
            if (livello != null) {
                return Integer.parseInt(livello);
            }
            return -1;
        }
        catch (Exception e) {
            this.logError("Errore durante l'esecuzione del metodo getLivello(" + modulo + "," + keyLivelloPersonalizzato + ")", e);
            return -1;
        }
    }

    public String getCodice(String modulo, String keyCodicePersonalizzato) {
        try {
            return codiciMsgDiagnosticiPersonalizzati.getValue(modulo + keyCodicePersonalizzato);
        }
        catch (Exception e) {
            this.logError("Errore durante l'esecuzione del metodo getCodice(" + modulo + "," + keyCodicePersonalizzato + ")", e);
            return null;
        }
    }

    public String getMessaggio(String modulo, String keyMsgPersonalizzato) {
        try {
            return messaggiMsgDiagnosticiPersonalizzati.getValue(modulo + keyMsgPersonalizzato);
        }
        catch (Exception e) {
            this.logError("Errore durante l'esecuzione del metodo getMessaggio(" + modulo + "," + keyMsgPersonalizzato + ")", e);
            return null;
        }
    }

    public String getKeyMessaggio(String codice) throws CoreException {
        if (mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.containsKey((Object)codice)) {
            String keyword = null;
            try {
                keyword = mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.getValue(codice);
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            if (keyword == null) {
                throw new CoreException("MsgDiagnostico con codice [" + codice + "] non registrato?");
            }
            return keyword;
        }
        throw new CoreException("MsgDiagnostico con codice [" + codice + "] non registrato");
    }

    public String getModulo(String codice) throws CoreException {
        Enumeration moduli = codiciIdentificativiFunzione.propertyNames();
        while (moduli.hasMoreElements()) {
            String modulo = (String)moduli.nextElement();
            String codiceModulo = null;
            try {
                codiceModulo = codiciIdentificativiFunzione.getValue(modulo);
            }
            catch (Exception e) {
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            if (codiceModulo == null) {
                throw new CoreException("Modulo [" + modulo + "] senza un codice registrato");
            }
            if (!codiceModulo.equals(codice)) continue;
            return modulo;
        }
        throw new CoreException("Modulo con codice [" + codice + "] non registrato");
    }

    private static synchronized void initCodiceDiagnostico(MsgDiagnosticiInstanceProperties reader) throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            codiceDiagnosticoFatal = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.fatal.codice");
            codiceDiagnosticoErrorProtocol = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.errorProtocol.codice");
            codiceDiagnosticoErrorIntegration = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.errorIntegration.codice");
            codiceDiagnosticoInfoProtocol = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.infoProtocol.codice");
            codiceDiagnosticoInfoIntegration = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.infoIntegration.codice");
            codiceDiagnosticoDebugLow = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugLow.codice");
            codiceDiagnosticoDebugMedium = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugMedium.codice");
            codiceDiagnosticoDebugHigh = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugHigh.codice");
            codiceDiagnosticoInitialized = true;
        }
    }

    public String getCodiceDiagnosticoFatal() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoFatal;
    }

    public String getCodiceDiagnosticoErrorProtocol() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoErrorProtocol;
    }

    public String getCodiceDiagnosticoErrorIntegration() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoErrorIntegration;
    }

    public String getCodiceDiagnosticoInfoProtocol() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoInfoProtocol;
    }

    public String getCodiceDiagnosticoInfoIntegration() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoInfoIntegration;
    }

    public String getCodiceDiagnosticoDebugLow() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugLow;
    }

    public String getCodiceDiagnosticoDebugMedium() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugMedium;
    }

    public String getCodiceDiagnosticoDebugHigh() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugHigh;
    }

    static {
        MSG_DIAGNOSTICI_WARNING.add("001069");
        MSG_DIAGNOSTICI_WARNING.add("001072");
        MSG_DIAGNOSTICI_WARNING.add("001084");
        MSG_DIAGNOSTICI_WARNING.add("001091");
        MSG_DIAGNOSTICI_WARNING.add("001098");
        MSG_DIAGNOSTICI_WARNING.add("001108");
        MSG_DIAGNOSTICI_WARNING.add("001122");
        MSG_DIAGNOSTICI_WARNING.add("001123");
        MSG_DIAGNOSTICI_WARNING.add("003060");
        MSG_DIAGNOSTICI_WARNING.add("004092");
        MSG_DIAGNOSTICI_WARNING.add("004095");
        MSG_DIAGNOSTICI_WARNING.add("004107");
        MSG_DIAGNOSTICI_WARNING.add("004114");
        MSG_DIAGNOSTICI_WARNING.add("004121");
        MSG_DIAGNOSTICI_WARNING.add("004131");
        MSG_DIAGNOSTICI_WARNING.add("004145");
        MSG_DIAGNOSTICI_WARNING.add("004146");
        MSG_DIAGNOSTICI_WARNING.add("004176");
        MSG_DIAGNOSTICI_WARNING.add("007059");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE = new ArrayList<String>();
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("003008");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("003013");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("003059");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("007013");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("007014");
        MSG_DIAGNOSTICI_ERRORE_CONNETTORE.add("007058");
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE = new ArrayList<String>();
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.add("001008");
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.add("001033");
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.add("004007");
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.add("004008");
        MSG_DIAGNOSTICI_SEGNALA_GENERATA_RISPOSTA_ERRORE.add("004080");
        MSG_DIAGNOSTICI_PERSONALIZZATI = new String[]{"ricezioneContenutiApplicativi.correlazioneApplicativaEsistente", "ricezioneContenutiApplicativi.correlazioneApplicativaInstaurata", "ricezioneContenutiApplicativi.ricevutaRichiestaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaOkEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaKoEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaVuota", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaFallita", "ricezioneContenutiApplicativi.timeoutRicezioneRisposta", "ricezioneContenutiApplicativi.richiestaContenenteBusta", "ricezioneContenutiApplicativi.portaDelegataNonEsistente", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteCredenzialiFallita", "ricezioneContenutiApplicativi.identificazioneDinamicaAzioneNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.nonAutorizzato", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.contenuto.nonAutorizzato", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiRichiestaNonRiuscita", "ricezioneContenutiApplicativi.portaDelegataInvocabilePerRiferimento.riferimentoNonPresente", "ricezioneContenutiApplicativi.portaDelegataInvocabileNormalmente.riferimentoPresente", "ricezioneContenutiApplicativi.funzionalitaScartaBodyNonEffettuabile", "ricezioneContenutiApplicativi.funzionalitaAllegaBodyNonEffettuabile", "ricezioneContenutiApplicativi.headerIntegrazione.letturaFallita", "ricezioneContenutiApplicativi.messaggioInGestione", "ricezioneContenutiApplicativi.messaggioInGestione.marcatoDaEliminare", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.soapEnvelopeNamespace.versionMismatch", "ricezioneContenutiApplicativi.gestoreCredenziali.errore", "ricezioneContenutiApplicativi.gestoreCredenziali.nuoveCredenziali", "ricezioneContenutiApplicativi.contentType.notDefined", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaEffettuata", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaVuota", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaFallita", "ricezioneContenutiApplicativi.localForward.logInfo", "ricezioneContenutiApplicativi.localForward.configError", "ricezioneContenutiApplicativi.protocolli.tipoSoggetto.fruitore.unsupported", "ricezioneContenutiApplicativi.protocolli.tipoSoggetto.erogatore.unsupported", "ricezioneContenutiApplicativi.protocolli.tipoServizio.unsupported", "ricezioneContenutiApplicativi.ricezioneRichiesta.firstLog", "ricezioneContenutiApplicativi.ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio", "ricezioneContenutiApplicativi.ricezioneRichiesta.elaborazioneDati.inCorso", "ricezioneContenutiApplicativi.ricezioneRichiesta.elaborazioneDati.completata", "ricezioneContenutiApplicativi.autorizzazioneDisabilitata", "ricezioneContenutiApplicativi.autorizzazioneInCorso", "ricezioneContenutiApplicativi.autorizzazioneEffettuata", "ricezioneContenutiApplicativi.autorizzazioneContenutiApplicativiDisabilitata", "ricezioneContenutiApplicativi.autorizzazioneContenutiApplicativiInCorso", "ricezioneContenutiApplicativi.autorizzazioneContenutiApplicativiEffettuata", "ricezioneContenutiApplicativi.autenticazioneDisabilitata", "ricezioneContenutiApplicativi.autenticazioneInCorso", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiRichiestaDisabilitata", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiRichiestaInCorso", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiRichiestaEffettuata", "ricezioneContenutiApplicativi.parsingExceptionRichiesta", "ricezioneContenutiApplicativi.parsingExceptionRisposta", "ricezioneContenutiApplicativi.autenticazioneEffettuata", "ricezioneContenutiApplicativi.ricevutaRichiestaApplicativa.mittenteAnonimo", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteCredenzialiFallita.opzionale", "ricezioneContenutiApplicativi.riferimentoIdRichiesta.nonFornito", "ricezioneContenutiApplicativi.controlloTraffico.maxRequestsViolated", "ricezioneContenutiApplicativi.controlloTraffico.pddCongestionata", "ricezioneContenutiApplicativi.controlloTraffico.policy.controlloInCorso", "ricezioneContenutiApplicativi.controlloTraffico.policy.controlloTerminato.richiestaNonBloccata", "ricezioneContenutiApplicativi.controlloTraffico.policy.controlloTerminato.richiestaBloccata", "ricezioneContenutiApplicativi.controlloTraffico.policy.disabilitata", "ricezioneContenutiApplicativi.controlloTraffico.policy.filtrata", "ricezioneContenutiApplicativi.controlloTraffico.policy.nonApplicabile", "ricezioneContenutiApplicativi.controlloTraffico.policy.violata", "ricezioneContenutiApplicativi.controlloTraffico.policy.violataWarningOnly", "ricezioneContenutiApplicativi.controlloTraffico.policy.rispettata", "ricezioneContenutiApplicativi.controlloTraffico.policy.inErrore", "ricezioneContenutiApplicativi.controlloTraffico.maxRequestsViolatedWarningOnly", "ricezioneContenutiApplicativi.gestioneTokenDisabilitata", "ricezioneContenutiApplicativi.gestioneTokenInCorso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.verificaPresenzaToken", "ricezioneContenutiApplicativi.gestioneTokenInCorso.verificaPresenzaToken.trovato", "ricezioneContenutiApplicativi.gestioneTokenInCorso.verificaPresenzaToken.completataSuccesso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.verificaPresenzaToken.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.completataSuccesso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.validato", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.inCache", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.warningOnly.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.validazioneToken.disabilitata", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.completataSuccesso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.validato", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.inCache", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.warningOnly.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.introspectionToken.disabilitata", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.completataSuccesso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.validato", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.inCache", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.warningOnly.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.userInfoToken.disabilitata", "ricezioneContenutiApplicativi.gestioneTokenCompletataConSuccesso", "ricezioneContenutiApplicativi.gestioneTokenFallita", "ricezioneContenutiApplicativi.gestioneTokenFallita.erroreGenerico", "ricezioneContenutiApplicativi.gestioneTokenCompletataSenzaRilevazioneToken", "ricezioneContenutiApplicativi.autenticazioneTokenDisabilitata", "ricezioneContenutiApplicativi.autenticazioneTokenInCorso", "ricezioneContenutiApplicativi.autenticazioneTokenEffettuata", "ricezioneContenutiApplicativi.autenticazioneTokenFallita", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly", "ricezioneContenutiApplicativi.headerIntegrazione.creazioneFallita", "ricezioneContenutiApplicativi.autorizzazioneCanale.inCorso", "ricezioneContenutiApplicativi.autorizzazioneCanale.effettuata", "ricezioneContenutiApplicativi.autorizzazioneCanale.fallita", "ricezioneContenutiApplicativi.richiestaNonValida", "ricezioneContenutiApplicativi.gestioneAADisabilitata", "ricezioneContenutiApplicativi.gestioneAAInCorso", "ricezioneContenutiApplicativi.gestioneAACompletata", "ricezioneContenutiApplicativi.gestioneAAFallita", "ricezioneContenutiApplicativi.gestioneAAInCorso.retrieve", "ricezioneContenutiApplicativi.gestioneAAInCorso.retrieve.completataSuccesso", "ricezioneContenutiApplicativi.gestioneAAInCorso.retrieve.completataSuccesso.inCache", "ricezioneContenutiApplicativi.gestioneAAInCorso.retrieve.fallita", "ricezioneContenutiApplicativi.richiesta.warningCharsetDifferenteDefault", "ricezioneContenutiApplicativi.risposta.warningCharsetDifferenteDefault", "ricezioneContenutiApplicativi.ricezioneRichiesta.firstAccessRequestStream", "ricezioneContenutiApplicativi.autenticazioneApplicativoTokenInCorso", "ricezioneContenutiApplicativi.autenticazioneApplicativoTokenEffettuata.identificazioneRiuscita", "ricezioneContenutiApplicativi.autenticazioneApplicativoTokenEffettuata.identificazioneFallita", "ricezioneContenutiApplicativi.autenticazioneApplicativoTokenFallita", "ricezioneContenutiApplicativi.protocolli.tipoSoggetto.applicativoToken.unsupported", "ricezioneContenutiApplicativi.letturaPayloadRichiesta.completata", "ricezioneContenutiApplicativi.letturaPayloadRichiesta.fallita", "ricezioneContenutiApplicativi.addTokenIdAuth.richiesta.inCorso", "ricezioneContenutiApplicativi.addTokenIdAuth.richiesta.completata", "ricezioneContenutiApplicativi.addTokenIdAuth.richiesta.fallita", "ricezioneContenutiApplicativi.validateTokenIdAuth.risposta.inCorso", "ricezioneContenutiApplicativi.validateTokenIdAuth.risposta.completata", "ricezioneContenutiApplicativi.validateTokenIdAuth.risposta.fallita", "ricezioneContenutiApplicativi.addTokenIntegrity.richiesta.inCorso", "ricezioneContenutiApplicativi.addTokenIntegrity.richiesta.completata", "ricezioneContenutiApplicativi.addTokenIntegrity.richiesta.fallita", "ricezioneContenutiApplicativi.validateTokenIntegrity.risposta.inCorso", "ricezioneContenutiApplicativi.validateTokenIntegrity.risposta.completata", "ricezioneContenutiApplicativi.validateTokenIntegrity.risposta.fallita", "ricezioneContenutiApplicativi.addTokenAudit.richiesta.inCorso", "ricezioneContenutiApplicativi.addTokenAudit.richiesta.completata", "ricezioneContenutiApplicativi.addTokenAudit.richiesta.fallita", "ricezioneContenutiApplicativi.validazioneSemantica.risposta.inCorso", "ricezioneContenutiApplicativi.validazioneSemantica.risposta.completata", "ricezioneContenutiApplicativi.validazioneSemantica.risposta.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery.completataSuccesso", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery.validato", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery.inCache", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery.fallita", "ricezioneContenutiApplicativi.gestioneTokenInCorso.dynamicDiscovery.disabilitata", "imbustamentoBusta.registroServizi.ricercaServizioInCorso", "imbustamentoBusta.registroServizi.ricercaServizioEffettuata", "imbustamentoBusta.registroServizi.ricercaServizioFallita", "imbustamentoBusta.consegnaAffidabile.salvataggioInformazioni", "imbustamentoBusta.consegnaAffidabile.profiloNonOneway", "imbustamentoBusta.consegnaInOrdine.profiloNonOneway", "imbustamentoBusta.consegnaInOrdine.confermaRicezioneNonRichiesta", "imbustamentoBusta.consegnaInOrdine.idCollaborazioneNonRichiesto", "imbustamentoBusta.consegnaInOrdine.funzionalitaMancanti", "imbustamentoBusta.profiloAsincronoSimmetrico.saAnonimo", "imbustamentoBusta.profiloAsincronoSimmetrico.saSenzaRispostaAsincrona", "imbustamentoBusta.profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente", "imbustamentoBusta.profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta", "imbustamentoBusta.profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta", "imbustamentoBusta.profiloAsincronoSimmetrico.risposta.correlazioneRichiesta", "imbustamentoBusta.profiloAsincronoAsimmetrico.richiestaStato.correlazioneRichiesta", "imbustamentoBusta.protocolli.funzionalita.unsupported", "inoltroBuste.routingTable.esaminaInCorso", "inoltroBuste.routingTable.esaminaInCorsoFallita", "inoltroBuste.routingTable.esaminaEffettuata", "inoltroBuste.routingTable.utilizzoIndirizzoTelematico", "inoltroBuste.routingTable.soggettoFruitoreNonGestito", "inoltroBuste.inoltroInCorso", "inoltroBuste.inoltroEffettuato", "inoltroBuste.inoltroConErrore", "inoltroBuste.ricezioneMessaggio", "inoltroBuste.ricezioneMessaggioErrore", "inoltroBuste.ricezioneMessaggioErrore.rollback", "inoltroBuste.inoltroBustaScaduta", "inoltroBuste.ricezioneSoapFault", "inoltroBuste.profiloSincrono.rispostaNonPervenuta", "inoltroBuste.validazioneContenutiApplicativiRispostaNonRiuscita", "inoltroBuste.ricezioneSoapMessage.headerProtocolloNonPresente", "inoltroBuste.ricezioneSoapMessage.msgGiaPresente", "inoltroBuste.riconsegnaMessaggioPrematura", "inoltroBuste.rispostaRicevuta.messaggio", "inoltroBuste.rispostaRicevuta.messaggioErrore", "inoltroBuste.gestioneConsegnaTerminata", "inoltroBuste.headerIntegrazione.letturaFallita", "inoltroBuste.profiloAsincrono.rispostaNonPervenuta", "inoltroBuste.validazioneContenutiApplicativiRispostaDisabilitata", "inoltroBuste.validazioneContenutiApplicativiRispostaInCorso", "inoltroBuste.validazioneContenutiApplicativiRispostaEffettuata", "inoltroBuste.comportamentoAnomalo.erroreConsegna.ricezioneMessaggioDiversoFault", "inoltroBuste.mtom.beforeSecurity.processamentoRichiestaDisabilitato", "inoltroBuste.mtom.afterSecurity.processamentoRichiestaDisabilitato", "inoltroBuste.mtom.processamentoRichiestaInCorso", "inoltroBuste.mtom.processamentoRichiestaEffettuato", "inoltroBuste.mtom.processamentoRichiestaInErrore", "inoltroBuste.mtom.beforeSecurity.processamentoRispostaDisabilitato", "inoltroBuste.mtom.afterSecurity.processamentoRispostaDisabilitato", "inoltroBuste.mtom.processamentoRispostaInCorso", "inoltroBuste.mtom.processamentoRispostaEffettuato", "inoltroBuste.mtom.processamentoRispostaInErrore", "inoltroBuste.messageSecurity.processamentoRichiestaDisabilitato", "inoltroBuste.messageSecurity.processamentoRichiestaInCorso", "inoltroBuste.messageSecurity.processamentoRichiestaEffettuato", "inoltroBuste.messageSecurity.processamentoRichiestaInErrore", "inoltroBuste.messageSecurity.processamentoRispostaDisabilitato", "inoltroBuste.messageSecurity.processamentoRispostaInCorso", "inoltroBuste.messageSecurity.processamentoRispostaEffettuato", "inoltroBuste.messageSecurity.processamentoRispostaInErrore", "inoltroBuste.validazioneSintattica", "inoltroBuste.validazioneSemantica.beforeSecurity", "inoltroBuste.validazioneSemantica.afterSecurity", "inoltroBuste.trasformazione.processamentoRichiestaDisabilitato", "inoltroBuste.trasformazione.processamentoRichiestaNessunMatch", "inoltroBuste.trasformazione.processamentoRichiestaInCorso", "inoltroBuste.trasformazione.processamentoRichiestaEffettuato", "inoltroBuste.trasformazione.processamentoRichiestaInErrore", "inoltroBuste.trasformazione.processamentoRispostaDisabilitato", "inoltroBuste.trasformazione.processamentoRispostaNessunMatch", "inoltroBuste.trasformazione.processamentoRispostaInCorso", "inoltroBuste.trasformazione.processamentoRispostaEffettuato", "inoltroBuste.trasformazione.processamentoRispostaInErrore", "inoltroBuste.ricezioneRestProblem", "inoltroBuste.validazioneContenutiApplicativiRispostaNonRiuscita.warningOnly", "inoltroBuste.headerIntegrazione.creazioneFallita", "inoltroBuste.ricezioneRisposta.firstAccessRequestStream", "inoltroBuste.letturaPayloadRisposta.completata", "inoltroBuste.letturaPayloadRisposta.fallita", "inoltroBuste.negoziazioneToken.inCorso", "inoltroBuste.negoziazioneToken.completata", "inoltroBuste.negoziazioneToken.inCache", "inoltroBuste.consegnaRispostaSSE", "ricezioneBuste.ricezioneMessaggio", "ricezioneBuste.ricezioneMessaggioErrore", "ricezioneBuste.autorizzazioneBusteInCorso", "ricezioneBuste.autorizzazioneBusteEffettuata", "ricezioneBuste.autorizzazioneBusteFallita", "ricezioneBuste.generazioneMessaggioRisposta", "ricezioneBuste.generazioneMessaggioErroreRisposta", "ricezioneBuste.generazioneMessaggioErroreRisposta.destinatarioSconosciuto", "ricezioneBuste.generazioneRiscontro", "ricezioneBuste.generazioneRicevutaAsincrona", "ricezioneBuste.consegnaMessaggioOkEffettuata", "ricezioneBuste.consegnaMessaggioKoEffettuata", "ricezioneBuste.consegnaMessaggioNonPresente", "ricezioneBuste.consegnaMessaggioFallita", "ricezioneBuste.timeoutRicezioneRisposta", "ricezioneBuste.messaggioInGestione.marcatoDaEliminare", "ricezioneBuste.messaggioInGestione.gestioneSincrona", "ricezioneBuste.messaggioInGestione.gestioneAsincrona", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.timeoutScaduto", "ricezioneBuste.attesaFineProcessamento.richiestaAsincrona.timeoutScaduto", "ricezioneBuste.attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto", "ricezioneBuste.validazioneContenutiApplicativiRichiestaNonRiuscita", "ricezioneBuste.headerIntegrazione.letturaFallita", "ricezioneBuste.mustUnderstand.unknown", "ricezioneBuste.contentType.unsupported", "ricezioneBuste.soapEnvelopeNamespace.versionMismatch", "ricezioneBuste.gestoreCredenziali.errore", "ricezioneBuste.gestoreCredenziali.nuoveCredenziali", "ricezioneBuste.contentType.notDefined", "ricezioneBuste.identificazionePAErrore", "ricezioneBuste.protocolli.tipoSoggetto.fruitore.unsupported", "ricezioneBuste.protocolli.tipoSoggetto.erogatore.unsupported", "ricezioneBuste.protocolli.tipoServizio.unsupported", "ricezioneBuste.ricezioneRichiesta.firstLog", "ricezioneBuste.ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio", "ricezioneBuste.ricezioneRichiesta.elaborazioneDati.inCorso", "ricezioneBuste.ricezioneRichiesta.elaborazioneDati.completata", "ricezioneBuste.autorizzazioneBusteDisabilitata", "ricezioneBuste.autorizzazioneContenutiBusteDisabilitata", "ricezioneBuste.autorizzazioneContenutiBusteInCorso", "ricezioneBuste.autorizzazioneContenutiBusteEffettuata", "ricezioneBuste.autorizzazioneContenutiBusteFallita", "ricezioneBuste.validazioneContenutiApplicativiRichiestaDisabilitata", "ricezioneBuste.validazioneContenutiApplicativiRichiestaInCorso", "ricezioneBuste.validazioneContenutiApplicativiRichiestaEffettuata", "ricezioneBuste.mtom.beforeSecurity.processamentoRichiestaDisabilitato", "ricezioneBuste.mtom.afterSecurity.processamentoRichiestaDisabilitato", "ricezioneBuste.mtom.processamentoRichiestaInCorso", "ricezioneBuste.mtom.processamentoRichiestaEffettuato", "ricezioneBuste.mtom.processamentoRichiestaInErrore", "ricezioneBuste.mtom.beforeSecurity.processamentoRispostaDisabilitato", "ricezioneBuste.mtom.afterSecurity.processamentoRispostaDisabilitato", "ricezioneBuste.mtom.processamentoRispostaInCorso", "ricezioneBuste.mtom.processamentoRispostaEffettuato", "ricezioneBuste.mtom.processamentoRispostaInErrore", "ricezioneBuste.messageSecurity.processamentoRichiestaDisabilitato", "ricezioneBuste.messageSecurity.processamentoRichiestaInCorso", "ricezioneBuste.messageSecurity.processamentoRichiestaEffettuato", "ricezioneBuste.messageSecurity.processamentoRichiestaInErrore", "ricezioneBuste.messageSecurity.processamentoRispostaDisabilitato", "ricezioneBuste.messageSecurity.processamentoRispostaInCorso", "ricezioneBuste.messageSecurity.processamentoRispostaEffettuato", "ricezioneBuste.messageSecurity.processamentoRispostaInErrore", "ricezioneBuste.validazioneSintattica", "ricezioneBuste.validazioneSemantica.beforeSecurity", "ricezioneBuste.validazioneSemantica.afterSecurity", "ricezioneBuste.parsingExceptionRichiesta", "ricezioneBuste.parsingExceptionRisposta", "ricezioneBuste.autenticazioneDisabilitata", "ricezioneBuste.autenticazioneInCorso", "ricezioneBuste.autenticazioneEffettuata", "ricezioneBuste.autenticazioneFallita", "ricezioneBuste.autenticazioneFallita.opzionale", "ricezioneBuste.ricezioneMessaggio.mittenteAnonimo", "ricezioneBuste.generazioneMessaggioRisposta.mittenteAnonimo", "ricezioneBuste.generazioneMessaggioErroreRisposta.mittenteAnonimo", "ricezioneBuste.identificazioneDinamicaAzioneNonRiuscita", "ricezioneBuste.riferimentoIdRichiesta.nonFornito", "ricezioneBuste.controlloTraffico.maxRequestsViolated", "ricezioneBuste.controlloTraffico.pddCongestionata", "ricezioneBuste.controlloTraffico.policy.controlloInCorso", "ricezioneBuste.controlloTraffico.policy.controlloTerminato.richiestaNonBloccata", "ricezioneBuste.controlloTraffico.policy.controlloTerminato.richiestaBloccata", "ricezioneBuste.controlloTraffico.policy.disabilitata", "ricezioneBuste.controlloTraffico.policy.filtrata", "ricezioneBuste.controlloTraffico.policy.nonApplicabile", "ricezioneBuste.controlloTraffico.policy.violata", "ricezioneBuste.controlloTraffico.policy.violataWarningOnly", "ricezioneBuste.controlloTraffico.policy.rispettata", "ricezioneBuste.controlloTraffico.policy.inErrore", "ricezioneBuste.controlloTraffico.maxRequestsViolatedWarningOnly", "ricezioneBuste.gestioneTokenDisabilitata", "ricezioneBuste.gestioneTokenInCorso", "ricezioneBuste.gestioneTokenInCorso.verificaPresenzaToken", "ricezioneBuste.gestioneTokenInCorso.verificaPresenzaToken.trovato", "ricezioneBuste.gestioneTokenInCorso.verificaPresenzaToken.completataSuccesso", "ricezioneBuste.gestioneTokenInCorso.verificaPresenzaToken.fallita", "ricezioneBuste.gestioneTokenInCorso.validazioneToken", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.completataSuccesso", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.validato", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.inCache", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.fallita", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.warningOnly.fallita", "ricezioneBuste.gestioneTokenInCorso.validazioneToken.disabilitata", "ricezioneBuste.gestioneTokenInCorso.introspectionToken", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.completataSuccesso", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.validato", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.inCache", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.fallita", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.warningOnly.fallita", "ricezioneBuste.gestioneTokenInCorso.introspectionToken.disabilitata", "ricezioneBuste.gestioneTokenInCorso.userInfoToken", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.completataSuccesso", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.validato", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.inCache", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.fallita", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.warningOnly.fallita", "ricezioneBuste.gestioneTokenInCorso.userInfoToken.disabilitata", "ricezioneBuste.gestioneTokenCompletataConSuccesso", "ricezioneBuste.gestioneTokenFallita", "ricezioneBuste.gestioneTokenFallita.erroreGenerico", "ricezioneBuste.gestioneTokenCompletataSenzaRilevazioneToken", "ricezioneBuste.autenticazioneTokenDisabilitata", "ricezioneBuste.autenticazioneTokenInCorso", "ricezioneBuste.autenticazioneTokenEffettuata", "ricezioneBuste.autenticazioneTokenFallita", "ricezioneBuste.validazioneContenutiApplicativiRichiestaNonRiuscita.warningOnly", "ricezioneBuste.headerIntegrazione.creazioneFallita", "ricezioneBuste.autorizzazioneCanale.inCorso", "ricezioneBuste.autorizzazioneCanale.effettuata", "ricezioneBuste.autorizzazioneCanale.fallita", "ricezioneBuste.richiestaNonValida", "ricezioneBuste.gestioneAADisabilitata", "ricezioneBuste.gestioneAAInCorso", "ricezioneBuste.gestioneAACompletata", "ricezioneBuste.gestioneAAFallita", "ricezioneBuste.gestioneAAInCorso.retrieve", "ricezioneBuste.gestioneAAInCorso.retrieve.completataSuccesso", "ricezioneBuste.gestioneAAInCorso.retrieve.completataSuccesso.inCache", "ricezioneBuste.gestioneAAInCorso.retrieve.fallita", "ricezioneBuste.richiesta.warningCharsetDifferenteDefault", "ricezioneBuste.risposta.warningCharsetDifferenteDefault", "ricezioneBuste.ricezioneRichiesta.firstAccessRequestStream", "ricezioneBuste.autenticazioneApplicativoTokenInCorso", "ricezioneBuste.autenticazioneApplicativoTokenEffettuata.identificazioneRiuscita", "ricezioneBuste.autenticazioneApplicativoTokenEffettuata.identificazioneFallita", "ricezioneBuste.autenticazioneApplicativoTokenFallita", "ricezioneBuste.protocolli.tipoSoggetto.applicativoToken.unsupported", "ricezioneBuste.letturaPayloadRichiesta.completata", "ricezioneBuste.letturaPayloadRichiesta.fallita", "ricezioneBuste.validateTokenIdAuth.richiesta.inCorso", "ricezioneBuste.validateTokenIdAuth.richiesta.completata", "ricezioneBuste.validateTokenIdAuth.richiesta.fallita", "ricezioneBuste.addTokenIdAuth.risposta.inCorso", "ricezioneBuste.addTokenIdAuth.risposta.completata", "ricezioneBuste.addTokenIdAuth.risposta.fallita", "ricezioneBuste.validateTokenIntegrity.richiesta.inCorso", "ricezioneBuste.validateTokenIntegrity.richiesta.completata", "ricezioneBuste.validateTokenIntegrity.richiesta.fallita", "ricezioneBuste.addTokenIntegrity.risposta.inCorso", "ricezioneBuste.addTokenIntegrity.risposta.completata", "ricezioneBuste.addTokenIntegrity.risposta.fallita", "ricezioneBuste.validateTokenAudit.richiesta.inCorso", "ricezioneBuste.validateTokenAudit.richiesta.completata", "ricezioneBuste.validateTokenAudit.richiesta.fallita", "ricezioneBuste.validazioneSemantica.richiesta.inCorso", "ricezioneBuste.validazioneSemantica.richiesta.completata", "ricezioneBuste.validazioneSemantica.richiesta.fallita", "ricezioneBuste.validazioneSemantica.autorizzazione.inCorso", "ricezioneBuste.validazioneSemantica.autorizzazione.completata", "ricezioneBuste.validazioneSemantica.autorizzazione.fallita", "ricezioneBuste.protocolli.tipoSoggetto.fruitore.unsupported.warning", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery.completataSuccesso", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery.validato", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery.inCache", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery.fallita", "ricezioneBuste.gestioneTokenInCorso.dynamicDiscovery.disabilitata", "ricezioneBuste.soggettoIntermediario", "sbustamentoBusta.ricezioneBustaErrore", "sbustamentoBusta.ricezioneBusta.eccezioniNonGravi", "sbustamentoBusta.validazioneNonRiuscita", "sbustamentoBusta.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoBusta.validazioneBusta.bustaNonCorretta", "sbustamentoBusta.validazioneBusta.eccezioniNonGravi", "sbustamentoBusta.validazioneRicevutaAsincrona", "sbustamentoBusta.ricezioneRiscontro", "sbustamentoBusta.ricezioneBustaServizio", "sbustamentoBusta.ricezioneBustaDuplicata", "sbustamentoBusta.ricezioneBustaDuplicata.count", "sbustamentoBusta.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoBusta.funzionalitaRichiestaAccordo.confermaRicezioneNonPresente", "sbustamentoBusta.funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente", "sbustamentoBusta.consegnaInOrdine.profiloDiversoOneway", "sbustamentoBusta.soggettoDestinatarioNonGestito", "sbustamentoBusta.portaApplicativaNonEsistente.identificazionePerServizio", "sbustamentoBusta.ricezioneRispostaSincrona", "sbustamentoBusta.profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto", "sbustamentoBusta.profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona", "sbustamentoBusta.profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente", "sbustamentoBusta.ricezioneBustaErroreDetails", "sbustamentoBusta.protocolli.funzionalita.unsupported", "sbustamentoBusta.portaApplicativaNonEsistente", "sbustamentoRispostaBusta.ricezioneBustaErrore", "sbustamentoRispostaBusta.ricezioneBusta.eccezioniNonGravi", "sbustamentoRispostaBusta.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoRispostaBusta.validazioneBusta.eccezioniNonGravi", "sbustamentoRispostaBusta.validazioneBusta.bustaNonCorretta", "sbustamentoRispostaBusta.validazioneRicevutaAsincrona", "sbustamentoRispostaBusta.ricezioneRiscontro", "sbustamentoRispostaBusta.ricezioneBustaServizio", "sbustamentoRispostaBusta.ricezioneBustaDuplicata", "sbustamentoRispostaBusta.ricezioneBustaDuplicata.count", "sbustamentoRispostaBusta.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoRispostaBusta.rispostaOneway", "sbustamentoRispostaBusta.soggettoDestinatarioNonGestito", "sbustamentoRispostaBusta.profiloCollaborazioneRisposta.diversoScenarioGestito", "sbustamentoRispostaBusta.riferimentoMessaggioNonValido", "sbustamentoRispostaBusta.riferimentoMessaggioNonPresente", "sbustamentoRispostaBusta.ricezioneBustaErroreDetails", "sbustamentoRispostaBusta.protocolli.funzionalita.unsupported", "consegnaContenutiApplicativi.integrationManager.messaggioDisponibile", "consegnaContenutiApplicativi.consegnaNonDefinita", "consegnaContenutiApplicativi.trasmissioneSincrona.servizioNonUtilizzabile", "consegnaContenutiApplicativi.gestioneProfiloAsincrono.servizioNonUtilizzabile", "consegnaContenutiApplicativi.servizioApplicativoNonDefinito", "consegnaContenutiApplicativi.gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.integrationManager", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioFuoriOrdine", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioGiaConsegnato", "consegnaContenutiApplicativi.consegnaInCorso", "consegnaContenutiApplicativi.consegnaEffettuata", "consegnaContenutiApplicativi.consegnaConErrore", "consegnaContenutiApplicativi.ricezioneSoapFault", "consegnaContenutiApplicativi.validazioneContenutiApplicativiRispostaNonRiuscita", "consegnaContenutiApplicativi.funzionalitaScartaBodyNonRiuscita", "consegnaContenutiApplicativi.funzionalitaAllegaBodyNonRiuscita", "consegnaContenutiApplicativi.riconsegnaMessaggioPrematura", "consegnaContenutiApplicativi.gestioneConsegnaTerminata", "consegnaContenutiApplicativi.rispostaContenenteBusta", "consegnaContenutiApplicativi.headerIntegrazione.letturaFallita", "consegnaContenutiApplicativi.behaviour.servizioApplicativoNonDefinito", "consegnaContenutiApplicativi.validazioneContenutiApplicativiRispostaDisabilitata", "consegnaContenutiApplicativi.validazioneContenutiApplicativiRispostaInCorso", "consegnaContenutiApplicativi.validazioneContenutiApplicativiRispostaEffettuata", "consegnaContenutiApplicativi.comportamentoAnomalo.erroreConsegna.ricezioneMessaggioDiversoFault", "consegnaContenutiApplicativi.consegnaEffettuata.mittenteAnonimo", "consegnaContenutiApplicativi.consegnaConErrore.mittenteAnonimo", "consegnaContenutiApplicativi.trasformazione.processamentoRichiestaDisabilitato", "consegnaContenutiApplicativi.trasformazione.processamentoRichiestaNessunMatch", "consegnaContenutiApplicativi.trasformazione.processamentoRichiestaInCorso", "consegnaContenutiApplicativi.trasformazione.processamentoRichiestaEffettuato", "consegnaContenutiApplicativi.trasformazione.processamentoRichiestaInErrore", "consegnaContenutiApplicativi.trasformazione.processamentoRispostaDisabilitato", "consegnaContenutiApplicativi.trasformazione.processamentoRispostaNessunMatch", "consegnaContenutiApplicativi.trasformazione.processamentoRispostaInCorso", "consegnaContenutiApplicativi.trasformazione.processamentoRispostaEffettuato", "consegnaContenutiApplicativi.trasformazione.processamentoRispostaInErrore", "consegnaContenutiApplicativi.queue.messaggioSchedulato", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.identificazioneFallita.error", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.identificazioneFallita.info", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.filtro.error", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.filtro.info", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.nomeConnettore.error", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreNonEsistente.nomeConnettore.info", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreDefault", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.connettoreNotificaDefault", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.loadBalancer.tuttiConnettori", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettore", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.tuttiConnettori", "consegnaContenutiApplicativi.connettoriMultipli.servizioSincrono.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.connettoriMultipli.servizioSincrono.consegnaIntegrationManager", "consegnaContenutiApplicativi.connettoriMultipli.servizioSincrono.consegnaNonTrasparente", "consegnaContenutiApplicativi.connettoriMultipli.loadBalancer.sticky.identificazioneFallita", "consegnaContenutiApplicativi.connettoriMultipli.loadBalancer.sticky.identificazioneRiuscita", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.identificazioneRiuscita", "consegnaContenutiApplicativi.ricezioneRestProblem", "consegnaContenutiApplicativi.validazioneContenutiApplicativiRispostaNonRiuscita.warningOnly", "consegnaContenutiApplicativi.headerIntegrazione.creazioneFallita", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.connettoreDefault", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.connettoreNotificaDefault", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.tuttiConnettori", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato.tuttiConnettoriNotifica", "consegnaContenutiApplicativi.connettoriMultipli.consegnaCondizionale.nessunConnettoreIdentificato", "consegnaContenutiApplicativi.trasformazione.processamentoNotificaDisabilitato", "consegnaContenutiApplicativi.trasformazione.processamentoNotificaNessunMatch", "consegnaContenutiApplicativi.trasformazione.processamentoNotificaInCorso", "consegnaContenutiApplicativi.trasformazione.processamentoNotificaEffettuato", "consegnaContenutiApplicativi.trasformazione.processamentoNotificaInErrore", "consegnaContenutiApplicativi.ricezioneRisposta.firstAccessRequestStream", "consegnaContenutiApplicativi.letturaPayloadRisposta.completata", "consegnaContenutiApplicativi.letturaPayloadRisposta.fallita", "consegnaContenutiApplicativi.negoziazioneToken.inCorso", "consegnaContenutiApplicativi.negoziazioneToken.completata", "consegnaContenutiApplicativi.negoziazioneToken.inCache", "consegnaContenutiApplicativi.consegnaRispostaSSE", "integrationManager.logInvocazioneOperazione", "integrationManager.autenticazioneNonImpostata", "integrationManager.servizioApplicativo.identificazioneTramiteCredenziali", "integrationManager.servizioApplicativo.nonAutorizzato", "integrationManager.mappingRifMsgToIdBusta.nonRiuscito", "integrationManager.buildMsg.nonRiuscito", "integrationManager.buildMsg.imbustamentoSOAP.nonRiuscito", "integrationManager.invocazionePortaDelegata.contenutoApplicativoNonPresente", "integrationManager.invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente", "integrationManager.invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente", "integrationManager.messaggiNonPresenti", "integrationManager.messaggioNonTrovato", "integrationManager.gestoreCredenziali.errore", "integrationManager.gestoreCredenziali.nuoveCredenziali", "integrationManager.ricezioneRichiesta.firstLog", "integrationManager.ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio", "integrationManager.ricezioneRichiesta.elaborazioneDati.inCorso", "integrationManager.ricezioneRichiesta.elaborazioneDati.completata", "integrationManager.ricezioneRichiesta.firstAccessRequestStream", "tracciamento.registrazioneNonRiuscita", "tracciamento.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.errore.bloccoServizi", "tracciamento.dumpContenutiApplicativi.errore.bloccoServizi", "tracciamento.dumpContenutiApplicativi.richiestaIngresso.inCorso", "tracciamento.dumpContenutiApplicativi.richiestaIngresso.completato", "tracciamento.dumpContenutiApplicativi.richiestaUscita.inCorso", "tracciamento.dumpContenutiApplicativi.richiestaUscita.completato", "tracciamento.dumpContenutiApplicativi.rispostaIngresso.inCorso", "tracciamento.dumpContenutiApplicativi.rispostaIngresso.completato", "tracciamento.dumpContenutiApplicativi.rispostaUscita.inCorso", "tracciamento.dumpContenutiApplicativi.rispostaUscita.completato", "tracciamento.dumpContenutiApplicativiFileTrace.richiestaIngresso.inCorso", "tracciamento.dumpContenutiApplicativiFileTrace.richiestaIngresso.completato", "tracciamento.dumpContenutiApplicativiFileTrace.richiestaUscita.inCorso", "tracciamento.dumpContenutiApplicativiFileTrace.richiestaUscita.completato", "tracciamento.dumpContenutiApplicativiFileTrace.rispostaIngresso.inCorso", "tracciamento.dumpContenutiApplicativiFileTrace.rispostaIngresso.completato", "tracciamento.dumpContenutiApplicativiFileTrace.rispostaUscita.inCorso", "tracciamento.dumpContenutiApplicativiFileTrace.rispostaUscita.completato", "tracciamento.registrazioneTransazioneNonRiuscita", "timerGestoreRiscontriRicevute.avvioInCorso", "timerGestoreRiscontriRicevute.avvioEffettuato", "timerGestoreRiscontriRicevute.timerGiaAvviato", "timerGestoreRiscontriRicevute.disabilitato", "timerGestoreRiscontriRicevute.controlloInCorso", "timerGestoreRiscontriRicevute.bustaNonRiscontrata", "timerGestoreRiscontriRicevute.bustaNonRiscontrataScaduta", "timerGestoreRiscontriRicevute.bustaNonRiscontrata.messaggioNonEsistente", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.bustaScaduta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.messaggioNonEsistente", "timerGestoreRiscontriRicevute.precedenteEsecuzioneInCorso", "timerGestoreRiscontriRicevute.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreMessaggi.avvioInCorso", "timerGestoreMessaggi.avvioEffettuato", "timerGestoreMessaggi.timerGiaAvviato", "timerGestoreMessaggi.disabilitato", "timerGestoreMessaggi.controlloInCorso", "timerGestoreMessaggi.ricercaMessaggiDaEliminare", "timerGestoreMessaggi.eliminazioneMessaggio", "timerGestoreMessaggi.eliminazioneDestinatarioMessaggio", "timerGestoreMessaggi.messaggioNonConsumato.codaJMS", "timerGestoreMessaggi.ricercaCorrelazioniApplicativeScadute", "timerGestoreMessaggi.ricercaCorrelazioniApplicativeScaduteRispettoOraRegistrazione", "timerGestoreMessaggi.eliminazioneCorrelazioneApplicativaScaduta", "timerGestoreMessaggi.precedenteEsecuzioneInCorso", "timerGestoreMessaggi.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreMessaggi.connessioneScaduta.EliminazioneInCorso", "timerGestoreMessaggi.connessioneScaduta.EliminazioneEffettuata", "timerGestoreMessaggiInconsistenti.avvioInCorso", "timerGestoreMessaggiInconsistenti.avvioEffettuato", "timerGestoreMessaggiInconsistenti.timerGiaAvviato", "timerGestoreMessaggiInconsistenti.disabilitato", "timerGestoreMessaggiInconsistenti.controlloInCorso", "timerGestoreMessaggiInconsistenti.ricercaMessaggiDaEliminare", "timerGestoreMessaggiInconsistenti.eliminazioneMessaggio", "timerGestoreMessaggiInconsistenti.precedenteEsecuzioneInCorso", "timerGestoreMessaggiInconsistenti.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreRepositoryBuste.avvioInCorso", "timerGestoreRepositoryBuste.avvioEffettuato", "timerGestoreRepositoryBuste.timerGiaAvviato", "timerGestoreRepositoryBuste.disabilitato", "timerGestoreRepositoryBuste.controlloInCorso", "timerGestoreRepositoryBuste.ricercaMessaggiDaEliminare", "timerGestoreRepositoryBuste.eliminazioneMessaggio", "timerGestoreRepositoryBuste.precedenteEsecuzioneInCorso", "timerGestoreRepositoryBuste.precedenteEsecuzioneInCorso.stopTimer", "timerMonitoraggioRisorse.avvioEffettuato", "timerMonitoraggioRisorse.risorsaNonDisponibile", "timerMonitoraggioRisorse.validazioneSemanticaFallita", "timerMonitoraggioRisorse.risorsaRitornataDisponibile", "timerThreshold.avvioEffettuato", "timerThreshold.controlloInCorso", "timerThreshold.risorsaNonDisponibile", "timerThreshold.risorsaRitornataDisponibile", "timerConsegnaContenutiApplicativi.avvioInCorso", "timerConsegnaContenutiApplicativi.avvioEffettuato", "timerConsegnaContenutiApplicativi.timerGiaAvviato", "timerConsegnaContenutiApplicativi.disabilitato", "timerConsegnaContenutiApplicativi.controlloInCorso", "timerConsegnaContenutiApplicativi.ricercaMessaggiDaInoltrare", "timerConsegnaContenutiApplicativi.inoltroMessaggio", "timerConsegnaContenutiApplicativi.precedenteEsecuzioneInCorso", "timerConsegnaContenutiApplicativi.precedenteEsecuzioneInCorso.stopTimer", "timerStatistiche.avvioInCorso", "timerStatistiche.avvioEffettuato", "timerStatistiche.disabilitato", "timerStatistiche.generazioneStatistiche", "timerStatistiche.generazioneStatistiche.inCorso", "timerStatistiche.generazioneStatistiche.effettuata", "timerGestoreChiaviPDND.avvioInCorso", "timerGestoreChiaviPDND.avvioEffettuato", "timerGestoreChiaviPDND.disabilitato", "timerGestoreChiaviPDND.letturaEventi", "timerGestoreChiaviPDND.letturaEventi.nonNecessaria", "timerGestoreChiaviPDND.gestioneEventi.inCorso", "timerGestoreChiaviPDND.gestioneEventi.analisi", "timerGestoreChiaviPDND.gestioneEventi.effettuata", "timerGestoreChiaviPDND.gestioneEventi.fallita", "timerGestoreChiaviPDND.gestioneEventi.evento", "timerGestoreChiaviPDND.inizializzazione.inCorso", "timerGestoreChiaviPDND.inizializzazione.effettuata", "timerGestoreChiaviPDND.inizializzazione.fallita", "timerGestoreChiaviPDND.letturaCacheKeys", "timerGestoreChiaviPDND.letturaCacheKeys.effettuata", "timerGestoreChiaviPDND.letturaCacheKeys.nonNecessaria", "timerGestoreOperazioniAsincrone.avvioInCorso", "timerGestoreOperazioniAsincrone.avvioEffettuato", "timerGestoreOperazioniAsincrone.disabilitato", "timerGestoreOperazioniAsincrone.letturaOperazioni", "timerGestoreOperazioniAsincrone.gestioneOperazioni.inCorso", "timerGestoreOperazioniAsincrone.gestioneOperazioni.analisi", "timerGestoreOperazioniAsincrone.gestioneOperazioni.effettuata", "timerGestoreOperazioniAsincrone.gestioneOperazioni.fallita", "timerGestoreOperazioniAsincrone.gestioneOperazioni.operazione", "timerGestoreOperazioniAsincrone.gestioneOperazioni.operazione.fallita", "timerSvecchiamentoOperazioniAsincrone.avvioInCorso", "timerSvecchiamentoOperazioniAsincrone.avvioEffettuato", "timerSvecchiamentoOperazioniAsincrone.disabilitato", "timerSvecchiamentoOperazioniAsincrone.svecchiamento.inCorso", "timerSvecchiamentoOperazioniAsincrone.svecchiamento.effettuata", "timerSvecchiamentoOperazioniAsincrone.svecchiamento.fallita", "timerFileSystemRecovery.avvioInCorso", "timerFileSystemRecovery.avvioEffettuato", "timerFileSystemRecovery.disabilitato", "timerFileSystemRecovery.recovery", "timerFileSystemRecovery.recovery.inCorso", "timerFileSystemRecovery.recovery.effettuata", "openspcoopStartup.pdd", "openspcoopStartup.IntegrationManager", "openspcoopStartup.erroreGenerico", "all.erroreGenerico", "all.erroreGenericoMalfunzionamentoPdD", "all.transactionManager.validityCheckError", "all.connessioneUscita.disconnectError", "all.acquisizioneLock.inCorso", "all.acquisizioneLock.wait.withoutOwner", "all.acquisizioneLock.wait.existsOldOwner", "all.acquisizioneLock.ok", "all.acquisizioneLock.nonDisponibile", "all.acquisizioneUnlock.inCorso", "all.acquisizioneUnlock.ok", "all.acquisizioneUnlock.ko", "all.updateLock.inCorso", "all.updateLock.ok", "all.updateLock.ko", "all.controlloTraffico.policy.violata.risorsaNumeroRichieste.simultaneo", "all.controlloTraffico.policy.violata.risorsaNumeroRichieste", "all.controlloTraffico.policy.violata.risorsaOccupazioneBanda", "all.controlloTraffico.policy.violata.risorsaTempoComplessivo", "all.controlloTraffico.policy.violata.risorsaTempoMedio", "all.controlloTraffico.policy.applicabilita.nonCongestionato", "all.controlloTraffico.policy.applicabilita.controlloCongestioneDisabilitato", "all.controlloTraffico.policy.applicabilita.degradoPrestazionale.rilevato", "all.controlloTraffico.policy.applicabilita.degradoPrestazionale.nonRilevato", "all.controlloTraffico.policy.applicabilita.statoAllarme.rilevato", "all.controlloTraffico.policy.applicabilita.statoAllarme.nonRilevato", "all.controlloTraffico.pddCongestionata", "all.controlloTraffico.policy.violata.risorsaNumeroRichiesteCompletateConSuccesso", "all.controlloTraffico.policy.violata.risorsaNumeroRichiesteFallite", "all.controlloTraffico.policy.violata.risorsaNumeroFaultApplicativi"};
        codiceDiagnosticoInitialized = false;
        codiceDiagnosticoFatal = null;
        codiceDiagnosticoErrorProtocol = null;
        codiceDiagnosticoErrorIntegration = null;
        codiceDiagnosticoInfoProtocol = null;
        codiceDiagnosticoInfoIntegration = null;
        codiceDiagnosticoDebugLow = null;
        codiceDiagnosticoDebugMedium = null;
        codiceDiagnosticoDebugHigh = null;
    }
}

