/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.rest.DumpRestMessageUtils;
import org.openspcoop2.message.soap.DumpSoapMessageUtils;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop2.pdd.core.transazioni.GestoreConsegnaMultipla;
import org.openspcoop2.pdd.core.transazioni.RepositoryGestioneStateful;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.dump.Attachment;
import org.openspcoop2.protocol.sdk.dump.BodyMultipartInfo;
import org.openspcoop2.protocol.sdk.dump.DumpException;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.URLProtocolContext;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.mime.MultipartUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class Dump {
    private static boolean sistemaDumpDisponibile = true;
    private static Throwable motivoMalfunzionamentoDump = null;
    private static final String DIAGNOSTICO_REGISTRAZIONE_NON_RIUSCITA = "dumpContenutiApplicativi.registrazioneNonRiuscita";
    private Logger loggerDump = null;
    private IDSoggetto dominio;
    private String idModulo;
    private String idMessaggio;
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String signature;
    private Date gdo;
    private TipoPdD tipoPdD;
    private String nomePorta;
    private PdDContext pddContext;
    private RequestInfo requestInfo = null;
    private OpenSPCoop2Properties properties = null;
    private MsgDiagnostico msgDiagErroreDump = null;
    private boolean emitDiagnosticDump = false;
    private List<IDumpProducer> loggerDumpOpenSPCoopAppender = null;
    private List<String> tipoDumpOpenSPCoopAppender = null;
    private DumpConfigurazione dumpConfigurazione;
    private IProtocolFactory<?> protocolFactory = null;
    private String idTransazione = null;
    private StateMessage statoRichiesta;
    private StateMessage statoRisposta;
    private Transaction transactionNullable = null;
    private TransazioneApplicativoServer transazioneApplicativoServer;
    private IDPortaApplicativa idPortaApplicativa;
    private Date dataConsegnaTransazioneApplicativoServer;

    public static boolean isSistemaDumpDisponibile() {
        return sistemaDumpDisponibile;
    }

    public static void setSistemaDumpDisponibile(boolean sistemaDumpDisponibile) {
        Dump.sistemaDumpDisponibile = sistemaDumpDisponibile;
    }

    public static Throwable getMotivoMalfunzionamentoDump() {
        return motivoMalfunzionamentoDump;
    }

    public static void setMotivoMalfunzionamentoDump(Throwable motivoMalfunzionamentoDump) {
        Dump.motivoMalfunzionamentoDump = motivoMalfunzionamentoDump;
    }

    private void loggerDumpError(String msg) {
        if (this.loggerDump != null) {
            this.loggerDump.error(msg);
        }
    }

    private void loggerDumpError(String msg, Throwable e) {
        if (this.loggerDump != null) {
            this.loggerDump.error(msg, e);
        }
    }

    private void loggerOpenSPCoopResourcesError(String msg, Throwable e) {
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error(msg, e);
        }
    }

    public void setTransazioneApplicativoServer(TransazioneApplicativoServer transazioneApplicativoServer, IDPortaApplicativa idPortaApplicativa, Date dataConsegnaTransazioneApplicativoServer) {
        this.transazioneApplicativoServer = transazioneApplicativoServer;
        this.idPortaApplicativa = idPortaApplicativa;
        this.dataConsegnaTransazioneApplicativoServer = dataConsegnaTransazioneApplicativoServer;
    }

    public Dump(IDSoggetto dominio, String modulo, TipoPdD tipoPdD, String nomePorta, PdDContext pddContext, DumpConfigurazione dumpConfigurazione) throws DumpException {
        this(dominio, modulo, null, null, null, tipoPdD, nomePorta, pddContext, null, null, dumpConfigurazione);
    }

    public Dump(IDSoggetto dominio, String modulo, TipoPdD tipoPdD, String nomePorta, PdDContext pddContext, IState statoRichiesta, IState statoRisposta, DumpConfigurazione dumpConfigurazione) throws DumpException {
        this(dominio, modulo, null, null, null, tipoPdD, nomePorta, pddContext, statoRichiesta, statoRisposta, dumpConfigurazione);
    }

    public Dump(IDSoggetto dominio, String modulo, String idMessaggio, IDSoggetto fruitore, IDServizio servizio, TipoPdD tipoPdD, String nomePorta, PdDContext pddContext, IState stateParam, IState responseStateParam, DumpConfigurazione dumpConfigurazione) throws DumpException {
        this.dominio = dominio;
        this.idModulo = modulo;
        this.idMessaggio = idMessaggio;
        this.fruitore = fruitore;
        this.servizio = servizio;
        this.loggerDump = OpenSPCoop2Logger.loggerDump;
        this.loggerDumpOpenSPCoopAppender = OpenSPCoop2Logger.loggerDumpOpenSPCoopAppender;
        this.tipoDumpOpenSPCoopAppender = OpenSPCoop2Logger.tipoDumpOpenSPCoopAppender;
        this.gdo = DateManager.getDate();
        this.signature = this.dominio != null ? this.dominio.getCodicePorta() + " <" + String.valueOf(this.gdo) + "> " + this.idModulo + "\n" : "<" + String.valueOf(this.gdo) + "> " + this.idModulo + "\n";
        this.tipoPdD = tipoPdD;
        this.nomePorta = nomePorta;
        this.pddContext = pddContext;
        if (this.pddContext == null) {
            throw new DumpException("PdDContext is null");
        }
        this.properties = OpenSPCoop2Properties.getInstance();
        if (stateParam instanceof StateMessage) {
            this.statoRichiesta = (StateMessage)stateParam;
        }
        if (responseStateParam instanceof StateMessage) {
            this.statoRisposta = (StateMessage)responseStateParam;
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        this.dumpConfigurazione = dumpConfigurazione;
        if (this.pddContext.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
        }
        this.msgDiagErroreDump = MsgDiagnostico.newInstance(this.tipoPdD, dominio, modulo, nomePorta, this.requestInfo, (IState)this.statoRichiesta, (IState)this.statoRisposta);
        this.msgDiagErroreDump.setPrefixMsgPersonalizzati("tracciamento.");
        this.emitDiagnosticDump = op2Properties.isDumpEmitDiagnostic();
        this.idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
        String protocol = null;
        try {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.pddContext.getObject(Costanti.PROTOCOL_NAME));
            protocol = this.protocolFactory.getProtocol();
            this.msgDiagErroreDump.setPddContext(this.pddContext, this.protocolFactory);
        }
        catch (Exception e) {
            throw new DumpException("Errore durante l'inizializzazione del ProtocolFactoryManager...", (Throwable)e);
        }
        if (this.dominio == null) {
            this.dominio = op2Properties.getIdentitaPortaDefault(protocol, this.requestInfo);
        }
        try {
            if (this.idTransazione != null) {
                this.transactionNullable = TransactionContext.getTransaction(this.idTransazione);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection getConnectionFromState(boolean richiesta) {
        if (richiesta) {
            Connection c = StateMessage.getConnection((StateMessage)this.statoRichiesta);
            if (c != null) {
                return c;
            }
        } else {
            Connection c = StateMessage.getConnection((StateMessage)this.statoRisposta);
            if (c != null) {
                return c;
            }
        }
        return null;
    }

    public void emitDiagnosticStartDumpBinarioRichiestaIngresso(boolean onlyFileTrace) {
        this.emitDiagnosticDumpStart(TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, onlyFileTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBinarioRichiestaIngresso(boolean dumpBinarioRegistrazioneDatabase, boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, DumpByteArrayOutputStream msg, MessageType messageType, URLProtocolContext protocolContext) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpBinarioRichiestaIngresso();
        }
        try {
            this.dump(dumpBinarioRegistrazioneDatabase, onlyLogFileTraceHeaders, onlyLogFileTraceBody, TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO, null, msg, messageType, protocolContext != null ? protocolContext.getSource() : null, protocolContext != null ? protocolContext.getHeaders() : null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpBinarioRichiestaIngresso();
            }
        }
    }

    public void dumpRichiestaIngresso(OpenSPCoop2Message msg, URLProtocolContext protocolContext) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpRichiestaIngresso();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.RICHIESTA_INGRESSO, msg, null, null, protocolContext != null ? protocolContext.getSource() : null, protocolContext != null ? protocolContext.getHeaders() : null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpRichiestaIngresso();
            }
        }
    }

    public void dumpRichiestaIngressoByIntegrationManagerError(byte[] msg, URLProtocolContext protocolContext) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpRichiestaIngresso();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.RICHIESTA_INGRESSO, null, DumpByteArrayOutputStream.newInstance((byte[])msg), null, protocolContext != null ? protocolContext.getSource() : null, protocolContext != null ? protocolContext.getHeaders() : null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpRichiestaIngresso();
            }
        }
    }

    public void emitDiagnosticStartDumpBinarioRichiestaUscita(boolean onlyFileTrace) {
        this.emitDiagnosticDumpStart(TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, onlyFileTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBinarioRichiestaUscita(boolean dumpBinarioRegistrazioneDatabase, boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, DumpByteArrayOutputStream msg, MessageType messageType, InfoConnettoreUscita infoConnettore) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpBinarioRichiestaUscita();
        }
        try {
            this.dump(dumpBinarioRegistrazioneDatabase, onlyLogFileTraceHeaders, onlyLogFileTraceBody, TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO, null, msg, messageType, infoConnettore != null ? infoConnettore.getLocation() : null, infoConnettore != null ? infoConnettore.getHeaders() : null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpBinarioRichiestaUscita();
            }
        }
    }

    public void dumpRichiestaUscita(OpenSPCoop2Message msg, InfoConnettoreUscita infoConnettore) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpRichiestaUscita();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.RICHIESTA_USCITA, msg, null, null, infoConnettore != null ? infoConnettore.getLocation() : null, infoConnettore != null ? infoConnettore.getHeaders() : null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpRichiestaUscita();
            }
        }
    }

    public void emitDiagnosticStartDumpBinarioRispostaIngresso(boolean onlyFileTrace) {
        this.emitDiagnosticDumpStart(TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, onlyFileTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBinarioRispostaIngresso(boolean dumpBinarioRegistrazioneDatabase, boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, DumpByteArrayOutputStream msg, MessageType messageType, InfoConnettoreUscita infoConnettore, Map<String, List<String>> transportHeaderRisposta) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpBinarioRispostaIngresso();
        }
        try {
            this.dump(dumpBinarioRegistrazioneDatabase, onlyLogFileTraceHeaders, onlyLogFileTraceBody, TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO, null, msg, messageType, infoConnettore != null ? infoConnettore.getLocation() : null, transportHeaderRisposta);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpBinarioRispostaIngresso();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpRispostaIngresso(OpenSPCoop2Message msg, InfoConnettoreUscita infoConnettore, Map<String, List<String>> transportHeaderRisposta) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpRispostaIngresso();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.RISPOSTA_INGRESSO, msg, null, null, infoConnettore != null ? infoConnettore.getLocation() : null, transportHeaderRisposta);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpRispostaIngresso();
            }
        }
    }

    public void emitDiagnosticStartDumpBinarioRispostaUscita(boolean onlyFileTrace) {
        this.emitDiagnosticDumpStart(TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, onlyFileTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBinarioRispostaUscita(boolean dumpBinarioRegistrazioneDatabase, boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, DumpByteArrayOutputStream msg, MessageType messageType, URLProtocolContext protocolContext, Map<String, List<String>> transportHeaderRisposta) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpBinarioRispostaUscita();
        }
        try {
            this.dump(dumpBinarioRegistrazioneDatabase, onlyLogFileTraceHeaders, onlyLogFileTraceBody, TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO, null, msg, messageType, protocolContext != null ? protocolContext.getSource() : null, transportHeaderRisposta);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpBinarioRispostaUscita();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpRispostaUscita(OpenSPCoop2Message msg, URLProtocolContext protocolContext, Map<String, List<String>> transportHeaderRisposta) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpRispostaUscita();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.RISPOSTA_USCITA, msg, null, null, protocolContext != null ? protocolContext.getSource() : null, transportHeaderRisposta);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpRispostaUscita();
            }
        }
    }

    public void dumpIntegrationManagerGetMessage(OpenSPCoop2Message msg) throws DumpException {
        if (this.transactionNullable != null) {
            this.transactionNullable.getTempiElaborazione().startDumpIntegrationManager();
        }
        try {
            this.dump(false, false, false, TipoMessaggio.INTEGRATION_MANAGER, msg, null, null, "IntegrationManager.getMessage()", null);
        }
        finally {
            if (this.transactionNullable != null) {
                this.transactionNullable.getTempiElaborazione().endDumpIntegrationManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(boolean dumpBinarioRegistrazioneDatabase, boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, TipoMessaggio tipoMessaggio, OpenSPCoop2Message msg, DumpByteArrayOutputStream msgBytes, MessageType messageType, String location, Map<String, List<String>> transportHeaderParam) throws DumpException {
        boolean dumpNormale = TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)tipoMessaggio) || TipoMessaggio.RICHIESTA_USCITA.equals((Object)tipoMessaggio) || TipoMessaggio.RISPOSTA_INGRESSO.equals((Object)tipoMessaggio) || TipoMessaggio.RISPOSTA_USCITA.equals((Object)tipoMessaggio);
        boolean dumpBinario = TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.equals((Object)tipoMessaggio) || TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.equals((Object)tipoMessaggio) || TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.equals((Object)tipoMessaggio) || TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.equals((Object)tipoMessaggio);
        boolean dumpIntegrationManager = TipoMessaggio.INTEGRATION_MANAGER.equals((Object)tipoMessaggio);
        if (dumpNormale) {
            if (this.dumpConfigurazione == null) {
                return;
            }
            if (this.dumpConfigurazione != null && StatoFunzionalita.DISABILITATO.equals((Object)this.dumpConfigurazione.getRealtime())) {
                return;
            }
        }
        boolean dumpHeaders = true;
        boolean dumpBody = true;
        boolean dumpAttachments = true;
        if (dumpBinario) {
            dumpAttachments = false;
        }
        boolean dumpBinarioAttivatoTramiteRegolaConfigurazione = false;
        if (dumpNormale) {
            if (TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)tipoMessaggio)) {
                if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRichiestaIngresso() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getPayloadParsing())) {
                        dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getHeaders());
                        dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getBody());
                        dumpAttachments = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getAttachments());
                    } else {
                        dumpHeaders = false;
                        dumpBody = false;
                        dumpAttachments = false;
                    }
                }
            } else if (TipoMessaggio.RICHIESTA_USCITA.equals((Object)tipoMessaggio)) {
                if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRichiestaUscita() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getPayloadParsing())) {
                        dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getHeaders());
                        dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getBody());
                        dumpAttachments = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getAttachments());
                    } else {
                        dumpHeaders = false;
                        dumpBody = false;
                        dumpAttachments = false;
                    }
                }
            } else if (TipoMessaggio.RISPOSTA_INGRESSO.equals((Object)tipoMessaggio)) {
                if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRispostaIngresso() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getPayloadParsing())) {
                        dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getHeaders());
                        dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getBody());
                        dumpAttachments = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getAttachments());
                    } else {
                        dumpHeaders = false;
                        dumpBody = false;
                        dumpAttachments = false;
                    }
                }
            } else if (TipoMessaggio.RISPOSTA_USCITA.equals((Object)tipoMessaggio) && this.dumpConfigurazione != null && this.dumpConfigurazione.getRispostaUscita() != null) {
                if (StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getPayloadParsing())) {
                    dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getHeaders());
                    dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getBody());
                    dumpAttachments = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getAttachments());
                } else {
                    dumpHeaders = false;
                    dumpBody = false;
                    dumpAttachments = false;
                }
            }
            if (!(dumpHeaders || dumpBody || dumpAttachments)) {
                return;
            }
        } else if (dumpBinario) {
            if (!dumpBinarioRegistrazioneDatabase) {
                dumpHeaders = false;
                dumpBody = false;
                if (TipoMessaggio.RICHIESTA_INGRESSO_DUMP_BINARIO.equals((Object)tipoMessaggio)) {
                    if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRichiestaIngresso() != null) {
                        boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getPayloadParsing());
                        if (!payloadParsing) {
                            dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getHeaders());
                            dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaIngresso().getPayload());
                            dumpBinarioAttivatoTramiteRegolaConfigurazione = dumpHeaders || dumpBody;
                        }
                    }
                } else if (TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.equals((Object)tipoMessaggio)) {
                    if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRichiestaUscita() != null) {
                        boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getPayloadParsing());
                        if (!payloadParsing) {
                            dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getHeaders());
                            dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRichiestaUscita().getPayload());
                            dumpBinarioAttivatoTramiteRegolaConfigurazione = dumpHeaders || dumpBody;
                        }
                    }
                } else if (TipoMessaggio.RISPOSTA_INGRESSO_DUMP_BINARIO.equals((Object)tipoMessaggio)) {
                    if (this.dumpConfigurazione != null && this.dumpConfigurazione.getRispostaIngresso() != null) {
                        boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getPayloadParsing());
                        if (!payloadParsing) {
                            dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getHeaders());
                            dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaIngresso().getPayload());
                            dumpBinarioAttivatoTramiteRegolaConfigurazione = dumpHeaders || dumpBody;
                        }
                    }
                } else if (TipoMessaggio.RISPOSTA_USCITA_DUMP_BINARIO.equals((Object)tipoMessaggio) && this.dumpConfigurazione != null && this.dumpConfigurazione.getRispostaUscita() != null) {
                    boolean bl = payloadParsing = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getPayload()) && StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getPayloadParsing());
                    if (!payloadParsing) {
                        dumpHeaders = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getHeaders());
                        dumpBody = StatoFunzionalita.ABILITATO.equals((Object)this.dumpConfigurazione.getRispostaUscita().getPayload());
                        boolean bl2 = dumpBinarioAttivatoTramiteRegolaConfigurazione = dumpHeaders || dumpBody;
                    }
                }
            }
            if (!(dumpHeaders || dumpBody || dumpAttachments || onlyLogFileTraceHeaders || onlyLogFileTraceBody)) {
                return;
            }
        }
        boolean dumpMultipartHeaders = dumpHeaders;
        String identificativoDiagnostico = null;
        if (dumpNormale) {
            identificativoDiagnostico = this.emitDiagnosticDumpStart(tipoMessaggio, false);
        } else {
            boolean onlyFileTrace = !dumpHeaders && !dumpBody && !dumpAttachments;
            identificativoDiagnostico = this.getIdentificativoDiagnostico(tipoMessaggio, onlyFileTrace);
        }
        try {
            this.dumpEngine(onlyLogFileTraceHeaders, onlyLogFileTraceBody, tipoMessaggio, msg, msgBytes, messageType, location, transportHeaderParam, dumpHeaders, dumpBody, dumpAttachments, dumpMultipartHeaders, dumpIntegrationManager, dumpBinario, dumpBinarioAttivatoTramiteRegolaConfigurazione);
        }
        finally {
            if (identificativoDiagnostico != null && this.emitDiagnosticDump) {
                try {
                    if (this.transazioneApplicativoServer != null && this.idPortaApplicativa != null) {
                        this.msgDiagErroreDump.setTransazioneApplicativoServer(this.transazioneApplicativoServer, this.idPortaApplicativa);
                    }
                    this.msgDiagErroreDump.logPersonalizzato(identificativoDiagnostico + "completato");
                }
                catch (Exception t) {
                    if (this.loggerDump != null) {
                        this.loggerDumpError("Riscontrato errore durante l'emissione del diagnostico per il dump del contenuto applicativo in corso del messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + t.getMessage(), t);
                    }
                }
                finally {
                    this.msgDiagErroreDump.setTransazioneApplicativoServer(null, null);
                }
            }
        }
    }

    private String getIdentificativoDiagnostico(TipoMessaggio tipoMessaggio, boolean onlyFileTrace) {
        String identificativoDiagnostico = null;
        if (tipoMessaggio != null) {
            switch (tipoMessaggio) {
                case RICHIESTA_INGRESSO: 
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    if (onlyFileTrace) {
                        identificativoDiagnostico = "dumpContenutiApplicativiFileTrace.richiestaIngresso.";
                        break;
                    }
                    identificativoDiagnostico = "dumpContenutiApplicativi.richiestaIngresso.";
                    break;
                }
                case RICHIESTA_USCITA: 
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    if (onlyFileTrace) {
                        identificativoDiagnostico = "dumpContenutiApplicativiFileTrace.richiestaUscita.";
                        break;
                    }
                    identificativoDiagnostico = "dumpContenutiApplicativi.richiestaUscita.";
                    break;
                }
                case RISPOSTA_INGRESSO: 
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    if (onlyFileTrace) {
                        identificativoDiagnostico = "dumpContenutiApplicativiFileTrace.rispostaIngresso.";
                        break;
                    }
                    identificativoDiagnostico = "dumpContenutiApplicativi.rispostaIngresso.";
                    break;
                }
                case RISPOSTA_USCITA: 
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    if (onlyFileTrace) {
                        identificativoDiagnostico = "dumpContenutiApplicativiFileTrace.rispostaUscita.";
                        break;
                    }
                    identificativoDiagnostico = "dumpContenutiApplicativi.rispostaUscita.";
                    break;
                }
            }
        }
        return identificativoDiagnostico;
    }

    private String emitDiagnosticDumpStart(TipoMessaggio tipoMessaggio, boolean onlyFileTrace) {
        String identificativoDiagnostico = this.getIdentificativoDiagnostico(tipoMessaggio, onlyFileTrace);
        this.emitDiagnosticDumpStart(tipoMessaggio, identificativoDiagnostico);
        return identificativoDiagnostico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitDiagnosticDumpStart(TipoMessaggio tipoMessaggio, String identificativoDiagnostico) {
        if (identificativoDiagnostico != null && this.emitDiagnosticDump) {
            try {
                if (this.transazioneApplicativoServer != null && this.idPortaApplicativa != null) {
                    this.msgDiagErroreDump.setTransazioneApplicativoServer(this.transazioneApplicativoServer, this.idPortaApplicativa);
                }
                this.msgDiagErroreDump.logPersonalizzato(identificativoDiagnostico + "inCorso");
            }
            catch (Exception t) {
                if (this.loggerDump != null) {
                    this.loggerDumpError("Riscontrato errore durante l'emissione del diagnostico per il dump del contenuto applicativo in corso del messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + t.getMessage(), t);
                }
            }
            finally {
                this.msgDiagErroreDump.setTransazioneApplicativoServer(null, null);
            }
        }
    }

    private List<String> initDumpWhiteHeaderList(TipoMessaggio tipoMessaggio) {
        return this.initDumpHeaderList(true, tipoMessaggio);
    }

    private List<String> initDumpBlackHeaderList(TipoMessaggio tipoMessaggio) {
        return this.initDumpHeaderList(false, tipoMessaggio);
    }

    private List<String> initDumpHeaderList(boolean whiteList, TipoMessaggio tipoMessaggio) {
        List<String> l = this.initDumpHeaderPorta(whiteList, tipoMessaggio);
        if (l != null && !l.isEmpty()) {
            return l;
        }
        if (this.tipoPdD != null && tipoMessaggio != null && (l = this.initDumpHeaderListRequestResponse(whiteList, tipoMessaggio)) != null && !l.isEmpty()) {
            return l;
        }
        if (this.tipoPdD != null && (l = this.initDumpHeaderList(whiteList, this.properties.getDumpHeaderErogazioniWhiteList(), this.properties.getDumpHeaderErogazioniBlackList(), this.properties.getDumpHeaderFruizioniWhiteList(), this.properties.getDumpHeaderFruizioniBlackList())) != null && !l.isEmpty()) {
            return l;
        }
        return whiteList ? this.properties.getDumpHeaderWhiteList() : this.properties.getDumpHeaderBlackList();
    }

    private List<Proprieta> getProprietaPortaList() throws DriverConfigurazioneException {
        List<Proprieta> lReturn = null;
        if (this.tipoPdD != null && this.nomePorta != null) {
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(this.statoRichiesta != null ? this.statoRichiesta : this.statoRisposta);
            if (TipoPdD.APPLICATIVA.equals((Object)this.tipoPdD)) {
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(this.nomePorta);
                PortaApplicativa pa = configPdDManager.getPortaApplicativaSafeMethod(idPA, this.requestInfo);
                if (pa != null) {
                    return pa.getProprieta();
                }
            } else if (TipoPdD.DELEGATA.equals((Object)this.tipoPdD)) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(this.nomePorta);
                PortaDelegata pd = configPdDManager.getPortaDelegataSafeMethod(idPD, this.requestInfo);
                if (pd != null) {
                    return pd.getProprieta();
                }
            }
        }
        return lReturn;
    }

    private List<String> initDumpHeaderPorta(boolean whiteList, TipoMessaggio tipoMessaggio) {
        List<String> l = null;
        List<Proprieta> portaProps = null;
        try {
            portaProps = this.getProprietaPortaList();
        }
        catch (Exception e) {
            this.loggerDumpError("Recupero propriet\u00e0 dalla porta '" + this.nomePorta + "' (tipo: " + String.valueOf(this.tipoPdD) + ") fallito: " + e.getMessage(), e);
        }
        if (portaProps != null && !portaProps.isEmpty()) {
            List<String> black;
            l = this.initDumpHeaderListRequestResponsePorta(whiteList, tipoMessaggio, portaProps);
            if (l != null && !l.isEmpty()) {
                return l;
            }
            List<String> white = CostantiProprieta.getRegistrazioneMessaggiWhiteList(portaProps);
            l = this.initDumpHeaderList(whiteList, white, black = CostantiProprieta.getRegistrazioneMessaggiBlackList(portaProps), white, black);
            if (l != null && !l.isEmpty()) {
                return l;
            }
        }
        return l;
    }

    private List<String> initDumpHeaderListRequestResponsePorta(boolean whiteList, TipoMessaggio tipoMessaggio, List<Proprieta> proprieta) {
        List<String> l = null;
        if (this.tipoPdD != null && tipoMessaggio != null) {
            switch (tipoMessaggio) {
                case RICHIESTA_INGRESSO: 
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    List<String> white = CostantiProprieta.getRegistrazioneMessaggiRichiestaIngressoWhiteList(proprieta);
                    List<String> black = CostantiProprieta.getRegistrazioneMessaggiRichiestaIngressoBlackList(proprieta);
                    l = this.initDumpHeaderList(whiteList, white, black, white, black);
                    break;
                }
                case RICHIESTA_USCITA: 
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    List<String> white = CostantiProprieta.getRegistrazioneMessaggiRichiestaUscitaWhiteList(proprieta);
                    List<String> black = CostantiProprieta.getRegistrazioneMessaggiRichiestaUscitaBlackList(proprieta);
                    l = this.initDumpHeaderList(whiteList, white, black, white, black);
                    break;
                }
                case RISPOSTA_INGRESSO: 
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    List<String> white = CostantiProprieta.getRegistrazioneMessaggiRispostaIngressoWhiteList(proprieta);
                    List<String> black = CostantiProprieta.getRegistrazioneMessaggiRispostaIngressoBlackList(proprieta);
                    l = this.initDumpHeaderList(whiteList, white, black, white, black);
                    break;
                }
                case RISPOSTA_USCITA: 
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    List<String> white = CostantiProprieta.getRegistrazioneMessaggiRispostaUscitaWhiteList(proprieta);
                    List<String> black = CostantiProprieta.getRegistrazioneMessaggiRispostaUscitaBlackList(proprieta);
                    l = this.initDumpHeaderList(whiteList, white, black, white, black);
                    break;
                }
            }
        }
        return l;
    }

    private List<String> initDumpHeaderListRequestResponse(boolean whiteList, TipoMessaggio tipoMessaggio) {
        List<String> l = null;
        if (this.tipoPdD != null && tipoMessaggio != null) {
            switch (tipoMessaggio) {
                case RICHIESTA_INGRESSO: 
                case RICHIESTA_INGRESSO_DUMP_BINARIO: {
                    l = this.initDumpHeaderList(whiteList, this.properties.getDumpHeaderErogazioniRichiestaIngressoWhiteList(), this.properties.getDumpHeaderErogazioniRichiestaIngressoBlackList(), this.properties.getDumpHeaderFruizioniRichiestaIngressoWhiteList(), this.properties.getDumpHeaderFruizioniRichiestaIngressoBlackList());
                    break;
                }
                case RICHIESTA_USCITA: 
                case RICHIESTA_USCITA_DUMP_BINARIO: {
                    l = this.initDumpHeaderList(whiteList, this.properties.getDumpHeaderErogazioniRichiestaUscitaWhiteList(), this.properties.getDumpHeaderErogazioniRichiestaUscitaBlackList(), this.properties.getDumpHeaderFruizioniRichiestaUscitaWhiteList(), this.properties.getDumpHeaderFruizioniRichiestaUscitaBlackList());
                    break;
                }
                case RISPOSTA_INGRESSO: 
                case RISPOSTA_INGRESSO_DUMP_BINARIO: {
                    l = this.initDumpHeaderList(whiteList, this.properties.getDumpHeaderErogazioniRispostaIngressoWhiteList(), this.properties.getDumpHeaderErogazioniRispostaIngressoBlackList(), this.properties.getDumpHeaderFruizioniRispostaIngressoWhiteList(), this.properties.getDumpHeaderFruizioniRispostaIngressoBlackList());
                    break;
                }
                case RISPOSTA_USCITA: 
                case RISPOSTA_USCITA_DUMP_BINARIO: {
                    l = this.initDumpHeaderList(whiteList, this.properties.getDumpHeaderErogazioniRispostaUscitaWhiteList(), this.properties.getDumpHeaderErogazioniRispostaUscitaBlackList(), this.properties.getDumpHeaderFruizioniRispostaUscitaWhiteList(), this.properties.getDumpHeaderFruizioniRispostaUscitaBlackList());
                    break;
                }
            }
        }
        return l;
    }

    private List<String> initDumpHeaderList(boolean whiteList, List<String> erogazioniWhiteList, List<String> erogazioniBlackList, List<String> fruizioniWhiteList, List<String> fruizioniBlackList) {
        List<String> l = null;
        if (TipoPdD.APPLICATIVA.equals((Object)this.tipoPdD)) {
            l = whiteList ? erogazioniWhiteList : erogazioniBlackList;
        } else if (TipoPdD.DELEGATA.equals((Object)this.tipoPdD)) {
            l = whiteList ? fruizioniWhiteList : fruizioniBlackList;
        }
        return l;
    }

    private void dumpEngine(boolean onlyLogFileTraceHeaders, boolean onlyLogFileTraceBody, TipoMessaggio tipoMessaggio, OpenSPCoop2Message msg, DumpByteArrayOutputStream msgBytes, MessageType messageType, String location, Map<String, List<String>> transportHeaderParam, boolean dumpHeaders, boolean dumpBody, boolean dumpAttachments, boolean dumpMultipartHeaders, boolean dumpIntegrationManager, boolean dumpBinario, boolean dumpBinarioAttivatoTramiteRegolaConfigurazione) throws DumpException {
        Messaggio messaggio = new Messaggio();
        if (this.protocolFactory != null) {
            messaggio.setProtocollo(this.protocolFactory.getProtocol());
        }
        messaggio.setTipoMessaggio(tipoMessaggio);
        if (msg != null) {
            messaggio.setFormatoMessaggio(msg.getMessageType());
        } else if (messageType != null) {
            messaggio.setFormatoMessaggio(messageType);
        }
        messaggio.setGdo(DateManager.getDate());
        messaggio.setDominio(this.dominio);
        messaggio.setTipoPdD(this.tipoPdD);
        messaggio.setIdFunzione(this.idModulo);
        messaggio.setIdTransazione(this.idTransazione);
        messaggio.setIdBusta(this.idMessaggio);
        messaggio.setFruitore(this.fruitore);
        messaggio.setServizio(this.servizio);
        if (this.protocolFactory != null) {
            messaggio.setProtocollo(this.protocolFactory.getProtocol());
        }
        HashMap<String, List> transportHeader = new HashMap<String, List>();
        try {
            String contentType;
            if (transportHeaderParam != null && transportHeaderParam.size() > 0) {
                transportHeader.putAll(transportHeaderParam);
            }
            if (msg != null) {
                OpenSPCoop2MessageProperties forwardHeader = null;
                if (TipoMessaggio.RICHIESTA_USCITA.equals((Object)tipoMessaggio)) {
                    forwardHeader = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? msg.getForwardTransportHeader(this.properties.getRESTServicesHeadersForwardConfig(true)) : msg.getForwardTransportHeader(this.properties.getSOAPServicesHeadersForwardConfig(true));
                } else if (TipoMessaggio.RISPOSTA_USCITA.equals((Object)tipoMessaggio)) {
                    forwardHeader = ServiceBinding.REST.equals((Object)msg.getServiceBinding()) ? msg.getForwardTransportHeader(this.properties.getRESTServicesHeadersForwardConfig(false)) : msg.getForwardTransportHeader(this.properties.getSOAPServicesHeadersForwardConfig(false));
                }
                if (forwardHeader != null && forwardHeader.size() > 0) {
                    Iterator enHdr = forwardHeader.getKeys();
                    while (enHdr.hasNext()) {
                        List values;
                        String key = (String)enHdr.next();
                        if (key == null || (values = forwardHeader.getPropertyValues(key)) == null || values.isEmpty()) continue;
                        transportHeader.put(key, values);
                    }
                }
            }
            if (msg != null && !TransportUtils.containsKey(transportHeader, (String)"Content-Type") && (contentType = msg.getContentType()) != null) {
                TransportUtils.setHeader(transportHeader, (String)"Content-Type", (String)contentType);
            }
        }
        catch (Exception e) {
            String messaggioErrore = "Riscontrato errore durante la lettura degli header di trasporto del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + e.getMessage();
            this.loggerDumpError(messaggioErrore);
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error(messaggioErrore);
        }
        if ((dumpHeaders || onlyLogFileTraceHeaders) && transportHeader != null && transportHeader.size() > 0) {
            List<String> filterList = null;
            boolean white = false;
            List<String> dumpHeaderWhiteList = this.initDumpWhiteHeaderList(tipoMessaggio);
            List<String> dumpHeaderBlackList = this.initDumpBlackHeaderList(tipoMessaggio);
            if (dumpHeaderWhiteList != null && !dumpHeaderWhiteList.isEmpty()) {
                filterList = dumpHeaderWhiteList;
                white = true;
            } else if (dumpHeaderBlackList != null && !dumpHeaderBlackList.isEmpty()) {
                filterList = dumpHeaderBlackList;
                white = false;
            }
            for (String key : transportHeader.keySet()) {
                if (key == null) continue;
                boolean add = false;
                if (filterList != null) {
                    boolean find = false;
                    for (String filterHdr : filterList) {
                        if (!filterHdr.equalsIgnoreCase(key)) continue;
                        find = true;
                        break;
                    }
                    if (white) {
                        if (find) {
                            add = true;
                        }
                    } else if (!find) {
                        add = true;
                    }
                } else {
                    add = true;
                }
                if (!add) continue;
                List values = (List)transportHeader.get(key);
                messaggio.getHeaders().put(key, values);
            }
        }
        DumpMessaggio dumpMessaggio = null;
        DumpMessaggioConfig dumpMessaggioConfig = null;
        try {
            if (dumpBody || onlyLogFileTraceBody || dumpAttachments) {
                if (msg != null) {
                    dumpMessaggioConfig = new DumpMessaggioConfig();
                    dumpMessaggio = Dump.fillMessaggio(msg, dumpMessaggioConfig, dumpBody, dumpAttachments, dumpMultipartHeaders, messaggio);
                } else if (dumpBody || onlyLogFileTraceBody) {
                    if (transportHeader != null && !transportHeader.isEmpty()) {
                        for (String key : transportHeader.keySet()) {
                            if (!"Content-Type".equalsIgnoreCase(key)) continue;
                            List values = (List)transportHeader.get(key);
                            if (values == null || values.isEmpty()) break;
                            messaggio.setContentType((String)values.get(0));
                            break;
                        }
                    }
                    messaggio.setBody(msgBytes);
                }
            }
        }
        catch (Exception e) {
            try {
                this.loggerDumpError("Riscontrato errore durante la preparazione al dump del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + e.getMessage());
            }
            catch (Exception key) {
                // empty catch block
            }
            this.loggerOpenSPCoopResourcesError("Errore durante la preparazione al dump del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ": " + e.getMessage(), e);
            try {
                this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getValue());
                this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                this.msgDiagErroreDump.logPersonalizzato(DIAGNOSTICO_REGISTRAZIONE_NON_RIUSCITA);
            }
            catch (Exception key) {
                // empty catch block
            }
            this.gestioneErroreDump(e);
        }
        if (this.properties.isTransazioniSaveDumpInUniqueTransaction() || onlyLogFileTraceBody || onlyLogFileTraceHeaders) {
            if (this.transazioneApplicativoServer != null) {
                try {
                    messaggio.setIdTransazione(this.transazioneApplicativoServer.getIdTransazione());
                    messaggio.setServizioApplicativoErogatore(this.transazioneApplicativoServer.getServizioApplicativoErogatore());
                    messaggio.setDataConsegna(this.dataConsegnaTransazioneApplicativoServer);
                    GestoreConsegnaMultipla.getInstance().safeSave(messaggio, this.idPortaApplicativa, (IState)(this.statoRichiesta != null ? this.statoRichiesta : this.statoRisposta), this.requestInfo, (Context)this.pddContext);
                }
                catch (Exception t) {
                    String msgError = "Errore durante il salvataggio delle informazioni relative al servizio applicativo: " + t.getMessage();
                    this.loggerDumpError(msgError, t);
                    this.loggerOpenSPCoopResourcesError(msgError, t);
                    try {
                        this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getValue());
                        this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", t.getMessage());
                        this.msgDiagErroreDump.logPersonalizzato(DIAGNOSTICO_REGISTRAZIONE_NON_RIUSCITA);
                    }
                    catch (Exception values) {
                        // empty catch block
                    }
                    this.gestioneErroreDump(t);
                }
            } else {
                Exception exc = null;
                boolean gestioneStateful = false;
                try {
                    Transaction tr = TransactionContext.getTransaction(this.idTransazione);
                    if (messaggio.getBody() != null) {
                        messaggio.getBody().lock();
                    }
                    tr.addMessaggio(messaggio, onlyLogFileTraceHeaders, onlyLogFileTraceBody);
                }
                catch (TransactionDeletedException | TransactionNotExistsException e) {
                    gestioneStateful = true;
                }
                catch (Exception e) {
                    exc = e;
                }
                if (gestioneStateful && !dumpIntegrationManager) {
                    try {
                        RepositoryGestioneStateful.addMessaggio(this.idTransazione, messaggio);
                    }
                    catch (Exception e) {
                        exc = e;
                    }
                }
                if (exc != null) {
                    try {
                        this.loggerDumpError("Riscontrato errore durante la registrazione, nel contesto della transazione, del dump del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + exc.getMessage());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.loggerOpenSPCoopResourcesError("Errore durante la registrazione, nel contesto della transazione, del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ": " + exc.getMessage(), exc);
                    try {
                        this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getValue());
                        this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", exc.getMessage());
                        this.msgDiagErroreDump.logPersonalizzato(DIAGNOSTICO_REGISTRAZIONE_NON_RIUSCITA);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.gestioneErroreDump(exc);
                }
            }
        }
        if (OpenSPCoop2Logger.loggerDumpAbilitato && (!dumpBinario || dumpBinarioAttivatoTramiteRegolaConfigurazione)) {
            try {
                StringBuilder out = new StringBuilder();
                out.append(this.signature);
                out.append("TipoMessaggio:" + tipoMessaggio.getValue());
                if (this.idTransazione != null) {
                    out.append(" idTransazione:");
                    out.append(this.idTransazione);
                }
                if (this.idMessaggio != null) {
                    out.append(" idMessaggio:");
                    out.append(this.idMessaggio);
                }
                if (location != null) {
                    if (TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)tipoMessaggio) || TipoMessaggio.RISPOSTA_USCITA.equals((Object)tipoMessaggio)) {
                        out.append(" source:");
                    } else {
                        out.append(" location:");
                    }
                    out.append(location);
                }
                if (this.fruitore != null) {
                    out.append(" FR:");
                    out.append(this.fruitore.toString());
                }
                if (this.fruitore != null && this.servizio != null) {
                    out.append(" -> ");
                }
                if (this.servizio != null) {
                    if (this.servizio.getNome() != null) {
                        out.append(" S:");
                        try {
                            out.append(IDServizioFactory.getInstance().getUriFromIDServizio(this.servizio));
                        }
                        catch (Exception e) {
                            out.append(this.servizio.toString(false));
                        }
                    } else if (this.servizio.getSoggettoErogatore() != null) {
                        out.append(" ER:");
                        out.append(this.servizio.getSoggettoErogatore().toString());
                    }
                }
                out.append(" \n");
                if (dumpHeaders) {
                    out.append("------ Header di trasporto ------\n");
                    if (messaggio.getHeaders() != null && messaggio.getHeaders().size() > 0) {
                        for (String key : messaggio.getHeaders().keySet()) {
                            List values;
                            if (key == null || (values = (List)messaggio.getHeaders().get(key)) == null || values.isEmpty()) continue;
                            for (String value : values) {
                                out.append("- " + key + ": " + value + "\n");
                            }
                        }
                    } else {
                        out.append("Non presenti\n");
                    }
                }
                if (dumpBody || dumpAttachments) {
                    if (msg != null) {
                        if (dumpAttachments && !this.properties.isDumpAllAttachments()) {
                            dumpMessaggio = ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) ? DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg.castAsSoap(), (DumpMessaggioConfig)dumpMessaggioConfig, (boolean)false) : DumpRestMessageUtils.dumpMessage((OpenSPCoop2RestMessage)msg.castAsRest(), (DumpMessaggioConfig)dumpMessaggioConfig, (boolean)false);
                        }
                        if (dumpMessaggio != null) {
                            out.append(dumpMessaggio.toString(dumpMessaggioConfig, this.properties.isDumpAllAttachments()));
                        }
                    } else if (msgBytes != null && msgBytes.size() > 0) {
                        if (MultipartUtils.messageWithAttachment((byte[])msgBytes.toByteArray())) {
                            out.append("------ MessageWithAttachments ------\n");
                        } else {
                            out.append("------ Message ------\n");
                        }
                        out.append(msgBytes.toString());
                    } else {
                        out.append("------ Message ------\n");
                        out.append("Non presente\n");
                    }
                }
                String msgDump = out.toString();
                this.loggerDump.info(msgDump);
            }
            catch (Exception e) {
                try {
                    this.loggerDumpError("Riscontrato errore durante il dump su file di log del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ":" + e.getMessage());
                }
                catch (Exception msgDump) {
                    // empty catch block
                }
                this.loggerOpenSPCoopResourcesError("Errore durante il dump su file di log del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ": " + e.getMessage(), e);
                try {
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getValue());
                    this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreDump.logPersonalizzato(DIAGNOSTICO_REGISTRAZIONE_NON_RIUSCITA);
                }
                catch (Exception msgDump) {
                    // empty catch block
                }
                this.gestioneErroreDump(e);
            }
        }
        boolean onlyLogFileTrace = false;
        if (onlyLogFileTraceHeaders && !dumpHeaders || onlyLogFileTraceBody && !dumpBody) {
            onlyLogFileTrace = true;
        }
        if (!onlyLogFileTrace && !dumpIntegrationManager) {
            for (int i = 0; i < this.loggerDumpOpenSPCoopAppender.size(); ++i) {
                try {
                    boolean headersCompact = false;
                    this.loggerDumpOpenSPCoopAppender.get(i).dump(this.getConnectionFromState(false), messaggio, headersCompact);
                    continue;
                }
                catch (Exception e) {
                    this.loggerOpenSPCoopResourcesError("Errore durante il dump personalizzato [" + this.tipoDumpOpenSPCoopAppender.get(i) + "] del contenuto applicativo presente nel messaggio (" + String.valueOf(tipoMessaggio) + ") " + this.getLogIdTransazione() + ": " + e.getMessage(), e);
                    try {
                        this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getValue());
                        this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                        this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoDumpOpenSPCoopAppender.get(i));
                        this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.gestioneErroreDump(e);
                }
            }
        }
    }

    public static DumpMessaggio fillMessaggio(OpenSPCoop2Message msg, DumpMessaggioConfig dumpMessaggioConfig, boolean dumpBody, boolean dumpAttachments, boolean dumpMultipartHeaders, Messaggio messaggio) throws MessageException {
        DumpMessaggio dumpMessaggio = null;
        dumpMessaggioConfig.setDumpBody(dumpBody);
        dumpMessaggioConfig.setDumpHeaders(false);
        dumpMessaggioConfig.setDumpAttachments(dumpAttachments);
        dumpMessaggioConfig.setDumpMultipartHeaders(dumpMultipartHeaders);
        dumpMessaggio = ServiceBinding.SOAP.equals((Object)msg.getServiceBinding()) ? DumpSoapMessageUtils.dumpMessage((OpenSPCoop2SoapMessage)msg.castAsSoap(), (DumpMessaggioConfig)dumpMessaggioConfig, (boolean)true) : DumpRestMessageUtils.dumpMessage((OpenSPCoop2RestMessage)msg.castAsRest(), (DumpMessaggioConfig)dumpMessaggioConfig, (boolean)true);
        messaggio.setContentType(dumpMessaggio.getContentType());
        if (dumpBody) {
            messaggio.setBody(DumpByteArrayOutputStream.newInstance((byte[])dumpMessaggio.getBody()));
            if (dumpMessaggio.getMultipartInfoBody() != null) {
                BodyMultipartInfo bodyMultipartInfo = new BodyMultipartInfo();
                bodyMultipartInfo.setContentId(dumpMessaggio.getMultipartInfoBody().getContentId());
                bodyMultipartInfo.setContentLocation(dumpMessaggio.getMultipartInfoBody().getContentLocation());
                bodyMultipartInfo.setContentType(dumpMessaggio.getMultipartInfoBody().getContentType());
                if (dumpMultipartHeaders && dumpMessaggio.getMultipartInfoBody().getHeadersValues() != null && dumpMessaggio.getMultipartInfoBody().getHeadersValues().size() > 0) {
                    for (String key : dumpMessaggio.getMultipartInfoBody().getHeadersValues().keySet()) {
                        List values = (List)dumpMessaggio.getMultipartInfoBody().getHeadersValues().get(key);
                        bodyMultipartInfo.getHeaders().put(key, values);
                    }
                }
                messaggio.setBodyMultipartInfo(bodyMultipartInfo);
            }
        }
        if (dumpAttachments && dumpMessaggio.getAttachments() != null && !dumpMessaggio.getAttachments().isEmpty()) {
            for (DumpAttachment dumpAttach : dumpMessaggio.getAttachments()) {
                Attachment attachment = new Attachment();
                attachment.setContentId(dumpAttach.getContentId());
                attachment.setContentLocation(dumpAttach.getContentLocation());
                attachment.setContentType(dumpAttach.getContentType());
                if (dumpMultipartHeaders && dumpAttach.getHeadersValues() != null && dumpAttach.getHeadersValues().size() > 0) {
                    for (String key : dumpAttach.getHeadersValues().keySet()) {
                        List values = (List)dumpAttach.getHeadersValues().get(key);
                        attachment.getHeaders().put(key, values);
                    }
                }
                if (dumpAttach.getContent() != null) {
                    attachment.setContent(dumpAttach.getContent());
                } else if (dumpAttach.getErrorContentNotSerializable() != null) {
                    attachment.setContent(dumpAttach.getErrorContentNotSerializable().getBytes());
                } else {
                    throw new MessageException("Contenuto dell'attachment con id '" + attachment.getContentId() + "' non presente ?");
                }
                messaggio.getAttachments().add(attachment);
            }
        }
        return dumpMessaggio;
    }

    private void gestioneErroreDump(Throwable e) throws DumpException {
        if (this.properties.isDumpFallitoBloccoServiziPdD()) {
            Dump.setSistemaDumpDisponibile(false);
            Dump.setMotivoMalfunzionamentoDump(e);
            try {
                this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loggerOpenSPCoopResourcesError("Il Sistema di dump dei contenuti applicativi ha rilevato un errore durante la registrazione di un contenuto applicativo, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio di GovWay. Errore rilevato: ", e);
        }
        if (this.properties.isDumpFallitoBloccaCooperazioneInCorso()) {
            throw new DumpException(e);
        }
    }

    private String getLogIdTransazione() {
        return "con identificativo di transazione [" + this.idTransazione + "]";
    }
}

