/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.transazioni;

import java.sql.Timestamp;
import java.util.Date;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class DateUtility {
    private static final String dateformatPattern = "yyyyMMddHHmm";

    public static Timestamp getTimestampIntoIdProtocollo(Logger log, IBustaBuilder<?> bustaBuilder, String idMessaggio) {
        Date dataIdBusta = null;
        try {
            dataIdBusta = bustaBuilder.extractDateFromID(idMessaggio);
        }
        catch (Exception e) {
            log.error("Errore durante l'estrazione della data dall'identificativo di protocollo [id: " + idMessaggio + "]: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (dataIdBusta == null) {
            return null;
        }
        DateTimeFormatterWrapper dateFormat = DateUtils.getDefaultDateTimeFormatter((String)dateformatPattern);
        String data = dateFormat.format(dataIdBusta);
        try {
            return new Timestamp(dateFormat.parse(data).getTime());
        }
        catch (Exception e) {
            log.error("Errore durante la conversione della data estratta dall'identificativo di protocollo [data estratta: " + data + "]: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

