/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser.test;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Properties;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.SorgenteInformazioniToken;
import org.openspcoop2.pdd.core.token.parser.BasicTokenParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;

public class BasicTokenParserTest {
    public static void main(String[] args) throws Exception {
        long attesoMax;
        long atteso;
        Object expS;
        Long expL;
        Object nbfS;
        Object nbfL;
        Object iatS;
        Long iatL;
        String tipoTestDateSuffix;
        InformazioniToken info;
        Object rawResponse;
        Date nbf;
        Date iat;
        String jti;
        String s3;
        String s2;
        String s1;
        String subject;
        String username;
        String issuer;
        String audience2;
        Date now;
        String audience;
        String cliendId;
        TipologiaClaims tipoTest = null;
        if (args != null && args.length > 0) {
            tipoTest = TipologiaClaims.valueOf(args[0]);
        }
        DecimalFormat decimalFormat9 = new DecimalFormat("0.#########E0");
        if (tipoTest == null || TipologiaClaims.GOOGLE.equals((Object)tipoTest)) {
            long data;
            InformazioniToken info2;
            BasicTokenParser tokenParser;
            String rawResponse2;
            String mail;
            String s32;
            String s22;
            String s12;
            String subject2;
            block466: {
                System.out.println("Test BasicTokenParser, access token google dopo introspection ...");
                cliendId = "18192.apps.googleusercontent.com";
                audience = "23223.apps.googleusercontent.com";
                subject2 = "10623542342342323";
                s12 = "https://www.googleapis.com/auth/userinfo.email";
                s22 = "https://www.googleapis.com/auth/userinfo.profile";
                s32 = "openid";
                mail = "example@gmail.com";
                rawResponse2 = "{\"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"1602666852\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
                info2 = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
                if (!info2.isValid()) {
                    throw new Exception("Atteso token valido");
                }
                if (info2.getClaims() == null || info2.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info2.getClaims().size() != 9) {
                    throw new Exception("Claims attesi 9, trovati '" + info2.getClaims().size() + "'");
                }
                if (!info2.getClaims().containsKey("azp")) {
                    throw new Exception("Atteso azp non presente tra i claims");
                }
                if (!info2.getClaims().containsKey("aud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info2.getClaims().containsKey("sub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info2.getClaims().containsKey("scope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info2.getClaims().containsKey("exp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info2.getClaims().containsKey("email")) {
                    throw new Exception("Atteso email non presente tra i claims");
                }
                if (!cliendId.equals(info2.getClientId())) {
                    throw new Exception("Atteso azp '" + cliendId + "' trovato '" + info2.getClientId() + "'");
                }
                if (info2.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info2.getAud().size() != 1) {
                    throw new Exception("Audience attesi 1, trovati '" + info2.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info2.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                if (!subject2.equals(info2.getSub())) {
                    throw new Exception("Atteso subject '" + subject2 + "' trovato '" + info2.getSub() + "'");
                }
                if (info2.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info2.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info2.getScopes().size() + "'");
                }
                find = false;
                for (String s : info2.getScopes()) {
                    if (!s12.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s12 + "' non trovato");
                }
                find = false;
                for (String s : info2.getScopes()) {
                    if (!s22.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s22 + "' non trovato");
                }
                find = false;
                for (String s : info2.getScopes()) {
                    if (!s32.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s32 + "' non trovato");
                }
                Date d = info2.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                now = DateManager.getDate();
                if ((now = new Date(now.getTime() + 0x6DDD00L)).before(d)) {
                    throw new Exception("Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (info2.getIat() != null) {
                    throw new Exception("Claim iat non atteso");
                }
                if (info2.getIss() != null) {
                    throw new Exception("Claim iss non atteso");
                }
                if (info2.getNbf() != null) {
                    throw new Exception("Claim nbf non atteso");
                }
                if (info2.getRoles() != null) {
                    throw new Exception("Ruoli non attesi");
                }
                if (info2.getUsername() != null) {
                    throw new Exception("Claim username non atteso");
                }
                if (info2.getUserInfo() != null) {
                    if (!mail.equals(info2.getUserInfo().getEMail())) {
                        throw new Exception("Atteso mail '" + mail + "' trovato '" + info2.getUserInfo().getEMail() + "'");
                    }
                    if (info2.getUserInfo().getFamilyName() != null) {
                        throw new Exception("Claim family name non atteso");
                    }
                    if (info2.getUserInfo().getFirstName() != null) {
                        throw new Exception("Claim first name non atteso");
                    }
                    if (info2.getUserInfo().getFullName() != null) {
                        throw new Exception("Claim full name non atteso");
                    }
                    if (info2.getUserInfo().getMiddleName() != null) {
                        throw new Exception("Claim middle name non atteso");
                    }
                } else {
                    throw new Exception("Atteso UserInfo");
                }
                System.out.println("Test BasicTokenParser, access token google dopo introspection ok");
                for (int i = 0; i < 2; ++i) {
                    long atteso2;
                    String tipoTestDateSuffix2 = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date" + tipoTestDateSuffix2 + ") ...");
                    long dataL = (DateManager.getDate().getTime() + 30000L) / 1000L;
                    Object dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
                    rawResponse2 = "{\"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"" + (String)dataS + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
                    info2 = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
                    d = info2.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 20000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now = new Date(now.getTime() + 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date" + tipoTestDateSuffix2 + ") ok");
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date con expires con max long value" + tipoTestDateSuffix2 + ") ...");
                    dataL = 9223372036854775L;
                    dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
                    rawResponse2 = "{\"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"" + (String)dataS + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
                    info2 = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
                    d = info2.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = new Date(9223372036854774806L);
                    if (!now.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    long l = atteso2 = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    if (d.getTime() != atteso2) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso2 + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date con expires con max long value" + tipoTestDateSuffix2 + ") ok");
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date con expires con overflow long value" + tipoTestDateSuffix2 + ") ...");
                    dataL = 9223372036854775L;
                    dataS = i == 0 ? "" + dataL : decimalFormat9.format(dataL);
                    rawResponse2 = "{\"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"111111111" + (String)dataS + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
                    info2 = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
                    d = info2.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = new Date(9223372036854774806L);
                    if (!now.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token google dopo introspection (check date con expires con overflow long value" + tipoTestDateSuffix2 + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token google dopo introspection (non valido) ...");
                data = 9223372036854775L;
                rawResponse2 = "{\"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"" + data + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
                try {
                    info2 = new InformazioniToken(500, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
                    if (info2.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block466;
                    throw e;
                }
            }
            rawResponse2 = "{\"error\": \"errore\", \"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"" + data + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
            tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
            info2 = new InformazioniToken(400, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
            if (info2.isValid()) {
                throw new Exception("Attes token non valido (claim error)");
            }
            rawResponse2 = "{\"error_description\": \"errore\", \"azp\": \"" + cliendId + "\", \"aud\": \"" + audience + "\", \"sub\": \"" + subject2 + "\", \"scope\": \"" + s12 + " " + s22 + " " + s32 + "\",  \"exp\": \"" + data + "\",  \"expires_in\": \"3113\",  \"email\": \"" + mail + "\",  \"email_verified\": \"true\",  \"access_type\": \"offline\"}";
            tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
            info2 = new InformazioniToken(401, SorgenteInformazioniToken.INTROSPECTION, rawResponse2, tokenParser);
            if (info2.isValid()) {
                throw new Exception("Attes token non valido (claim error_description)");
            }
            System.out.println("Test BasicTokenParser, access token google dopo introspection (non valido) ok");
        }
        if (tipoTest == null || TipologiaClaims.GOOGLE.equals((Object)tipoTest)) {
            System.out.println("Test BasicTokenParser, access token google dopo userinfo ...");
            String nomeCognome = "Paolo Rossi";
            String nome = "Paolo";
            String cognome = "Rossi";
            String subject3 = "10623542342342323";
            String mail = "example@gmail.com";
            String rawResponse3 = "{\"sub\": \"" + subject3 + "\", \"name\": \"" + nomeCognome + "\",\n  \"given_name\": \"" + nome + "\",\n  \"family_name\": \"" + cognome + "\",\n  \"picture\": \"https://lh6.googleusercontent.com/-5-xqlP4VKB8/AAAAAAAAA/photo.jpg\",\n  \"email\": \"" + mail + "\",\n  \"email_verified\": true,\n  \"locale\": \"it\"\n}";
            BasicTokenParser tokenParser = new BasicTokenParser(TipologiaClaims.GOOGLE);
            InformazioniToken info3 = new InformazioniToken(200, SorgenteInformazioniToken.USER_INFO, rawResponse3, tokenParser);
            if (info3.getClaims() == null || info3.getClaims().isEmpty()) {
                throw new Exception("Parse non riuscito?");
            }
            if (info3.getClaims().size() != 8) {
                throw new Exception("Claims attesi 8, trovati '" + info3.getClaims().size() + "'");
            }
            if (!info3.getClaims().containsKey("sub")) {
                throw new Exception("Atteso sub non presente tra i claims");
            }
            if (!info3.getClaims().containsKey("name")) {
                throw new Exception("Atteso name non presente tra i claims");
            }
            if (!info3.getClaims().containsKey("given_name")) {
                throw new Exception("Atteso given_name non presente tra i claims");
            }
            if (!info3.getClaims().containsKey("family_name")) {
                throw new Exception("Atteso scope non presente tra i claims");
            }
            if (!info3.getClaims().containsKey("family_name")) {
                throw new Exception("Atteso exp non presente tra i claims");
            }
            if (!info3.getClaims().containsKey("email")) {
                throw new Exception("Atteso email non presente tra i claims");
            }
            if (!subject3.equals(info3.getSub())) {
                throw new Exception("Atteso subject '" + subject3 + "' trovato '" + info3.getSub() + "'");
            }
            if (info3.getUserInfo() != null) {
                if (!nomeCognome.equals(info3.getUserInfo().getFullName())) {
                    throw new Exception("Atteso nome e cognome '" + nomeCognome + "' trovato '" + info3.getUserInfo().getFullName() + "'");
                }
                if (!nome.equals(info3.getUserInfo().getFirstName())) {
                    throw new Exception("Atteso nome '" + nome + "' trovato '" + info3.getUserInfo().getFirstName() + "'");
                }
                if (!cognome.equals(info3.getUserInfo().getFamilyName())) {
                    throw new Exception("Atteso cognome '" + cognome + "' trovato '" + info3.getUserInfo().getFamilyName() + "'");
                }
                if (!mail.equals(info3.getUserInfo().getEMail())) {
                    throw new Exception("Atteso mail '" + mail + "' trovato '" + info3.getUserInfo().getEMail() + "'");
                }
                if (info3.getUserInfo().getMiddleName() != null) {
                    throw new Exception("Claim middle name non atteso");
                }
            } else {
                throw new Exception("Atteso UserInfo");
            }
            if (info3.getAud() != null) {
                throw new Exception("Audience non atteso");
            }
            if (info3.getScopes() != null) {
                throw new Exception("Scope non attesi");
            }
            Date d = info3.getExp();
            if (d != null) {
                throw new Exception("Data di scadenza non attesa");
            }
            if (info3.getIat() != null) {
                throw new Exception("Claim iat non atteso");
            }
            if (info3.getIss() != null) {
                throw new Exception("Claim iss non atteso");
            }
            if (info3.getNbf() != null) {
                throw new Exception("Claim nbf non atteso");
            }
            if (info3.getRoles() != null) {
                throw new Exception("Ruoli non attesi");
            }
            if (!nomeCognome.equals(info3.getUsername())) {
                throw new Exception("Atteso username '" + nomeCognome + "' trovato '" + info3.getUsername() + "'");
            }
            System.out.println("Test BasicTokenParser, access token google dopo userinfo ok");
        }
        if (tipoTest == null || TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662.equals((Object)tipoTest)) {
            BasicTokenParser tokenParser;
            block467: {
                System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662'...");
                cliendId = "18192.apps";
                audience = "23223.apps";
                audience2 = "7777.apps";
                issuer = "testAuthEnte";
                username = "Utente di Prova";
                subject = "10623542342342323";
                s1 = "https://userinfo.email";
                s2 = "https://userinfo.profile";
                s3 = "altro";
                jti = "33aa1676-1f9e-34e2-8515-0cfca111a188";
                Date now2 = DateManager.getDate();
                iat = new Date(now2.getTime() / 1000L * 1000L);
                nbf = new Date(iat.getTime() - 20000L);
                Date exp = new Date(iat.getTime() + 60000L);
                rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + iat.getTime() / 1000L + "\", \"nbf\": \"" + nbf.getTime() / 1000L + "\", \"exp\": \"" + exp.getTime() / 1000L + "\",  \"jti\": \"" + jti + "\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                if (info.getClaims() == null || info.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info.getClaims().size() != 10) {
                    throw new Exception("Claims attesi 10, trovati '" + info.getClaims().size() + "'");
                }
                if (!info.getClaims().containsKey("client_id")) {
                    throw new Exception("Atteso client_id non presente tra i claims");
                }
                if (!info.getClaims().containsKey("aud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info.getClaims().containsKey("sub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iss")) {
                    throw new Exception("Atteso iss non presente tra i claims");
                }
                if (!info.getClaims().containsKey("username")) {
                    throw new Exception("Atteso username non presente tra i claims");
                }
                if (!info.getClaims().containsKey("scope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iat")) {
                    throw new Exception("Atteso iat non presente tra i claims");
                }
                if (!info.getClaims().containsKey("nbf")) {
                    throw new Exception("Atteso nbf non presente tra i claims");
                }
                if (!info.getClaims().containsKey("exp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info.getClaims().containsKey("jti")) {
                    throw new Exception("Atteso jti non presente tra i claims");
                }
                if (!cliendId.equals(info.getClientId())) {
                    throw new Exception("Atteso client_id '" + cliendId + "' trovato '" + info.getClientId() + "'");
                }
                if (info.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info.getAud().size() != 2) {
                    throw new Exception("Audience attesi 2, trovati '" + info.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                find = false;
                for (String s : info.getAud()) {
                    if (!audience2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience2 + "' non trovato");
                }
                if (!subject.equals(info.getSub())) {
                    throw new Exception("Atteso subject '" + subject + "' trovato '" + info.getSub() + "'");
                }
                if (!issuer.equals(info.getIss())) {
                    throw new Exception("Atteso issuer '" + issuer + "' trovato '" + info.getIss() + "'");
                }
                if (!username.equals(info.getUsername())) {
                    throw new Exception("Atteso username '" + username + "' trovato '" + info.getUsername() + "'");
                }
                if (info.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info.getScopes().size() + "'");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s1 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s2 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s3.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s3 + "' non trovato");
                }
                Date d = info.getIat();
                if (d == null) {
                    throw new Exception("Data non trovata");
                }
                if (!d.equals(iat)) {
                    throw new Exception("Claim iat differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(iat) + " iat=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                d = info.getNbf();
                if (d == null) {
                    throw new Exception("Data nbf non trovata");
                }
                if (!d.equals(nbf)) {
                    throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (now2.before(d)) {
                    throw new Exception("Token non utilizzabile, non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                d = info.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                if (!d.equals(exp)) {
                    throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (!now2.before(d)) {
                    throw new Exception("Token scaduto non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (!jti.equals(tokenParser.getJWTIdentifier())) {
                    throw new Exception("Atteso jti '" + jti + "' trovato '" + tokenParser.getJWTIdentifier() + "'");
                }
                if (info.getRoles() != null) {
                    throw new Exception("Ruoli non attesi");
                }
                if (info.getUserInfo() != null) {
                    if (info.getUserInfo().getFamilyName() != null) {
                        throw new Exception("Claim family name non atteso");
                    }
                    if (info.getUserInfo().getFirstName() != null) {
                        throw new Exception("Claim first name non atteso");
                    }
                    if (info.getUserInfo().getFullName() != null) {
                        throw new Exception("Claim full name non atteso");
                    }
                    if (info.getUserInfo().getMiddleName() != null) {
                        throw new Exception("Claim middle name non atteso");
                    }
                    if (info.getUserInfo().getEMail() != null) {
                        throw new Exception("Claim mail non atteso");
                    }
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' ok");
                for (int i = 0; i < 2; ++i) {
                    tipoTestDateSuffix = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date" + tipoTestDateSuffix + ") ...");
                    now2 = DateManager.getDate();
                    iat = new Date(now2.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now2 = DateManager.getDate();
                    if (!now2.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now2 = new Date(now2.getTime() + 20000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now2 = new Date(now2.getTime() + 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    now2 = DateManager.getDate();
                    if (now2.before(d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now2 = new Date(now2.getTime() - 20000L)).before(d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now2 = new Date(now2.getTime() - 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token non utilizzabile, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con expires con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now2.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    atteso = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    exp = new Date(atteso);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = DateManager.getDate();
                    if (!now2.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now2 = new Date(now2.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = new Date(9223372036854774806L);
                    if (!now2.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != atteso) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con expires con max long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now2.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"111111111" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    exp = new Date(Long.MAX_VALUE);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = DateManager.getDate();
                    if (!now2.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now2 = new Date(now2.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = new Date(9223372036854774806L);
                    if (!now2.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con nbf con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now2.getTime() / 1000L * 1000L);
                    nbf = new Date(9223372036854775000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    attesoMax = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    nbf = new Date(attesoMax);
                    if (!d.equals(nbf)) {
                        throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = DateManager.getDate();
                    if (!now2.before(d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now2 = new Date(now2.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now2 = new Date(9223372036854774806L);
                    if (!now2.before(d)) {
                        throw new Exception("(3 MaxValue) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != attesoMax) {
                        throw new Exception("(4) Attesa data associata la long max value '" + attesoMax + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (check date con nbf con max long value" + tipoTestDateSuffix + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (non valido) ...");
                rawResponse = "{\"client_id\":\"nonImportante\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
                try {
                    info = new InformazioniToken(500, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
                    if (info.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block467;
                    throw e;
                }
            }
            rawResponse = "{\"active\": \"true\", \"client_id\":\"nonImportante\"}";
            tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
            info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
            if (!info.isValid()) {
                throw new Exception("Atteso token valido");
            }
            rawResponse = "{\"active\": \"false\", \"client_id\":\"nonImportante\"}";
            tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
            info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
            if (info.isValid()) {
                throw new Exception("Atteso token non valido");
            }
            rawResponse = "{\"active\": \"valoreNonBooleano\", \"client_id\":\"nonImportante\"}";
            tokenParser = new BasicTokenParser(TipologiaClaims.INTROSPECTION_RESPONSE_RFC_7662);
            info = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse, tokenParser);
            if (info.isValid()) {
                throw new Exception("Atteso token non valido (not boolean value)");
            }
            System.out.println("Test BasicTokenParser, access token dopo introspection 'INTROSPECTION_RESPONSE_RFC_7662' (non valido) ok");
        }
        if (tipoTest == null || TipologiaClaims.JSON_WEB_TOKEN_RFC_7519.equals((Object)tipoTest)) {
            block468: {
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519'...");
                cliendId = "18192.apps";
                audience = "23223.apps";
                audience2 = "7777.apps";
                issuer = "testAuthEnte";
                username = "Utente di Prova";
                subject = "10623542342342323";
                s1 = "https://userinfo.email";
                s2 = "https://userinfo.profile";
                s3 = "altro";
                jti = "33aa1676-1f9e-34e2-8515-0cfca111a188";
                Date now3 = DateManager.getDate();
                iat = new Date(now3.getTime() / 1000L * 1000L);
                nbf = new Date(iat.getTime() - 20000L);
                Date exp = new Date(iat.getTime() + 60000L);
                rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + iat.getTime() / 1000L + "\", \"nbf\": \"" + nbf.getTime() / 1000L + "\", \"exp\": \"" + exp.getTime() / 1000L + "\",  \"jti\": \"" + jti + "\"}";
                BasicTokenParser tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                if (info.getClaims() == null || info.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info.getClaims().size() != 10) {
                    throw new Exception("Claims attesi 10, trovati '" + info.getClaims().size() + "'");
                }
                if (!info.getClaims().containsKey("client_id")) {
                    throw new Exception("Atteso client_id non presente tra i claims");
                }
                if (!info.getClaims().containsKey("aud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info.getClaims().containsKey("sub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iss")) {
                    throw new Exception("Atteso iss non presente tra i claims");
                }
                if (!info.getClaims().containsKey("username")) {
                    throw new Exception("Atteso username non presente tra i claims");
                }
                if (!info.getClaims().containsKey("scope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iat")) {
                    throw new Exception("Atteso iat non presente tra i claims");
                }
                if (!info.getClaims().containsKey("nbf")) {
                    throw new Exception("Atteso nbf non presente tra i claims");
                }
                if (!info.getClaims().containsKey("exp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info.getClaims().containsKey("jti")) {
                    throw new Exception("Atteso jti non presente tra i claims");
                }
                if (info.getClientId() != null) {
                    throw new Exception("ClientId non atteso");
                }
                if (info.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info.getAud().size() != 2) {
                    throw new Exception("Audience attesi 2, trovati '" + info.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                find = false;
                for (String s : info.getAud()) {
                    if (!audience2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience2 + "' non trovato");
                }
                if (!subject.equals(info.getSub())) {
                    throw new Exception("Atteso subject '" + subject + "' trovato '" + info.getSub() + "'");
                }
                if (!issuer.equals(info.getIss())) {
                    throw new Exception("Atteso issuer '" + issuer + "' trovato '" + info.getIss() + "'");
                }
                if (info.getUsername() != null) {
                    throw new Exception("Username non atteso");
                }
                if (info.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info.getScopes().size() + "'");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s1 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s2 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s3.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s3 + "' non trovato");
                }
                Object d = info.getIat();
                if (d == null) {
                    throw new Exception("Data non trovata");
                }
                if (!((Date)d).equals(iat)) {
                    throw new Exception("Claim iat differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(iat) + " iat=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                d = info.getNbf();
                if (d == null) {
                    throw new Exception("Data nbf non trovata");
                }
                if (!((Date)d).equals(nbf)) {
                    throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (now3.before((Date)d)) {
                    throw new Exception("Token non utilizzabile, non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                d = info.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                if (!((Date)d).equals(exp)) {
                    throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (!now3.before((Date)d)) {
                    throw new Exception("Token scaduto non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (!jti.equals(tokenParser.getJWTIdentifier())) {
                    throw new Exception("Atteso jti '" + jti + "' trovato '" + tokenParser.getJWTIdentifier() + "'");
                }
                if (info.getRoles() != null) {
                    throw new Exception("Ruoli non attesi");
                }
                if (info.getUserInfo() != null) {
                    if (info.getUserInfo().getFamilyName() != null) {
                        throw new Exception("Claim family name non atteso");
                    }
                    if (info.getUserInfo().getFirstName() != null) {
                        throw new Exception("Claim first name non atteso");
                    }
                    if (info.getUserInfo().getFullName() != null) {
                        throw new Exception("Claim full name non atteso");
                    }
                    if (info.getUserInfo().getMiddleName() != null) {
                        throw new Exception("Claim middle name non atteso");
                    }
                    if (info.getUserInfo().getEMail() != null) {
                        throw new Exception("Claim mail non atteso");
                    }
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' ok");
                for (int i = 0; i < 2; ++i) {
                    tipoTestDateSuffix = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date" + tipoTestDateSuffix + ") ...");
                    now3 = DateManager.getDate();
                    iat = new Date(now3.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now3 = DateManager.getDate();
                    if (!now3.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now3 = new Date(now3.getTime() + 20000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if ((now3 = new Date(now3.getTime() + 60000L)).before((Date)d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    now3 = DateManager.getDate();
                    if (now3.before((Date)d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if ((now3 = new Date(now3.getTime() - 20000L)).before((Date)d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now3 = new Date(now3.getTime() - 60000L)).before((Date)d)) {
                        throw new Exception("(3) Atteso token non utilizzabile, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con expires con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now3.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    atteso = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    exp = new Date(atteso);
                    if (!((Date)d).equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = DateManager.getDate();
                    if (!now3.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now3 = new Date(now3.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = new Date(9223372036854774806L);
                    if (!now3.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != atteso) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso + "', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con expires con max long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now3.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"111111111" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    exp = new Date(Long.MAX_VALUE);
                    if (!((Date)d).equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = DateManager.getDate();
                    if (!now3.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now3 = new Date(now3.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = new Date(9223372036854774806L);
                    if (!now3.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con nbf con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now3.getTime() / 1000L * 1000L);
                    nbf = new Date(9223372036854775000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    attesoMax = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    nbf = new Date(attesoMax);
                    if (!((Date)d).equals(nbf)) {
                        throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = DateManager.getDate();
                    if (!now3.before((Date)d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now3 = new Date(now3.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now3 = new Date(9223372036854774806L);
                    if (!now3.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now3) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != attesoMax) {
                        throw new Exception("(4) Attesa data associata la long max value '" + attesoMax + "', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (check date con nbf con max long value" + tipoTestDateSuffix + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (non valido) ...");
                rawResponse = "{\"client_id\":\"nonImportante\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_RFC_7519);
                try {
                    info = new InformazioniToken(500, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    if (info.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block468;
                    throw e;
                }
            }
            System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_RFC_7519' (non valido) ok");
        }
        if (tipoTest == null || TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068.equals((Object)tipoTest)) {
            block469: {
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068'...");
                cliendId = "18192.apps";
                audience = "23223.apps";
                audience2 = "7777.apps";
                issuer = "testAuthEnte";
                username = "Utente di Prova";
                subject = "10623542342342323";
                s1 = "https://userinfo.email";
                s2 = "https://userinfo.profile";
                s3 = "altro";
                jti = "33aa1676-1f9e-34e2-8515-0cfca111a188";
                Date now4 = DateManager.getDate();
                iat = new Date(now4.getTime() / 1000L * 1000L);
                nbf = new Date(iat.getTime() - 20000L);
                Date exp = new Date(iat.getTime() + 60000L);
                rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + iat.getTime() / 1000L + "\", \"nbf\": \"" + nbf.getTime() / 1000L + "\", \"exp\": \"" + exp.getTime() / 1000L + "\",  \"jti\": \"" + jti + "\"}";
                BasicTokenParser tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                if (info.getClaims() == null || info.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info.getClaims().size() != 10) {
                    throw new Exception("Claims attesi 10, trovati '" + info.getClaims().size() + "'");
                }
                if (!info.getClaims().containsKey("client_id")) {
                    throw new Exception("Atteso client_id non presente tra i claims");
                }
                if (!info.getClaims().containsKey("aud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info.getClaims().containsKey("sub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iss")) {
                    throw new Exception("Atteso iss non presente tra i claims");
                }
                if (!info.getClaims().containsKey("username")) {
                    throw new Exception("Atteso username non presente tra i claims");
                }
                if (!info.getClaims().containsKey("scope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info.getClaims().containsKey("iat")) {
                    throw new Exception("Atteso iat non presente tra i claims");
                }
                if (!info.getClaims().containsKey("nbf")) {
                    throw new Exception("Atteso nbf non presente tra i claims");
                }
                if (!info.getClaims().containsKey("exp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info.getClaims().containsKey("jti")) {
                    throw new Exception("Atteso jti non presente tra i claims");
                }
                if (!cliendId.equals(info.getClientId())) {
                    throw new Exception("Atteso client_id '" + cliendId + "' trovato '" + info.getClientId() + "'");
                }
                if (info.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info.getAud().size() != 2) {
                    throw new Exception("Audience attesi 2, trovati '" + info.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                find = false;
                for (String s : info.getAud()) {
                    if (!audience2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience2 + "' non trovato");
                }
                if (!subject.equals(info.getSub())) {
                    throw new Exception("Atteso subject '" + subject + "' trovato '" + info.getSub() + "'");
                }
                if (!issuer.equals(info.getIss())) {
                    throw new Exception("Atteso issuer '" + issuer + "' trovato '" + info.getIss() + "'");
                }
                if (info.getUsername() != null) {
                    throw new Exception("Username non atteso");
                }
                if (info.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info.getScopes().size() + "'");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s1 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s2 + "' non trovato");
                }
                find = false;
                for (String s : info.getScopes()) {
                    if (!s3.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s3 + "' non trovato");
                }
                Object d = info.getIat();
                if (d == null) {
                    throw new Exception("Data non trovata");
                }
                if (!((Date)d).equals(iat)) {
                    throw new Exception("Claim iat differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(iat) + " iat=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                d = info.getNbf();
                if (d == null) {
                    throw new Exception("Data nbf non trovata");
                }
                if (!((Date)d).equals(nbf)) {
                    throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (now4.before((Date)d)) {
                    throw new Exception("Token non utilizzabile, non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                d = info.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                if (!((Date)d).equals(exp)) {
                    throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (!now4.before((Date)d)) {
                    throw new Exception("Token scaduto non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                }
                if (!jti.equals(tokenParser.getJWTIdentifier())) {
                    throw new Exception("Atteso jti '" + jti + "' trovato '" + tokenParser.getJWTIdentifier() + "'");
                }
                if (info.getRoles() != null) {
                    throw new Exception("Ruoli non attesi");
                }
                if (info.getUserInfo() != null) {
                    if (info.getUserInfo().getFamilyName() != null) {
                        throw new Exception("Claim family name non atteso");
                    }
                    if (info.getUserInfo().getFirstName() != null) {
                        throw new Exception("Claim first name non atteso");
                    }
                    if (info.getUserInfo().getFullName() != null) {
                        throw new Exception("Claim full name non atteso");
                    }
                    if (info.getUserInfo().getMiddleName() != null) {
                        throw new Exception("Claim middle name non atteso");
                    }
                    if (info.getUserInfo().getEMail() != null) {
                        throw new Exception("Claim mail non atteso");
                    }
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' ok");
                for (int i = 0; i < 2; ++i) {
                    tipoTestDateSuffix = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date" + tipoTestDateSuffix + ") ...");
                    now4 = DateManager.getDate();
                    iat = new Date(now4.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now4 = DateManager.getDate();
                    if (!now4.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now4 = new Date(now4.getTime() + 20000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if ((now4 = new Date(now4.getTime() + 60000L)).before((Date)d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    now4 = DateManager.getDate();
                    if (now4.before((Date)d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if ((now4 = new Date(now4.getTime() - 20000L)).before((Date)d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now4 = new Date(now4.getTime() - 60000L)).before((Date)d)) {
                        throw new Exception("(3) Atteso token non utilizzabile, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con expires con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now4.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    atteso = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    exp = new Date(atteso);
                    if (!((Date)d).equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = DateManager.getDate();
                    if (!now4.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now4 = new Date(now4.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = new Date(9223372036854774806L);
                    if (!now4.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != atteso) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso + "', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con expires con max long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now4.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"111111111" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    exp = new Date(Long.MAX_VALUE);
                    if (!((Date)d).equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = DateManager.getDate();
                    if (!now4.before((Date)d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now4 = new Date(now4.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = new Date(9223372036854774806L);
                    if (!now4.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con expires con overflow long value" + tipoTestDateSuffix + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con nbf con max long value" + tipoTestDateSuffix + ") ...");
                    iat = new Date(now4.getTime() / 1000L * 1000L);
                    nbf = new Date(9223372036854775000L);
                    exp = new Date(iat.getTime() + 60000L);
                    iatL = iat.getTime() / 1000L;
                    iatS = i == 0 ? "" + iatL : decimalFormat9.format(iatL);
                    nbfL = nbf.getTime() / 1000L;
                    nbfS = i == 0 ? "" + (Long)nbfL : decimalFormat9.format(nbfL);
                    expL = exp.getTime() / 1000L;
                    expS = i == 0 ? "" + expL : decimalFormat9.format(expL);
                    rawResponse = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS + "\", \"nbf\": \"" + (String)nbfS + "\", \"exp\": \"" + (String)expS + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                    info = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    d = info.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    attesoMax = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    nbf = new Date(attesoMax);
                    if (!((Date)d).equals(nbf)) {
                        throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = DateManager.getDate();
                    if (!now4.before((Date)d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (!(now4 = new Date(now4.getTime() + 3600000L)).before((Date)d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    now4 = new Date(9223372036854774806L);
                    if (!now4.before((Date)d)) {
                        throw new Exception("(3 MaxValue) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now4) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    if (((Date)d).getTime() != attesoMax) {
                        throw new Exception("(4) Attesa data associata la long max value '" + attesoMax + "', trovata con long value '" + ((Date)d).getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format((Date)d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (check date con nbf con max long value" + tipoTestDateSuffix + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (non valido) ...");
                rawResponse = "{\"client_id\":\"nonImportante\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068);
                try {
                    info = new InformazioniToken(500, SorgenteInformazioniToken.JWT, (String)rawResponse, tokenParser);
                    if (info.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block469;
                    throw e;
                }
            }
            System.out.println("Test BasicTokenParser, access token dopo introspection 'JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068' (non valido) ok");
        }
        if (tipoTest == null || TipologiaClaims.OIDC_ID_TOKEN.equals((Object)tipoTest)) {
            block470: {
                System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN'...");
                cliendId = "18192.apps";
                audience = "23223.apps";
                audience2 = "7777.apps";
                issuer = "testAuthEnte";
                username = "Utente di Prova";
                subject = "10623542342342323";
                s1 = "https://userinfo.email";
                s2 = "https://userinfo.profile";
                s3 = "altro";
                jti = "33aa1676-1f9e-34e2-8515-0cfca111a188";
                Date now5 = DateManager.getDate();
                iat = new Date(now5.getTime() / 1000L * 1000L);
                nbf = new Date(iat.getTime() - 20000L);
                Date exp = new Date(iat.getTime() + 60000L);
                String fullName = "Mario Bianchi Rossi";
                String firstName = "Mario";
                String middleName = "Bianchi";
                String familyName = "Rossi";
                String email = "mariorossi@govway.org";
                Object rawResponse4 = "{\"azp\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"preferred_username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + iat.getTime() / 1000L + "\", \"nbf\": \"" + nbf.getTime() / 1000L + "\", \"exp\": \"" + exp.getTime() / 1000L + "\",   \"name\": \"" + fullName + "\",  \"given_name\": \"" + firstName + "\",  \"middle_name\": \"" + middleName + "\",  \"family_name\": \"" + familyName + "\",  \"email\": \"" + email + "\", \"jti\": \"" + jti + "\"}";
                BasicTokenParser tokenParser = new BasicTokenParser(TipologiaClaims.OIDC_ID_TOKEN);
                InformazioniToken info4 = new InformazioniToken(200, SorgenteInformazioniToken.USER_INFO, (String)rawResponse4, tokenParser);
                if (info4.getClaims() == null || info4.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info4.getClaims().size() != 15) {
                    throw new Exception("Claims attesi 15, trovati '" + info4.getClaims().size() + "'");
                }
                if (!info4.getClaims().containsKey("azp")) {
                    throw new Exception("Atteso azp non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("aud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("sub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("iss")) {
                    throw new Exception("Atteso iss non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("preferred_username")) {
                    throw new Exception("Atteso preferred_username non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("scope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("iat")) {
                    throw new Exception("Atteso iat non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("nbf")) {
                    throw new Exception("Atteso nbf non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("exp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info4.getClaims().containsKey("jti")) {
                    throw new Exception("Atteso jti non presente tra i claims");
                }
                if (!cliendId.equals(info4.getClientId())) {
                    throw new Exception("Atteso client_id '" + cliendId + "' trovato '" + info4.getClientId() + "'");
                }
                if (info4.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info4.getAud().size() != 2) {
                    throw new Exception("Audience attesi 2, trovati '" + info4.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info4.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                find = false;
                for (String s : info4.getAud()) {
                    if (!audience2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience2 + "' non trovato");
                }
                if (!subject.equals(info4.getSub())) {
                    throw new Exception("Atteso subject '" + subject + "' trovato '" + info4.getSub() + "'");
                }
                if (!issuer.equals(info4.getIss())) {
                    throw new Exception("Atteso issuer '" + issuer + "' trovato '" + info4.getIss() + "'");
                }
                if (!username.equals(info4.getUsername())) {
                    throw new Exception("Atteso username '" + username + "' trovato '" + info4.getUsername() + "'");
                }
                if (info4.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info4.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info4.getScopes().size() + "'");
                }
                find = false;
                for (String s : info4.getScopes()) {
                    if (!s1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s1 + "' non trovato");
                }
                find = false;
                for (String s : info4.getScopes()) {
                    if (!s2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s2 + "' non trovato");
                }
                find = false;
                for (String s : info4.getScopes()) {
                    if (!s3.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s3 + "' non trovato");
                }
                Date d = info4.getIat();
                if (d == null) {
                    throw new Exception("Data non trovata");
                }
                if (!d.equals(iat)) {
                    throw new Exception("Claim iat differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(iat) + " iat=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                d = info4.getNbf();
                if (info4.getNbf() != null) {
                    throw new Exception("Data nbf non attesa");
                }
                d = info4.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                if (!d.equals(exp)) {
                    throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (!now5.before(d)) {
                    throw new Exception("Token scaduto non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (tokenParser.getJWTIdentifier() != null) {
                    throw new Exception("jti non atteso");
                }
                if (info4.getRoles() != null) {
                    throw new Exception("Ruoli non attesi");
                }
                if (info4.getUserInfo() != null) {
                    if (!fullName.equals(info4.getUserInfo().getFullName())) {
                        throw new Exception("Atteso user full name '" + fullName + "' trovato '" + info4.getUserInfo().getFullName() + "'");
                    }
                    if (!firstName.equals(info4.getUserInfo().getFirstName())) {
                        throw new Exception("Atteso user first name '" + firstName + "' trovato '" + info4.getUserInfo().getFirstName() + "'");
                    }
                    if (!middleName.equals(info4.getUserInfo().getMiddleName())) {
                        throw new Exception("Atteso user middle name '" + middleName + "' trovato '" + info4.getUserInfo().getMiddleName() + "'");
                    }
                    if (!familyName.equals(info4.getUserInfo().getFamilyName())) {
                        throw new Exception("Atteso user family name '" + familyName + "' trovato '" + info4.getUserInfo().getFamilyName() + "'");
                    }
                    if (!email.equals(info4.getUserInfo().getEMail())) {
                        throw new Exception("Atteso user email '" + email + "' trovato '" + info4.getUserInfo().getEMail() + "'");
                    }
                }
                System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' ok");
                for (int i = 0; i < 2; ++i) {
                    String tipoTestDateSuffix3 = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date" + tipoTestDateSuffix3 + ") ...");
                    now5 = DateManager.getDate();
                    iat = new Date(now5.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(iat.getTime() + 60000L);
                    Object iatL2 = iat.getTime() / 1000L;
                    Object iatS2 = i == 0 ? "" + (Long)iatL2 : decimalFormat9.format(iatL2);
                    Long nbfL2 = nbf.getTime() / 1000L;
                    Object nbfS2 = i == 0 ? "" + nbfL2 : decimalFormat9.format(nbfL2);
                    Long expL2 = exp.getTime() / 1000L;
                    Object expS2 = i == 0 ? "" + expL2 : decimalFormat9.format(expL2);
                    rawResponse4 = "{\"azp\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"preferred_username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS2 + "\", \"nbf\": \"" + (String)nbfS2 + "\", \"exp\": \"" + (String)expS2 + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.OIDC_ID_TOKEN);
                    info4 = new InformazioniToken(200, SorgenteInformazioniToken.USER_INFO, (String)rawResponse4, tokenParser);
                    d = info4.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now5 = DateManager.getDate();
                    if (!now5.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now5 = new Date(now5.getTime() + 20000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now5 = new Date(now5.getTime() + 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    d = info4.getNbf();
                    if (d != null) {
                        throw new Exception("Data nbf non attesa");
                    }
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date" + tipoTestDateSuffix3 + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date con expires con max long value" + tipoTestDateSuffix3 + ") ...");
                    iat = new Date(now5.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL2 = iat.getTime() / 1000L;
                    iatS2 = i == 0 ? "" + (Long)iatL2 : decimalFormat9.format(iatL2);
                    nbfL2 = nbf.getTime() / 1000L;
                    nbfS2 = i == 0 ? "" + nbfL2 : decimalFormat9.format(nbfL2);
                    expL2 = exp.getTime() / 1000L;
                    expS2 = i == 0 ? "" + expL2 : decimalFormat9.format(expL2);
                    rawResponse4 = "{\"azp\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"preferred_username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS2 + "\", \"nbf\": \"" + (String)nbfS2 + "\", \"exp\": \"" + (String)expS2 + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.OIDC_ID_TOKEN);
                    info4 = new InformazioniToken(200, SorgenteInformazioniToken.USER_INFO, (String)rawResponse4, tokenParser);
                    d = info4.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    long atteso3 = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    exp = new Date(atteso3);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now5 = DateManager.getDate();
                    if (!now5.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now5 = new Date(now5.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now5 = new Date(9223372036854774806L);
                    if (!now5.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != atteso3) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso3 + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date con expires con max long value" + tipoTestDateSuffix3 + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date con expires con overflow long value" + tipoTestDateSuffix3 + ") ...");
                    iat = new Date(now5.getTime() / 1000L * 1000L);
                    nbf = new Date(iat.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL2 = iat.getTime() / 1000L;
                    iatS2 = i == 0 ? "" + (Long)iatL2 : decimalFormat9.format(iatL2);
                    nbfL2 = nbf.getTime() / 1000L;
                    nbfS2 = i == 0 ? "" + nbfL2 : decimalFormat9.format(nbfL2);
                    expL2 = exp.getTime() / 1000L;
                    expS2 = i == 0 ? "" + expL2 : decimalFormat9.format(expL2);
                    rawResponse4 = "{\"azp\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"preferred_username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS2 + "\", \"nbf\": \"" + (String)nbfS2 + "\", \"exp\": \"111111111" + (String)expS2 + "\",  \"jti\": \"" + jti + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.OIDC_ID_TOKEN);
                    info4 = new InformazioniToken(200, SorgenteInformazioniToken.USER_INFO, (String)rawResponse4, tokenParser);
                    d = info4.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    exp = new Date(Long.MAX_VALUE);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now5 = DateManager.getDate();
                    if (!now5.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now5 = new Date(now5.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now5 = new Date(9223372036854774806L);
                    if (!now5.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now5) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (check date con expires con overflow long value" + tipoTestDateSuffix3 + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (non valido) ...");
                rawResponse4 = "{\"client_id\":\"nonImportante\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.OIDC_ID_TOKEN);
                try {
                    info4 = new InformazioniToken(500, SorgenteInformazioniToken.USER_INFO, (String)rawResponse4, tokenParser);
                    if (info4.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block470;
                    throw e;
                }
            }
            System.out.println("Test BasicTokenParser, access token dopo userInfo 'OIDC_ID_TOKEN' (non valido) ok");
        }
        if (tipoTest == null || TipologiaClaims.MAPPING.equals((Object)tipoTest)) {
            block471: {
                System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING'...");
                cliendId = "18192.apps";
                audience = "23223.apps";
                audience2 = "7777.apps";
                issuer = "testAuthEnte";
                username = "Utente di Prova";
                subject = "10623542342342323";
                s1 = "https://userinfo.email";
                s2 = "https://userinfo.profile";
                s3 = "altro";
                String role1 = "r1";
                String role2 = "r2";
                String jti2 = "33aa1676-1f9e-34e2-8515-0cfca111a188";
                now = DateManager.getDate();
                Date iat2 = new Date(now.getTime() / 1000L * 1000L);
                Date nbf2 = new Date(iat2.getTime() - 20000L);
                Date exp = new Date(iat2.getTime() + 60000L);
                String fullName = "Mario Bianchi Rossi";
                String firstName = "Mario";
                String middleName = "Bianchi";
                String familyName = "Rossi";
                String email = "mariorossi@govway.org";
                Object rawResponse5 = "{\"TESTclient_id\": \"" + cliendId + "\", \"TESTaud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"TESTsub\": \"" + subject + "\",  \"TESTiss\": \"" + issuer + "\", \"TESTusername\": \"" + username + "\", \"TESTscope\": \"" + s1 + " " + s2 + " " + s3 + "\", \"TESTiat\": \"" + iat2.getTime() / 1000L + "\", \"TESTnbf\": \"" + nbf2.getTime() / 1000L + "\", \"TESTexp\": \"" + exp.getTime() / 1000L + "\",   \"TESTrole\": [ \"" + role1 + "\" , \"" + role2 + "\" ], \"TESTname\": \"" + fullName + "\",  \"TESTgiven_name\": \"" + firstName + "\",  \"TESTmiddle_name\": \"" + middleName + "\",  \"TESTfamily_name\": \"" + familyName + "\",  \"TESTemail\": \"" + email + "\",  \"TESTjti\": \"" + jti2 + "\"}";
                Properties pMapping = new Properties();
                pMapping.put("token.parser.issuer", "TESTiss");
                pMapping.put("token.parser.subject", "TESTsub,Altro");
                pMapping.put("token.parser.audience", "TESTaud");
                pMapping.put("token.parser.expire", "TESTexp");
                pMapping.put("token.parser.issuedAt", "TESTiat");
                pMapping.put("token.parser.notToBeUsedBefore", "TESTnbf");
                pMapping.put("token.parser.jwtIdentifier", "TESTjti");
                pMapping.put("token.parser.clientId", "TESTclient_id");
                pMapping.put("token.parser.username", "TESTusername");
                pMapping.put("token.parser.scope", "TESTscope,AltroDiverso");
                pMapping.put("token.parser.role", "TESTroleAltro,TESTrole");
                pMapping.put("token.parser.user.fullName", "TESTname");
                pMapping.put("token.parser.user.firstName", "TESTgiven_name");
                pMapping.put("token.parser.user.middleName", "TESTmiddle_name");
                pMapping.put("token.parser.user.familyName", "TESTlast_name,TESTfamily_name");
                pMapping.put("token.parser.user.eMail", "TESTemail");
                BasicTokenParser tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMapping);
                InformazioniToken info5 = new InformazioniToken(200, SorgenteInformazioniToken.INTROSPECTION, (String)rawResponse5, tokenParser);
                if (info5.getClaims() == null || info5.getClaims().isEmpty()) {
                    throw new Exception("Parse non riuscito?");
                }
                if (info5.getClaims().size() != 16) {
                    throw new Exception("Claims attesi 16, trovati '" + info5.getClaims().size() + "'");
                }
                if (!info5.getClaims().containsKey("TESTclient_id")) {
                    throw new Exception("Atteso client_id non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTaud")) {
                    throw new Exception("Atteso aud non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTsub")) {
                    throw new Exception("Atteso sub non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTiss")) {
                    throw new Exception("Atteso iss non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTusername")) {
                    throw new Exception("Atteso username non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTscope")) {
                    throw new Exception("Atteso scope non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTiat")) {
                    throw new Exception("Atteso iat non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTnbf")) {
                    throw new Exception("Atteso nbf non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTexp")) {
                    throw new Exception("Atteso exp non presente tra i claims");
                }
                if (!info5.getClaims().containsKey("TESTjti")) {
                    throw new Exception("Atteso jti non presente tra i claims");
                }
                if (!cliendId.equals(info5.getClientId())) {
                    throw new Exception("Atteso client_id '" + cliendId + "' trovato '" + info5.getClientId() + "'");
                }
                if (info5.getAud() == null) {
                    throw new Exception("Audience attesi non trovato");
                }
                if (info5.getAud().size() != 2) {
                    throw new Exception("Audience attesi 2, trovati '" + info5.getAud().size() + "'");
                }
                boolean find = false;
                for (String s : info5.getAud()) {
                    if (!audience.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience + "' non trovato");
                }
                find = false;
                for (String s : info5.getAud()) {
                    if (!audience2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Audience atteso '" + audience2 + "' non trovato");
                }
                if (!subject.equals(info5.getSub())) {
                    throw new Exception("Atteso subject '" + subject + "' trovato '" + info5.getSub() + "'");
                }
                if (!issuer.equals(info5.getIss())) {
                    throw new Exception("Atteso issuer '" + issuer + "' trovato '" + info5.getIss() + "'");
                }
                if (!username.equals(info5.getUsername())) {
                    throw new Exception("Atteso username '" + username + "' trovato '" + info5.getUsername() + "'");
                }
                if (info5.getScopes() == null) {
                    throw new Exception("Scope attesi non trovato");
                }
                if (info5.getScopes().size() != 3) {
                    throw new Exception("Scope attesi 3, trovati '" + info5.getScopes().size() + "'");
                }
                find = false;
                for (String s : info5.getScopes()) {
                    if (!s1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s1 + "' non trovato");
                }
                find = false;
                for (String s : info5.getScopes()) {
                    if (!s2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s2 + "' non trovato");
                }
                find = false;
                for (String s : info5.getScopes()) {
                    if (!s3.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Scope atteso '" + s3 + "' non trovato");
                }
                Date d = info5.getIat();
                if (d == null) {
                    throw new Exception("Data non trovata");
                }
                if (!d.equals(iat2)) {
                    throw new Exception("Claim iat differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(iat2) + " iat=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                d = info5.getNbf();
                if (d == null) {
                    throw new Exception("Data nbf non trovata");
                }
                if (!d.equals(nbf2)) {
                    throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (now.before(d)) {
                    throw new Exception("Token non utilizzabile, non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                d = info5.getExp();
                if (d == null) {
                    throw new Exception("Data di scadenza non trovata");
                }
                if (!d.equals(exp)) {
                    throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (!now.before(d)) {
                    throw new Exception("Token scaduto non atteso now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                }
                if (!jti2.equals(tokenParser.getJWTIdentifier())) {
                    throw new Exception("Atteso jti '" + jti2 + "' trovato '" + tokenParser.getJWTIdentifier() + "'");
                }
                if (info5.getRoles() == null) {
                    throw new Exception("Roles attesi non trovato");
                }
                if (info5.getRoles().size() != 2) {
                    throw new Exception("Roles attesi 2, trovati '" + info5.getRoles().size() + "'");
                }
                find = false;
                for (String s : info5.getRoles()) {
                    if (!role1.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Role atteso '" + role1 + "' non trovato");
                }
                find = false;
                for (String s : info5.getRoles()) {
                    if (!role2.equals(s)) continue;
                    find = true;
                    break;
                }
                if (!find) {
                    throw new Exception("Role atteso '" + role2 + "' non trovato");
                }
                if (info5.getUserInfo() != null) {
                    if (!fullName.equals(info5.getUserInfo().getFullName())) {
                        throw new Exception("Atteso user full name '" + fullName + "' trovato '" + info5.getUserInfo().getFullName() + "'");
                    }
                    if (!firstName.equals(info5.getUserInfo().getFirstName())) {
                        throw new Exception("Atteso user first name '" + firstName + "' trovato '" + info5.getUserInfo().getFirstName() + "'");
                    }
                    if (!middleName.equals(info5.getUserInfo().getMiddleName())) {
                        throw new Exception("Atteso user middle name '" + middleName + "' trovato '" + info5.getUserInfo().getMiddleName() + "'");
                    }
                    if (!familyName.equals(info5.getUserInfo().getFamilyName())) {
                        throw new Exception("Atteso user family name '" + familyName + "' trovato '" + info5.getUserInfo().getFamilyName() + "'");
                    }
                    if (!email.equals(info5.getUserInfo().getEMail())) {
                        throw new Exception("Atteso user email '" + email + "' trovato '" + info5.getUserInfo().getEMail() + "'");
                    }
                }
                System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' ok");
                Properties pMappingNomiStandard = new Properties();
                pMappingNomiStandard.put("token.parser.issuer", "iss");
                pMappingNomiStandard.put("token.parser.subject", "sub,Altro");
                pMappingNomiStandard.put("token.parser.audience", "aud");
                pMappingNomiStandard.put("token.parser.expire", "exp");
                pMappingNomiStandard.put("token.parser.issuedAt", "iat");
                pMappingNomiStandard.put("token.parser.notToBeUsedBefore", "nbf");
                pMappingNomiStandard.put("token.parser.jwtIdentifier", "jti");
                pMappingNomiStandard.put("token.parser.clientId", "client_id");
                pMappingNomiStandard.put("token.parser.username", "username");
                pMappingNomiStandard.put("token.parser.scope", "scope,AltroDiverso");
                pMappingNomiStandard.put("token.parser.role", "roleAltro,TESTrole");
                pMappingNomiStandard.put("token.parser.user.fullName", "name");
                pMappingNomiStandard.put("token.parser.user.firstName", "given_name");
                pMappingNomiStandard.put("token.parser.user.middleName", "middle_name");
                pMappingNomiStandard.put("token.parser.user.familyName", "last_name,family_name");
                pMappingNomiStandard.put("token.parser.user.eMail", "email");
                for (int i = 0; i < 2; ++i) {
                    String tipoTestDateSuffix4 = i == 0 ? " [formato: number]" : " [formato: exponential E9]";
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date" + tipoTestDateSuffix4 + ") ...");
                    now = DateManager.getDate();
                    iat2 = new Date(now.getTime() / 1000L * 1000L);
                    nbf2 = new Date(iat2.getTime() - 60000L);
                    exp = new Date(iat2.getTime() + 60000L);
                    Long iatL3 = iat2.getTime() / 1000L;
                    Object iatS3 = i == 0 ? "" + iatL3 : decimalFormat9.format(iatL3);
                    Long nbfL3 = nbf2.getTime() / 1000L;
                    Object nbfS3 = i == 0 ? "" + nbfL3 : decimalFormat9.format(nbfL3);
                    Long expL3 = exp.getTime() / 1000L;
                    Object expS3 = i == 0 ? "" + expL3 : decimalFormat9.format(expL3);
                    rawResponse5 = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"AltroDiverso\": [ \"altroS " + s1 + "\", \"" + s2 + "\", \"" + s3 + "\"],  \"iat\": \"" + (String)iatS3 + "\", \"nbf\": \"" + (String)nbfS3 + "\", \"exp\": \"" + (String)expS3 + "\",  \"jti\": \"" + jti2 + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMappingNomiStandard);
                    info5 = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse5, tokenParser);
                    d = info5.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 20000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now = new Date(now.getTime() + 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token scaduto, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    d = info5.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    now = DateManager.getDate();
                    if (now.before(d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if ((now = new Date(now.getTime() - 20000L)).before(d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() - 60000L)).before(d)) {
                        throw new Exception("(3) Atteso token non utilizzabile, invece sembre valido? now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date" + tipoTestDateSuffix4 + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con expires con max long value" + tipoTestDateSuffix4 + ") ...");
                    iat2 = new Date(now.getTime() / 1000L * 1000L);
                    nbf2 = new Date(iat2.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL3 = iat2.getTime() / 1000L;
                    iatS3 = i == 0 ? "" + iatL3 : decimalFormat9.format(iatL3);
                    nbfL3 = nbf2.getTime() / 1000L;
                    nbfS3 = i == 0 ? "" + nbfL3 : decimalFormat9.format(nbfL3);
                    expL3 = exp.getTime() / 1000L;
                    expS3 = i == 0 ? "" + expL3 : decimalFormat9.format(expL3);
                    rawResponse5 = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS3 + "\", \"nbf\": \"" + (String)nbfS3 + "\", \"exp\": \"" + (String)expS3 + "\",  \"jti\": \"" + jti2 + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMappingNomiStandard);
                    info5 = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse5, tokenParser);
                    d = info5.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    long atteso4 = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    exp = new Date(atteso4);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = new Date(9223372036854774806L);
                    if (!now.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != atteso4) {
                        throw new Exception("(4) Attesa data associata la long max value '" + atteso4 + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con expires con max long value" + tipoTestDateSuffix4 + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con expires con overflow long value" + tipoTestDateSuffix4 + ") ...");
                    iat2 = new Date(now.getTime() / 1000L * 1000L);
                    nbf2 = new Date(iat2.getTime() - 60000L);
                    exp = new Date(9223372036854775000L);
                    iatL3 = iat2.getTime() / 1000L;
                    iatS3 = i == 0 ? "" + iatL3 : decimalFormat9.format(iatL3);
                    nbfL3 = nbf2.getTime() / 1000L;
                    nbfS3 = i == 0 ? "" + nbfL3 : decimalFormat9.format(nbfL3);
                    expL3 = exp.getTime() / 1000L;
                    expS3 = i == 0 ? "" + expL3 : decimalFormat9.format(expL3);
                    rawResponse5 = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS3 + "\", \"nbf\": \"" + (String)nbfS3 + "\", \"exp\": \"111111111" + (String)expS3 + "\",  \"jti\": \"" + jti2 + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMappingNomiStandard);
                    info5 = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse5, tokenParser);
                    d = info5.getExp();
                    if (d == null) {
                        throw new Exception("Data di scadenza non trovata");
                    }
                    exp = new Date(Long.MAX_VALUE);
                    if (!d.equals(exp)) {
                        throw new Exception("Claim exp differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(exp) + " exp=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = new Date(9223372036854774806L);
                    if (!now.before(d)) {
                        throw new Exception("(3 MaxValue) Token scaduto non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " expires_in=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != Long.MAX_VALUE) {
                        throw new Exception("(4) Attesa data associata la long max value '9223372036854775807', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con expires con overflow long value" + tipoTestDateSuffix4 + ") ok");
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con nbf con max long value" + tipoTestDateSuffix4 + ") ...");
                    iat2 = new Date(now.getTime() / 1000L * 1000L);
                    nbf2 = new Date(9223372036854775000L);
                    exp = new Date(iat2.getTime() + 60000L);
                    iatL3 = iat2.getTime() / 1000L;
                    iatS3 = i == 0 ? "" + iatL3 : decimalFormat9.format(iatL3);
                    nbfL3 = nbf2.getTime() / 1000L;
                    nbfS3 = i == 0 ? "" + nbfL3 : decimalFormat9.format(nbfL3);
                    expL3 = exp.getTime() / 1000L;
                    expS3 = i == 0 ? "" + expL3 : decimalFormat9.format(expL3);
                    rawResponse5 = "{\"client_id\": \"" + cliendId + "\", \"aud\": [ \"" + audience + "\" , \"" + audience2 + "\" ], \"sub\": \"" + subject + "\",  \"iss\": \"" + issuer + "\", \"username\": \"" + username + "\", \"scope\": \"" + s1 + " " + s2 + " " + s3 + "\",  \"iat\": \"" + (String)iatS3 + "\", \"nbf\": \"" + (String)nbfS3 + "\", \"exp\": \"" + (String)expS3 + "\",  \"jti\": \"" + jti2 + "\"}";
                    tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMappingNomiStandard);
                    info5 = new InformazioniToken(200, SorgenteInformazioniToken.JWT, (String)rawResponse5, tokenParser);
                    d = info5.getNbf();
                    if (d == null) {
                        throw new Exception("Data nbf non trovata");
                    }
                    long attesoMax2 = i == 0 ? 9223372036854775000L : Long.MAX_VALUE;
                    nbf2 = new Date(attesoMax2);
                    if (!d.equals(nbf2)) {
                        throw new Exception("Claim nbf differente da quello atteso; atteso=" + DateUtils.getOldSimpleDateFormatMs().format(nbf2) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = DateManager.getDate();
                    if (!now.before(d)) {
                        throw new Exception("(1) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (!(now = new Date(now.getTime() + 3600000L)).before(d)) {
                        throw new Exception("(2) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    now = new Date(9223372036854774806L);
                    if (!now.before(d)) {
                        throw new Exception("(3 MaxValue) Token non utilizzabile non atteso, now=" + DateUtils.getOldSimpleDateFormatMs().format(now) + " nbf=" + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    if (d.getTime() != attesoMax2) {
                        throw new Exception("(4) Attesa data associata la long max value '" + attesoMax2 + "', trovata con long value '" + d.getTime() + "' data: " + DateUtils.getOldSimpleDateFormatMs().format(d));
                    }
                    System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (check date con nbf con max long value" + tipoTestDateSuffix4 + ") ok");
                }
                System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (non valido) ...");
                rawResponse5 = "{\"client_id\":\"nonImportante\"}";
                tokenParser = new BasicTokenParser(TipologiaClaims.MAPPING, pMappingNomiStandard);
                try {
                    info5 = new InformazioniToken(500, SorgenteInformazioniToken.JWT, (String)rawResponse5, tokenParser);
                    if (info5.isValid()) {
                        throw new Exception("Attes token non valido (trasporto)");
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().startsWith("Connessione terminata con errore (codice trasporto: 500)")) break block471;
                    throw e;
                }
            }
            System.out.println("Test BasicTokenParser, access token dopo validazione jwt 'MAPPING' (non valido) ok");
        }
    }
}

