/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.token.parser;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.parser.ITokenUserInfoParser;
import org.openspcoop2.pdd.core.token.parser.TipologiaClaims;

public class BasicTokenUserInfoParser
implements ITokenUserInfoParser {
    protected String raw;
    protected Map<String, Serializable> claims;
    protected TipologiaClaims parser;
    protected Properties parserConfig;

    public BasicTokenUserInfoParser(TipologiaClaims parser, Properties parserConfig) {
        this.parser = parser;
        this.parserConfig = parserConfig;
    }

    @Override
    public void init(String raw, Map<String, Serializable> claims) {
        this.raw = raw;
        this.claims = claims;
    }

    @Override
    public String getFullName() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "name");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "name");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.user.fullName");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getFirstName() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "given_name");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "given_name");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.user.firstName");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getMiddleName() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "middle_name");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "middle_name");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.user.middleName");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getFamilyName() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                String tmp = TokenUtilities.getClaimAsString(this.claims, "family_name");
                if (tmp == null) {
                    tmp = TokenUtilities.getClaimAsString(this.claims, "last_name");
                }
                return tmp;
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "family_name");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.user.familyName");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getEMail() {
        switch (this.parser) {
            case OIDC_ID_TOKEN: {
                return TokenUtilities.getClaimAsString(this.claims, "email");
            }
            case GOOGLE: {
                return TokenUtilities.getClaimAsString(this.claims, "email");
            }
            case MAPPING: {
                List<String> claimNames = TokenUtilities.getClaims(this.parserConfig, "token.parser.user.eMail");
                return TokenUtilities.getFirstClaimAsString(this.claims, claimNames);
            }
            case JSON_WEB_TOKEN_RFC_7519: 
            case JSON_WEB_TOKEN_FOR_OAUTH2_ACCESS_TOKENS_RFC_9068: 
            case INTROSPECTION_RESPONSE_RFC_7662: 
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }
}

