/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.response_caching;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneHashGenerator;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.TransportUtils;

public class HashGenerator {
    private String algoritmo;

    public HashGenerator(String algoritmo) {
        this.algoritmo = algoritmo;
    }

    public String buildKeyCache(OpenSPCoop2Message message, RequestInfo requestInfo, ResponseCachingConfigurazione responseCachingConfig) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(this.algoritmo);
        StringBuilder sb = new StringBuilder();
        sb.append("interfaceName").append("=").append(requestInfo.getProtocolContext().getInterfaceName());
        sb.append("\n").append("function").append("=").append(requestInfo.getProtocolContext().getFunction());
        boolean printAzione = true;
        sb.append("\n").append("idServizio").append("=").append(requestInfo.getIdServizio().toString(printAzione));
        digest.update(sb.toString().getBytes());
        ResponseCachingConfigurazioneHashGenerator configHash = responseCachingConfig.getHashGenerator();
        if (configHash == null) {
            configHash = new ResponseCachingConfigurazioneHashGenerator();
        }
        if (configHash != null) {
            List v;
            if (StatoFunzionalita.ABILITATO.equals((Object)configHash.getRequestUri())) {
                sb = new StringBuilder();
                sb.append("requestType").append("=").append(requestInfo.getProtocolContext().getRequestType());
                sb.append("\nrequestURI").append("=").append(requestInfo.getProtocolContext().getRequestURI());
                digest.update(sb.toString().getBytes());
            }
            if (StatoFunzionalitaCacheDigestQueryParameter.ABILITATO.equals((Object)configHash.getQueryParameters()) || StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals((Object)configHash.getQueryParameters())) {
                sb = new StringBuilder();
                sb.append("ParametriURL");
                if (StatoFunzionalitaCacheDigestQueryParameter.ABILITATO.equals((Object)configHash.getQueryParameters())) {
                    this.addList(requestInfo.getProtocolContext().getParameters(), false, sb);
                } else {
                    HashMap<String, List<String>> pUrlForDigest = new HashMap<String, List<String>>();
                    if (requestInfo.getProtocolContext().getParameters() != null && configHash.sizeQueryParameterList() > 0) {
                        for (String queryParameter : configHash.getQueryParameterList()) {
                            v = requestInfo.getProtocolContext().getParameterValues(queryParameter);
                            if (v == null || v.isEmpty()) continue;
                            pUrlForDigest.put(queryParameter, v);
                        }
                    }
                    if (!pUrlForDigest.isEmpty()) {
                        this.addList(pUrlForDigest, false, sb);
                    }
                }
                digest.update(sb.toString().getBytes());
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)configHash.getHeaders())) {
                HashMap<String, List<String>> pTrasportoForDigest = new HashMap<String, List<String>>();
                if (requestInfo.getProtocolContext().getHeaders() != null && configHash.sizeHeaderList() > 0) {
                    for (String header : configHash.getHeaderList()) {
                        v = requestInfo.getProtocolContext().getHeaderValues(header);
                        if (v == null || v.isEmpty()) continue;
                        pTrasportoForDigest.put(header, v);
                    }
                }
                if (!pTrasportoForDigest.isEmpty()) {
                    sb = new StringBuilder("HEADER");
                    this.addList(pTrasportoForDigest, true, sb);
                    digest.update(sb.toString().getBytes());
                }
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)configHash.getPayload())) {
                boolean doDigest = true;
                message.saveChanges();
                if (ServiceBinding.REST.equals((Object)message.getServiceBinding())) {
                    doDigest = message.castAsRest().hasContent();
                }
                if (doDigest) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    message.writeTo((OutputStream)bout, false);
                    bout.flush();
                    bout.close();
                    digest.update(bout.toByteArray());
                }
            }
        }
        return Base64Utilities.encodeAsString((byte[])digest.digest());
    }

    private void addList(Map<String, List<String>> p, boolean toLowerCase, StringBuilder sb) {
        if (p != null && !p.isEmpty()) {
            ArrayList<String> sortKeys = new ArrayList<String>();
            for (String key : p.keySet()) {
                sortKeys.add(key);
            }
            Collections.sort(sortKeys);
            for (String sortKey : sortKeys) {
                List values = (List)TransportUtils.getRawObject(p, (String)sortKey);
                ArrayList ordinatedValues = new ArrayList();
                ordinatedValues.addAll(values);
                if (ordinatedValues.size() > 1) {
                    Collections.sort(ordinatedValues);
                }
                String key = sortKey;
                if (toLowerCase) {
                    key = key.toLowerCase();
                }
                if (ordinatedValues == null || ordinatedValues.isEmpty()) continue;
                for (String value : ordinatedValues) {
                    sb.append("\n").append(key).append("=").append(value);
                }
            }
        }
    }
}

