/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione.backward_compatibility;

import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.backward_compatibility.UtilitiesIntegrazioneBC;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public abstract class AbstractGestoreIntegrazionePATrasportoBC
extends AbstractCore
implements IGestoreIntegrazionePA {
    UtilitiesIntegrazioneBC utilitiesRequestBC = null;
    UtilitiesIntegrazioneBC utilitiesResponseBC = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public AbstractGestoreIntegrazionePATrasportoBC(boolean openspcoop2, boolean x_prefix) {
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(AbstractGestoreIntegrazionePATrasportoBC.class);
        }
        try {
            this.utilitiesRequestBC = UtilitiesIntegrazioneBC.getInstancePARequest(this.log, openspcoop2, x_prefix);
            this.utilitiesResponseBC = UtilitiesIntegrazioneBC.getInstancePAResponse(this.log, openspcoop2, x_prefix);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesRequestBC.readTransportProperties(inRequestPAMessage.getUrlProtocolContext().getHeaders(), integrazione, protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPAMessage outRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesRequestBC.setTransportProperties(integrazione, outRequestPAMessage.getHeaders(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.TRASPORTO), protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesResponseBC.readTransportProperties(inResponsePAMessage.getHeaders(), integrazione, protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            String protocollo = this.getProtocolFactory() != null ? this.getProtocolFactory().getProtocol() : null;
            this.utilitiesResponseBC.setTransportProperties(null, outResponsePAMessage.getHeaders(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePAMessage.getBustaRichiesta(), false, TipoIntegrazione.TRASPORTO), protocollo);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }
}

