/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.slf4j.Logger;

public class UtilitiesAutenticazione {
    private OpenSPCoop2Message msg;
    private Context context;
    private Busta busta;
    private Logger log;
    private List<String> headers = null;
    private Map<String, String> hdrValues = null;

    public UtilitiesAutenticazione(HeaderIntegrazione integrazione, OutRequestPDMessage inRequestPDMessage, Context context, Logger log) throws HeaderIntegrazioneException {
        try {
            this.init(inRequestPDMessage.getMessage(), context, inRequestPDMessage.getBustaRichiesta(), log);
            List proprieta = null;
            if (inRequestPDMessage.getPortaDelegata() != null && inRequestPDMessage.getPortaDelegata().getProprietaList() != null) {
                proprieta = inRequestPDMessage.getPortaDelegata().getProprietaList();
            }
            this.init(proprieta, true);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(e.getMessage(), e);
        }
    }

    public UtilitiesAutenticazione(HeaderIntegrazione integrazione, OutRequestPAMessage inRequestPAMessage, Context context, Logger log) throws HeaderIntegrazioneException {
        try {
            this.init(inRequestPAMessage.getMessage(), context, inRequestPAMessage.getBustaRichiesta(), log);
            List proprieta = null;
            if (inRequestPAMessage.getPortaApplicativa() != null && inRequestPAMessage.getPortaApplicativa().getProprietaList() != null) {
                proprieta = inRequestPAMessage.getPortaApplicativa().getProprietaList();
            }
            this.init(proprieta, false);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(e.getMessage(), e);
        }
    }

    private void init(OpenSPCoop2Message msg, Context context, Busta busta, Logger log) {
        this.msg = msg;
        this.context = context;
        this.busta = busta;
        this.log = log;
    }

    private void init(List<Proprieta> proprieta, boolean portaDelegata) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (portaDelegata) {
                this.headers = properties.getIntegrazioneAutenticazionePortaDelegataRequestHeaders();
                this.hdrValues = properties.getIntegrazioneAutenticazionePortaDelegataRequestHeadersMap();
            } else {
                this.headers = properties.getIntegrazioneAutenticazionePortaApplicativaRequestHeaders();
                this.hdrValues = properties.getIntegrazioneAutenticazionePortaApplicativaRequestHeadersMap();
            }
            if (proprieta != null && !proprieta.isEmpty()) {
                String headersPropertyName = properties.getIntegrazioneAutenticazionePropertyHeaders();
                String headerPrefixPropertyName = properties.getIntegrazioneAutenticazionePropertyHeaderPrefix();
                for (Proprieta p : proprieta) {
                    if (!headersPropertyName.equalsIgnoreCase(p.getNome())) continue;
                    this.headers = UtilitiesAutenticazione.convert(p.getValore(), headersPropertyName);
                }
                if (this.headers != null && !this.headers.isEmpty()) {
                    for (String hdr : this.headers) {
                        String pName = headerPrefixPropertyName + hdr;
                        for (Proprieta p : proprieta) {
                            if (!pName.equalsIgnoreCase(p.getNome())) continue;
                            String valore = p.getValore();
                            this.hdrValues.put(hdr, valore);
                        }
                    }
                }
            }
            if (this.headers == null || this.headers.isEmpty()) {
                throw new HeaderIntegrazioneException("Nessun header di autenticazione configurato");
            }
            if (this.hdrValues == null || this.hdrValues.isEmpty()) {
                throw new HeaderIntegrazioneException("Nessun valore definito per gli header di autenticazione configurati");
            }
            for (String hdr : this.headers) {
                String v = this.hdrValues.get(hdr);
                if (v != null) continue;
                throw new HeaderIntegrazioneException("Nessun valore definito per l'header di autenticazione '" + hdr + "' configurato");
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(e.getMessage(), e);
        }
    }

    public static List<String> convert(String headers, String pName) throws HeaderIntegrazioneException {
        try {
            String[] split;
            ArrayList<String> l = new ArrayList<String>();
            if (headers != null && (split = (headers = headers.trim()).split(",")) != null) {
                for (int i = 0; i < split.length; ++i) {
                    String v = split[i];
                    if (v != null) {
                        v = v.trim();
                    }
                    if ("".equals(v)) continue;
                    l.add(v);
                }
            }
            if (l.isEmpty()) {
                throw new HeaderIntegrazioneException("Trovata propriet\u00e0 '" + pName + "' che non contiene alcun header");
            }
            return l;
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(e.getMessage(), e);
        }
    }

    public void process() throws HeaderIntegrazioneException {
        try {
            if (this.msg == null) {
                return;
            }
            for (String hdr : this.headers) {
                String v = this.hdrValues.get(hdr);
                this.msg.forceTransportHeader(hdr, v);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException(e.getMessage(), e);
        }
    }
}

