/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.util.ArrayList;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.constants.ServiceBinding;

public enum GruppoIntegrazione {
    HTTP("http", "Header HTTP", "Header HTTP", true, false, null),
    URL("urlBased", "Parametri della Url", "Parametri della Url", true, false, null),
    SOAP("soap", "Header SOAP proprietari di GovWay", "Header SOAP GovWay", true, false, ServiceBinding.SOAP),
    WSA("wsa", "Header SOAP con formato standard WS-Addressing", "WS-Addressing", true, false, ServiceBinding.SOAP),
    TEMPLATE("template", "Metadati definiti in template freemaker o velocity", "Template", true, false, null),
    AUTENTICAZIONE("autenticazione", "Header HTTP utilizzati dal backend per autenticare l'API Gateway", "Header HTTP di Autenticazione", false, false, null),
    PLUGIN("plugin", "Plugin", "Plugin", true, true, null),
    BACKWARD_COMPATIBILITY_OPENSPCOOP2_HTTP("backward_compatibility_op2_http", "Header HTTP generati come OpenSPCoop 2.x", "Header HTTP OpenSPCoop 2.x", true, false, null),
    BACKWARD_COMPATIBILITY_OPENSPCOOP2_URL("backward_compatibility_op2_url", "Parametri della Url generati come OpenSPCoop 2.x", "Parametri Url OpenSPCoop 2.x", true, false, null),
    BACKWARD_COMPATIBILITY_OPENSPCOOP2_SOAP("backward_compatibility_op2_soap", "Header SOAP generati come OpenSPCoop 2.x", "Header SOAP OpenSPCoop 2.x", true, false, ServiceBinding.SOAP),
    BACKWARD_COMPATIBILITY_OPENSPCOOP1_HTTP("backward_compatibility_op1_http", "Header HTTP generati come OpenSPCoop 1.x", "Header HTTP OpenSPCoop 1.x", true, false, null),
    BACKWARD_COMPATIBILITY_OPENSPCOOP1_URL("backward_compatibility_op1_url", "Parametri della Url generati come OpenSPCoop 1.x", "Parametri Url OpenSPCoop 1.x", true, false, null),
    BACKWARD_COMPATIBILITY_OPENSPCOOP1_SOAP("backward_compatibility_op1_soap", "Header SOAP generati come OpenSPCoop 1.x", "Header SOAP OpenSPCoop 1.x", true, false, ServiceBinding.SOAP);

    private String value;
    private String label;
    private String compactLabel;
    private boolean config;
    private boolean multi;
    private ServiceBinding serviceBinding;

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCompactLabel() {
        return this.compactLabel;
    }

    public boolean isConfig() {
        return this.config;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public ServiceBinding getServiceBinding() {
        return this.serviceBinding;
    }

    private GruppoIntegrazione(String value, String label, String compactLabel, boolean config, boolean multi, ServiceBinding serviceBinding) {
        this.value = value;
        this.label = label;
        this.compactLabel = compactLabel;
        this.config = config;
        this.multi = multi;
        this.serviceBinding = serviceBinding;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public static String[] toValues(ServiceBinding serviceBinding) {
        ArrayList<String> list = new ArrayList<String>();
        for (GruppoIntegrazione tmp : GruppoIntegrazione.values()) {
            if (tmp.getServiceBinding() == null || serviceBinding == null) {
                list.add(tmp.getValue());
                continue;
            }
            if (!tmp.getServiceBinding().equals((Object)serviceBinding)) continue;
            list.add(tmp.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] toLabels(boolean compact, ServiceBinding serviceBinding) {
        ArrayList<String> list = new ArrayList<String>();
        for (GruppoIntegrazione tmp : GruppoIntegrazione.values()) {
            String label;
            String string = label = compact ? tmp.getCompactLabel() : tmp.getLabel();
            if (tmp.getServiceBinding() == null || serviceBinding == null) {
                list.add(label);
                continue;
            }
            if (!tmp.getServiceBinding().equals((Object)serviceBinding)) continue;
            list.add(label);
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean contains(String value) {
        return GruppoIntegrazione.toEnumConstant(value) != null;
    }

    public static GruppoIntegrazione toEnumConstant(String value) {
        try {
            return GruppoIntegrazione.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static GruppoIntegrazione toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        GruppoIntegrazione res = null;
        for (GruppoIntegrazione tmp : GruppoIntegrazione.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

