/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class GestoreIntegrazionePATrasporto
extends AbstractCore
implements IGestoreIntegrazionePA {
    UtilitiesIntegrazione utilitiesRequest = null;
    UtilitiesIntegrazione utilitiesResponse = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePATrasporto() {
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(GestoreIntegrazionePATrasporto.class);
        }
        try {
            this.utilitiesRequest = UtilitiesIntegrazione.getInstancePARequest(this.log);
            this.utilitiesResponse = UtilitiesIntegrazione.getInstancePAResponse(this.log);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilitiesRequest.readTransportProperties(inRequestPAMessage.getUrlProtocolContext().getHeaders(), integrazione);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPAMessage outRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilitiesRequest.setTransportProperties(integrazione, outRequestPAMessage.getHeaders(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.TRASPORTO));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilitiesResponse.readTransportProperties(inResponsePAMessage.getHeaders(), integrazione);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilitiesResponse.setTransportProperties(null, outResponsePAMessage.getHeaders(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePAMessage.getBustaRichiesta(), false, TipoIntegrazione.TRASPORTO));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePATrasporto, " + e.getMessage(), e);
        }
    }
}

