/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import jakarta.xml.soap.SOAPHeaderElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class GestoreIntegrazionePASoap
extends AbstractCore
implements IGestoreIntegrazionePASoap {
    UtilitiesIntegrazione utilitiesRequest = null;
    UtilitiesIntegrazione utilitiesResponse = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePASoap() {
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(GestoreIntegrazionePASoap.class);
        }
        try {
            this.utilitiesRequest = UtilitiesIntegrazione.getInstancePARequest(this.log);
            this.utilitiesResponse = UtilitiesIntegrazione.getInstancePAResponse(this.log);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.readHeader(soapMsg, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.deleteHeader(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPAMessage inRequestPAMessage, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inRequestPAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesRequest.updateHeader(soapMsg, inRequestPAMessage.getSoggettoMittente(), inRequestPAMessage.getServizio(), idMessaggio, servizioApplicativo, correlazioneApplicativa, null, UtilitiesIntegrazione.getIdTransazione(this.getPddContext()), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPAMessage outRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = outRequestPAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            SOAPHeaderElement header = this.utilitiesRequest.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), soapMsg, this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
            if (soapMsg.getSOAPHeader() == null) {
                soapMsg.getSOAPPart().getEnvelope().addHeader();
            }
            soapMsg.addHeaderElement(soapMsg.getSOAPHeader(), header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.readHeader(soapMsg, integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.deleteHeader(soapMsg, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePAMessage inResponsePAMessage, String idMessaggioRichiesta, String idMessaggioRisposta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message msg = inResponsePAMessage.getMessage();
            if (!ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
                throw new Exception("Non utilizzabile con un Service Binding Rest");
            }
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.utilitiesResponse.updateHeader(soapMsg, inResponsePAMessage.getSoggettoMittente(), inResponsePAMessage.getServizio(), idMessaggioRichiesta, idMessaggioRisposta, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inResponsePAMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
    }
}

