/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import java.util.List;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.controllo_traffico.handler.PreInRequestHandlerGestioneControlloTraffico;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.handlers.transazioni.FirstPositionHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class PreInRequestHandler
extends FirstPositionHandler
implements org.openspcoop2.pdd.core.handlers.PreInRequestHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(PreInRequestContext context) throws HandlerException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        if (!op2Properties.isTransazioniEnabled()) {
            return;
        }
        String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        Transaction tr = null;
        try {
            tr = TransactionContext.getTransaction(idTransazione);
        }
        catch (TransactionNotExistsException e) {
            throw new HandlerException(e);
        }
        if (op2Properties.isControlloTrafficoEnabled()) {
            tr.getTempiElaborazione().startControlloTraffico_maxRequests();
            try {
                PreInRequestHandlerGestioneControlloTraffico preInRequestHandler_gestioneControlloTraffico = new PreInRequestHandlerGestioneControlloTraffico();
                preInRequestHandler_gestioneControlloTraffico.process(context);
            }
            finally {
                tr.getTempiElaborazione().endControlloTraffico_maxRequests();
            }
        }
        ConnectorInMessage req = null;
        try {
            req = (ConnectorInMessage)context.getTransportContext().get("SERVLET_REQUEST");
        }
        catch (Throwable e) {
            context.getLogCore().error("Errore durante il recupero delle informazioni servlet: " + e.getMessage(), e);
        }
        if (req != null) {
            PreInRequestHandler.readClientAddress(context.getLogCore(), req, context.getPddContext());
        }
        RequestInfo requestInfo = null;
        try {
            requestInfo = context.getRequestInfo() != null ? context.getRequestInfo() : (RequestInfo)context.getPddContext().getObject(Costanti.REQUEST_INFO);
            PreInRequestHandler.setInfoInvocation(tr, requestInfo, req);
        }
        catch (TransactionDeletedException e) {
            throw new HandlerException(e);
        }
        catch (Throwable e) {
            context.getLogCore().error("Errore durante il recupero delle informazioni dall'oggetto request info: " + e.getMessage(), e);
        }
    }

    public static void readClientAddress(Logger log, ConnectorInMessage req, PdDContext pddContext) {
        if (req != null) {
            try {
                String remoteAddr = req.getRemoteAddress();
                if (remoteAddr != null) {
                    pddContext.addObject(Costanti.CLIENT_IP_REMOTE_ADDRESS, remoteAddr);
                }
            }
            catch (Throwable e) {
                log.error("Errore durante l'identificazione dell'indirizzo ip del chiamante (via socket): " + e.getMessage(), e);
            }
            try {
                String transportAddr = PreInRequestHandler.getIPClientAddressFromHeader(HttpUtilities.getClientAddressHeaders(), req);
                if (transportAddr != null) {
                    pddContext.addObject(Costanti.CLIENT_IP_TRANSPORT_ADDRESS, transportAddr);
                }
            }
            catch (Throwable e) {
                log.error("Errore durante l'identificazione dell'indirizzo ip del chiamante (via trasporto): " + e.getMessage(), e);
            }
        }
    }

    private static String getIPClientAddressFromHeader(List<String> headers, ConnectorInMessage req) throws ConnectorException {
        if (headers.size() > 0) {
            for (String header : headers) {
                String transportAddr = TransportUtils.getFirstValue(req.getHeaderValues(header));
                if (transportAddr == null) continue;
                return transportAddr;
            }
        }
        return null;
    }

    public static void setInfoInvocation(Transaction tr, RequestInfo requestInfo, ConnectorInMessage req) throws Exception {
        if (tr == null) {
            throw new Exception("Transaction is null");
        }
        tr.setRequestInfo(requestInfo);
        if (req.getCredential() != null) {
            Credenziali credenziali = new Credenziali(req.getCredential());
            String credenzialiFornite = "";
            if (credenziali != null) {
                credenzialiFornite = credenziali.toString(false, true, false, true, "", "", "\n");
            }
            tr.setCredenziali(credenzialiFornite);
        }
        if (req.getURLProtocolContext() != null) {
            Object urlInvocazione = req.getURLProtocolContext().getUrlInvocazione_formBased();
            if (req.getURLProtocolContext().getFunction() != null) {
                urlInvocazione = "[" + req.getURLProtocolContext().getFunction() + "] " + (String)urlInvocazione;
            }
            tr.setUrlInvocazione((String)urlInvocazione);
        }
    }
}

