/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.transazioni.FirstPositionHandler;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionDeletedException;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;

public class InRequestHandler
extends FirstPositionHandler
implements org.openspcoop2.pdd.core.handlers.InRequestHandler {
    @Override
    public void invoke(InRequestContext context) throws HandlerException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        if (!op2Properties.isTransazioniEnabled()) {
            return;
        }
        String idTransazione = (String)context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
        try {
            Transaction tr = TransactionContext.getTransaction(idTransazione);
            tr.setDataAccettazioneRichiesta(context.getDataAccettazioneRichiesta());
            tr.setDataIngressoRichiesta(context.getDataElaborazioneMessaggio());
            if (context.getConnettore() != null) {
                Credenziali credenziali = context.getConnettore().getCredenziali();
                String credenzialiFornite = "";
                if (credenziali != null) {
                    credenzialiFornite = credenziali.toString(false, true, false, true, "", "", "\n");
                }
                tr.setCredenziali(credenzialiFornite);
                if (context.getConnettore().getUrlProtocolContext() != null) {
                    Object urlInvocazione = context.getConnettore().getUrlProtocolContext().getUrlInvocazione_formBased();
                    if (context.getConnettore().getUrlProtocolContext().getFunction() != null) {
                        urlInvocazione = "[" + context.getConnettore().getUrlProtocolContext().getFunction() + "] " + (String)urlInvocazione;
                    }
                    tr.setUrlInvocazione((String)urlInvocazione);
                }
            }
        }
        catch (TransactionDeletedException e) {
            throw new HandlerException(e);
        }
        catch (TransactionNotExistsException e) {
            throw new HandlerException(e);
        }
    }
}

