/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.transazioni;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.diagnostica.ElencoMessaggiDiagnostici;
import org.openspcoop2.core.diagnostica.MessaggioDiagnostico;
import org.openspcoop2.core.tracciamento.Traccia;
import org.openspcoop2.core.transazioni.DumpMessaggio;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.pdd.core.FileSystemSerializer;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class ExceptionSerialzerFileSystem {
    private Logger logger;

    public ExceptionSerialzerFileSystem(Logger log) {
        this.logger = log;
    }

    public void registrazioneFileSystem(Transazione transazione, String idTransazione) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            transazione.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            bout.flush();
            bout.close();
            FileSystemSerializer.getInstance().registraTransazione(bout.toByteArray(), transazione.getDataIngressoRichiesta());
        }
        catch (Throwable eSerializer) {
            this.logger.error("Errore durante la registrazione su file system della transazione [" + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrazioneFileSystemDiagnosticiTracceDumpEmessiPdD(Transaction transaction, String idTransazione, Transazione transazioneDTO, boolean registraTracciaRichiesta, boolean registraTracciaRisposta, boolean registrazioneMessaggiDiagnostici, boolean registrazioneDumpMessaggi) {
        ByteArrayOutputStream bout;
        ByteArrayOutputStream bout2;
        Traccia tr;
        if (registraTracciaRichiesta && transaction.getTracciaRichiesta() != null) {
            try {
                transaction.getTracciaRichiesta().addPropertyInBusta((String)((Object)Costanti.ID_TRANSAZIONE.getValue()), idTransazione);
                tr = transaction.getTracciaRichiesta().getTraccia();
                bout2 = new ByteArrayOutputStream();
                tr.writeTo((OutputStream)bout2, WriteToSerializerType.XML_JAXB);
                bout2.flush();
                bout2.close();
                FileSystemSerializer.getInstance().registraTraccia(bout2.toByteArray(), tr.getOraRegistrazione());
                if (transazioneDTO != null) {
                    transazioneDTO.setTracciaRichiesta(null);
                }
            }
            catch (Throwable eSerializer) {
                this.logger.error("Errore durante la registrazione su file system della traccia di richiesta [idTransazione: " + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
            }
        }
        if (registraTracciaRisposta && transaction.getTracciaRisposta() != null) {
            try {
                transaction.getTracciaRisposta().addPropertyInBusta((String)((Object)Costanti.ID_TRANSAZIONE.getValue()), idTransazione);
                tr = transaction.getTracciaRisposta().getTraccia();
                bout2 = new ByteArrayOutputStream();
                tr.writeTo((OutputStream)bout2, WriteToSerializerType.XML_JAXB);
                bout2.flush();
                bout2.close();
                FileSystemSerializer.getInstance().registraTraccia(bout2.toByteArray(), tr.getOraRegistrazione());
                if (transazioneDTO != null) {
                    transazioneDTO.setTracciaRisposta(null);
                }
            }
            catch (Throwable eSerializer) {
                this.logger.error("Errore durante la registrazione su file system della traccia di risposta [idTransazione: " + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
            }
        }
        if (registrazioneMessaggiDiagnostici && transaction.getMsgDiagnostici() != null && transaction.getMsgDiagnostici().size() > 0) {
            boolean error = false;
            boolean registrazioneSingoloDiagnostico = false;
            if (registrazioneSingoloDiagnostico) {
                for (MsgDiagnostico msgDiag : transaction.getMsgDiagnostici()) {
                    try {
                        MessaggioDiagnostico msgDiagOp2 = msgDiag.getMessaggioDiagnostico();
                        ByteArrayOutputStream bout3 = new ByteArrayOutputStream();
                        msgDiagOp2.writeTo((OutputStream)bout3, WriteToSerializerType.XML_JAXB);
                        bout3.flush();
                        bout3.close();
                        FileSystemSerializer.getInstance().registraDiagnostico(bout3.toByteArray(), msgDiagOp2.getOraRegistrazione());
                    }
                    catch (Throwable eSerializer) {
                        error = true;
                        this.logger.error("Errore durante la registrazione su file system del messaggio diagnostico [idTransazione: " + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
                    }
                }
            } else {
                ElencoMessaggiDiagnostici elencoDiagnostici = new ElencoMessaggiDiagnostici();
                Date oraRegistrazione = null;
                for (MsgDiagnostico msgDiag : transaction.getMsgDiagnostici()) {
                    MessaggioDiagnostico msgDiagOp2 = msgDiag.getMessaggioDiagnostico();
                    elencoDiagnostici.addMessaggioDiagnostico(msgDiagOp2);
                    if (oraRegistrazione != null) continue;
                    oraRegistrazione = msgDiagOp2.getOraRegistrazione();
                }
                try {
                    bout = new ByteArrayOutputStream();
                    elencoDiagnostici.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
                    bout.flush();
                    bout.close();
                    FileSystemSerializer.getInstance().registraDiagnostico(bout.toByteArray(), oraRegistrazione);
                }
                catch (Throwable eSerializer) {
                    error = true;
                    this.logger.error("Errore durante la registrazione su file system dei messaggi diagnostici [idTransazione: " + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
                }
            }
            if (!error && transazioneDTO != null) {
                transazioneDTO.setDiagnostici(null);
                transazioneDTO.setDiagnosticiList1(null);
                transazioneDTO.setDiagnosticiList2(null);
                transazioneDTO.setDiagnosticiListExt(null);
                transazioneDTO.setDiagnosticiExt(null);
            }
        }
        if (registrazioneDumpMessaggi && transaction.getMessaggi() != null && transaction.getMessaggi().size() > 0) {
            boolean error = false;
            for (Messaggio messaggio : transaction.getMessaggi()) {
                try {
                    DumpMessaggio messaggioOp2 = messaggio.toDumpMessaggio();
                    bout = new ByteArrayOutputStream();
                    messaggioOp2.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
                    bout.flush();
                    bout.close();
                    FileSystemSerializer.getInstance().registraDump(bout.toByteArray(), messaggioOp2.getDumpTimestamp());
                }
                catch (Throwable eSerializer) {
                    error = true;
                    this.logger.error("Errore durante la registrazione su file system del messaggio [idTransazione: " + idTransazione + "]: " + eSerializer.getMessage(), eSerializer);
                }
                finally {
                    try {
                        if (messaggio.getBody() == null) continue;
                        messaggio.getBody().unlock();
                        messaggio.getBody().clearResources();
                    }
                    catch (Throwable t) {
                        this.logger.error("Errore durante il rilascio delle risorse su del messaggio [idTransazione: " + idTransazione + "]: " + t.getMessage(), t);
                    }
                }
            }
            if (!error && transazioneDTO != null) {
                transazioneDTO.getDumpMessaggioList().clear();
            }
        }
    }

    public void registrazioneFileSystemDiagnosticoEmessoPdD(MsgDiagnostico msgDiag, String idTransazione, String applicativoServer) {
        try {
            MessaggioDiagnostico msgDiagOp2 = msgDiag.getMessaggioDiagnostico();
            msgDiagOp2.setIdTransazione(idTransazione);
            msgDiagOp2.setApplicativo(applicativoServer);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            msgDiagOp2.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            bout.flush();
            bout.close();
            FileSystemSerializer.getInstance().registraDiagnostico(bout.toByteArray(), msgDiagOp2.getOraRegistrazione());
        }
        catch (Throwable eSerializer) {
            this.logger.error("Errore durante la registrazione su file system del messaggio diagnostico [idTransazione: " + idTransazione + "][server: " + applicativoServer + "]: " + eSerializer.getMessage(), eSerializer);
        }
    }

    public void registrazioneFileSystemDumpEmessoPdD(Messaggio messaggio, String idTransazione, String applicativoServer, Date dataConsegna) {
        try {
            DumpMessaggio messaggioOp2 = messaggio.toDumpMessaggio();
            messaggio.setIdTransazione(idTransazione);
            messaggio.setServizioApplicativoErogatore(applicativoServer);
            messaggio.setDataConsegna(dataConsegna);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            messaggioOp2.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            bout.flush();
            bout.close();
            FileSystemSerializer.getInstance().registraDump(bout.toByteArray(), messaggioOp2.getDumpTimestamp());
        }
        catch (Throwable eSerializer) {
            this.logger.error("Errore durante la registrazione su file system del messaggio [idTransazione: " + idTransazione + "][server: " + applicativoServer + "][data:" + DateUtils.getSimpleDateFormatMs().format(dataConsegna) + "]: " + eSerializer.getMessage(), eSerializer);
        }
    }

    public void registrazioneFileSystemTransazioneApplicativoServerEmessoPdD(TransazioneApplicativoServer transazioneApplicativoServer, String idTransazione, String applicativoServer) {
        try {
            transazioneApplicativoServer.setIdTransazione(idTransazione);
            transazioneApplicativoServer.setServizioApplicativoErogatore(applicativoServer);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            transazioneApplicativoServer.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            bout.flush();
            bout.close();
            FileSystemSerializer.getInstance().registraTransazioneApplicativoServer(bout.toByteArray(), transazioneApplicativoServer.getDataAccettazioneRichiesta());
        }
        catch (Throwable eSerializer) {
            this.logger.error("Errore durante la registrazione su file system dell'applicativo server [idTransazione: " + idTransazione + "][server: " + applicativoServer + "]: " + eSerializer.getMessage(), eSerializer);
        }
    }

    public void registrazioneFileSystemTransazioneApplicativoServerConsegnaTerminata(TransazioneApplicativoServer transazioneApplicativoServer, String idTransazione, String applicativoServer) {
        try {
            transazioneApplicativoServer.setIdTransazione(idTransazione);
            transazioneApplicativoServer.setServizioApplicativoErogatore(applicativoServer);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            transazioneApplicativoServer.writeTo((OutputStream)bout, WriteToSerializerType.XML_JAXB);
            bout.flush();
            bout.close();
            FileSystemSerializer.getInstance().registraTransazioneApplicativoServerConsegnaTerminata(bout.toByteArray(), transazioneApplicativoServer.getDataAccettazioneRichiesta());
        }
        catch (Throwable eSerializer) {
            this.logger.error("Errore durante la registrazione su file system dell'informazione di consegna terminata [idTransazione: " + idTransazione + "][server: " + applicativoServer + "]: " + eSerializer.getMessage(), eSerializer);
        }
    }
}

