/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.notifier.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierCallback;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierDump;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierResultStreamingHandler;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.unblocked.AbstractStreamingHandler;
import org.openspcoop2.utils.io.notifier.unblocked.ResultStreamingHandler;
import org.slf4j.Logger;

public class NotifierStreamingHandler
extends AbstractStreamingHandler {
    private Throwable exception = null;
    private String error = null;
    private String idTransazione;
    private TipoMessaggio tipoMessaggio;
    private Map<String, List<String>> headerTrasporto;
    private long idDumpConfigurazione;
    private String contentType;
    private NotifierCallback notifierCallback;
    private IDSoggetto dominio;

    public NotifierStreamingHandler(NotifierCallback notifierCallback, String idTransazione, TipoMessaggio tipoMessaggio, Map<String, List<String>> headerTrasporto, long idDumpConfigurazione, String contentType, Logger log, IDSoggetto dominio) throws Exception {
        super(log, (long)OpenSPCoop2Properties.getInstance().getDumpNonRealtimeInMemoryThreshold());
        this.notifierCallback = notifierCallback;
        this.idTransazione = idTransazione;
        this.tipoMessaggio = tipoMessaggio;
        this.headerTrasporto = headerTrasporto;
        this.contentType = contentType;
        this.idDumpConfigurazione = idDumpConfigurazione;
        this.dominio = dominio;
    }

    public boolean isPrematureEnd() throws UtilsException {
        return this.exception != null;
    }

    public String getError() {
        return this.error;
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultStreamingHandler call() throws UtilsException {
        try {
            NotifierResultStreamingHandler result = new NotifierResultStreamingHandler();
            OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
            if (op2Properties.isDumpNonRealtimeDatabaseMode()) {
                this.notifierCallback.debug("Save on database.....");
                NotifierDump notifierDump = NotifierDump.getInstance();
                this.notifierCallback.debug("Get Instance.....");
                int executeUpdate = notifierDump.saveOnDatabase(this.notifierCallback, this.idTransazione, this.tipoMessaggio, this.headerTrasporto, this.idDumpConfigurazione, this.contentType, (InputStream)((Object)this), this.dominio);
                this.notifierCallback.debug("Execute: " + executeUpdate);
                result.setSaveOnFileSystem(false);
                result.setExecuteUpdateRow(executeUpdate);
                this.notifierCallback.debug("Save on database execute with row: " + executeUpdate);
            } else {
                this.notifierCallback.debug("Save on fs.....");
                File fDir = op2Properties.getDumpNonRealtimeRepository();
                if (!fDir.exists()) {
                    throw new Exception("Directory [" + fDir.getAbsolutePath() + "] not exists");
                }
                if (!fDir.canRead()) {
                    throw new Exception("Directory [" + fDir.getAbsolutePath() + "] not readable");
                }
                if (!fDir.canWrite()) {
                    throw new Exception("Directory [" + fDir.getAbsolutePath() + "] not writable");
                }
                File f = new File(fDir, this.idTransazione + "_" + this.tipoMessaggio.toString() + ".bin");
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(f);
                    byte[] buffer = new byte[4096];
                    int letti = 0;
                    while ((letti = this.read(buffer)) != -1) {
                        fout.write(buffer, 0, letti);
                    }
                }
                finally {
                    try {
                        if (fout != null) {
                            fout.flush();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (fout != null) {
                            fout.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                result.setSaveOnFileSystem(true);
                result.setFile(f);
                this.notifierCallback.debug("Save on fs execute: " + f.getAbsolutePath());
            }
            return result;
        }
        catch (Throwable e) {
            this.exception = e;
            this.error = e.getMessage();
            throw new UtilsException(this.error, this.exception);
        }
    }
}

