/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.notifier.engine;

import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.PostOutRequestContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInResponseContext;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierBufferState;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierResult;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierType;
import org.openspcoop2.pdd.core.handlers.notifier.engine.ManagementMode;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierCallback;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierConstants;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierDump;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierResultStreamingHandler;
import org.openspcoop2.pdd.core.handlers.notifier.engine.NotifierStreamingHandler;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.ConnectorInMessage;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.io.notifier.unblocked.PipedInputOutputStreamHandler;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class NotifierCallbackEnableUtils {
    public static boolean enableNotifierInputStream(NotifierCallback notifierCallback, NotifierType notifierType, Object context) throws ConnectorException {
        PreInResponseContext op2Context;
        Boolean responseDumpPostProcessEnabled;
        if (!OpenSPCoop2Properties.getInstance().isNotifierInputStreamEnabled()) {
            return false;
        }
        if (NotifierType.PRE_IN_REQUEST.equals((Object)notifierType)) {
            PreInRequestContext op2Context2 = (PreInRequestContext)context;
            ConnectorInMessage request = (ConnectorInMessage)op2Context2.getTransportContext().get("SERVLET_REQUEST");
            int length = request.getContentLength();
            notifierCallback.debug("CONTENT LENGTH [" + length + "]");
            NotifierCallbackEnableUtils.setManagementMode(notifierCallback, length, op2Context2.getPddContext());
            String contentType = request.getContentType();
            notifierCallback.debug("CONTENT TYPE [" + contentType + "]");
            op2Context2.getPddContext().addObject(NotifierConstants.REQUEST_CONTENT_TYPE, contentType);
            return true;
        }
        if (NotifierType.PRE_IN_RESPONSE.equals((Object)notifierType) && (responseDumpPostProcessEnabled = (Boolean)(op2Context = (PreInResponseContext)context).getPddContext().getObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED)) != null && responseDumpPostProcessEnabled.booleanValue()) {
            notifierCallback.debug("ReturnCode [" + op2Context.getCodiceTrasporto() + "]");
            int length = -1;
            if (op2Context.getResponseHeaders() != null && op2Context.getResponseHeaders().size() > 0) {
                for (String key : op2Context.getResponseHeaders().keySet()) {
                    if ("Content-Length".equalsIgnoreCase(key)) {
                        String lengthParam = TransportUtils.getFirstValue(op2Context.getResponseHeaders(), (String)key);
                        length = Integer.parseInt(lengthParam);
                        notifierCallback.debug("CONTENT LENGTH RESPONSE [" + length + "]");
                        continue;
                    }
                    if (!"Content-Type".equalsIgnoreCase(key)) continue;
                    String contentType = TransportUtils.getFirstValue(op2Context.getResponseHeaders(), (String)key);
                    notifierCallback.debug("CONTENT TYPE RESPONSE [" + contentType + "]");
                    op2Context.getPddContext().addObject(NotifierConstants.RESPONSE_CONTENT_TYPE, contentType);
                }
            }
            NotifierCallbackEnableUtils.setManagementMode(notifierCallback, length, op2Context.getPddContext());
            return true;
        }
        return false;
    }

    private static void setManagementMode(NotifierCallback notifierCallback, int length, PdDContext pddContext) {
        ManagementMode mode = null;
        if (length > 0) {
            mode = ManagementMode.STREAMING;
            Integer thresholdInMemory = OpenSPCoop2Properties.getInstance().getDumpNonRealtimeInMemoryThreshold();
            if (thresholdInMemory != null && length < thresholdInMemory) {
                mode = ManagementMode.BUFFER;
            }
        } else {
            mode = ManagementMode.STREAMING;
        }
        pddContext.addObject(NotifierConstants.MANAGEMENT_MODE, (Object)mode);
        notifierCallback.debug("MANAGEMENT MODE [" + mode.name() + "]");
    }

    public static NotifierResult notify(NotifierCallback notifierCallback, NotifierType notifierType, Object context) throws Exception {
        NotifierResult result = new NotifierResult();
        NotifierCallbackEnableUtils.newStreamingHandlers(notifierCallback, result, notifierType, context);
        result.setBufferState(NotifierCallbackEnableUtils.getBufferState(notifierCallback, notifierType, context));
        return result;
    }

    private static void newStreamingHandlers(NotifierCallback notifierCallback, NotifierResult notifierResult, NotifierType notifierType, Object context) throws Exception {
        PreInResponseContext op2Context;
        Boolean responseDumpPostProcessEnabled;
        if (NotifierType.IN_REQUEST_PROTOCOL_INFO.equals((Object)notifierType)) {
            InRequestProtocolContext op2Context2 = (InRequestProtocolContext)context;
            NotifierCallbackEnableUtils.setConfigurazioneDump(notifierCallback, op2Context2);
            Boolean requestDumpPostProcessEnabled = (Boolean)op2Context2.getPddContext().getObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED);
            if (requestDumpPostProcessEnabled.booleanValue()) {
                ManagementMode managementMode;
                Map headerTrasporto = null;
                if (TipoPdD.DELEGATA.equals((Object)op2Context2.getTipoPorta()) && op2Context2.getConnettore() != null && op2Context2.getConnettore().getUrlProtocolContext().getHeaders() != null) {
                    headerTrasporto = op2Context2.getConnettore().getUrlProtocolContext().getHeaders();
                    op2Context2.getPddContext().addObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_HEADER_TRASPORTO, headerTrasporto);
                }
                if (ManagementMode.STREAMING.equals((Object)(managementMode = (ManagementMode)((Object)op2Context2.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE))))) {
                    notifierCallback.debug("CREO HANDLER DI STREAMING ...");
                    Logger log = op2Context2.getLogCore();
                    IDSoggetto dominio = null;
                    if (op2Context2.getProtocollo() != null) {
                        dominio = op2Context2.getProtocollo().getDominio();
                    }
                    notifierResult.addStreamingHandler("PddMonitorStreamingHandler", NotifierCallbackEnableUtils.newHandler(notifierCallback, log, TipoMessaggio.RICHIESTA_INGRESSO, op2Context2.getPddContext(), headerTrasporto, dominio), log);
                    notifierCallback.debug("CREATO!");
                }
            }
        } else if (NotifierType.PRE_IN_RESPONSE.equals((Object)notifierType) && (responseDumpPostProcessEnabled = (Boolean)(op2Context = (PreInResponseContext)context).getPddContext().getObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED)).booleanValue()) {
            ManagementMode managementMode;
            Map<String, List<String>> headerTrasporto = null;
            if (TipoPdD.APPLICATIVA.equals((Object)op2Context.getTipoPorta()) && op2Context.getResponseHeaders() != null) {
                headerTrasporto = op2Context.getResponseHeaders();
                op2Context.getPddContext().addObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_HEADER_TRASPORTO, headerTrasporto);
            }
            if (ManagementMode.STREAMING.equals((Object)(managementMode = (ManagementMode)((Object)op2Context.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE))))) {
                notifierCallback.debug("CREO HANDLER DI STREAMING DI RISPOSTA ...");
                Logger log = op2Context.getLogCore();
                IDSoggetto dominio = null;
                if (op2Context.getProtocollo() != null) {
                    dominio = op2Context.getProtocollo().getDominio();
                }
                notifierResult.addStreamingHandler("PddMonitorStreamingHandler", NotifierCallbackEnableUtils.newHandler(notifierCallback, log, TipoMessaggio.RISPOSTA_INGRESSO, op2Context.getPddContext(), headerTrasporto, dominio), log);
                notifierCallback.debug("CREATO!");
            }
        }
    }

    private static NotifierStreamingHandler newHandler(NotifierCallback notifierCallback, Logger log, TipoMessaggio tipoMessaggio, PdDContext pddContext, Map<String, List<String>> headerTrasporto, IDSoggetto dominio) throws Exception {
        long dumpPostProcessConfigId = (Long)pddContext.getObject(NotifierConstants.DUMP_POST_PROCESS_ID_CONFIG);
        String idTransazione = (String)pddContext.getObject(Costanti.ID_TRANSAZIONE);
        String contentType = null;
        contentType = TipoMessaggio.RICHIESTA_INGRESSO.equals((Object)tipoMessaggio) ? (String)pddContext.getObject(NotifierConstants.REQUEST_CONTENT_TYPE) : (String)pddContext.getObject(NotifierConstants.RESPONSE_CONTENT_TYPE);
        NotifierStreamingHandler notifierStreamingHandler = new NotifierStreamingHandler(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dumpPostProcessConfigId, contentType, log, dominio);
        return notifierStreamingHandler;
    }

    private static NotifierBufferState getBufferState(NotifierCallback notifierCallback, NotifierType notifierType, Object context) throws Exception {
        NotifierBufferState state = NotifierBufferState.UNMODIFIED;
        if (NotifierType.PRE_IN_REQUEST.equals((Object)notifierType)) {
            state = NotifierBufferState.ENABLE;
            notifierCallback.debug("ABILITO IL BUFFER!!");
        } else if (NotifierType.IN_REQUEST_PROTOCOL_INFO.equals((Object)notifierType)) {
            InRequestProtocolContext op2Context = (InRequestProtocolContext)context;
            NotifierCallbackEnableUtils.setConfigurazioneDump(notifierCallback, op2Context);
            Boolean requestDumpPostProcessEnabled = (Boolean)op2Context.getPddContext().getObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED);
            if (requestDumpPostProcessEnabled.booleanValue()) {
                ManagementMode managementMode = (ManagementMode)((Object)op2Context.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE));
                if (ManagementMode.BUFFER.equals((Object)managementMode)) {
                    notifierCallback.debug("DUMP POST PROCESS ABILITATO COME BUFFER, LASCIO BUFFER ABILITATO");
                } else {
                    state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                    notifierCallback.debug("RILASCIO IL BUFFER, DUMP POST PROCESS ABILITATO COME STREAMING");
                }
            } else {
                state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                notifierCallback.debug("RILASCIO IL BUFFER, DUMP POST PROCESS NON ABILITATO");
            }
        } else if (NotifierType.POST_OUT_REQUEST.equals((Object)notifierType)) {
            Boolean requestDumpPostProcessEnabled;
            PostOutRequestContext op2Context = (PostOutRequestContext)context;
            IDSoggetto dominio = null;
            if (op2Context.getProtocollo() != null) {
                dominio = op2Context.getProtocollo().getDominio();
            }
            if ((requestDumpPostProcessEnabled = (Boolean)op2Context.getPddContext().getObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED)).booleanValue()) {
                Map headerTrasporto = null;
                if (TipoPdD.DELEGATA.equals((Object)op2Context.getTipoPorta())) {
                    Object o = op2Context.getPddContext().getObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_HEADER_TRASPORTO);
                    if (o != null) {
                        headerTrasporto = (Map)o;
                    }
                } else if (op2Context.getConnettore() != null) {
                    headerTrasporto = op2Context.getConnettore().getHeaders();
                }
                long dumpPostProcessConfigId = (Long)op2Context.getPddContext().getObject(NotifierConstants.DUMP_POST_PROCESS_ID_CONFIG);
                String contentTypeRequest = (String)op2Context.getPddContext().getObject(NotifierConstants.REQUEST_CONTENT_TYPE);
                String idTransazione = (String)op2Context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                TipoMessaggio tipoMessaggio = TipoMessaggio.RICHIESTA_INGRESSO;
                ManagementMode managementMode = (ManagementMode)((Object)op2Context.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE));
                if (ManagementMode.BUFFER.equals((Object)managementMode)) {
                    notifierCallback.debug("[BUFFER MODE] RILASCIO IL BUFFER, e salvo il contenuto su database");
                    state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                    byte[] buffer = op2Context.getMessaggio().getNotifierInputStream().serializeAndConsume();
                    NotifierDump.getInstance().saveBuffer(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dumpPostProcessConfigId, contentTypeRequest, buffer, dominio);
                } else {
                    PipedInputOutputStreamHandler streamingHandler = (PipedInputOutputStreamHandler)op2Context.getMessaggio().getNotifierInputStream().getStreamingHandler("PddMonitorStreamingHandler");
                    if (streamingHandler.getError() != null || streamingHandler.getException() != null) {
                        String msg = null;
                        msg = streamingHandler.getError() != null ? streamingHandler.getError() : streamingHandler.getException().getMessage();
                        notifierCallback.debug("EVENTUALE ERRORE [" + msg + "]");
                        if (streamingHandler.getException() != null) {
                            throw new Exception(msg, streamingHandler.getException());
                        }
                        throw new Exception(msg);
                    }
                    NotifierResultStreamingHandler result = (NotifierResultStreamingHandler)streamingHandler.getResult();
                    if (result == null) {
                        throw new Exception("Streaming Handler [PddMonitorStreamingHandler] non ha ritornato un risultato, ma nemmeno una eccezione");
                    }
                    if (result.isSaveOnFileSystem()) {
                        notifierCallback.debug("[STREAMING MODE su FS] RILASCIO IL BUFFER, e salvo il contenuto su database (file:" + result.getFile().getAbsolutePath() + ")");
                        state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                        NotifierDump.getInstance().saveOnFileSystem(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dumpPostProcessConfigId, contentTypeRequest, result.getFile(), dominio);
                    } else {
                        notifierCallback.debug("[STREAMING MODE su Database] INSERT EFFETTUATA (ExecuteUpdate:" + result.getExecuteUpdateRow() + ")");
                        int rowUpdate = result.getExecuteUpdateRow();
                        if (TipoPdD.APPLICATIVA.equals((Object)op2Context.getTipoPorta()) && headerTrasporto != null) {
                            rowUpdate = NotifierDump.getInstance().update(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dominio);
                        }
                        notifierCallback.debug("[STREAMING MODE su Database] RILASCIO IL BUFFER (ExecuteUpdate:" + rowUpdate + ")");
                        state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                    }
                }
            }
        } else if (NotifierType.PRE_IN_RESPONSE.equals((Object)notifierType)) {
            ManagementMode managementMode;
            PreInResponseContext op2Context = (PreInResponseContext)context;
            Boolean responseDumpPostProcessEnabled = (Boolean)op2Context.getPddContext().getObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED);
            if (responseDumpPostProcessEnabled.booleanValue() && ManagementMode.BUFFER.equals((Object)(managementMode = (ManagementMode)((Object)op2Context.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE))))) {
                notifierCallback.debug("[BUFFER] ABILITO IL BUFFER ");
                state = NotifierBufferState.ENABLE;
            }
        } else if (NotifierType.POST_OUT_RESPONSE.equals((Object)notifierType)) {
            Boolean responseDumpPostProcessEnabled;
            PostOutResponseContext op2Context = (PostOutResponseContext)context;
            IDSoggetto dominio = null;
            if (op2Context.getProtocollo() != null) {
                dominio = op2Context.getProtocollo().getDominio();
            }
            if ((responseDumpPostProcessEnabled = (Boolean)op2Context.getPddContext().getObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED)).booleanValue()) {
                Map headerTrasporto = null;
                if (TipoPdD.APPLICATIVA.equals((Object)op2Context.getTipoPorta())) {
                    Object o = op2Context.getPddContext().getObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_HEADER_TRASPORTO);
                    if (o != null) {
                        headerTrasporto = (Map)o;
                    }
                } else if (op2Context.getResponseHeaders() != null) {
                    headerTrasporto = op2Context.getResponseHeaders();
                }
                long dumpPostProcessConfigId = (Long)op2Context.getPddContext().getObject(NotifierConstants.DUMP_POST_PROCESS_ID_CONFIG);
                String contentTypeResponse = (String)op2Context.getPddContext().getObject(NotifierConstants.RESPONSE_CONTENT_TYPE);
                String idTransazione = (String)op2Context.getPddContext().getObject(Costanti.ID_TRANSAZIONE);
                TipoMessaggio tipoMessaggio = TipoMessaggio.RISPOSTA_INGRESSO;
                ManagementMode managementMode = (ManagementMode)((Object)op2Context.getPddContext().getObject(NotifierConstants.MANAGEMENT_MODE));
                if (ManagementMode.BUFFER.equals((Object)managementMode)) {
                    notifierCallback.debug("[BUFFER MODE] RILASCIO IL BUFFER, e salvo il contenuto su database");
                    state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                    byte[] buffer = op2Context.getMessaggio().getNotifierInputStream().serializeAndConsume();
                    NotifierDump.getInstance().saveBuffer(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dumpPostProcessConfigId, contentTypeResponse, buffer, dominio);
                } else {
                    PipedInputOutputStreamHandler streamingHandler = (PipedInputOutputStreamHandler)op2Context.getMessaggio().getNotifierInputStream().getStreamingHandler("PddMonitorStreamingHandler");
                    if (streamingHandler.getError() != null || streamingHandler.getException() != null) {
                        String msg = null;
                        msg = streamingHandler.getError() != null ? streamingHandler.getError() : streamingHandler.getException().getMessage();
                        notifierCallback.debug("EVENTUALE ERRORE [" + msg + "]");
                        if (streamingHandler.getException() != null) {
                            throw new Exception(msg, streamingHandler.getException());
                        }
                        throw new Exception(msg);
                    }
                    NotifierResultStreamingHandler result = (NotifierResultStreamingHandler)streamingHandler.getResult();
                    if (result == null) {
                        throw new Exception("Streaming Handler [PddMonitorStreamingHandler] non ha ritornato un risultato, ma nemmeno una eccezione");
                    }
                    if (result.isSaveOnFileSystem()) {
                        notifierCallback.debug("[STREAMING MODE su FS] RILASCIO IL BUFFER, e salvo il contenuto della risposta su database (file:" + result.getFile().getAbsolutePath() + ")");
                        state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                        NotifierDump.getInstance().saveOnFileSystem(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dumpPostProcessConfigId, contentTypeResponse, result.getFile(), dominio);
                    } else {
                        notifierCallback.debug("[STREAMING MODE su Database] INSERT EFFETTUATA (ExecuteUpdate:" + result.getExecuteUpdateRow() + ")");
                        int rowUpdate = result.getExecuteUpdateRow();
                        if (TipoPdD.DELEGATA.equals((Object)op2Context.getTipoPorta()) && headerTrasporto != null) {
                            rowUpdate = NotifierDump.getInstance().update(notifierCallback, idTransazione, tipoMessaggio, headerTrasporto, dominio);
                        }
                        notifierCallback.debug("[STREAMING MODE su Database] RILASCIO IL BUFFER (ExecuteUpdate:" + rowUpdate + ")");
                        state = NotifierBufferState.DISABLE_AND_RELEASE_BUFFER_READED;
                    }
                }
            }
        }
        return state;
    }

    private static void setConfigurazioneDump(NotifierCallback notifierCallback, InRequestProtocolContext inRequestProtocolContext) throws Exception {
        if (inRequestProtocolContext.getPddContext().getObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED) == null) {
            DumpConfigurazione regolaDump = NotifierCallbackEnableUtils.readConfigurazioneDump(inRequestProtocolContext);
            if (regolaDump != null) {
                if (StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRealtime())) {
                    boolean requestDumpPostProcessEnabled = regolaDump.getRichiestaIngresso() != null && (StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRichiestaIngresso().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRichiestaIngresso().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRichiestaIngresso().getAttachments()));
                    boolean responseDumpPostProcessEnabled = regolaDump.getRispostaIngresso() != null && (StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRispostaIngresso().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRispostaIngresso().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)regolaDump.getRispostaIngresso().getAttachments()));
                    inRequestProtocolContext.getPddContext().addObject(NotifierConstants.DUMP_POST_PROCESS_ID_CONFIG, regolaDump.getId());
                    inRequestProtocolContext.getPddContext().addObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED, requestDumpPostProcessEnabled);
                    inRequestProtocolContext.getPddContext().addObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED, responseDumpPostProcessEnabled);
                    notifierCallback.debug("REGOLA DUMP PRESENTE COME POST PROCESS REQUEST[" + requestDumpPostProcessEnabled + "] RESPONSE[" + responseDumpPostProcessEnabled + "]");
                } else {
                    notifierCallback.debug("REGOLA DUMP PRESENTE COME REAL TIME");
                    inRequestProtocolContext.getPddContext().addObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED, false);
                    inRequestProtocolContext.getPddContext().addObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED, false);
                }
            } else {
                notifierCallback.debug("REGOLA DUMP NON PRESENTE");
                inRequestProtocolContext.getPddContext().addObject(NotifierConstants.REQUEST_DUMP_POST_PROCESS_ENABLED, false);
                inRequestProtocolContext.getPddContext().addObject(NotifierConstants.RESPONSE_DUMP_POST_PROCESS_ENABLED, false);
            }
        }
    }

    private static DumpConfigurazione readConfigurazioneDump(InRequestProtocolContext inRequestProtocolContext) throws Exception {
        if (inRequestProtocolContext.getIntegrazione() == null) {
            throw new Exception("inRequestProtocolContext.getIntegrazione() is null");
        }
        if (inRequestProtocolContext.getIntegrazione().getIdPD() == null && inRequestProtocolContext.getIntegrazione().getIdPA() == null) {
            throw new Exception("non \u00e8 presente ne un identificativo di porta delegata, ne uno di porta applicativa");
        }
        RequestInfo requestInfo = null;
        if (inRequestProtocolContext.getPddContext() != null && inRequestProtocolContext.getPddContext().containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)inRequestProtocolContext.getPddContext().getObject(Costanti.REQUEST_INFO);
        }
        DumpConfigurazione config = null;
        ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(inRequestProtocolContext.getStato());
        if (inRequestProtocolContext.getIntegrazione().getIdPD() != null) {
            PortaDelegata pd = configPdDManager.getPortaDelegata(inRequestProtocolContext.getIntegrazione().getIdPD(), requestInfo);
            config = configPdDManager.getDumpConfigurazione(pd);
        } else {
            PortaApplicativa pa = configPdDManager.getPortaApplicativa(inRequestProtocolContext.getIntegrazione().getIdPA(), requestInfo);
            config = configPdDManager.getDumpConfigurazione(pa);
        }
        return config;
    }
}

