/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers;

import org.openspcoop2.message.AbstractBaseOpenSPCoop2Message;
import org.openspcoop2.message.ForcedResponseMessage;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

public class HandlerException
extends Exception {
    private boolean customizedResponse = false;
    private boolean customizedResponseAs4xxCode = false;
    private String customizedResponseCode = null;
    private String responseCode = null;
    private boolean emptyResponse = false;
    private byte[] response = null;
    private String responseContentType;
    private boolean emettiDiagnostico = true;
    private String identitaHandler = null;
    private IntegrationFunctionError integrationError = null;
    private static final long serialVersionUID = 1L;

    public boolean isCustomizedResponse() {
        return this.customizedResponse;
    }

    public void setCustomizedResponse(boolean customizedResponse) {
        this.customizedResponse = customizedResponse;
    }

    public boolean isCustomizedResponseAs4xxCode() {
        return this.customizedResponseAs4xxCode;
    }

    public void setCustomizedResponseAs4xxCode(boolean customizedResponseAs4xxCode) {
        this.customizedResponseAs4xxCode = customizedResponseAs4xxCode;
    }

    public String getCustomizedResponseCode() {
        return this.customizedResponseCode;
    }

    public void setCustomizedResponseCode(String customizedResponseCode) {
        this.customizedResponseCode = customizedResponseCode;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public boolean isEmptyResponse() {
        return this.emptyResponse;
    }

    public void setEmptyResponse(boolean emptyResponse) {
        this.emptyResponse = emptyResponse;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public boolean isEmettiDiagnostico() {
        return this.emettiDiagnostico;
    }

    public void setEmettiDiagnostico(boolean emettiDiagnostico) {
        this.emettiDiagnostico = emettiDiagnostico;
    }

    public String getIdentitaHandler() {
        return this.identitaHandler;
    }

    protected void setIdentitaHandler(String identitaHandler) {
        this.identitaHandler = identitaHandler;
    }

    public IntegrationFunctionError getIntegrationFunctionError() {
        return this.integrationError;
    }

    public void setIntegrationFunctionError(IntegrationFunctionError integrationError) {
        this.integrationError = integrationError;
    }

    public ErroreIntegrazione convertToErroreIntegrazione() {
        if (!this.customizedResponse) {
            return null;
        }
        if (this.customizedResponseAs4xxCode) {
            String customizedCode = "400";
            if (this.customizedResponseCode != null) {
                customizedCode = this.customizedResponseCode;
            }
            return ErroriIntegrazione.ERRORE_4XX_CUSTOM.get4XX_Custom(this.getMessage(), customizedCode);
        }
        String customizedCode = "500";
        if (this.customizedResponseCode != null) {
            customizedCode = this.customizedResponseCode;
        }
        return ErroriIntegrazione.ERRORE_5XX_CUSTOM.get5XX_Custom(this.getMessage(), customizedCode);
    }

    public void customized(OpenSPCoop2Message responseMessage) {
        if (!this.customizedResponse) {
            return;
        }
        if (this.isEmptyResponse()) {
            responseMessage.forceEmptyResponse();
        } else if (this.getResponse() != null) {
            ForcedResponseMessage force = null;
            force = responseMessage instanceof AbstractBaseOpenSPCoop2Message ? new ForcedResponseMessage((AbstractBaseOpenSPCoop2Message)responseMessage) : new ForcedResponseMessage();
            force.setContent(this.getResponse());
            if (this.getResponseContentType() != null) {
                force.setContentType(this.getResponseContentType());
            }
            responseMessage.forceResponse(force);
        }
        if (this.getResponseCode() != null) {
            responseMessage.setForcedResponseCode(this.getResponseCode());
        }
    }

    public HandlerException(String message, Throwable cause) {
        super(message, cause);
    }

    public HandlerException(Throwable cause) {
        super(cause);
    }

    public HandlerException() {
    }

    public HandlerException(String msg) {
        super(msg);
    }
}

