/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.io.Entry;
import org.openspcoop2.utils.io.ZipUtilities;

public class ZipTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private byte[] zip;
    private Template templateFreeMarker;
    private Template templateVelocity;
    private transient Semaphore _lock = null;

    public ZipTemplate(String name, byte[] zip) {
        this.name = name;
        this.zip = zip;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getZip() {
        return this.zip;
    }

    private synchronized void initLock() {
        if (this._lock == null) {
            this._lock = new Semaphore("ZipTemplate");
        }
    }

    public Semaphore getLock() {
        if (this._lock == null) {
            this.initLock();
        }
        return this._lock;
    }

    private void initTemplateFreeMarker() throws DynamicException {
        if (this.templateFreeMarker == null) {
            SemaphoreLock lock = null;
            try {
                lock = this.getLock().acquire("initTemplateFreeMarker");
            }
            catch (Throwable t) {
                throw new DynamicException(t.getMessage(), t);
            }
            try {
                this.templateFreeMarker = this.buildTemplate("index.ftl");
            }
            finally {
                this.getLock().release(lock, "initTemplateFreeMarker");
            }
        }
    }

    public Template getTemplateFreeMarker() throws DynamicException {
        if (this.templateFreeMarker == null) {
            this.initTemplateFreeMarker();
        }
        return this.templateFreeMarker;
    }

    private void initTemplateVelocity() throws DynamicException {
        if (this.templateVelocity == null) {
            SemaphoreLock lock = null;
            try {
                lock = this.getLock().acquire("initTemplateVelocity");
            }
            catch (Throwable t) {
                throw new DynamicException(t.getMessage(), t);
            }
            try {
                this.templateVelocity = this.buildTemplate("index.vm");
            }
            finally {
                this.getLock().release(lock, "initTemplateVelocity");
            }
        }
    }

    public Template getTemplateVelocity() throws DynamicException {
        if (this.templateVelocity == null) {
            this.initTemplateVelocity();
        }
        return this.templateVelocity;
    }

    private Template buildTemplate(String indexEntryName) throws DynamicException {
        List entries = null;
        try {
            entries = ZipUtilities.read((byte[])this.zip);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
        if (entries.isEmpty()) {
            throw new DynamicException("Entries not found");
        }
        byte[] template = null;
        HashMap<String, byte[]> templateIncludes = new HashMap<String, byte[]>();
        for (Entry entry : entries) {
            if (indexEntryName.equals(entry.getName())) {
                template = entry.getContent();
                continue;
            }
            if (!entry.getName().contains("/") && !entry.getName().contains("\\") && template == null) {
                template = entry.getContent();
                continue;
            }
            templateIncludes.put(entry.getName(), entry.getContent());
        }
        Template t = new Template(this.name, template, templateIncludes);
        return t;
    }
}

