/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.PropertiesReader;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.slf4j.Logger;

public class SystemPropertiesReader
extends PropertiesReader {
    private SystemProperties systemProperties;

    public SystemPropertiesReader(Logger log, RequestInfo requestInfo, boolean initFromJmx) throws DynamicException {
        super(log);
        try {
            if (ConfigurazionePdDManager.getInstance() != null && ConfigurazionePdDManager.getInstance().isInitializedConfigurazionePdDReader()) {
                this.systemProperties = initFromJmx ? ConfigurazionePdDManager.getInstance().getSystemPropertiesPdDNoCached(true) : ConfigurazionePdDManager.getInstance().getSystemPropertiesPdDCached(requestInfo);
            }
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    @Override
    public String read(String nome) throws DynamicException {
        if (this.systemProperties == null || this.systemProperties.sizeSystemPropertyList() <= 0) {
            return null;
        }
        for (Property p : this.systemProperties.getSystemPropertyList()) {
            if (p == null || p.getNome() == null || !p.getNome().equalsIgnoreCase(nome)) continue;
            return p.getValore();
        }
        return null;
    }
}

