/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.TemplateHashModel;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.dynamic.AttachmentsReader;
import org.openspcoop2.pdd.core.dynamic.ContentExtractor;
import org.openspcoop2.pdd.core.dynamic.DynamicConfig;
import org.openspcoop2.pdd.core.dynamic.DynamicException;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.EnvironmentJavaPropertiesReader;
import org.openspcoop2.pdd.core.dynamic.EnvironmentPropertiesReader;
import org.openspcoop2.pdd.core.dynamic.ErrorHandler;
import org.openspcoop2.pdd.core.dynamic.InformazioniIntegrazione;
import org.openspcoop2.pdd.core.dynamic.JavaPropertiesReader;
import org.openspcoop2.pdd.core.dynamic.MessageContent;
import org.openspcoop2.pdd.core.dynamic.ObjectConstructor;
import org.openspcoop2.pdd.core.dynamic.PatternExtractor;
import org.openspcoop2.pdd.core.dynamic.SystemPropertiesReader;
import org.openspcoop2.pdd.core.dynamic.Template;
import org.openspcoop2.pdd.core.dynamic.TemplateType;
import org.openspcoop2.pdd.core.dynamic.URLRegExpExtractor;
import org.openspcoop2.pdd.core.dynamic.ZipTemplate;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.attribute_authority.InformazioniAttributi;
import org.openspcoop2.pdd.services.connector.FormUrlEncodedHttpServletRequest;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.DynamicStringReplace;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.ArchiveType;
import org.openspcoop2.utils.io.CompressorUtilities;
import org.openspcoop2.utils.io.Entry;
import org.openspcoop2.utils.resources.FreemarkerTemplateLoader;
import org.openspcoop2.utils.resources.TemplateUtils;
import org.openspcoop2.utils.resources.VelocityTemplateUtils;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpServletTransportRequestContext;
import org.openspcoop2.utils.xml.XMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class DynamicUtils {
    private static final String NON_UTILIZZABILE_IN_QUESTO_CONTESTO = "non utilizzabile in questo contesto ";
    private static boolean xsltProcessAsDomSource = true;

    private DynamicUtils() {
    }

    public static void fillDynamicMapRequest(Logger log, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext, String urlInvocazione, OpenSPCoop2Message message, MessageContent messageContent, Busta busta, Map<String, List<String>> trasporto, Map<String, List<String>> url, Map<String, List<String>> form, ErrorHandler errorHandler) {
        DynamicUtils.fillDynamicMapEngine(log, dynamicMap, pddContext, urlInvocazione, message, messageContent, busta, trasporto, url, form, errorHandler);
    }

    public static void fillDynamicMapResponse(Logger log, Map<String, Object> dynamicMap, Map<String, Object> dynamicMapRequest, org.openspcoop2.protocol.sdk.Context pddContext, OpenSPCoop2Message message, MessageContent messageContent, Busta busta, Map<String, List<String>> trasporto, ErrorHandler errorHandler) {
        DynamicUtils.fillDynamicMapResponse(log, dynamicMap, dynamicMapRequest, pddContext, message, messageContent, busta, trasporto, errorHandler, false);
    }

    public static void fillDynamicMapResponse(Logger log, Map<String, Object> dynamicMap, Map<String, Object> dynamicMapRequest, org.openspcoop2.protocol.sdk.Context pddContext, OpenSPCoop2Message message, MessageContent messageContent, Busta busta, Map<String, List<String>> trasporto, ErrorHandler errorHandler, boolean preserveRequest) {
        Object o;
        HashMap<String, Object> dynamicMapResponse = new HashMap<String, Object>();
        DynamicUtils.fillDynamicMapEngine(log, dynamicMapResponse, pddContext, null, message, messageContent, busta, trasporto, null, null, errorHandler);
        if (!dynamicMapResponse.isEmpty()) {
            for (String key : dynamicMapResponse.keySet()) {
                o = dynamicMapResponse.get(key);
                if ("errorHandler".equalsIgnoreCase(key) || "response".equalsIgnoreCase(key) || "integration".equalsIgnoreCase(key) || "integrationResponse".equalsIgnoreCase(key)) {
                    dynamicMap.put(key, o);
                    continue;
                }
                String keyResponse = key + "Response";
                dynamicMap.put(keyResponse, o);
                dynamicMap.put(keyResponse.toLowerCase(), o);
                if (!"headerValues".equals(key)) continue;
                dynamicMap.put("headerResponseValues", o);
                dynamicMap.put("headerResponseValues".toLowerCase(), o);
            }
        }
        if (dynamicMapRequest != null && !dynamicMapRequest.isEmpty()) {
            for (String key : dynamicMapRequest.keySet()) {
                if ("errorHandler".equalsIgnoreCase(key) || "request".equalsIgnoreCase(key) && !preserveRequest) continue;
                o = dynamicMapRequest.get(key);
                if (o instanceof PatternExtractor) {
                    PatternExtractor pe = (PatternExtractor)o;
                    pe.refreshContent();
                }
                dynamicMap.put(key, o);
            }
        }
    }

    private static void fillDynamicMapEngine(Logger log, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext, String urlInvocazione, OpenSPCoop2Message message, MessageContent messageContent, Busta busta, Map<String, List<String>> trasporto, Map<String, List<String>> url, Map<String, List<String>> form, ErrorHandler errorHandler) {
        DynamicInfo dInfo = new DynamicInfo();
        dInfo.setBusta(busta);
        dInfo.setPddContext(pddContext);
        if (trasporto != null) {
            dInfo.setHeaders(trasporto);
        }
        if (url != null) {
            dInfo.setParameters(url);
        }
        if (form != null) {
            dInfo.setFormParameters(form);
        }
        if (urlInvocazione != null) {
            dInfo.setUrl(urlInvocazione);
        }
        if (messageContent != null) {
            dInfo.setMessageContent(messageContent);
        }
        if (message != null) {
            dInfo.setMessage(message);
        }
        dInfo.setErrorHandler(errorHandler);
        DynamicUtils.fillDynamicMap(log, dynamicMap, dInfo);
    }

    public static void fillDynamicMap(Logger log, Map<String, Object> dynamicMap, DynamicInfo dynamicInfo) {
        DynamicUtils.fillDynamicMap(log, dynamicMap, dynamicInfo, false);
    }

    public static void fillDynamicMap(Logger log, Map<String, Object> dynamicMap, DynamicInfo dynamicInfo, boolean initFromJmx) {
        PatternExtractor pe;
        OpenSPCoop2MessageFactory messageFactory;
        if (!dynamicMap.containsKey("date")) {
            dynamicMap.put("date", DateManager.getDate());
        }
        RequestInfo requestInfo = null;
        if (dynamicInfo != null && dynamicInfo.getPddContext() != null) {
            Map configProperties;
            Object oSecToken;
            Object oInformazioniAttributiNormalizzati;
            Object oInformazioniTokenNormalizzate;
            InformazioniIntegrazione informazioniIntegrazione;
            Object oInformazioniIntegrazione;
            if (!dynamicMap.containsKey("context")) {
                dynamicMap.put("context", dynamicInfo.getPddContext());
            }
            if (!dynamicMap.containsKey("syncContext") && dynamicInfo.getPddContext().containsKey(CostantiPdD.CONTESTO_RICHIESTA_MESSAGGIO_NOTIFICA)) {
                org.openspcoop2.protocol.sdk.Context transactionSyncContext = (org.openspcoop2.protocol.sdk.Context)dynamicInfo.getPddContext().getObject(CostantiPdD.CONTESTO_RICHIESTA_MESSAGGIO_NOTIFICA);
                dynamicMap.put("syncContext", transactionSyncContext);
            }
            if (!dynamicMap.containsKey("transactionId") && dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE)) {
                String idTransazione = (String)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE);
                dynamicMap.put("transactionId", idTransazione);
            }
            if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.REQUEST_INFO);
            }
            if (!dynamicMap.containsKey("transportContext") && requestInfo != null) {
                if (requestInfo.getProtocolContext() != null) {
                    dynamicMap.put("transportContext", requestInfo.getProtocolContext());
                    dynamicMap.put("transportContext".toLowerCase(), requestInfo.getProtocolContext());
                }
                if (requestInfo.getIdServizio() != null) {
                    AttachmentsReader aReader = new AttachmentsReader(requestInfo.getIdServizio(), requestInfo);
                    dynamicMap.put("attachments", aReader);
                }
            }
            if (!dynamicMap.containsKey("integration") && (oInformazioniIntegrazione = dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.INFORMAZIONI_INTEGRAZIONE)) != null) {
                informazioniIntegrazione = (InformazioniIntegrazione)oInformazioniIntegrazione;
                dynamicMap.put("integration", informazioniIntegrazione);
            }
            if (!dynamicMap.containsKey("integrationResponse") && (oInformazioniIntegrazione = dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.INFORMAZIONI_INTEGRAZIONE_RISPOSTA)) != null) {
                informazioniIntegrazione = (InformazioniIntegrazione)oInformazioniIntegrazione;
                dynamicMap.put("integrationResponse", informazioniIntegrazione);
                dynamicMap.put("integrationResponse".toLowerCase(), informazioniIntegrazione);
            }
            if (!dynamicMap.containsKey("tokenInfo") && (oInformazioniTokenNormalizzate = dynamicInfo.getPddContext().getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE)) != null) {
                InformazioniToken informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
                dynamicMap.put("tokenInfo", informazioniTokenNormalizzate);
                dynamicMap.put("tokenInfo".toLowerCase(), informazioniTokenNormalizzate);
            }
            if (!dynamicMap.containsKey("aa") && (oInformazioniAttributiNormalizzati = dynamicInfo.getPddContext().getObject(Costanti.PDD_CONTEXT_ATTRIBUTI_INFORMAZIONI_NORMALIZZATE)) != null) {
                InformazioniAttributi informazioniAttributiNormalizzati = (InformazioniAttributi)oInformazioniAttributiNormalizzati;
                dynamicMap.put("aa", informazioniAttributiNormalizzati);
            }
            if (!dynamicMap.containsKey("securityToken") && (oSecToken = dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.SECURITY_TOKEN)) != null) {
                SecurityToken securityToken = (SecurityToken)oSecToken;
                dynamicMap.put("securityToken", securityToken);
            }
            if (!dynamicMap.containsKey("config")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_CONFIGURAZIONE)) {
                    configProperties = (HashMap)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_CONFIGURAZIONE);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("config", configProperties);
            }
            if (!dynamicMap.containsKey("clientApplicationConfig")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO)) {
                    configProperties = (Map)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("clientApplicationConfig", configProperties);
                dynamicMap.put("clientApplicationConfig".toLowerCase(), configProperties);
            }
            if (!dynamicMap.containsKey("clientOrganizationConfig")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_FRUITORE)) {
                    configProperties = (Map)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_FRUITORE);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("clientOrganizationConfig", configProperties);
                dynamicMap.put("clientOrganizationConfig".toLowerCase(), configProperties);
            }
            if (!dynamicMap.containsKey("providerOrganizationConfig")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_EROGATORE)) {
                    configProperties = (Map)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_EROGATORE);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("providerOrganizationConfig", configProperties);
                dynamicMap.put("providerOrganizationConfig".toLowerCase(), configProperties);
            }
            if (!dynamicMap.containsKey("tokenClient")) {
                IDServizioApplicativo idApplicativoToken = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN)) {
                    idApplicativoToken = (IDServizioApplicativo)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN);
                }
                if (idApplicativoToken != null) {
                    dynamicMap.put("tokenClient", idApplicativoToken);
                    dynamicMap.put("tokenClient".toLowerCase(), idApplicativoToken);
                }
            }
            if (!dynamicMap.containsKey("tokenClientApplicationConfig")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO_TOKEN)) {
                    configProperties = (Map)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_APPLICATIVO_TOKEN);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("tokenClientApplicationConfig", configProperties);
                dynamicMap.put("tokenClientApplicationConfig".toLowerCase(), configProperties);
            }
            if (!dynamicMap.containsKey("tokenClientOrganizationConfig")) {
                configProperties = null;
                if (dynamicInfo.getPddContext().containsKey(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_PROPRIETARIO_APPLICATIVO_TOKEN)) {
                    configProperties = (Map)dynamicInfo.getPddContext().getObject(org.openspcoop2.core.constants.Costanti.PROPRIETA_SOGGETTO_PROPRIETARIO_APPLICATIVO_TOKEN);
                }
                if (configProperties == null) {
                    configProperties = new HashMap();
                }
                dynamicMap.put("tokenClientOrganizationConfig", configProperties);
                dynamicMap.put("tokenClientOrganizationConfig".toLowerCase(), configProperties);
            }
        }
        if (!dynamicMap.containsKey("busta") && dynamicInfo != null && dynamicInfo.getBusta() != null) {
            dynamicMap.put("busta", dynamicInfo.getBusta());
        }
        if (!dynamicMap.containsKey("property") && dynamicInfo != null && dynamicInfo.getBusta() != null && dynamicInfo.getBusta().sizeProperties() > 0) {
            HashMap<String, String> propertiesBusta = new HashMap<String, String>();
            String[] pNames = dynamicInfo.getBusta().getPropertiesNames();
            if (pNames != null && pNames.length > 0) {
                for (int j = 0; j < pNames.length; ++j) {
                    String pName = pNames[j];
                    String pValue = dynamicInfo.getBusta().getProperty(pName);
                    if (pValue == null) continue;
                    propertiesBusta.put(pName, pValue);
                }
            }
            if (!propertiesBusta.isEmpty()) {
                dynamicMap.put("property", propertiesBusta);
            }
        }
        if (!dynamicMap.containsKey("header")) {
            if (dynamicInfo != null && dynamicInfo.getHeaders() != null && !dynamicInfo.getHeaders().isEmpty()) {
                dynamicMap.put("header", TransportUtils.convertToMapSingleValue(dynamicInfo.getHeaders()));
            } else {
                dynamicMap.put("header", new HashMap());
            }
        }
        if (!dynamicMap.containsKey("headerValues")) {
            if (dynamicInfo != null && dynamicInfo.getHeaders() != null) {
                dynamicMap.put("headerValues", dynamicInfo.getHeaders());
            } else {
                dynamicMap.put("headerValues", new HashMap());
            }
        }
        if (!dynamicMap.containsKey("query")) {
            if (dynamicInfo != null && dynamicInfo.getParameters() != null && !dynamicInfo.getParameters().isEmpty()) {
                dynamicMap.put("query", TransportUtils.convertToMapSingleValue(dynamicInfo.getParameters()));
            } else {
                dynamicMap.put("query", new HashMap());
            }
        }
        if (!dynamicMap.containsKey("queryValues")) {
            if (dynamicInfo != null && dynamicInfo.getParameters() != null) {
                dynamicMap.put("queryValues", dynamicInfo.getParameters());
            } else {
                dynamicMap.put("queryValues", new HashMap());
            }
        }
        if (!dynamicMap.containsKey("form")) {
            if (dynamicInfo != null && dynamicInfo.getFormParameters() != null && !dynamicInfo.getFormParameters().isEmpty()) {
                dynamicMap.put("form", TransportUtils.convertToMapSingleValue(dynamicInfo.getFormParameters()));
            } else {
                dynamicMap.put("form", new HashMap());
            }
        }
        if (!dynamicMap.containsKey("formValues")) {
            if (dynamicInfo != null && dynamicInfo.getFormParameters() != null) {
                dynamicMap.put("formValues", dynamicInfo.getFormParameters());
            } else {
                dynamicMap.put("formValues", new HashMap());
            }
        }
        try {
            SystemPropertiesReader systemPropertiesReader = new SystemPropertiesReader(log, requestInfo, initFromJmx);
            dynamicMap.put("system", systemPropertiesReader);
            dynamicMap.put("system".toLowerCase(), systemPropertiesReader);
        }
        catch (Exception e) {
            log.error("Creazione system properties reader fallita: " + e.getMessage(), (Throwable)e);
        }
        EnvironmentPropertiesReader environmentPropertiesReader = new EnvironmentPropertiesReader(log);
        dynamicMap.put("env", environmentPropertiesReader);
        dynamicMap.put("env".toLowerCase(), environmentPropertiesReader);
        JavaPropertiesReader javaPropertiesReader = new JavaPropertiesReader(log);
        dynamicMap.put("java", javaPropertiesReader);
        dynamicMap.put("java".toLowerCase(), javaPropertiesReader);
        EnvironmentJavaPropertiesReader envJavaPropertiesReader = new EnvironmentJavaPropertiesReader(log);
        dynamicMap.put("envj", envJavaPropertiesReader);
        dynamicMap.put("envj".toLowerCase(), envJavaPropertiesReader);
        if (dynamicInfo != null && dynamicInfo.getUrl() != null) {
            URLRegExpExtractor urle = new URLRegExpExtractor(dynamicInfo.getUrl(), log);
            dynamicMap.put("urlRegExp", urle);
            dynamicMap.put("urlRegExp".toLowerCase(), urle);
        }
        if (dynamicInfo != null && dynamicInfo.getMessageContent() != null && (dynamicInfo.getMessageContent().isXml() || dynamicInfo.getMessageContent().isRestMultipart())) {
            messageFactory = dynamicInfo.getMessage() != null ? dynamicInfo.getMessage().getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            pe = new PatternExtractor(messageFactory, dynamicInfo.getMessageContent(), log);
            dynamicMap.put("xPath", pe);
            dynamicMap.put("xPath".toLowerCase(), pe);
        }
        if (dynamicInfo != null && dynamicInfo.getMessageContent() != null && (dynamicInfo.getMessageContent().isJson() || dynamicInfo.getMessageContent().isRestMultipart())) {
            messageFactory = dynamicInfo.getMessage() != null ? dynamicInfo.getMessage().getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            pe = new PatternExtractor(messageFactory, dynamicInfo.getMessageContent(), log);
            dynamicMap.put("jsonPath", pe);
            dynamicMap.put("jsonPath".toLowerCase(), pe);
        }
        if (dynamicInfo != null && dynamicInfo.getMessage() != null) {
            ContentExtractor content = new ContentExtractor(dynamicInfo.getMessage(), dynamicInfo.getPddContext(), log);
            if (MessageRole.REQUEST.equals((Object)dynamicInfo.getMessage().getMessageRole())) {
                dynamicMap.put("request", content);
            } else {
                dynamicMap.put("response", content);
            }
        }
        if (dynamicInfo != null && dynamicInfo.getErrorHandler() != null) {
            dynamicMap.put("errorHandler", dynamicInfo.getErrorHandler());
            dynamicMap.put("errorHandler".toLowerCase(), dynamicInfo.getErrorHandler());
        }
        if (!dynamicMap.containsKey("dynamicConfig")) {
            dynamicMap.put("dynamicConfig", new DynamicConfig(log, dynamicMap, requestInfo, dynamicInfo != null ? dynamicInfo.getBusta() : null));
        }
    }

    @Deprecated
    public static Map<String, Object> buildDynamicMap(OpenSPCoop2Message msg, org.openspcoop2.protocol.sdk.Context context, Logger log, boolean bufferMessageReadOnly) throws DynamicException {
        return DynamicUtils.buildDynamicMap(msg, context, null, log, bufferMessageReadOnly);
    }

    public static Map<String, Object> buildDynamicMap(OpenSPCoop2Message msg, org.openspcoop2.protocol.sdk.Context context, Busta busta, Logger log, boolean bufferMessageReadOnly) throws DynamicException {
        return DynamicUtils.buildDynamicMapEngine(msg, context, busta, log, bufferMessageReadOnly, null);
    }

    public static Map<String, Object> buildDynamicMapResponse(OpenSPCoop2Message msg, org.openspcoop2.protocol.sdk.Context context, Busta busta, Logger log, boolean bufferMessageReadOnly, Map<String, Object> dynamicMapRequest) throws DynamicException {
        return DynamicUtils.buildDynamicMapEngine(msg, context, busta, log, bufferMessageReadOnly, dynamicMapRequest);
    }

    private static Map<String, Object> buildDynamicMapEngine(OpenSPCoop2Message msg, org.openspcoop2.protocol.sdk.Context context, Busta busta, Logger log, boolean bufferMessageReadOnly, Map<String, Object> dynamicMapRequest) throws DynamicException {
        DynamicInfo dInfo = DynamicUtils.readDynamicInfo(msg, bufferMessageReadOnly, context);
        MessageContent messageContent = dInfo.getMessageContent();
        Map<String, List<String>> parametriTrasporto = dInfo.getHeaders();
        Map<String, List<String>> parametriUrl = dInfo.getParameters();
        Map<String, List<String>> parametriForm = dInfo.getFormParameters();
        String urlInvocazione = dInfo.getUrl();
        HashMap<String, Object> dynamicMap = new HashMap<String, Object>();
        ErrorHandler errorHandler = new ErrorHandler();
        if (dynamicMapRequest != null) {
            DynamicUtils.fillDynamicMapResponse(log, dynamicMap, dynamicMapRequest, context, msg, messageContent, busta, parametriTrasporto, errorHandler);
            return dynamicMap;
        }
        DynamicUtils.fillDynamicMapRequest(log, dynamicMap, context, urlInvocazione, msg, messageContent, busta, parametriTrasporto, parametriUrl, parametriForm, errorHandler);
        return dynamicMap;
    }

    public static DynamicInfo readDynamicInfo(OpenSPCoop2Message message, boolean bufferMessageReadOnly, org.openspcoop2.protocol.sdk.Context context) throws DynamicException {
        MessageContent content = null;
        Map parametriTrasporto = null;
        Map parametriUrl = null;
        Map<String, List<String>> parametriForm = null;
        String urlInvocazione = null;
        try {
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding())) {
                OpenSPCoop2SoapMessage soapMessage = message.castAsSoap();
                content = new MessageContent(soapMessage, bufferMessageReadOnly, context);
            } else if (MessageType.XML.equals((Object)message.getMessageType()) && message.castAsRest().hasContent()) {
                OpenSPCoop2RestXmlMessage xml = message.castAsRestXml();
                content = new MessageContent(xml, bufferMessageReadOnly, context);
            } else if (MessageType.JSON.equals((Object)message.getMessageType()) && message.castAsRest().hasContent()) {
                OpenSPCoop2RestJsonMessage json = message.castAsRestJson();
                content = new MessageContent(json, bufferMessageReadOnly, context);
            }
            if (message.getTransportRequestContext() != null) {
                FormUrlEncodedHttpServletRequest formServlet;
                HttpServletTransportRequestContext httpServletContext;
                HttpServletRequest httpServletRequest;
                if (message.getTransportRequestContext().getHeaders() != null && !message.getTransportRequestContext().getHeaders().isEmpty()) {
                    parametriTrasporto = message.getTransportRequestContext().getHeaders();
                }
                if (message.getTransportRequestContext().getParameters() != null && !message.getTransportRequestContext().getParameters().isEmpty()) {
                    parametriUrl = message.getTransportRequestContext().getParameters();
                }
                if (message.getTransportRequestContext() instanceof HttpServletTransportRequestContext && (httpServletRequest = (httpServletContext = (HttpServletTransportRequestContext)message.getTransportRequestContext()).getHttpServletRequest()) instanceof FormUrlEncodedHttpServletRequest && (formServlet = (FormUrlEncodedHttpServletRequest)httpServletRequest).getFormUrlEncodedParametersValues() != null && !formServlet.getFormUrlEncodedParametersValues().isEmpty()) {
                    parametriForm = formServlet.getFormUrlEncodedParametersValues();
                }
                urlInvocazione = message.getTransportRequestContext().getUrlInvocazione_formBased();
            }
            if (message.getTransportResponseContext() != null && message.getTransportResponseContext().getHeaders() != null && !message.getTransportResponseContext().getHeaders().isEmpty()) {
                parametriTrasporto = message.getTransportResponseContext().getHeaders();
            }
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
        DynamicInfo dInfo = new DynamicInfo();
        dInfo.setMessage(message);
        dInfo.setMessageContent(content);
        dInfo.setHeaders(parametriTrasporto);
        dInfo.setParameters(parametriUrl);
        dInfo.setFormParameters(parametriForm);
        dInfo.setUrl(urlInvocazione);
        return dInfo;
    }

    private static String initTemplateValue(String tmpParam, boolean forceStartWithDollaro, org.openspcoop2.protocol.sdk.Context pddContext) {
        String idTransazione;
        String tmp = tmpParam;
        if (!forceStartWithDollaro) {
            while (tmp.contains("${")) {
                tmp = tmp.replace("${", "{");
            }
        }
        Object transactionIdConstant = "{transaction:id}";
        if (forceStartWithDollaro) {
            transactionIdConstant = "$" + (String)transactionIdConstant;
        }
        if (tmp.contains((CharSequence)transactionIdConstant)) {
            idTransazione = (String)pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE);
            while (tmp.contains((CharSequence)transactionIdConstant)) {
                tmp = tmp.replace((CharSequence)transactionIdConstant, idTransazione);
            }
        }
        if (forceStartWithDollaro) {
            transactionIdConstant = "{transaction:id}";
            if (tmp.contains((CharSequence)(transactionIdConstant = "?" + (String)transactionIdConstant))) {
                idTransazione = (String)pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE);
                while (tmp.contains((CharSequence)transactionIdConstant)) {
                    tmp = tmp.replace((CharSequence)transactionIdConstant, idTransazione);
                }
            }
        }
        return tmp;
    }

    public static void validate(String name, String tmpParam, boolean addPrefixError) throws DynamicException {
        DynamicUtils.validate(name, tmpParam, true, addPrefixError);
    }

    public static void validate(String name, String tmpParam, boolean forceStartWithDollaro, boolean addPrefixError) throws DynamicException {
        org.openspcoop2.protocol.sdk.Context pddContext = new org.openspcoop2.protocol.sdk.Context();
        pddContext.addObject(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, (Object)"fakeId");
        String tmp = DynamicUtils.initTemplateValue(tmpParam, forceStartWithDollaro, pddContext);
        boolean onlyValidate = true;
        tmp = DynamicUtils.processTemplateValueUrlXpathJsonpath(tmp, onlyValidate, null, forceStartWithDollaro);
        try {
            DynamicStringReplace.validate((String)tmp, (boolean)forceStartWithDollaro);
        }
        catch (Exception e) {
            Object prefix = addPrefixError ? "Proprieta' '" + name + "' contiene un valore non corretto: " : "";
            throw new DynamicException((String)prefix + e.getMessage(), e);
        }
    }

    public static String convertDynamicPropertyValue(String name, String tmpParam, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext) throws DynamicException {
        return DynamicUtils.convertDynamicPropertyValue(name, tmpParam, dynamicMap, pddContext, true);
    }

    public static String convertDynamicPropertyValue(String name, String tmpParam, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext, boolean forceStartWithDollaro) throws DynamicException {
        String tmp = DynamicUtils.initTemplateValue(tmpParam, forceStartWithDollaro, pddContext);
        boolean onlyValidate = false;
        tmp = DynamicUtils.processTemplateValueUrlXpathJsonpath(tmp, onlyValidate, dynamicMap, forceStartWithDollaro);
        try {
            tmp = DynamicStringReplace.replace((String)tmp, dynamicMap, (boolean)forceStartWithDollaro);
        }
        catch (Exception e) {
            throw new DynamicException("Proprieta' '" + name + "' contiene un valore non corretto: " + e.getMessage(), e);
        }
        return tmp;
    }

    private static String processTemplateValueUrlXpathJsonpath(String tmpParam, boolean onlyValidate, Map<String, Object> dynamicMap, boolean forceStartWithDollaro) throws DynamicException {
        String tmp = tmpParam;
        boolean request = false;
        boolean response = true;
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.URL, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.URL, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.XML, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.XML, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.JSON, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.JSON, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.SYSTEM, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.SYSTEM, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.ENV, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.ENV, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.JAVA, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.JAVA, forceStartWithDollaro, response, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.ENV_JAVA, forceStartWithDollaro, request, onlyValidate);
        tmp = DynamicUtils.convertDynamicPropertyContent(tmp, dynamicMap, TemplateType.ENV_JAVA, forceStartWithDollaro, response, onlyValidate);
        return tmp;
    }

    private static String convertDynamicPropertyContent(String tmpOriginal, Map<String, Object> dynamicMap, TemplateType templateType, boolean forceStartWithDollaro, boolean response, boolean onlyValidate) throws DynamicException {
        if (tmpOriginal == null) {
            return null;
        }
        String istruzione = null;
        String prefix = null;
        switch (templateType) {
            case XML: {
                istruzione = "xPath";
                prefix = "{xPath:";
                break;
            }
            case JSON: {
                istruzione = "jsonPath";
                prefix = "{jsonPath:";
                break;
            }
            case URL: {
                istruzione = "urlRegExp";
                prefix = "{urlRegExp:";
                break;
            }
            case SYSTEM: {
                istruzione = "system";
                prefix = "{system:";
                break;
            }
            case ENV: {
                istruzione = "env";
                prefix = "{env:";
                break;
            }
            case JAVA: {
                istruzione = "java";
                prefix = "{java:";
                break;
            }
            case ENV_JAVA: {
                istruzione = "envj";
                prefix = "{envj:";
            }
        }
        String tmp = tmpOriginal;
        if (forceStartWithDollaro) {
            String prefixDollaro = "$" + prefix;
            tmp = DynamicUtils.convertDynamicPropertyContentEngine(tmp, dynamicMap, templateType, response, onlyValidate, istruzione, prefixDollaro);
            String prefixOptional = "?" + prefix;
            tmp = DynamicUtils.convertDynamicPropertyContentEngine(tmp, dynamicMap, templateType, response, onlyValidate, istruzione, prefixOptional);
        } else {
            tmp = DynamicUtils.convertDynamicPropertyContentEngine(tmp, dynamicMap, templateType, response, onlyValidate, istruzione, prefix);
        }
        if (tmpOriginal.trim().startsWith("?{") && tmp != null && StringUtils.isEmpty((CharSequence)tmp)) {
            return null;
        }
        return tmp;
    }

    private static String convertDynamicPropertyContentEngine(String tmp, Map<String, Object> dynamicMap, TemplateType templateType, boolean response, boolean onlyValidate, String istruzione, String prefix) throws DynamicException {
        String prefixLowerCase;
        String tmpLowerCase;
        if (response) {
            istruzione = (String)istruzione + "Response";
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
            prefix = (String)prefix + "Response:";
        }
        if ((tmpLowerCase = tmp.toLowerCase()).contains(prefixLowerCase = ((String)prefix).toLowerCase())) {
            for (int maxIteration = 100; maxIteration > 0 && tmpLowerCase.contains(prefixLowerCase); --maxIteration) {
                int indexOfStart = tmpLowerCase.indexOf(prefixLowerCase);
                String pattern = tmp.substring(indexOfStart + ((String)prefix).length(), tmp.length());
                if (!pattern.contains("}")) {
                    throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError((String)istruzione) + "non correttamente formata (chiusura '}' non trovata)");
                }
                char[] patternChars = pattern.toCharArray();
                int numAperture = 0;
                int positionChiusura = -1;
                for (int i = 0; i < patternChars.length; ++i) {
                    if (patternChars[i] == '{') {
                        ++numAperture;
                    }
                    if (patternChars[i] != '}') continue;
                    if (numAperture == 0) {
                        positionChiusura = i;
                        break;
                    }
                    --numAperture;
                }
                if (positionChiusura <= 0) {
                    throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError((String)istruzione) + "non correttamente formata (chiusura '}' non trovata)");
                }
                pattern = pattern.substring(0, positionChiusura);
                String complete = tmp.substring(indexOfStart, positionChiusura + indexOfStart + ((String)prefix).length() + 1);
                String value = DynamicUtils.getValue(dynamicMap, templateType, onlyValidate, (String)istruzione, pattern);
                tmp = tmp.replace(complete, value);
                tmpLowerCase = tmp.toLowerCase();
            }
        }
        return tmp;
    }

    private static String getValue(Map<String, Object> dynamicMap, TemplateType templateType, boolean onlyValidate, String istruzione, String pattern) throws DynamicException {
        String value = null;
        if (!onlyValidate) {
            Object o = dynamicMap.get(istruzione);
            if (o == null) {
                throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + "non utilizzabile in questo contesto");
            }
            switch (templateType) {
                case XML: 
                case JSON: {
                    if (!(o instanceof PatternExtractor)) {
                        throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildExtractorWrongClassMsg(o));
                    }
                    PatternExtractor patternExtractor = (PatternExtractor)o;
                    value = patternExtractor.read(pattern);
                    break;
                }
                case URL: {
                    if (!(o instanceof URLRegExpExtractor)) {
                        throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildExtractorWrongClassMsg(o));
                    }
                    URLRegExpExtractor urlExtractor = (URLRegExpExtractor)o;
                    value = urlExtractor.read(pattern);
                    break;
                }
                case SYSTEM: {
                    value = DynamicUtils.getSystemProperty(o, istruzione, pattern);
                    break;
                }
                case ENV: {
                    value = DynamicUtils.getEnvProperty(o, istruzione, pattern);
                    break;
                }
                case JAVA: {
                    value = DynamicUtils.getJavaProperty(o, istruzione, pattern);
                    break;
                }
                case ENV_JAVA: {
                    value = DynamicUtils.getEnvJavaProperty(o, istruzione, pattern);
                }
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static String getSystemProperty(Object o, String istruzione, String pattern) throws DynamicException {
        if (!(o instanceof SystemPropertiesReader)) {
            throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildReaderWrongClassMsg(o));
        }
        SystemPropertiesReader systemPropertiesReader = (SystemPropertiesReader)o;
        return systemPropertiesReader.read(pattern);
    }

    private static String getEnvProperty(Object o, String istruzione, String pattern) throws DynamicException {
        if (!(o instanceof EnvironmentPropertiesReader)) {
            throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildReaderWrongClassMsg(o));
        }
        EnvironmentPropertiesReader environmentPropertiesReader = (EnvironmentPropertiesReader)o;
        return environmentPropertiesReader.read(pattern);
    }

    private static String getJavaProperty(Object o, String istruzione, String pattern) throws DynamicException {
        if (!(o instanceof JavaPropertiesReader)) {
            throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildReaderWrongClassMsg(o));
        }
        JavaPropertiesReader javaPropertiesReader = (JavaPropertiesReader)o;
        return javaPropertiesReader.read(pattern);
    }

    private static String getEnvJavaProperty(Object o, String istruzione, String pattern) throws DynamicException {
        if (!(o instanceof EnvironmentJavaPropertiesReader)) {
            throw new DynamicException(DynamicUtils.buildPrefixIstruzioneMsgError(istruzione) + NON_UTILIZZABILE_IN_QUESTO_CONTESTO + DynamicUtils.buildReaderWrongClassMsg(o));
        }
        EnvironmentJavaPropertiesReader envJavaPropertiesReader = (EnvironmentJavaPropertiesReader)o;
        return envJavaPropertiesReader.read(pattern);
    }

    private static String buildPrefixIstruzioneMsgError(String istruzione) {
        return "Trovata istruzione '" + istruzione + "' ";
    }

    private static String buildReaderWrongClassMsg(Object o) {
        return "(reader wrong class: " + o.getClass().getName() + ")";
    }

    private static String buildExtractorWrongClassMsg(Object o) {
        return "(extractor wrong class: " + o.getClass().getName() + ")";
    }

    public static void convertFreeMarkerTemplate(Template template, Map<String, Object> dynamicMap, OutputStream out) throws DynamicException {
        DynamicUtils.convertFreeMarkerTemplate(template, dynamicMap, out, null);
    }

    public static void convertFreeMarkerTemplate(Template template, Map<String, Object> dynamicMap, OutputStream out, String charset) throws DynamicException {
        try {
            OutputStreamWriter oow = null;
            oow = charset != null ? new OutputStreamWriter(out, charset) : new OutputStreamWriter(out);
            DynamicUtils.convertFreeMarkerTemplateEngine(template, dynamicMap, oow);
            oow.flush();
            oow.close();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static void convertFreeMarkerTemplate(Template template, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        DynamicUtils.convertFreeMarkerTemplateEngine(template, dynamicMap, writer);
    }

    public static void convertZipFreeMarkerTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, OutputStream out) throws DynamicException {
        DynamicUtils.convertZipFreeMarkerTemplate(zipTemplate, dynamicMap, out, null);
    }

    public static void convertZipFreeMarkerTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, OutputStream out, String charset) throws DynamicException {
        try {
            OutputStreamWriter oow = null;
            oow = charset != null ? new OutputStreamWriter(out, charset) : new OutputStreamWriter(out);
            DynamicUtils.convertZipFreeMarkerTemplate(zipTemplate, dynamicMap, oow);
            oow.flush();
            oow.close();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static void convertZipFreeMarkerTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        Template template = zipTemplate.getTemplateFreeMarker();
        DynamicUtils.convertFreeMarkerTemplateEngine(template, dynamicMap, writer);
    }

    private static void convertFreeMarkerTemplateEngine(Template template, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        try {
            BeansWrapper wrapper = new BeansWrapper(Configuration.VERSION_2_3_23);
            TemplateHashModel classModel = wrapper.getStaticModels();
            dynamicMap.put("class", classModel);
            dynamicMap.put("new", new freemarker.template.utility.ObjectConstructor());
            freemarker.template.Template templateFTL = template.getTemplateFreeMarker();
            templateFTL.process(dynamicMap, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static freemarker.template.Template buildFreeMarkerTemplate(Template template) throws DynamicException {
        try {
            String name = template.getName();
            byte[] templateBin = template.getTemplate();
            Map<String, byte[]> templateIncludes = template.getTemplateIncludes();
            Configuration config = TemplateUtils.newTemplateEngine();
            config.setAPIBuiltinEnabled(true);
            if (templateIncludes != null && !templateIncludes.isEmpty()) {
                config.setTemplateLoader((TemplateLoader)new FreemarkerTemplateLoader(templateIncludes));
            }
            return TemplateUtils.buildTemplate((Configuration)config, (String)name, (byte[])templateBin);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static void convertVelocityTemplate(Template template, Map<String, Object> dynamicMap, OutputStream out) throws DynamicException {
        DynamicUtils.convertVelocityTemplate(template, dynamicMap, out, null);
    }

    public static void convertVelocityTemplate(Template template, Map<String, Object> dynamicMap, OutputStream out, String charset) throws DynamicException {
        try {
            OutputStreamWriter oow = null;
            oow = charset != null ? new OutputStreamWriter(out, charset) : new OutputStreamWriter(out);
            DynamicUtils.convertVelocityTemplateEngine(template, dynamicMap, oow);
            oow.flush();
            oow.close();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static void convertVelocityTemplate(Template template, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        DynamicUtils.convertVelocityTemplateEngine(template, dynamicMap, writer);
    }

    public static void convertZipVelocityTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, OutputStream out) throws DynamicException {
        DynamicUtils.convertZipVelocityTemplate(zipTemplate, dynamicMap, out, null);
    }

    public static void convertZipVelocityTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, OutputStream out, String charset) throws DynamicException {
        try {
            OutputStreamWriter oow = null;
            oow = charset != null ? new OutputStreamWriter(out, charset) : new OutputStreamWriter(out);
            DynamicUtils.convertZipVelocityTemplate(zipTemplate, dynamicMap, oow);
            oow.flush();
            oow.close();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static void convertZipVelocityTemplate(ZipTemplate zipTemplate, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        Template template = zipTemplate.getTemplateFreeMarker();
        DynamicUtils.convertVelocityTemplateEngine(template, dynamicMap, writer);
    }

    private static void convertVelocityTemplateEngine(Template template, Map<String, Object> dynamicMap, Writer writer) throws DynamicException {
        try {
            dynamicMap.put("class", "".getClass());
            dynamicMap.put("new", new ObjectConstructor());
            org.apache.velocity.Template templateVelocity = template.getTemplateVelocity();
            templateVelocity.merge((Context)VelocityTemplateUtils.toVelocityContext(dynamicMap), writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static org.apache.velocity.Template buildVelocityTemplate(Template template) throws DynamicException {
        try {
            String name = template.getName();
            byte[] templateBin = template.getTemplate();
            Map<String, byte[]> templateIncludes = template.getTemplateIncludes();
            return VelocityTemplateUtils.buildTemplate((String)name, (byte[])templateBin, templateIncludes);
        }
        catch (Exception e) {
            throw new DynamicException(e.getMessage(), e);
        }
    }

    public static boolean isXsltProcessAsDomSource() {
        return xsltProcessAsDomSource;
    }

    public static void setXsltProcessAsDomSource(boolean xsltProcessAsDomSource) {
        DynamicUtils.xsltProcessAsDomSource = xsltProcessAsDomSource;
    }

    public static void convertXSLTTemplate(String name, byte[] template, Element element, OutputStream out) throws DynamicException {
        try {
            Source xsltSource = null;
            xsltSource = xsltProcessAsDomSource ? new DOMSource(XMLUtils.getInstance().newElement(template)) : new StreamSource(new ByteArrayInputStream(template));
            DOMSource xmlSource = new DOMSource(element);
            Transformer trans = MessageXMLUtils.DEFAULT.getTransformerFactory().newTransformer(xsltSource);
            trans.transform(xmlSource, new StreamResult(out));
            out.flush();
        }
        catch (Exception e) {
            throw new DynamicException("[" + name + "] " + e.getMessage(), e);
        }
    }

    public static void convertCompressorTemplate(String name, byte[] template, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext, ArchiveType archiveType, OutputStream out) throws DynamicException {
        try (ByteArrayInputStream bin = new ByteArrayInputStream(template);){
            Properties p = new Properties();
            p.load(bin);
            ContentExtractor contentExtractor = null;
            String ruolo = null;
            if (dynamicMap.containsKey("request")) {
                contentExtractor = (ContentExtractor)dynamicMap.get("request");
                ruolo = "messaggio di richiesta";
            } else if (dynamicMap.containsKey("response")) {
                contentExtractor = (ContentExtractor)dynamicMap.get("response");
                ruolo = "messaggio di risposta";
            }
            ArrayList<Entry> listEntries = new ArrayList<Entry>();
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String keyP = (String)keys.nextElement();
                keyP = keyP.trim();
                String oggetto = "property-" + keyP;
                String entryName = DynamicUtils.convertCompressorTemplateReadDynamicValueEntryName(oggetto, keyP, dynamicMap, pddContext);
                String prefixError = "[" + keyP + "] ";
                String valoreP = p.getProperty(keyP);
                if (valoreP == null) {
                    throw new DynamicException(prefixError + "Nessun valore fornito per la propriet\u00e0");
                }
                valoreP = valoreP.trim();
                byte[] content = DynamicUtils.converCompressTemplateReadContent(prefixError, keyP, valoreP, contentExtractor, ruolo, dynamicMap, pddContext);
                listEntries.add(new Entry(entryName, content));
            }
            out.write(CompressorUtilities.archive(listEntries, (ArchiveType)archiveType));
        }
        catch (Exception e) {
            throw new DynamicException("[" + name + "] " + e.getMessage(), e);
        }
    }

    private static byte[] converCompressTemplateReadContent(String prefixError, String keyP, String valoreP, ContentExtractor contentExtractor, String ruolo, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext) throws DynamicException {
        byte[] content = null;
        if ("content".equals(valoreP)) {
            if (contentExtractor == null || !contentExtractor.hasContent()) {
                throw new DynamicException(prefixError + "Il " + ruolo + " non possiede un payload");
            }
            content = contentExtractor.getContent();
        } else if ("soapEnvelope".equals(valoreP) || "soapBody".equals(valoreP) || "soapEnvelope".equalsIgnoreCase(valoreP) || "soapBody".equalsIgnoreCase(valoreP)) {
            content = DynamicUtils.convertCompressorTemplateReadEnvelope(prefixError, valoreP, contentExtractor, ruolo);
        } else if (valoreP.startsWith("attachment[") || valoreP.startsWith("attachmentId[") && valoreP.endsWith("]")) {
            content = DynamicUtils.convertCompressorTemplateReadAttachContent(prefixError, valoreP, contentExtractor, ruolo);
        } else {
            String oggettoV = "valore-" + keyP;
            content = DynamicUtils.convertCompressorTemplateReadDynamicContent(prefixError, oggettoV, valoreP, dynamicMap, pddContext);
        }
        if (content == null || content.length == 0) {
            throw new DynamicException(prefixError + "Nessun contenuto da associare alla entry trovato");
        }
        return content;
    }

    private static int converCompressTemplateReadAttachmentIndex(String prefixError, String valoreInterno) throws DynamicException {
        int index = -1;
        try {
            index = Integer.valueOf(valoreInterno);
        }
        catch (Exception e) {
            throw new DynamicException(prefixError + "L'indice definito per l'attachment non \u00e8 un numero intero: " + e.getMessage(), e);
        }
        return index;
    }

    private static String convertCompressorTemplateReadDynamicValueEntryName(String oggetto, String key, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext) throws DynamicException {
        try {
            return DynamicUtils.convertDynamicPropertyValue(oggetto, key, dynamicMap, pddContext);
        }
        catch (Exception e) {
            throw new DynamicException("[" + oggetto + "] Conversione valore per entry name '" + key + "' non riuscita: " + e.getMessage(), e);
        }
    }

    private static byte[] convertCompressorTemplateReadEnvelope(String prefixError, String valoreP, ContentExtractor contentExtractor, String ruolo) throws DynamicException {
        byte[] content = null;
        if (contentExtractor == null || !contentExtractor.hasContent()) {
            throw new DynamicException(prefixError + "Il " + ruolo + " non possiede un payload");
        }
        if (!contentExtractor.isSoap()) {
            throw new DynamicException(prefixError + "Il " + ruolo + " non \u00e8 un messaggio soap");
        }
        if ("soapEnvelope".equals(valoreP) || "soapEnvelope".equalsIgnoreCase(valoreP)) {
            DumpMessaggio dump = contentExtractor.dumpMessage();
            if (dump == null) {
                throw new DynamicException(prefixError + "Dump del " + ruolo + " non disponibile");
            }
            content = dump.getBody();
        } else {
            content = contentExtractor.getContentSoapBody();
        }
        return content;
    }

    private static byte[] convertCompressorTemplateReadDynamicContent(String prefixError, String oggettoV, String valoreP, Map<String, Object> dynamicMap, org.openspcoop2.protocol.sdk.Context pddContext) throws DynamicException {
        try {
            String v = DynamicUtils.convertDynamicPropertyValue(oggettoV, valoreP, dynamicMap, pddContext);
            if (v != null) {
                return v.getBytes();
            }
        }
        catch (Exception e) {
            throw new DynamicException(prefixError + "[" + oggettoV + "] Conversione valore non riuscita: " + e.getMessage(), e);
        }
        return new byte[0];
    }

    private static byte[] convertCompressorTemplateReadAttachContent(String prefixError, String valoreP, ContentExtractor contentExtractor, String ruolo) throws DynamicException {
        String valoreInterno = valoreP.substring("attachment[".length(), valoreP.length() - 1);
        if (valoreInterno == null || "".equals(valoreInterno)) {
            throw new DynamicException(prefixError + "Non \u00e8 stato definito un indice per l'attachment");
        }
        DumpMessaggio dump = contentExtractor.dumpMessage();
        if (dump == null) {
            throw new DynamicException(prefixError + "Dump del " + ruolo + " non disponibile");
        }
        DumpAttachment attach = null;
        boolean attachAtteso = true;
        byte[] content = null;
        if (valoreP.startsWith("attachment[")) {
            int index = DynamicUtils.converCompressTemplateReadAttachmentIndex(prefixError, valoreInterno);
            if (contentExtractor.isRest() && index == 0) {
                content = dump.getBody();
                attachAtteso = false;
            } else {
                attach = DynamicUtils.convertCompressorTemplateReadDumpAttachment(dump, contentExtractor, index);
            }
        } else if (contentExtractor.isRest() && dump.getMultipartInfoBody() != null && valoreInterno.equals(dump.getMultipartInfoBody().getContentId())) {
            content = dump.getBody();
            attachAtteso = false;
        } else {
            attach = dump.getAttachment(valoreInterno);
        }
        if (attachAtteso) {
            content = DynamicUtils.convertCompressorTemplateReadAttachContent(prefixError, attach);
        }
        return content;
    }

    private static DumpAttachment convertCompressorTemplateReadDumpAttachment(DumpMessaggio dump, ContentExtractor contentExtractor, int index) {
        DumpAttachment attach = null;
        attach = contentExtractor.isRest() ? dump.getAttachment(index - 1) : dump.getAttachment(index);
        return attach;
    }

    private static byte[] convertCompressorTemplateReadAttachContent(String prefixError, DumpAttachment attach) throws DynamicException {
        byte[] content = null;
        if (attach == null) {
            throw new DynamicException(prefixError + "L'indice definito per l'attachment non ha identificato alcun attachment");
        }
        content = attach.getContent();
        return content;
    }
}

