/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.dynamic;

import java.io.Serializable;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class AttachmentsReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IDServizio idServizio;
    private IDAccordo idAccordo;
    private transient RegistroServiziManager registroServiziManagerField;
    private RequestInfo requestInfo;

    public AttachmentsReader(IDServizio idServizio, RequestInfo requestInfo) {
        this.idServizio = idServizio;
        this.registroServiziManagerField = RegistroServiziManager.getInstance();
        this.requestInfo = requestInfo;
    }

    private RegistroServiziManager getRegistroServiziManager() {
        if (this.registroServiziManagerField == null) {
            this.registroServiziManagerField = RegistroServiziManager.getInstance();
        }
        return this.registroServiziManagerField;
    }

    private IDAccordo getIDAccordo() throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (this.idAccordo == null) {
            AccordoServizioParteSpecifica asps = this.getRegistroServiziManager().getAccordoServizioParteSpecifica(this.idServizio, null, Boolean.valueOf(false), this.requestInfo);
            this.idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
        }
        return this.idAccordo;
    }

    public byte[] read(String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.read(nome, false);
    }

    public byte[] read(String nome, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getAllegato(this.idServizio, nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }

    public byte[] readSemiformalDocumentation(String nome, String tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentation(nome, TipiDocumentoSemiformale.toEnumConstant((String)tipo), false);
    }

    public byte[] readSemiformalDocumentation(String nome, String tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentation(nome, TipiDocumentoSemiformale.toEnumConstant((String)tipo), throwNotFoundException);
    }

    public byte[] readSemiformalDocumentation(String nome, TipiDocumentoSemiformale tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentation(nome, tipo, false);
    }

    public byte[] readSemiformalDocumentation(String nome, TipiDocumentoSemiformale tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getSpecificaSemiformale(this.idServizio, tipo, nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }

    public byte[] readSecurityDocumentation(String nome, String tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSecurityDocumentation(nome, TipiDocumentoSicurezza.toEnumConstant((String)tipo), false);
    }

    public byte[] readSecurityDocumentation(String nome, String tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSecurityDocumentation(nome, TipiDocumentoSicurezza.toEnumConstant((String)tipo), throwNotFoundException);
    }

    public byte[] readSecurityDocumentation(String nome, TipiDocumentoSicurezza tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSecurityDocumentation(nome, tipo, false);
    }

    public byte[] readSecurityDocumentation(String nome, TipiDocumentoSicurezza tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getSpecificaSicurezza(this.idServizio, tipo, nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }

    public byte[] readServiceLevelDocumentation(String nome, String tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readServiceLevelDocumentation(nome, TipiDocumentoLivelloServizio.toEnumConstant((String)tipo), false);
    }

    public byte[] readServiceLevelDocumentation(String nome, String tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readServiceLevelDocumentation(nome, TipiDocumentoLivelloServizio.toEnumConstant((String)tipo), throwNotFoundException);
    }

    public byte[] readServiceLevelDocumentation(String nome, TipiDocumentoLivelloServizio tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readServiceLevelDocumentation(nome, tipo, false);
    }

    public byte[] readServiceLevelDocumentation(String nome, TipiDocumentoLivelloServizio tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getSpecificaLivelloServizio(this.idServizio, tipo, nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }

    public byte[] readFromApi(String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readFromApi(nome, false);
    }

    public byte[] readFromApi(String nome, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getAllegato(this.getIDAccordo(), nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }

    public byte[] readSemiformalDocumentationFromApi(String nome, String tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentationFromApi(nome, TipiDocumentoSemiformale.toEnumConstant((String)tipo), false);
    }

    public byte[] readSemiformalDocumentationFromApi(String nome, String tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentationFromApi(nome, TipiDocumentoSemiformale.toEnumConstant((String)tipo), throwNotFoundException);
    }

    public byte[] readSemiformalDocumentationFromApi(String nome, TipiDocumentoSemiformale tipo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.readSemiformalDocumentationFromApi(nome, tipo, false);
    }

    public byte[] readSemiformalDocumentationFromApi(String nome, TipiDocumentoSemiformale tipo, boolean throwNotFoundException) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getRegistroServiziManager().getSpecificaSemiformale(this.getIDAccordo(), tipo, nome, this.requestInfo).getByteContenuto();
        }
        catch (DriverRegistroServiziNotFound notFound) {
            byte[] bNull = null;
            if (throwNotFoundException) {
                throw notFound;
            }
            return bNull;
        }
    }
}

