/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.credenziali;

import java.util.List;
import java.util.Map;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.credenziali.GestoreCredenzialiException;
import org.openspcoop2.pdd.core.credenziali.IGestoreCredenziali;
import org.openspcoop2.pdd.core.credenziali.engine.GestoreCredenzialiEngine;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.utils.transport.TransportUtils;

public class GestoreCredenzialiTest
extends AbstractCore
implements IGestoreCredenziali {
    public static final String TEST_CREDENZIALI_BASIC_USERNAME = "GovWay-TestCredenziali-BasicUsername";
    public static final String TEST_CREDENZIALI_BASIC_PASSWORD = "GovWay-TestCredenziali-BasicPassword";
    public static final String TEST_CREDENZIALI_SSL_SUBJECT = "GovWay-TestCredenziali-SSLSubject";
    public static final String TEST_CREDENZIALI_SIMULAZIONE_ERRORE = "GovWay-TestCredenziali-SimulazioneErrore";
    public static final String TEST_CREDENZIALI_SIMULAZIONE_ERRORE_CONFIGURAZIONE = "GovWay-TestCredenziali-SimulazioneErroreConfigurazione";
    public static final String TEST_CREDENZIALI_SIMULAZIONE_ERRORE_FORWARD = "GovWay-TestCredenziali-SimulazioneErroreForward";
    private String identita = null;

    @Override
    public Credenziali elaborazioneCredenziali(IDSoggetto idSoggetto, InfoConnettoreIngresso infoConnettoreIngresso, OpenSPCoop2Message messaggio) throws GestoreCredenzialiException, GestoreCredenzialiConfigurationException {
        Credenziali c = new Credenziali();
        String realm = "GovWay";
        String authType = "ProxyAuth";
        if (this.existsHeader(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_BASIC_USERNAME)) {
            String username = this.getProperty(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_BASIC_USERNAME);
            String password = this.getProperty(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_BASIC_PASSWORD);
            if (username == null || "".equals(username)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthBasic(authType, realm, true), "Username value non fornito");
            }
            if (password == null || "".equals(password)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthBasic(authType, realm, true), "Password value non fornito");
            }
            c.setUsername(username);
            c.setPassword(password);
        } else if (this.existsHeader(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_SSL_SUBJECT)) {
            String subject = this.getProperty(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_SSL_SUBJECT);
            if (subject == null || "".equals(subject)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWProxyAuthSSL(authType, realm, true), "Subject value non fornito");
            }
            c.setSubject(subject);
        } else {
            if (this.existsHeader(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_SIMULAZIONE_ERRORE)) {
                throw new GestoreCredenzialiException("Eccezione generale richiesta dalla testsuite");
            }
            if (this.existsHeader(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_SIMULAZIONE_ERRORE_CONFIGURAZIONE)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_INVALID_CREDENTIALS, GestoreCredenzialiEngine.buildWWWProxyAuthSSL(authType, realm, false), "Eccezione, di configurazione, richiesta dalla testsuite");
            }
            if (this.existsHeader(infoConnettoreIngresso.getUrlProtocolContext().getHeaders(), TEST_CREDENZIALI_SIMULAZIONE_ERRORE_FORWARD)) {
                throw new GestoreCredenzialiConfigurationException(IntegrationFunctionError.PROXY_AUTHENTICATION_FORWARDED_CREDENTIALS_NOT_FOUND, GestoreCredenzialiEngine.buildWWWAuthSSL(), "Eccezione, di configurazione, richiesta dalla testsuite");
            }
            return infoConnettoreIngresso.getCredenziali();
        }
        this.identita = infoConnettoreIngresso.getCredenziali().getSubject() != null || infoConnettoreIngresso.getCredenziali().getUsername() != null ? "GestoreCredenziali di test " + infoConnettoreIngresso.getCredenziali().toString() : "GestoreCredenziali di test anonimo";
        return c;
    }

    @Override
    public String getIdentitaGestoreCredenziali() {
        return this.identita;
    }

    private boolean existsHeader(Map<String, List<String>> properties, String name) {
        if (properties != null) {
            return TransportUtils.containsKey(properties, (String)name);
        }
        return false;
    }

    private String getProperty(Map<String, List<String>> properties, String name) {
        if (properties != null) {
            return TransportUtils.getFirstValue(properties, (String)name);
        }
        return null;
    }
}

