/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters;

import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.RLongAdderOperation;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.RLongAdderResponse;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.redisson.api.RLongAdder;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class DatoRLongAdder {
    private RedissonClient redisson;
    private String name;
    private RLongAdder counter;
    private int failover = -1;
    private int failoverCheckEveryMs = -1;
    private Logger logControlloTraffico;

    public void setFailover(int failover) {
        this.failover = failover;
    }

    public DatoRLongAdder(RedissonClient redisson, String name) {
        this.redisson = redisson;
        this.name = name;
        this.initCounter();
        OpenSPCoop2Properties op2Props = OpenSPCoop2Properties.getInstance();
        this.failover = -1;
        this.failoverCheckEveryMs = -1;
        this.logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Props.isControlloTrafficoDebug());
    }

    private void initCounter() {
        this.counter = this.redisson.getLongAdder(this.name);
    }

    public long sum() {
        RLongAdderResponse r = this.process(RLongAdderOperation.SUM, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public void add(long value) {
        this.process(RLongAdderOperation.ADD, value, -1L);
    }

    public void increment() {
        this.process(RLongAdderOperation.INCREMENT, -1L, -1L);
    }

    public void decrement() {
        this.process(RLongAdderOperation.DECREMENT, -1L, -1L);
    }

    public void reset() {
        this.process(RLongAdderOperation.RESET, -1L, -1L);
    }

    public void destroy() {
        this.process(RLongAdderOperation.DESTROY, -1L, -1L);
    }

    private RLongAdderResponse process(RLongAdderOperation op, long arg1, long arg2) {
        String prefix = "[Redis-RAtomicLong-" + this.name + " operation:" + String.valueOf((Object)op) + "] ";
        if (this.failover > 0) {
            return this.processFailOver(prefix, op, arg1, arg2);
        }
        return this.operation(prefix, op, arg1, arg2);
    }

    private RLongAdderResponse processFailOver(String prefix, RLongAdderOperation op, long arg1, long arg2) {
        boolean success = false;
        Exception eFinal = null;
        RLongAdderResponse v = null;
        for (int i = 0; i < this.failover; ++i) {
            try {
                if (i > 0 && this.failoverCheckEveryMs > 0) {
                    Utilities.sleep((long)this.failoverCheckEveryMs);
                    this.initCounter();
                }
                v = this.operation(prefix, op, arg1, arg2);
                success = true;
                break;
            }
            catch (Exception e) {
                eFinal = e;
                if (i == 0) {
                    this.logControlloTraffico.error(prefix + "rilevato contatore distrutto (verr\u00e0 riprovata la creazione): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                this.logControlloTraffico.error(prefix + "il tenativo i=" + i + " di ricreare il contatore \u00e8 fallito: " + e.getMessage(), (Throwable)e);
                continue;
            }
        }
        if (!success) {
            this.throwDistributedObjectDestroyedException(prefix, eFinal);
        }
        return v;
    }

    private void throwDistributedObjectDestroyedException(String prefix, Exception eFinal) {
        String msg = prefix + "tutti i tentativi di ricreare il contatore sono falliti";
        this.logControlloTraffico.error(msg);
        if (eFinal != null) {
            throw new UtilsRuntimeException((Throwable)eFinal);
        }
        throw new UtilsRuntimeException("tutti i tentativi di ricreare il contatore sono falliti");
    }

    private RLongAdderResponse operation(String prefix, RLongAdderOperation op, long arg1, long arg2) {
        switch (op) {
            case SUM: {
                return new RLongAdderResponse(this.counter.sum());
            }
            case ADD: {
                this.counter.add(arg1);
                return null;
            }
            case INCREMENT: {
                this.counter.increment();
                return null;
            }
            case DECREMENT: {
                this.counter.decrement();
                return null;
            }
            case RESET: {
                this.counter.reset();
                return null;
            }
            case DESTROY: {
                try {
                    this.counter.destroy();
                }
                catch (Throwable e) {
                    this.logControlloTraffico.error(prefix + "delete non riuscito: " + e.getMessage(), e);
                    throw e;
                }
                return null;
            }
        }
        return null;
    }
}

