/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.IDatiCollezionatiDistributed;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.DatoRAtomicLong;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class DatiCollezionatiDistributedRedisAtomicLong
extends DatiCollezionati
implements IDatiCollezionatiDistributed {
    private static final long serialVersionUID = 1L;
    private final transient Semaphore lock = new Semaphore("DatiCollezionatiDistributedRedisAtomicLong");
    private final transient RedissonClient redisson;
    private final IDUnivocoGroupByPolicyMapId groupByPolicyMapId;
    private final int groupByPolicyMapIdHashCode;
    private final transient DatoRAtomicLong distributedUpdatePolicyDate;
    private final transient DatoRAtomicLong distributedPolicyDate;
    private transient DatoRAtomicLong distributedPolicyRequestCounter;
    private transient DatoRAtomicLong distributedPolicyCounter;
    private final transient DatoRAtomicLong distributedPolicyDegradoPrestazionaleDate;
    private transient DatoRAtomicLong distributedPolicyDegradoPrestazionaleRequestCounter;
    private transient DatoRAtomicLong distributedPolicyDegradoPrestazionaleCounter;
    private final boolean distribuitedActiveRequestCounterPolicyRichiesteSimultanee;
    private final transient DatoRAtomicLong distributedActiveRequestCounterForStats;
    private transient DatoRAtomicLong distributedActiveRequestCounterForCheck;
    private transient DatoRAtomicLong distributedPolicyDenyRequestCounter;
    private transient List<DatoRAtomicLong> cestinoPolicyCounters = new ArrayList<DatoRAtomicLong>();
    private transient List<DatoRAtomicLong> cestinoPolicyCountersDegradoPrestazionale = new ArrayList<DatoRAtomicLong>();
    private boolean initialized = false;

    public DatiCollezionatiDistributedRedisAtomicLong(Logger log, Date updatePolicyDate, Date gestorePolicyConfigDate, RedissonClient redisson, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(updatePolicyDate, gestorePolicyConfigDate);
        this.redisson = redisson;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.initDatiIniziali(activePolicy);
        this.checkDate(log, activePolicy);
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.initPolicyCounters(super.getPolicyDate().getTime());
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.initPolicyCountersDegradoPrestazionale(super.getPolicyDegradoPrestazionaleDate().getTime());
        }
        if (this.policyRealtime != null && this.policyRealtime.booleanValue() && updatePolicyDate != null && this.distributedUpdatePolicyDate != null && this.distributedUpdatePolicyDate.get() < updatePolicyDate.getTime()) {
            this.resetCounters(updatePolicyDate);
        }
        this.initialized = true;
    }

    public DatiCollezionatiDistributedRedisAtomicLong(Logger log, DatiCollezionati dati, RedissonClient redisson, IDUnivocoGroupByPolicyMapId groupByPolicyMapId, ActivePolicy activePolicy) {
        super(dati.getUpdatePolicyDate(), dati.getGestorePolicyConfigDate());
        if (log != null) {
            // empty if block
        }
        dati.setValuesIn((DatiCollezionati)this, false);
        this.redisson = redisson;
        this.groupByPolicyMapId = groupByPolicyMapId;
        this.groupByPolicyMapIdHashCode = this.groupByPolicyMapId.hashCode();
        this.distributedPolicyDate = this.initPolicyDate();
        this.distributedUpdatePolicyDate = this.initUpdatePolicyDate();
        this.distributedPolicyDegradoPrestazionaleDate = this.initPolicyDegradoPrestazionaleDate();
        boolean bl = this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee = activePolicy.getConfigurazionePolicy().isSimultanee() && TipoControlloPeriodo.REALTIME.equals((Object)activePolicy.getConfigurazionePolicy().getModalitaControllo());
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.distributedActiveRequestCounterForCheck = this.initActiveRequestCounters();
            this.distributedActiveRequestCounterForStats = null;
        } else {
            this.distributedActiveRequestCounterForStats = this.initActiveRequestCounters();
        }
        if (super.getPolicyDate() != null) {
            Long polDate = this.distributedPolicyDate != null ? Long.valueOf(this.distributedPolicyDate.get()) : null;
            this.initPolicyCounters(polDate);
        }
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue() && super.getPolicyDegradoPrestazionaleDate() != null) {
            Long degradoPrestazionaleTime = this.distributedPolicyDegradoPrestazionaleDate != null ? Long.valueOf(this.distributedPolicyDegradoPrestazionaleDate.get()) : null;
            this.initPolicyCountersDegradoPrestazionale(degradoPrestazionaleTime);
        }
        this.initialized = true;
    }

    private DatoRAtomicLong initPolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDate-c" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRAtomicLong initUpdatePolicyDate() {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-updatePolicyDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRAtomicLong initPolicyDegradoPrestazionaleDate() {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleDate-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
        }
        return null;
    }

    private DatoRAtomicLong initActiveRequestCounters() {
        return new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-activeRequestCounter-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
    }

    private void initPolicyCounters(Long policyDate) {
        if (this.policyRealtime != null && this.policyRealtime.booleanValue()) {
            this.distributedPolicyRequestCounter = new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            this.distributedPolicyDenyRequestCounter = new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDenyRequestCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            if (this.tipoRisorsa == null || !this.isRisorsaContaNumeroRichieste(this.tipoRisorsa)) {
                this.distributedPolicyCounter = new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyCounter-i-" + policyDate + "-c-" + (this.gestorePolicyConfigDate != null ? this.gestorePolicyConfigDate.getTime() : -1L));
            }
        }
    }

    private void initPolicyCountersDegradoPrestazionale(Long policyDate) {
        if (this.policyDegradoPrestazionaleRealtime != null && this.policyDegradoPrestazionaleRealtime.booleanValue()) {
            this.distributedPolicyDegradoPrestazionaleCounter = new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleCounter-i-" + policyDate);
            this.distributedPolicyDegradoPrestazionaleRequestCounter = new DatoRAtomicLong(this.redisson, this.groupByPolicyMapIdHashCode + "-policyDegradoPrestazionaleRequestCounter-i-" + policyDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDate(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDate");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDate != null ? this.policyDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCounters.isEmpty()) {
                        for (DatoRAtomicLong iAtomicLong : this.cestinoPolicyCounters) {
                            iAtomicLong.delete();
                        }
                        this.cestinoPolicyCounters.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyRequestCounter);
                        }
                        if (this.distributedPolicyDenyRequestCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyDenyRequestCounter);
                        }
                        if (this.distributedPolicyCounter != null) {
                            this.cestinoPolicyCounters.add(this.distributedPolicyCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCounters(date.getTime());
                super.resetPolicyCounterForDate(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDate");
            }
        } else {
            super.resetPolicyCounterForDate(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resetPolicyCounterForDateDegradoPrestazionale(Date date) {
        if (this.initialized) {
            SemaphoreLock slock = this.lock.acquireThrowRuntime("resetPolicyCounterForDateDegradoPrestazionale");
            try {
                long actualSuper;
                long policyDate = date.getTime();
                long actual = this.distributedPolicyDate.get();
                long l = actualSuper = this.policyDegradoPrestazionaleDate != null ? this.policyDegradoPrestazionaleDate.getTime() : -1L;
                if (actualSuper != policyDate && actual < policyDate && this.distributedPolicyDegradoPrestazionaleDate.compareAndSet(actual, policyDate)) {
                    if (!this.cestinoPolicyCountersDegradoPrestazionale.isEmpty()) {
                        for (DatoRAtomicLong iAtomicLong : this.cestinoPolicyCountersDegradoPrestazionale) {
                            iAtomicLong.delete();
                        }
                        this.cestinoPolicyCountersDegradoPrestazionale.clear();
                    }
                    if (this.distributedPolicyRequestCounter != null || this.distributedPolicyDenyRequestCounter != null || this.distributedPolicyCounter != null) {
                        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleCounter);
                        }
                        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                            this.cestinoPolicyCountersDegradoPrestazionale.add(this.distributedPolicyDegradoPrestazionaleRequestCounter);
                        }
                    }
                }
                if (actualSuper == policyDate) return;
                this.initPolicyCountersDegradoPrestazionale(policyDate);
                super.resetPolicyCounterForDateDegradoPrestazionale(date);
                return;
            }
            finally {
                this.lock.release(slock, "resetPolicyCounterForDateDegradoPrestazionale");
            }
        } else {
            super.resetPolicyCounterForDateDegradoPrestazionale(date);
        }
    }

    public void resetCounters(Date updatePolicyDate) {
        super.resetCounters(updatePolicyDate);
        if (updatePolicyDate != null) {
            this.distributedUpdatePolicyDate.set(updatePolicyDate.getTime());
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.set(0L);
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.set(0L);
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.set(0L);
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.set(0L);
        }
    }

    protected void internalRegisterStartRequestIncrementActiveRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.activeRequestCounter = datiCollezionatiPerPolicyVerifier != null ? Long.valueOf(datiCollezionatiPerPolicyVerifier.setAndGetActiveRequestCounter(this.distributedActiveRequestCounterForCheck.incrementAndGet())) : Long.valueOf(this.distributedActiveRequestCounterForCheck.incrementAndGet());
        } else {
            this.distributedActiveRequestCounterForStats.incrementAndGetAsync();
        }
    }

    protected void internalUpdateDatiStartRequestApplicabileIncrementRequestCounter(DatiCollezionati datiCollezionatiPerPolicyVerifier) {
        this.policyRequestCounter = datiCollezionatiPerPolicyVerifier != null ? datiCollezionatiPerPolicyVerifier.setAndGetPolicyRequestCounter(Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet())) : Long.valueOf(this.distributedPolicyRequestCounter.incrementAndGet());
    }

    protected void internalRegisterEndRequestDecrementActiveRequestCounter() {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            this.activeRequestCounter = this.distributedActiveRequestCounterForCheck.decrementAndGet();
        } else {
            this.distributedActiveRequestCounterForStats.decrementAndGetAsync();
        }
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleRequestCounter() {
        this.policyDegradoPrestazionaleRequestCounter = this.distributedPolicyDegradoPrestazionaleRequestCounter.incrementAndGet();
    }

    protected void internalRegisterEndRequestIncrementDegradoPrestazionaleCounter(long latenza) {
        this.policyDegradoPrestazionaleCounter = this.distributedPolicyDegradoPrestazionaleCounter.addAndGet(latenza);
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.incrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileDecrementRequestCounter() {
        this.policyRequestCounter = this.distributedPolicyRequestCounter.decrementAndGet();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementDenyRequestCounter() {
        this.distributedPolicyDenyRequestCounter.incrementAndGetAsync();
    }

    protected void internalUpdateDatiEndRequestApplicabileIncrementCounter(long v) {
        this.policyCounter = this.distributedPolicyCounter.addAndGet(v);
    }

    public void destroyDatiDistribuiti() {
        if (this.distributedPolicyDate != null) {
            this.distributedPolicyDate.delete();
        }
        if (this.distributedUpdatePolicyDate != null) {
            this.distributedUpdatePolicyDate.delete();
        }
        if (this.distributedPolicyRequestCounter != null) {
            this.distributedPolicyRequestCounter.delete();
        }
        if (this.distributedPolicyCounter != null) {
            this.distributedPolicyCounter.delete();
        }
        if (this.distributedPolicyDegradoPrestazionaleDate != null) {
            this.distributedPolicyDegradoPrestazionaleDate.delete();
        }
        if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
            this.distributedPolicyDegradoPrestazionaleRequestCounter.delete();
        }
        if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
            this.distributedPolicyDegradoPrestazionaleCounter.delete();
        }
        if (this.distributedActiveRequestCounterForStats != null) {
            this.distributedActiveRequestCounterForStats.delete();
        }
        if (this.distributedActiveRequestCounterForCheck != null) {
            this.distributedActiveRequestCounterForCheck.delete();
        }
        if (this.distributedPolicyDenyRequestCounter != null) {
            this.distributedPolicyDenyRequestCounter.delete();
        }
    }

    public Long getActiveRequestCounter(boolean readRemoteInfo) {
        if (this.distribuitedActiveRequestCounterPolicyRichiesteSimultanee) {
            if (readRemoteInfo) {
                return this.distributedActiveRequestCounterForCheck.get();
            }
            return this.activeRequestCounter;
        }
        return this.distributedActiveRequestCounterForStats.get();
    }

    public Long getPolicyDenyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDenyRequestCounter != null) {
                return this.distributedPolicyDenyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDenyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyRequestCounter != null) {
                return this.distributedPolicyRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyRequestCounter(readRemoteInfo);
    }

    public Long getPolicyCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyCounter != null) {
                return this.distributedPolicyCounter.get();
            }
            return null;
        }
        return super.getPolicyCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleRequestCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleRequestCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleRequestCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleRequestCounter(readRemoteInfo);
    }

    public Long getPolicyDegradoPrestazionaleCounter(boolean readRemoteInfo) {
        if (readRemoteInfo) {
            if (this.distributedPolicyDegradoPrestazionaleCounter != null) {
                return this.distributedPolicyDegradoPrestazionaleCounter.get();
            }
            return null;
        }
        return super.getPolicyDegradoPrestazionaleCounter(readRemoteInfo);
    }
}

