/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.Offloadable;
import com.hazelcast.map.EntryProcessor;
import java.util.Date;
import java.util.Map;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Map;
import org.slf4j.Logger;

public class StartRequestProcessor
implements EntryProcessor<IDUnivocoGroupByPolicy, DatiCollezionati, DatiCollezionati>,
Offloadable {
    private static final long serialVersionUID = 1L;
    private final ActivePolicy activePolicy;
    private final Map<Object> ctx;

    public StartRequestProcessor(ActivePolicy policy, Map<Object> ctx) {
        this.activePolicy = policy;
        this.ctx = ctx;
    }

    public DatiCollezionati process(Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry) {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
        if (entry.getValue() == null) {
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(this.ctx);
            entry.setValue(new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate));
        } else if (entry.getValue().getUpdatePolicyDate() != null && !entry.getValue().getUpdatePolicyDate().equals(this.activePolicy.getInstanceConfiguration().getUpdateTime())) {
            entry.getValue().resetCounters(this.activePolicy.getInstanceConfiguration().getUpdateTime());
        }
        entry.getValue().registerStartRequest(log, this.activePolicy, this.ctx);
        DatiCollezionati datiCollezionatiReaded = entry.getValue().newInstance();
        entry.setValue(entry.getValue());
        return datiCollezionatiReaded;
    }

    public String getExecutorName() {
        return "hz:offloadable";
    }
}

